# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Use these APIs to manage Azure Websites resources through the Azure
  # Resource Manager. All task operations conform to the HTTP/1.1 protocol
  # specification and each operation returns an x-ms-request-id header that
  # can be used to obtain information about the request. You must make sure
  # that requests made to these resources are secure. For more information,
  # see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class HostingEnvironments
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the HostingEnvironments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get properties of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironment] operation results.
    #
    def get_hosting_environment(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get properties of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param hosting_environment_envelope [HostingEnvironment] Properties of
    # hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironment] operation results.
    #
    def create_or_update_hosting_environment(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      response = create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param hosting_environment_envelope [HostingEnvironment] Properties of
    # hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = HostingEnvironment.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param hosting_environment_envelope [HostingEnvironment] Properties of
    # hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironment] operation results.
    #
    def begin_create_or_update_hosting_environment(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      response = begin_create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param hosting_environment_envelope [HostingEnvironment] Properties of
    # hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_hosting_environment_with_http_info(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      begin_create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
    end

    #
    # Create or update a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param hosting_environment_envelope [HostingEnvironment] Properties of
    # hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_hosting_environment_async(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'hosting_environment_envelope is nil' if hosting_environment_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostingEnvironment.mapper()
      request_content = @client.serialize(request_mapper,  hosting_environment_envelope, 'hosting_environment_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param force_delete [Boolean] Delete even if the hostingEnvironment (App
    # Service Environment) contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_hosting_environment(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = delete_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param force_delete [Boolean] Delete even if the hostingEnvironment (App
    # Service Environment) contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_hosting_environment_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      # Send request
      promise = begin_delete_hosting_environment_async(resource_group_name, name, force_delete, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param force_delete [Boolean] Delete even if the hostingEnvironment (App
    # Service Environment) contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_delete_hosting_environment(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = begin_delete_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param force_delete [Boolean] Delete even if the hostingEnvironment (App
    # Service Environment) contains resources
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_hosting_environment_with_http_info(resource_group_name, name, force_delete = nil, custom_headers = nil)
      begin_delete_hosting_environment_async(resource_group_name, name, force_delete, custom_headers).value!
    end

    #
    # Delete a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param force_delete [Boolean] Delete even if the hostingEnvironment (App
    # Service Environment) contains resources
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_hosting_environment_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'forceDelete' => force_delete,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_hosting_environment_diagnostics(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_diagnostics_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_diagnostics_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_diagnostics_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_diagnostics_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'HostingEnvironmentDiagnosticsElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'HostingEnvironmentDiagnostics'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param diagnostics_name [String] Name of the diagnostics
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentDiagnostics] operation results.
    #
    def get_hosting_environment_diagnostics_item(resource_group_name, name, diagnostics_name, custom_headers = nil)
      response = get_hosting_environment_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param diagnostics_name [String] Name of the diagnostics
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_diagnostics_item_with_http_info(resource_group_name, name, diagnostics_name, custom_headers = nil)
      get_hosting_environment_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers).value!
    end

    #
    # Get diagnostic information for hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param diagnostics_name [String] Name of the diagnostics
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'diagnostics_name is nil' if diagnostics_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'diagnosticsName' => diagnostics_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironmentDiagnostics.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StampCapacityCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_capacities_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_capacities_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_capacities_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StampCapacity>] operation results.
    #
    def get_hosting_environment_capacities(resource_group_name, name, custom_headers = nil)
      first_page = get_hosting_environment_capacities_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_capacities_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_capacities_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_capacities_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StampCapacityCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get IP addresses assigned to the hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AddressResponse] operation results.
    #
    def get_hosting_environment_vips(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_vips_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get IP addresses assigned to the hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_vips_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_vips_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get IP addresses assigned to the hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_vips_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AddressResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentCollection] which provide lazy access to pages of
    # the response.
    #
    def get_hosting_environments_as_lazy(resource_group_name, custom_headers = nil)
      response = get_hosting_environments_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environments_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostingEnvironment>] operation results.
    #
    def get_hosting_environments(resource_group_name, custom_headers = nil)
      first_page = get_hosting_environments_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environments_with_http_info(resource_group_name, custom_headers = nil)
      get_hosting_environments_async(resource_group_name, custom_headers).value!
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param resource_group_name [String] Name of resource group
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environments_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reboots all machines in a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reboot_hosting_environment(resource_group_name, name, custom_headers = nil)
      response = reboot_hosting_environment_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Reboots all machines in a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reboot_hosting_environment_with_http_info(resource_group_name, name, custom_headers = nil)
      reboot_hosting_environment_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Reboots all machines in a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reboot_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List all currently running operations on the hostingEnvironment (App Service
    # Environment)
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_hosting_environment_operations(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_operations_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all currently running operations on the hostingEnvironment (App Service
    # Environment)
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_operations_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_operations_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List all currently running operations on the hostingEnvironment (App Service
    # Environment)
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_operations_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get status of an operation on a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param operation_id [String] operation identifier GUID
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_hosting_environment_operation(resource_group_name, name, operation_id, custom_headers = nil)
      response = get_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get status of an operation on a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param operation_id [String] operation identifier GUID
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_operation_with_http_info(resource_group_name, name, operation_id, custom_headers = nil)
      get_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers).value!
    end

    #
    # Get status of an operation on a hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param operation_id [String] operation identifier GUID
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_operation_async(resource_group_name, name, operation_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 404 || status_code == 500
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_metrics_as_lazy(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      response = get_hosting_environment_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_hosting_environment_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = get_hosting_environment_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      get_hosting_environment_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global metric definitions of hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinition] operation results.
    #
    def get_hosting_environment_metric_definitions(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_metric_definitions_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global metric definitions of hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get global metric definitions of hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_usages_as_lazy(resource_group_name, name, filter = nil, custom_headers = nil)
      response = get_hosting_environment_usages_async(resource_group_name, name, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def get_hosting_environment_usages(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = get_hosting_environment_usages_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_usages_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      get_hosting_environment_usages_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_usages_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param start_time [String] Beginning time of metrics query
    # @param end_time [String] End time of metrics query
    # @param time_grain [String] Time granularity of metrics query
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_multi_role_metrics_as_lazy(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      response = get_hosting_environment_multi_role_metrics_async(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_multi_role_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param start_time [String] Beginning time of metrics query
    # @param end_time [String] End time of metrics query
    # @param time_grain [String] Time granularity of metrics query
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_hosting_environment_multi_role_metrics(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      first_page = get_hosting_environment_multi_role_metrics_as_lazy(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param start_time [String] Beginning time of metrics query
    # @param end_time [String] End time of metrics query
    # @param time_grain [String] Time granularity of metrics query
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_metrics_with_http_info(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      get_hosting_environment_multi_role_metrics_async(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param start_time [String] Beginning time of metrics query
    # @param end_time [String] End time of metrics query
    # @param time_grain [String] Time granularity of metrics query
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_metrics_async(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'startTime' => start_time,'endTime' => end_time,'timeGrain' => time_grain,'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_web_worker_metrics_as_lazy(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      response = get_hosting_environment_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_web_worker_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_hosting_environment_web_worker_metrics(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      first_page = get_hosting_environment_web_worker_metrics_as_lazy(resource_group_name, name, worker_pool_name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_metrics_with_http_info(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      get_hosting_environment_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] which provide lazy access to pages of
    # the response.
    #
    def get_hosting_environment_multi_role_metric_definitions_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_multi_role_metric_definitions_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_multi_role_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def get_hosting_environment_multi_role_metric_definitions(resource_group_name, name, custom_headers = nil)
      first_page = get_hosting_environment_multi_role_metric_definitions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_multi_role_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] which provide lazy access to pages of
    # the response.
    #
    def get_hosting_environment_web_worker_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = get_hosting_environment_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_web_worker_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def get_hosting_environment_web_worker_metric_definitions(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = get_hosting_environment_web_worker_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_metric_definitions_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      get_hosting_environment_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] which provide lazy access to pages of the response.
    #
    def get_hosting_environment_multi_role_usages_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_multi_role_usages_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_multi_role_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Usage>] operation results.
    #
    def get_hosting_environment_multi_role_usages(resource_group_name, name, custom_headers = nil)
      first_page = get_hosting_environment_multi_role_usages_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_usages_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_multi_role_usages_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_usages_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] which provide lazy access to pages of the response.
    #
    def get_hosting_environment_web_worker_usages_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = get_hosting_environment_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_web_worker_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Usage>] operation results.
    #
    def get_hosting_environment_web_worker_usages(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = get_hosting_environment_web_worker_usages_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_usages_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      get_hosting_environment_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def get_hosting_environment_sites_as_lazy(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = get_hosting_environment_sites_async(resource_group_name, name, properties_to_include, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_sites_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def get_hosting_environment_sites(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      first_page = get_hosting_environment_sites_as_lazy(resource_group_name, name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_sites_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      get_hosting_environment_sites_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param properties_to_include [String] Comma separated list of site
    # properties to include
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_sites_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_web_hosting_plans_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ServerFarmWithRichSku>] operation results.
    #
    def get_hosting_environment_web_hosting_plans(resource_group_name, name, custom_headers = nil)
      first_page = get_hosting_environment_web_hosting_plans_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_hosting_plans_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_hosting_plans_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/webhostingplans'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] which provide lazy access to pages of the
    # response.
    #
    def get_hosting_environment_server_farms_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_hosting_environment_server_farms_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_hosting_environment_server_farms_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ServerFarmWithRichSku>] operation results.
    #
    def get_hosting_environment_server_farms(resource_group_name, name, custom_headers = nil)
      first_page = get_hosting_environment_server_farms_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_server_farms_with_http_info(resource_group_name, name, custom_headers = nil)
      get_hosting_environment_server_farms_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_server_farms_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all multi role pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] which provide lazy access to pages of the
    # response.
    #
    def get_multi_role_pools_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_multi_role_pools_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_multi_role_pools_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all multi role pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<WorkerPool>] operation results.
    #
    def get_multi_role_pools(resource_group_name, name, custom_headers = nil)
      first_page = get_multi_role_pools_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all multi role pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pools_with_http_info(resource_group_name, name, custom_headers = nil)
      get_multi_role_pools_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all multi role pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pools_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get properties of a multiRool pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def get_multi_role_pool(resource_group_name, name, custom_headers = nil)
      response = get_multi_role_pool_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of a multiRool pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_with_http_info(resource_group_name, name, custom_headers = nil)
      get_multi_role_pool_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get properties of a multiRool pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param multi_role_pool_envelope [WorkerPool] Properties of multiRole pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def create_or_update_multi_role_pool(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      response = create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param multi_role_pool_envelope [WorkerPool] Properties of multiRole pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = WorkerPool.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param multi_role_pool_envelope [WorkerPool] Properties of multiRole pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def begin_create_or_update_multi_role_pool(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      response = begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param multi_role_pool_envelope [WorkerPool] Properties of multiRole pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_multi_role_pool_with_http_info(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
    end

    #
    # Create or update a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param multi_role_pool_envelope [WorkerPool] Properties of multiRole pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'multi_role_pool_envelope is nil' if multi_role_pool_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = WorkerPool.mapper()
      request_content = @client.serialize(request_mapper,  multi_role_pool_envelope, 'multi_role_pool_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] which provide lazy access to pages of the
    # response.
    #
    def get_multi_role_pool_skus_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_multi_role_pool_skus_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_multi_role_pool_skus_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SkuInfo>] operation results.
    #
    def get_multi_role_pool_skus(resource_group_name, name, custom_headers = nil)
      first_page = get_multi_role_pool_skus_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_skus_with_http_info(resource_group_name, name, custom_headers = nil)
      get_multi_role_pool_skus_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_skus_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all worker pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] which provide lazy access to pages of the
    # response.
    #
    def get_worker_pools_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_worker_pools_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_worker_pools_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all worker pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<WorkerPool>] operation results.
    #
    def get_worker_pools(resource_group_name, name, custom_headers = nil)
      first_page = get_worker_pools_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all worker pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pools_with_http_info(resource_group_name, name, custom_headers = nil)
      get_worker_pools_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all worker pools
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pools_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def get_worker_pool(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param worker_pool_envelope [WorkerPool] Properties of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def create_or_update_worker_pool(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      response = create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param worker_pool_envelope [WorkerPool] Properties of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = WorkerPool.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param worker_pool_envelope [WorkerPool] Properties of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPool] operation results.
    #
    def begin_create_or_update_worker_pool(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      response = begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param worker_pool_envelope [WorkerPool] Properties of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_worker_pool_with_http_info(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
    end

    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param worker_pool_envelope [WorkerPool] Properties of worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'worker_pool_envelope is nil' if worker_pool_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = WorkerPool.mapper()
      request_content = @client.serialize(request_mapper,  worker_pool_envelope, 'worker_pool_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPool.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] which provide lazy access to pages of the
    # response.
    #
    def get_worker_pool_skus_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = get_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_worker_pool_skus_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SkuInfo>] operation results.
    #
    def get_worker_pool_skus(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = get_worker_pool_skus_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_skus_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      get_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a worker pool of a hostingEnvironment
    # (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_worker_pool_instance_metrics(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      response = get_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details, filter, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a specific instance of a worker pool of a hostingEnvironment
    # (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_instance_metrics_with_http_info(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      get_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a worker pool of a hostingEnvironment
    # (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param details [Boolean] Include instance details
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a specific instance of a worker pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_worker_pool_instance_metric_definitions(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      response = get_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a specific instance of a worker pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_instance_metric_definitions_with_http_info(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      get_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a worker pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param worker_pool_name [String] Name of worker pool
    # @param instance [String] Name of instance in the worker pool
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool
    # @param details [Boolean] Include instance details
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_multi_role_pool_instance_metrics(resource_group_name, name, instance, details = nil, custom_headers = nil)
      response = get_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool
    # @param details [Boolean] Include instance details
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_instance_metrics_with_http_info(resource_group_name, name, instance, details = nil, custom_headers = nil)
      get_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool
    # @param details [Boolean] Include instance details
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool&gt;
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_multi_role_pool_instance_metric_definitions(resource_group_name, name, instance, custom_headers = nil)
      response = get_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool&gt;
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_instance_metric_definitions_with_http_info(resource_group_name, name, instance, custom_headers = nil)
      get_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a multiRole pool of a
    # hostingEnvironment (App Service Environment).
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param instance [String] Name of instance in the multiRole pool&gt;
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def suspend_hosting_environment_as_lazy(resource_group_name, name, custom_headers = nil)
      response = suspend_hosting_environment_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          suspend_hosting_environment_next_async(next_page_link, custom_headers)
        end
        page
      end
    end
    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def suspend_hosting_environment(resource_group_name, name, custom_headers = nil)
      first_page = suspend_hosting_environment_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def suspend_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_suspend_hosting_environment_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = SiteCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def begin_suspend_hosting_environment_as_lazy(resource_group_name, name, custom_headers = nil)
      response = begin_suspend_hosting_environment_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          begin_suspend_hosting_environment_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def begin_suspend_hosting_environment(resource_group_name, name, custom_headers = nil)
      first_page = begin_suspend_hosting_environment_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_suspend_hosting_environment_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_suspend_hosting_environment_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_suspend_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def resume_hosting_environment_as_lazy(resource_group_name, name, custom_headers = nil)
      response = resume_hosting_environment_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          resume_hosting_environment_next_async(next_page_link, custom_headers)
        end
        page
      end
    end
    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def resume_hosting_environment(resource_group_name, name, custom_headers = nil)
      first_page = resume_hosting_environment_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def resume_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_resume_hosting_environment_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = SiteCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def begin_resume_hosting_environment_as_lazy(resource_group_name, name, custom_headers = nil)
      response = begin_resume_hosting_environment_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          begin_resume_hosting_environment_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def begin_resume_hosting_environment(resource_group_name, name, custom_headers = nil)
      first_page = begin_resume_hosting_environment_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_resume_hosting_environment_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_resume_hosting_environment_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of hostingEnvironment (App Service Environment)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_resume_hosting_environment_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StampCapacityCollection] operation results.
    #
    def get_hosting_environment_capacities_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_capacities_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_capacities_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_capacities_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get used, available, and total worker capacity for hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_capacities_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StampCapacityCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentCollection] operation results.
    #
    def get_hosting_environments_next(next_page_link, custom_headers = nil)
      response = get_hosting_environments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environments_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environments_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all hostingEnvironments (App Service Environments) in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostingEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_hosting_environment_metrics_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get global metrics of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] operation results.
    #
    def get_hosting_environment_usages_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_usages_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get global usages of hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_hosting_environment_multi_role_metrics_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_multi_role_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_multi_role_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_hosting_environment_web_worker_metrics_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_web_worker_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_web_worker_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def get_hosting_environment_multi_role_metric_definitions_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_multi_role_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_multi_role_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a multiRole pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def get_hosting_environment_web_worker_metric_definitions_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_web_worker_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_web_worker_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a worker pool of a hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] operation results.
    #
    def get_hosting_environment_multi_role_usages_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_multi_role_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_multi_role_usages_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_multi_role_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get usages for a multiRole pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_multi_role_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] operation results.
    #
    def get_hosting_environment_web_worker_usages_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_web_worker_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_worker_usages_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_web_worker_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get usages for a worker pool of a hostingEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_worker_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def get_hosting_environment_sites_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_sites_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_sites_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_sites_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all sites on the hostingEnvironment (App Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_sites_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] operation results.
    #
    def get_hosting_environment_web_hosting_plans_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_web_hosting_plans_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_web_hosting_plans_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ServerFarmCollection] operation results.
    #
    def get_hosting_environment_server_farms_next(next_page_link, custom_headers = nil)
      response = get_hosting_environment_server_farms_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hosting_environment_server_farms_next_with_http_info(next_page_link, custom_headers = nil)
      get_hosting_environment_server_farms_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all serverfarms (App Service Plans) on the hostingEnvironment (App
    # Service Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hosting_environment_server_farms_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ServerFarmCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all multi role pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] operation results.
    #
    def get_multi_role_pools_next(next_page_link, custom_headers = nil)
      response = get_multi_role_pools_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all multi role pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pools_next_with_http_info(next_page_link, custom_headers = nil)
      get_multi_role_pools_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all multi role pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pools_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] operation results.
    #
    def get_multi_role_pool_skus_next(next_page_link, custom_headers = nil)
      response = get_multi_role_pool_skus_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_skus_next_with_http_info(next_page_link, custom_headers = nil)
      get_multi_role_pool_skus_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get available skus for scaling a multiRole pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_skus_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all worker pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] operation results.
    #
    def get_worker_pools_next(next_page_link, custom_headers = nil)
      response = get_worker_pools_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all worker pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pools_next_with_http_info(next_page_link, custom_headers = nil)
      get_worker_pools_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all worker pools
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pools_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] operation results.
    #
    def get_worker_pool_skus_next(next_page_link, custom_headers = nil)
      response = get_worker_pool_skus_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_skus_next_with_http_info(next_page_link, custom_headers = nil)
      get_worker_pool_skus_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get available skus for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_skus_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def suspend_hosting_environment_next(next_page_link, custom_headers = nil)
      response = suspend_hosting_environment_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def suspend_hosting_environment_next_async(next_page_link, custom_headers = nil)
      # Send request
      promise = begin_suspend_hosting_environment_next_async(next_page_link, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = SiteCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def begin_suspend_hosting_environment_next(next_page_link, custom_headers = nil)
      response = begin_suspend_hosting_environment_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_suspend_hosting_environment_next_with_http_info(next_page_link, custom_headers = nil)
      begin_suspend_hosting_environment_next_async(next_page_link, custom_headers).value!
    end

    #
    # Suspends the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_suspend_hosting_environment_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def resume_hosting_environment_next(next_page_link, custom_headers = nil)
      response = resume_hosting_environment_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def resume_hosting_environment_next_async(next_page_link, custom_headers = nil)
      # Send request
      promise = begin_resume_hosting_environment_next_async(next_page_link, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = SiteCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def begin_resume_hosting_environment_next(next_page_link, custom_headers = nil)
      response = begin_resume_hosting_environment_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_resume_hosting_environment_next_with_http_info(next_page_link, custom_headers = nil)
      begin_resume_hosting_environment_next_async(next_page_link, custom_headers).value!
    end

    #
    # Resumes the hostingEnvironment.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_resume_hosting_environment_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
