# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Search
  module Models
    #
    # Defines all the properties of an Azure Search service.
    #
    class SearchServiceReadableProperties

      include MsRestAzure

      # @return [SearchServiceStatus] The status of the Search service.
      # Possible values include: 'running', 'provisioning', 'deleting',
      # 'degraded', 'disabled', 'error'
      attr_accessor :status

      # @return [String] The details of the Search service status.
      attr_accessor :status_details

      # @return [ProvisioningState] The state of the last provisioning
      # operation performed on the Search service. Possible values include:
      # 'succeeded', 'provisioning', 'failed'
      attr_accessor :provisioning_state

      # @return [Sku] The SKU of the Search Service, which determines price
      # tier and capacity limits.
      attr_accessor :sku

      # @return [Integer] The number of replicas in the Search service. If
      # specified, it must be a value between 1 and 6 inclusive.
      attr_accessor :replica_count

      # @return [Integer] The number of partitions in the Search service; if
      # specified, it can be 1, 2, 3, 4, 6, or 12.
      attr_accessor :partition_count


      #
      # Mapper for SearchServiceReadableProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'SearchServiceReadableProperties',
          type: {
            name: 'Composite',
            class_name: 'SearchServiceReadableProperties',
            model_properties: {
              status: {
                required: false,
                read_only: true,
                serialized_name: 'status',
                type: {
                  name: 'Enum',
                  module: 'SearchServiceStatus'
                }
              },
              status_details: {
                required: false,
                read_only: true,
                serialized_name: 'statusDetails',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                required: false,
                read_only: true,
                serialized_name: 'provisioningState',
                type: {
                  name: 'Enum',
                  module: 'ProvisioningState'
                }
              },
              sku: {
                required: false,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'Sku'
                }
              },
              replica_count: {
                required: false,
                serialized_name: 'replicaCount',
                type: {
                  name: 'Number'
                }
              },
              partition_count: {
                required: false,
                serialized_name: 'partitionCount',
                type: {
                  name: 'Number'
                }
              }
            }
          }
        }
      end
    end
  end
end
