# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Scheduler
  #
  # Jobs
  #
  class Jobs
    include Azure::ARM::Scheduler::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Jobs class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SchedulerManagementClient] reference to the SchedulerManagementClient
    attr_reader :client

    #
    # Gets a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobDefinition] operation results.
    #
    def get(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      response = get_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      get_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
    end

    #
    # Gets a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Provisions a new job or updates an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobDefinition] operation results.
    #
    def create_or_update(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      response = create_or_update_async(resource_group_name, job_collection_name, job_name, job, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Provisions a new job or updates an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      create_or_update_async(resource_group_name, job_collection_name, job_name, job, custom_headers).value!
    end

    #
    # Provisions a new job or updates an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'job is nil' if job.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = JobDefinition.mapper()
      request_content = @client.serialize(request_mapper,  job, 'job')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Patches an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobDefinition] operation results.
    #
    def patch(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      response = patch_async(resource_group_name, job_collection_name, job_name, job, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Patches an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def patch_with_http_info(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      patch_async(resource_group_name, job_collection_name, job_name, job, custom_headers).value!
    end

    #
    # Patches an existing job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param job [JobDefinition] The job definition.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def patch_async(resource_group_name, job_collection_name, job_name, job, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'job is nil' if job.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = JobDefinition.mapper()
      request_content = @client.serialize(request_mapper,  job, 'job')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      response = delete_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
      nil
    end

    #
    # Deletes a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      delete_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
    end

    #
    # Deletes a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Runs a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def run(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      response = run_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
      nil
    end

    #
    # Runs a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def run_with_http_info(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      run_async(resource_group_name, job_collection_name, job_name, custom_headers).value!
    end

    #
    # Runs a job.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def run_async(resource_group_name, job_collection_name, job_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}/run'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param top [Integer] The number of jobs to request, in the of range [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobListResult] which provide lazy access to pages of the response.
    #
    def list_as_lazy(resource_group_name, job_collection_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      response = list_async(resource_group_name, job_collection_name, top, skip, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param top [Integer] The number of jobs to request, in the of range [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<JobDefinition>] operation results.
    #
    def list(resource_group_name, job_collection_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      first_page = list_as_lazy(resource_group_name, job_collection_name, top, skip, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param top [Integer] The number of jobs to request, in the of range [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, job_collection_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      list_async(resource_group_name, job_collection_name, top, skip, filter, custom_headers).value!
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param top [Integer] The number of jobs to request, in the of range [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, job_collection_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name},
          query_params: {'api-version' => @client.api_version,'$top' => top,'$skip' => skip,'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists job history.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param top [Integer] the number of job history to request, in the of range
    # [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobHistoryListResult] which provide lazy access to pages of the
    # response.
    #
    def list_job_history_as_lazy(resource_group_name, job_collection_name, job_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      response = list_job_history_async(resource_group_name, job_collection_name, job_name, top, skip, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_job_history_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists job history.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param top [Integer] the number of job history to request, in the of range
    # [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<JobHistoryDefinition>] operation results.
    #
    def list_job_history(resource_group_name, job_collection_name, job_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      first_page = list_job_history_as_lazy(resource_group_name, job_collection_name, job_name, top, skip, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists job history.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param top [Integer] the number of job history to request, in the of range
    # [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_job_history_with_http_info(resource_group_name, job_collection_name, job_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      list_job_history_async(resource_group_name, job_collection_name, job_name, top, skip, filter, custom_headers).value!
    end

    #
    # Lists job history.
    #
    # @param resource_group_name [String] The resource group name.
    # @param job_collection_name [String] The job collection name.
    # @param job_name [String] The job name.
    # @param top [Integer] the number of job history to request, in the of range
    # [1..100].
    # @param skip [Integer] The (0-based) index of the job history list from which
    # to begin requesting entries.
    # @param filter [String] The filter to apply on the job state.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_job_history_async(resource_group_name, job_collection_name, job_name, top = nil, skip = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_collection_name is nil' if job_collection_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}/jobs/{jobName}/history'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobCollectionName' => job_collection_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version,'$top' => top,'$skip' => skip,'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobHistoryListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all jobs under the specified job collection.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists job history.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [JobHistoryListResult] operation results.
    #
    def list_job_history_next(next_page_link, custom_headers = nil)
      response = list_job_history_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists job history.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_job_history_next_with_http_info(next_page_link, custom_headers = nil)
      list_job_history_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists job history.
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_job_history_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = JobHistoryListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
