# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DevTestLabs
  module Models
    #
    # A lab.
    #
    class Lab

      include MsRestAzure

      # @return [String] The lab's default storage account.
      attr_accessor :default_storage_account

      # @return [String] The artifact storage account of the lab.
      attr_accessor :artifacts_storage_account

      # @return [String] The name of the key vault of the lab.
      attr_accessor :vault_name

      # @return [LabStorageType] The type of the lab storage. Possible values
      # include: 'Standard', 'Premium'
      attr_accessor :lab_storage_type

      # @return [DateTime] The creation date of the lab.
      attr_accessor :created_date

      # @return [String] The provisioning status of the resource.
      attr_accessor :provisioning_state

      # @return [String] The unique immutable identifier of a resource (Guid).
      attr_accessor :unique_identifier

      # @return [String] The identifier of the resource.
      attr_accessor :id

      # @return [String] The name of the resource.
      attr_accessor :name

      # @return [String] The type of the resource.
      attr_accessor :type

      # @return [String] The location of the resource.
      attr_accessor :location

      # @return [Hash{String => String}] The tags of the resource.
      attr_accessor :tags


      #
      # Mapper for Lab class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Lab',
          type: {
            name: 'Composite',
            class_name: 'Lab',
            model_properties: {
              default_storage_account: {
                required: false,
                serialized_name: 'properties.defaultStorageAccount',
                type: {
                  name: 'String'
                }
              },
              artifacts_storage_account: {
                required: false,
                serialized_name: 'properties.artifactsStorageAccount',
                type: {
                  name: 'String'
                }
              },
              vault_name: {
                required: false,
                serialized_name: 'properties.vaultName',
                type: {
                  name: 'String'
                }
              },
              lab_storage_type: {
                required: false,
                serialized_name: 'properties.labStorageType',
                type: {
                  name: 'String'
                }
              },
              created_date: {
                required: false,
                serialized_name: 'properties.createdDate',
                type: {
                  name: 'DateTime'
                }
              },
              provisioning_state: {
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              unique_identifier: {
                required: false,
                serialized_name: 'properties.uniqueIdentifier',
                type: {
                  name: 'String'
                }
              },
              id: {
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
