# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Use these APIs to manage Azure Websites resources through the Azure
  # Resource Manager. All task operations conform to the HTTP/1.1 protocol
  # specification and each operation returns an x-ms-request-id header that
  # can be used to obtain information about the request. You must make sure
  # that requests made to these resources are secure. For more information,
  # see <a
  # href="https://msdn.microsoft.com/en-us/library/azure/dn790557.aspx">Authenticating
  # Azure Resource Manager requests.</a>
  #
  class Sites
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Sites class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_site_vnetconnection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = get_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnetconnection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      get_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_site_vnetconnection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_vnetconnection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_vnetconnection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = delete_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_vnetconnection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      delete_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_site_vnetconnection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_vnetconnection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_vnetconnection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_site_vnetconnection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnetconnection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_site_vnetconnection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = create_or_update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_vnetconnection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      create_or_update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_vnetconnection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = delete_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_vnetconnection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      delete_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_vnetconnection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_site_vnetconnection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_vnetconnection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_vnetconnection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def get_site_network_features_slot(resource_group_name, name, view, slot, custom_headers = nil)
      response = get_site_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_network_features_slot_with_http_info(resource_group_name, name, view, slot, custom_headers = nil)
      get_site_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_network_features_slot_async(resource_group_name, name, view, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def get_site_network_features(resource_group_name, name, view, custom_headers = nil)
      response = get_site_network_features_async(resource_group_name, name, view, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_network_features_with_http_info(resource_group_name, name, view, custom_headers = nil)
      get_site_network_features_async(resource_group_name, name, view, custom_headers).value!
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_network_features_async(resource_group_name, name, view, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_operation_slot(resource_group_name, name, operation_id, slot, custom_headers = nil)
      response = get_site_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_operation_slot_with_http_info(resource_group_name, name, operation_id, slot, custom_headers = nil)
      get_site_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers).value!
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/operationresults/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_operation(resource_group_name, name, operation_id, custom_headers = nil)
      response = get_site_operation_async(resource_group_name, name, operation_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_operation_with_http_info(resource_group_name, name, operation_id, custom_headers = nil)
      get_site_operation_async(resource_group_name, name, operation_id, custom_headers).value!
    end

    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_operation_async(resource_group_name, name, operation_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/operationresults/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def swap_slot_with_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      # Send request
      promise = begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_swap_slot_with_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_swap_slot_with_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def swap_slots_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_swap_slots_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_swap_slots_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of source slot for the swap
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotDifferenceCollection] which provide lazy access to pages of the
    # response.
    #
    def get_slots_differences_from_production_as_lazy(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = get_slots_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_slots_differences_from_production_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def get_slots_differences_from_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      first_page = get_slots_differences_from_production_as_lazy(resource_group_name, name, slot_swap_entity, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_from_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      get_slots_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotDifferenceCollection] which provide lazy access to pages of the
    # response.
    #
    def get_slots_differences_slot_as_lazy(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = get_slots_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_slots_differences_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def get_slots_differences_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      first_page = get_slots_differences_slot_as_lazy(resource_group_name, name, slot_swap_entity, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      get_slots_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name
    # @param slot [String] Name of the source slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def apply_slot_config_to_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_config_to_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def apply_slot_config_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = apply_slot_config_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_config_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      apply_slot_config_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the
    # target slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_config_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reset_production_slot_config(resource_group_name, name, custom_headers = nil)
      response = reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_production_slot_config_with_http_info(resource_group_name, name, custom_headers = nil)
      reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_production_slot_config_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reset_slot_config_slot(resource_group_name, name, slot, custom_headers = nil)
      response = reset_slot_config_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_slot_config_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      reset_slot_config_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were
    # previously modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_slot_config_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def get_slot_config_names(resource_group_name, name, custom_headers = nil)
      response = get_slot_config_names_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slot_config_names_with_http_info(resource_group_name, name, custom_headers = nil)
      get_slot_config_names_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slot_config_names_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def update_slot_config_names(resource_group_name, name, slot_config_names, custom_headers = nil)
      response = update_slot_config_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_slot_config_names_with_http_info(resource_group_name, name, slot_config_names, custom_headers = nil)
      update_slot_config_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_slot_config_names_async(resource_group_name, name, slot_config_names, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_config_names is nil' if slot_config_names.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SlotConfigNamesResource.mapper()
      request_content = @client.serialize(request_mapper,  slot_config_names, 'slot_config_names')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def get_site_slots_as_lazy(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = get_site_slots_async(resource_group_name, name, properties_to_include, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_slots_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def get_site_slots(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      first_page = get_site_slots_as_lazy(resource_group_name, name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_slots_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      get_site_slots_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_slots_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots
    # in results
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] which provide lazy access to pages of the response.
    #
    def get_sites_as_lazy(resource_group_name, properties_to_include = nil, include_site_types = nil, include_slots = nil, custom_headers = nil)
      response = get_sites_async(resource_group_name, properties_to_include, include_site_types, include_slots, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_sites_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots
    # in results
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def get_sites(resource_group_name, properties_to_include = nil, include_site_types = nil, include_slots = nil, custom_headers = nil)
      first_page = get_sites_as_lazy(resource_group_name, properties_to_include, include_site_types, include_slots, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots
    # in results
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_sites_with_http_info(resource_group_name, properties_to_include = nil, include_site_types = nil, include_slots = nil, custom_headers = nil)
      get_sites_async(resource_group_name, properties_to_include, include_site_types, include_slots, custom_headers).value!
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots
    # in results
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_sites_async(resource_group_name, properties_to_include = nil, include_site_types = nil, include_slots = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'includeSiteTypes' => include_site_types,'includeSlots' => include_slots,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get_site(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = get_site_async(resource_group_name, name, properties_to_include, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      get_site_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update_site(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_create_or_update_site(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = begin_create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_site_with_http_info(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      begin_create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_site_async(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_envelope is nil' if site_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Site.mapper()
      request_content = @client.serialize(request_mapper,  site_envelope, 'site_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'skipDnsRegistration' => skip_dns_registration,'skipCustomDomainVerification' => skip_custom_domain_verification,'forceDnsRegistration' => force_dns_registration,'ttlInSeconds' => ttl_in_seconds,'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      response = delete_site_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, delete_all_slots, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_with_http_info(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      delete_site_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, delete_all_slots, custom_headers).value!
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_async(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'deleteAllSlots' => delete_all_slots,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get_site_slot(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      response = get_site_slot_async(resource_group_name, name, slot, properties_to_include, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_slot_with_http_info(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      get_site_slot_async(resource_group_name, name, slot, properties_to_include, custom_headers).value!
    end

    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_slot_async(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update_site_slot(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_create_or_update_site_slot(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = begin_create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_site_slot_with_http_info(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      begin_create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param skip_dns_registration [String] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [String] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [String] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_site_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_envelope is nil' if site_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Site.mapper()
      request_content = @client.serialize(request_mapper,  site_envelope, 'site_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'skipDnsRegistration' => skip_dns_registration,'skipCustomDomainVerification' => skip_custom_domain_verification,'forceDnsRegistration' => force_dns_registration,'ttlInSeconds' => ttl_in_seconds,'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_slot(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      response = delete_site_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, delete_all_slots, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_slot_with_http_info(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      delete_site_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, delete_all_slots, custom_headers).value!
    end

    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param delete_metrics [String] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [String] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [String] If true, DNS registration is skipped
    # @param delete_all_slots [String] If true, all slots associated with web app
    # are also deleted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_slot_async(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, delete_all_slots = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'deleteAllSlots' => delete_all_slots,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_site_cloneable(resource_group_name, name, custom_headers = nil)
      response = is_site_cloneable_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_site_cloneable_with_http_info(resource_group_name, name, custom_headers = nil)
      is_site_cloneable_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_site_cloneable_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_site_cloneable_slot(resource_group_name, name, slot, custom_headers = nil)
      response = is_site_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_site_cloneable_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      is_site_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_site_cloneable_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def recover_site(resource_group_name, name, recovery_entity, custom_headers = nil)
      response = recover_site_async(resource_group_name, name, recovery_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_site_async(resource_group_name, name, recovery_entity, custom_headers = nil)
      # Send request
      promise = begin_recover_site_async(resource_group_name, name, recovery_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_recover_site(resource_group_name, name, recovery_entity, custom_headers = nil)
      response = begin_recover_site_async(resource_group_name, name, recovery_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_recover_site_with_http_info(resource_group_name, name, recovery_entity, custom_headers = nil)
      begin_recover_site_async(resource_group_name, name, recovery_entity, custom_headers).value!
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_recover_site_async(resource_group_name, name, recovery_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'recovery_entity is nil' if recovery_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSiteRecoveryEntity.mapper()
      request_content = @client.serialize(request_mapper,  recovery_entity, 'recovery_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def recover_site_slot(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      response = recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_recover_site_slot(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      response = begin_recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_recover_site_slot_with_http_info(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      begin_recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
    end

    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web
    # app recovery. Snapshot information can be obtained by calling
    # GetDeletedSites or GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_recover_site_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'recovery_entity is nil' if recovery_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSiteRecoveryEntity.mapper()
      request_content = @client.serialize(request_mapper,  recovery_entity, 'recovery_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_snapshots(resource_group_name, name, custom_headers = nil)
      response = get_site_snapshots_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_snapshots_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_snapshots_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_snapshots_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_snapshots_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_snapshots_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_snapshots_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_snapshots_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Webspace
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_snapshots_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeletedSiteCollection] which provide lazy access to pages of the
    # response.
    #
    def get_deleted_sites_as_lazy(resource_group_name, properties_to_include = nil, include_site_types = nil, custom_headers = nil)
      response = get_deleted_sites_async(resource_group_name, properties_to_include, include_site_types, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_deleted_sites_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DeletedSite>] operation results.
    #
    def get_deleted_sites(resource_group_name, properties_to_include = nil, include_site_types = nil, custom_headers = nil)
      first_page = get_deleted_sites_as_lazy(resource_group_name, properties_to_include, include_site_types, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deleted_sites_with_http_info(resource_group_name, properties_to_include = nil, include_site_types = nil, custom_headers = nil)
      get_deleted_sites_async(resource_group_name, properties_to_include, include_site_types, custom_headers).value!
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_site_types [String] Types of apps included in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deleted_sites_async(resource_group_name, properties_to_include = nil, include_site_types = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/deletedSites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'includeSiteTypes' => include_site_types,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeletedSiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] which provide lazy access to pages of the
    # response.
    #
    def get_deployments_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_deployments_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_deployments_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def get_deployments(resource_group_name, name, custom_headers = nil)
      first_page = get_deployments_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployments_with_http_info(resource_group_name, name, custom_headers = nil)
      get_deployments_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployments_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] which provide lazy access to pages of the
    # response.
    #
    def get_deployments_slot_as_lazy(resource_group_name, name, slot, custom_headers = nil)
      response = get_deployments_slot_async(resource_group_name, name, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_deployments_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def get_deployments_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = get_deployments_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployments_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_deployments_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployments_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] which provide lazy access to pages of the
    # response.
    #
    def get_instance_deployments_as_lazy(resource_group_name, name, instance_id, custom_headers = nil)
      response = get_instance_deployments_async(resource_group_name, name, instance_id, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_instance_deployments_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def get_instance_deployments(resource_group_name, name, instance_id, custom_headers = nil)
      first_page = get_instance_deployments_as_lazy(resource_group_name, name, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployments_with_http_info(resource_group_name, name, instance_id, custom_headers = nil)
      get_instance_deployments_async(resource_group_name, name, instance_id, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployments_async(resource_group_name, name, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] which provide lazy access to pages of the
    # response.
    #
    def get_instance_deployments_slot_as_lazy(resource_group_name, name, slot, instance_id, custom_headers = nil)
      response = get_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_instance_deployments_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def get_instance_deployments_slot(resource_group_name, name, slot, instance_id, custom_headers = nil)
      first_page = get_instance_deployments_slot_as_lazy(resource_group_name, name, slot, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployments_slot_with_http_info(resource_group_name, name, slot, instance_id, custom_headers = nil)
      get_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment(resource_group_name, name, id, custom_headers = nil)
      response = get_deployment_async(resource_group_name, name, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      get_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment(resource_group_name, name, id, deployment, custom_headers = nil)
      response = create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_with_http_info(resource_group_name, name, id, deployment, custom_headers = nil)
      create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_async(resource_group_name, name, id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_deployment(resource_group_name, name, id, custom_headers = nil)
      response = delete_deployment_async(resource_group_name, name, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      delete_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment_slot(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      response = create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_slot_with_http_info(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_instance_identifiers_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_site_instance_identifiers_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_instance_identifiers_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def get_site_instance_identifiers(resource_group_name, name, custom_headers = nil)
      first_page = get_site_instance_identifiers_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_instance_identifiers_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_instance_identifiers_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_instance_identifiers_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_instance_identifiers_slot_as_lazy(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_instance_identifiers_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def get_site_instance_identifiers_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = get_site_instance_identifiers_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_instance_identifiers_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] which provide lazy access to pages of
    # the response.
    #
    def get_site_host_name_bindings_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_site_host_name_bindings_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_host_name_bindings_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def get_site_host_name_bindings(resource_group_name, name, custom_headers = nil)
      first_page = get_site_host_name_bindings_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_bindings_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_host_name_bindings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_bindings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] which provide lazy access to pages of
    # the response.
    #
    def get_site_host_name_bindings_slot_as_lazy(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_host_name_bindings_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def get_site_host_name_bindings_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = get_site_host_name_bindings_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_bindings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_site_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = get_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      get_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_site_host_name_binding(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      response = create_or_update_site_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_host_name_binding_with_http_info(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      create_or_update_site_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding, 'host_name_binding')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = delete_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      delete_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_site_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = get_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      get_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_site_host_name_binding_slot(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      response = create_or_update_site_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_host_name_binding_slot_with_http_info(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      create_or_update_site_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
    end

    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding, 'host_name_binding')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = delete_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      delete_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def get_site_config(resource_group_name, name, custom_headers = nil)
      response = get_site_config_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_config_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_config_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_config_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def create_or_update_site_config(resource_group_name, name, site_config, custom_headers = nil)
      response = create_or_update_site_config_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_config_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      create_or_update_site_config_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_config_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def update_site_config(resource_group_name, name, site_config, custom_headers = nil)
      response = update_site_config_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_config_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      update_site_config_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_config_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def get_site_config_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_config_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_config_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_config_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_config_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def create_or_update_site_config_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = create_or_update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_config_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      create_or_update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def update_site_config_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_config_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_config_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_site_source_control(resource_group_name, name, custom_headers = nil)
      response = get_site_source_control_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_site_source_control(resource_group_name, name, site_source_control, custom_headers = nil)
      response = create_or_update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_source_control_with_http_info(resource_group_name, name, site_source_control, custom_headers = nil)
      create_or_update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_source_control(resource_group_name, name, custom_headers = nil)
      response = delete_site_source_control_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_site_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def update_site_source_control(resource_group_name, name, site_source_control, custom_headers = nil)
      response = update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_source_control_with_http_info(resource_group_name, name, site_source_control, custom_headers = nil)
      update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_source_control_async(resource_group_name, name, site_source_control, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_site_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_site_source_control_slot(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      response = create_or_update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_source_control_slot_with_http_info(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      create_or_update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = delete_site_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      delete_site_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def update_site_source_control_slot(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      response = update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_source_control_slot_with_http_info(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains
    # the source control parameters
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_site_app_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_app_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_app_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_app_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_app_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_site_app_settings(resource_group_name, name, custom_headers = nil)
      response = list_site_app_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_app_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_app_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_app_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_site_app_settings(resource_group_name, name, app_settings, custom_headers = nil)
      response = update_site_app_settings_async(resource_group_name, name, app_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_app_settings_with_http_info(resource_group_name, name, app_settings, custom_headers = nil)
      update_site_app_settings_async(resource_group_name, name, app_settings, custom_headers).value!
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_app_settings_async(resource_group_name, name, app_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings, 'app_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_site_app_settings_slot(resource_group_name, name, app_settings, slot, custom_headers = nil)
      response = update_site_app_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_app_settings_slot_with_http_info(resource_group_name, name, app_settings, slot, custom_headers = nil)
      update_site_app_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
    end

    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_app_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings, 'app_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_site_connection_strings(resource_group_name, name, custom_headers = nil)
      response = list_site_connection_strings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_connection_strings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_connection_strings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_connection_strings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_site_connection_strings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_connection_strings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_connection_strings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_site_connection_strings(resource_group_name, name, connection_strings, custom_headers = nil)
      response = update_site_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_connection_strings_with_http_info(resource_group_name, name, connection_strings, custom_headers = nil)
      update_site_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_connection_strings_async(resource_group_name, name, connection_strings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings, 'connection_strings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_site_connection_strings_slot(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      response = update_site_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_connection_strings_slot_with_http_info(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      update_site_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
    end

    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings, 'connection_strings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def list_site_auth_settings(resource_group_name, name, custom_headers = nil)
      response = list_site_auth_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_auth_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_auth_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_auth_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def list_site_auth_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_auth_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_auth_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_site_auth_settings(resource_group_name, name, site_auth_settings, custom_headers = nil)
      response = update_site_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_auth_settings_with_http_info(resource_group_name, name, site_auth_settings, custom_headers = nil)
      update_site_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings, 'site_auth_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_site_auth_settings_slot(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      response = update_site_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_auth_settings_slot_with_http_info(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      update_site_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings, 'site_auth_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_site_publishing_credentials(resource_group_name, name, custom_headers = nil)
      response = list_site_publishing_credentials_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_site_publishing_credentials_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_list_site_publishing_credentials_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def begin_list_site_publishing_credentials(resource_group_name, name, custom_headers = nil)
      response = begin_list_site_publishing_credentials_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_site_publishing_credentials_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_list_site_publishing_credentials_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_site_publishing_credentials_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = User.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_site_publishing_credentials_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers = nil)
      # Send request
      promise = begin_list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def begin_list_site_publishing_credentials_slot(resource_group_name, name, slot, custom_headers = nil)
      response = begin_list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_site_publishing_credentials_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      begin_list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_site_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = User.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_site_metadata(resource_group_name, name, custom_headers = nil)
      response = list_site_metadata_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_metadata_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_metadata_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_metadata_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_site_metadata_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_metadata_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_metadata_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_site_metadata(resource_group_name, name, metadata, custom_headers = nil)
      response = update_site_metadata_async(resource_group_name, name, metadata, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_metadata_with_http_info(resource_group_name, name, metadata, custom_headers = nil)
      update_site_metadata_async(resource_group_name, name, metadata, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_metadata_async(resource_group_name, name, metadata, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata, 'metadata')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_site_metadata_slot(resource_group_name, name, metadata, slot, custom_headers = nil)
      response = update_site_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_metadata_slot_with_http_info(resource_group_name, name, metadata, slot, custom_headers = nil)
      update_site_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata, 'metadata')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_site_logs_config(resource_group_name, name, custom_headers = nil)
      response = get_site_logs_config_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_logs_config_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_logs_config_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_logs_config_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_site_logs_config(resource_group_name, name, site_logs_config, custom_headers = nil)
      response = update_site_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_logs_config_with_http_info(resource_group_name, name, site_logs_config, custom_headers = nil)
      update_site_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_logs_config_async(resource_group_name, name, site_logs_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config, 'site_logs_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_site_logs_config_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_logs_config_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_logs_config_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_logs_config_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_logs_config_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_site_logs_config_slot(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      response = update_site_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_logs_config_slot_with_http_info(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      update_site_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config, 'site_logs_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_site_premier_add_ons(resource_group_name, name, custom_headers = nil)
      response = list_site_premier_add_ons_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_premier_add_ons_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_premier_add_ons_async(resource_group_name, name, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_premier_add_ons_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_site_premier_add_ons_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_premier_add_ons_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = get_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      get_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def add_site_premier_add_on(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      response = add_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_site_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      add_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PremierAddOnRequest.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on, 'premier_add_on')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = delete_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      delete_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = get_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      get_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def add_site_premier_add_on_slot(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      response = add_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_site_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      add_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param premier_add_on [PremierAddOnRequest]
    # @param slot [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PremierAddOnRequest.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on, 'premier_add_on')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = delete_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      delete_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param premier_add_on_name [String]
    # @param slot [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_site_backup_configuration(resource_group_name, name, custom_headers = nil)
      response = get_site_backup_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_backup_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_site_backup_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_site_backup_configuration(resource_group_name, name, request, custom_headers = nil)
      response = update_site_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_backup_configuration_with_http_info(resource_group_name, name, request, custom_headers = nil)
      update_site_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_backup_configuration_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_site_backup_configuration_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = update_site_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_backup_configuration_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      update_site_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup_site(resource_group_name, name, request, custom_headers = nil)
      response = backup_site_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_site_with_http_info(resource_group_name, name, request, custom_headers = nil)
      backup_site_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_site_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup_site_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = backup_site_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_site_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      backup_site_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_site_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_site_restore(resource_group_name, name, request, custom_headers = nil)
      response = discover_site_restore_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_site_restore_with_http_info(resource_group_name, name, request, custom_headers = nil)
      discover_site_restore_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_site_restore_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_site_restore_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = discover_site_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_site_restore_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      discover_site_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_site_restore_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] which provide lazy access to pages of the
    # response.
    #
    def list_site_backups_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_site_backups_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_site_backups_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_site_backups(resource_group_name, name, custom_headers = nil)
      first_page = list_site_backups_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_backups_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_backups_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_backups_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] which provide lazy access to pages of the
    # response.
    #
    def list_site_backups_slot_as_lazy(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_backups_slot_async(resource_group_name, name, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_site_backups_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_site_backups_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_site_backups_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_backups_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_backups_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_backups_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_site_backup_status(resource_group_name, name, backup_id, custom_headers = nil)
      response = get_site_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_status_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      get_site_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_status_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def delete_backup(resource_group_name, name, backup_id, custom_headers = nil)
      response = delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_site_backup_status_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = get_site_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_status_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      get_site_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def delete_backup_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_site_backup_status_secrets_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = get_site_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_status_secrets_slot_with_http_info(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      get_site_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_site_backup_status_secrets(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = get_site_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_backup_status_secrets_with_http_info(resource_group_name, name, backup_id, request, custom_headers = nil)
      get_site_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore_site(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = restore_site_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_site_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      # Send request
      promise = begin_restore_site_async(resource_group_name, name, backup_id, request, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def begin_restore_site(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = begin_restore_site_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restore_site_with_http_info(resource_group_name, name, backup_id, request, custom_headers = nil)
      begin_restore_site_async(resource_group_name, name, backup_id, request, custom_headers).value!
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restore_site_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore_site_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      # Send request
      promise = begin_restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def begin_restore_site_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = begin_restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restore_site_slot_with_http_info(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      begin_restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
    end

    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restore_site_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_usages_as_lazy(resource_group_name, name, filter = nil, custom_headers = nil)
      response = get_site_usages_async(resource_group_name, name, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def get_site_usages(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = get_site_usages_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_usages_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      get_site_usages_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_usages_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_usages_slot_as_lazy(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      response = get_site_usages_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_usages_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def get_site_usages_slot(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      first_page = get_site_usages_slot_as_lazy(resource_group_name, name, slot, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_usages_slot_with_http_info(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      get_site_usages_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_usages_slot_async(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_metrics_as_lazy(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      response = get_site_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_site_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = get_site_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      get_site_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def get_site_metrics_slot_as_lazy(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      response = get_site_metrics_slot_async(resource_group_name, name, slot, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_metrics_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def get_site_metrics_slot(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      first_page = get_site_metrics_slot_as_lazy(resource_group_name, name, slot, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metrics_slot_with_http_info(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      get_site_metrics_slot_async(resource_group_name, name, slot, details, filter, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
    # or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
    # endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metrics_slot_async(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] which provide lazy access to pages of
    # the response.
    #
    def get_site_metric_definitions_slot_as_lazy(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_metric_definitions_slot_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def get_site_metric_definitions_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = get_site_metric_definitions_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metric_definitions_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] which provide lazy access to pages of
    # the response.
    #
    def get_site_metric_definitions_as_lazy(resource_group_name, name, custom_headers = nil)
      response = get_site_metric_definitions_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_site_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def get_site_metric_definitions(resource_group_name, name, custom_headers = nil)
      first_page = get_site_metric_definitions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [System.IO.Stream] operation results.
    #
    def list_site_publishing_profile_xml(resource_group_name, name, options, custom_headers = nil)
      response = list_site_publishing_profile_xml_async(resource_group_name, name, options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_publishing_profile_xml_with_http_info(resource_group_name, name, options, custom_headers = nil)
      list_site_publishing_profile_xml_async(resource_group_name, name, options, custom_headers).value!
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_publishing_profile_xml_async(resource_group_name, name, options, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'options is nil' if options.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  options, 'options')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [System.IO.Stream] operation results.
    #
    def list_site_publishing_profile_xml_slot(resource_group_name, name, options, slot, custom_headers = nil)
      response = list_site_publishing_profile_xml_slot_async(resource_group_name, name, options, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_publishing_profile_xml_slot_with_http_info(resource_group_name, name, options, slot, custom_headers = nil)
      list_site_publishing_profile_xml_slot_async(resource_group_name, name, options, slot, custom_headers).value!
    end

    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for
    # publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
    # FileZilla FTP format.
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_publishing_profile_xml_slot_async(resource_group_name, name, options, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'options is nil' if options.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  options, 'options')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def restart_site_slot(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_site_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_site_slot_with_http_info(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_site_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_site_slot_async(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def restart_site(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_site_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_site_with_http_info(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_site_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration
    # settings and restarts the app if necessary. Hard restart always restarts
    # and reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_site_async(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def start_site(resource_group_name, name, custom_headers = nil)
      response = start_site_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_site_with_http_info(resource_group_name, name, custom_headers = nil)
      start_site_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_site_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def start_site_slot(resource_group_name, name, slot, custom_headers = nil)
      response = start_site_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_site_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      start_site_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_site_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def stop_site(resource_group_name, name, custom_headers = nil)
      response = stop_site_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_site_with_http_info(resource_group_name, name, custom_headers = nil)
      stop_site_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_site_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def stop_site_slot(resource_group_name, name, slot, custom_headers = nil)
      response = stop_site_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_site_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      stop_site_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_site_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def sync_site_repository(resource_group_name, name, custom_headers = nil)
      response = sync_site_repository_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_site_repository_with_http_info(resource_group_name, name, custom_headers = nil)
      sync_site_repository_async(resource_group_name, name, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_site_repository_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def sync_site_repository_slot(resource_group_name, name, slot, custom_headers = nil)
      response = sync_site_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_site_repository_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      sync_site_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # @param resource_group_name [String]
    # @param name [String]
    # @param slot [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_site_repository_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def generate_new_site_publishing_password_slot(resource_group_name, name, slot, custom_headers = nil)
      response = generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will
    # default to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def generate_new_site_publishing_password(resource_group_name, name, custom_headers = nil)
      response = generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_with_http_info(resource_group_name, name, custom_headers = nil)
      generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_site_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = get_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      get_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_site_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = create_or_update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      create_or_update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = delete_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      delete_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_site_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_site_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = get_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      get_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_site_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_site_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = delete_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_site_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      delete_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_site_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_site_relay_service_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_relay_service_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_site_relay_service_connections(resource_group_name, name, custom_headers = nil)
      response = list_site_relay_service_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_relay_service_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_relay_service_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_relay_service_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_vnet_gateway_slot(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      response = get_site_vnet_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnet_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      get_site_vnet_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnet_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_site_vnetconnection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_vnetconnection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_site_vnetconnection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_vnetconnection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_vnetconnection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_site_vnet_gateway(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      response = get_site_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnet_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      get_site_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnet_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_site_vnetconnection_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = create_or_update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_site_vnetconnection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      create_or_update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_site_vnetconnection_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_vnetconnection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_vnetconnection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_site_vnetconnections(resource_group_name, name, custom_headers = nil)
      response = get_site_vnetconnections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnetconnections_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_vnetconnections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnetconnections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_site_vnetconnections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_vnetconnections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_vnetconnections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_vnetconnections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_vnetconnections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotDifferenceCollection] operation results.
    #
    def get_slots_differences_from_production_next(next_page_link, custom_headers = nil)
      response = get_slots_differences_from_production_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_from_production_next_with_http_info(next_page_link, custom_headers = nil)
      get_slots_differences_from_production_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_from_production_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotDifferenceCollection] operation results.
    #
    def get_slots_differences_slot_next(next_page_link, custom_headers = nil)
      response = get_slots_differences_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_slots_differences_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def get_site_slots_next(next_page_link, custom_headers = nil)
      response = get_site_slots_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_slots_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_slots_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_slots_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCollection] operation results.
    #
    def get_sites_next(next_page_link, custom_headers = nil)
      response = get_sites_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_sites_next_with_http_info(next_page_link, custom_headers = nil)
      get_sites_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_sites_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeletedSiteCollection] operation results.
    #
    def get_deleted_sites_next(next_page_link, custom_headers = nil)
      response = get_deleted_sites_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deleted_sites_next_with_http_info(next_page_link, custom_headers = nil)
      get_deleted_sites_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deleted_sites_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeletedSiteCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def get_deployments_next(next_page_link, custom_headers = nil)
      response = get_deployments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployments_next_with_http_info(next_page_link, custom_headers = nil)
      get_deployments_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def get_deployments_slot_next(next_page_link, custom_headers = nil)
      response = get_deployments_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployments_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_deployments_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployments_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def get_instance_deployments_next(next_page_link, custom_headers = nil)
      response = get_instance_deployments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployments_next_with_http_info(next_page_link, custom_headers = nil)
      get_instance_deployments_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def get_instance_deployments_slot_next(next_page_link, custom_headers = nil)
      response = get_instance_deployments_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployments_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_instance_deployments_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployments_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] operation results.
    #
    def get_site_instance_identifiers_next(next_page_link, custom_headers = nil)
      response = get_site_instance_identifiers_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_instance_identifiers_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_instance_identifiers_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_instance_identifiers_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] operation results.
    #
    def get_site_instance_identifiers_slot_next(next_page_link, custom_headers = nil)
      response = get_site_instance_identifiers_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_instance_identifiers_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_instance_identifiers_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_instance_identifiers_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] operation results.
    #
    def get_site_host_name_bindings_next(next_page_link, custom_headers = nil)
      response = get_site_host_name_bindings_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_bindings_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_host_name_bindings_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_bindings_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] operation results.
    #
    def get_site_host_name_bindings_slot_next(next_page_link, custom_headers = nil)
      response = get_site_host_name_bindings_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_host_name_bindings_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_host_name_bindings_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_host_name_bindings_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] operation results.
    #
    def list_site_backups_next(next_page_link, custom_headers = nil)
      response = list_site_backups_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_backups_next_with_http_info(next_page_link, custom_headers = nil)
      list_site_backups_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_backups_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] operation results.
    #
    def list_site_backups_slot_next(next_page_link, custom_headers = nil)
      response = list_site_backups_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_backups_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_site_backups_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_backups_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] operation results.
    #
    def get_site_usages_next(next_page_link, custom_headers = nil)
      response = get_site_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_usages_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] operation results.
    #
    def get_site_usages_slot_next(next_page_link, custom_headers = nil)
      response = get_site_usages_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_usages_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_usages_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_usages_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_site_metrics_next(next_page_link, custom_headers = nil)
      response = get_site_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def get_site_metrics_slot_next(next_page_link, custom_headers = nil)
      response = get_site_metrics_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metrics_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_metrics_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metrics_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def get_site_metric_definitions_slot_next(next_page_link, custom_headers = nil)
      response = get_site_metric_definitions_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metric_definitions_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_metric_definitions_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metric_definitions_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def get_site_metric_definitions_next(next_page_link, custom_headers = nil)
      response = get_site_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      get_site_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
