# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServerManagement
  #
  # REST API for Azure Server Management Service
  #
  class Gateway
    include Azure::ARM::ServerManagement::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Gateway class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ServerManagement] reference to the ServerManagement
    attr_reader :client

    #
    # Creates or updates a ManagementService gateway.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResource] operation results.
    #
    def create(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      response = create_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = GatewayResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates or updates a ManagementService gateway.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResource] operation results.
    #
    def begin_create(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      response = begin_create_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a ManagementService gateway.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      begin_create_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
    end

    #
    # Creates or updates a ManagementService gateway.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?

      gateway_parameters = GatewayParameters.new
      unless location.nil? && tags.nil? && auto_upgrade.nil?
        gateway_parameters.location = location
        gateway_parameters.tags = tags
        gateway_parameters.auto_upgrade = auto_upgrade
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = GatewayParameters.mapper()
      request_content = @client.serialize(request_mapper,  gateway_parameters, 'gateway_parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a gateway belonging to a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResource] operation results.
    #
    def update(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      response = update_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      # Send request
      promise = begin_update_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = GatewayResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a gateway belonging to a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResource] operation results.
    #
    def begin_update(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      response = begin_update_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a gateway belonging to a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      begin_update_async(resource_group_name, gateway_name, location, tags, auto_upgrade, custom_headers).value!
    end

    #
    # Updates a gateway belonging to a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param location [String] location of the resource
    # @param tags resource tags
    # @param auto_upgrade [AutoUpgrade] The autoUpgrade property gives the
    # flexibility to gateway to auto upgrade itself. If properties value not
    # specified, then we assume autoUpgrade = Off. Possible values include: 'On',
    # 'Off'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, gateway_name, location = nil, tags = nil, auto_upgrade = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?

      gateway_parameters = GatewayParameters.new
      unless location.nil? && tags.nil? && auto_upgrade.nil?
        gateway_parameters.location = location
        gateway_parameters.tags = tags
        gateway_parameters.auto_upgrade = auto_upgrade
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = GatewayParameters.mapper()
      request_content = @client.serialize(request_mapper,  gateway_parameters, 'gateway_parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a gateway from a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, gateway_name, custom_headers = nil)
      response = delete_async(resource_group_name, gateway_name, custom_headers).value!
      nil
    end

    #
    # Deletes a gateway from a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, gateway_name, custom_headers = nil)
      delete_async(resource_group_name, gateway_name, custom_headers).value!
    end

    #
    # Deletes a gateway from a resource group.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, gateway_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Returns a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum)
    # @param expand [GatewayExpandOption] Gets subscription credentials which
    # uniquely identify Microsoft Azure subscription. The subscription ID forms
    # part of the URI for every service call. Possible values include: 'status'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResource] operation results.
    #
    def get(resource_group_name, gateway_name, expand = nil, custom_headers = nil)
      response = get_async(resource_group_name, gateway_name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum)
    # @param expand [GatewayExpandOption] Gets subscription credentials which
    # uniquely identify Microsoft Azure subscription. The subscription ID forms
    # part of the URI for every service call. Possible values include: 'status'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, gateway_name, expand = nil, custom_headers = nil)
      get_async(resource_group_name, gateway_name, expand, custom_headers).value!
    end

    #
    # Returns a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum)
    # @param expand [GatewayExpandOption] Gets subscription credentials which
    # uniquely identify Microsoft Azure subscription. The subscription ID forms
    # part of the URI for every service call. Possible values include: 'status'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, gateway_name, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns gateways in a subscription
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResources] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(custom_headers = nil)
      response = list_async(custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Returns gateways in a subscription
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GatewayResource>] operation results.
    #
    def list(custom_headers = nil)
      first_page = list_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Returns gateways in a subscription
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Returns gateways in a subscription
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.ServerManagement/gateways'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResources.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns gateways in a resource group
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResources] which provide lazy access to pages of the
    # response.
    #
    def list_for_resource_group_as_lazy(resource_group_name, custom_headers = nil)
      response = list_for_resource_group_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_for_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Returns gateways in a resource group
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GatewayResource>] operation results.
    #
    def list_for_resource_group(resource_group_name, custom_headers = nil)
      first_page = list_for_resource_group_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Returns gateways in a resource group
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_for_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_for_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Returns gateways in a resource group
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_for_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResources.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Upgrade a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def upgrade(resource_group_name, gateway_name, custom_headers = nil)
      response = upgrade_async(resource_group_name, gateway_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def upgrade_async(resource_group_name, gateway_name, custom_headers = nil)
      # Send request
      promise = begin_upgrade_async(resource_group_name, gateway_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Upgrade a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_upgrade(resource_group_name, gateway_name, custom_headers = nil)
      response = begin_upgrade_async(resource_group_name, gateway_name, custom_headers).value!
      nil
    end

    #
    # Upgrade a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_upgrade_with_http_info(resource_group_name, gateway_name, custom_headers = nil)
      begin_upgrade_async(resource_group_name, gateway_name, custom_headers).value!
    end

    #
    # Upgrade a gateway
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_upgrade_async(resource_group_name, gateway_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/upgradetolatest'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Regenerate a gateway's profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def regenerate_profile(resource_group_name, gateway_name, custom_headers = nil)
      response = regenerate_profile_async(resource_group_name, gateway_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def regenerate_profile_async(resource_group_name, gateway_name, custom_headers = nil)
      # Send request
      promise = begin_regenerate_profile_async(resource_group_name, gateway_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Regenerate a gateway's profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_regenerate_profile(resource_group_name, gateway_name, custom_headers = nil)
      response = begin_regenerate_profile_async(resource_group_name, gateway_name, custom_headers).value!
      nil
    end

    #
    # Regenerate a gateway's profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_regenerate_profile_with_http_info(resource_group_name, gateway_name, custom_headers = nil)
      begin_regenerate_profile_async(resource_group_name, gateway_name, custom_headers).value!
    end

    #
    # Regenerate a gateway's profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_regenerate_profile_async(resource_group_name, gateway_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/regenerateprofile'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a gateway profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayProfile] operation results.
    #
    def get_profile(resource_group_name, gateway_name, custom_headers = nil)
      response = get_profile_async(resource_group_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_profile_async(resource_group_name, gateway_name, custom_headers = nil)
      # Send request
      promise = begin_get_profile_async(resource_group_name, gateway_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = GatewayProfile.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a gateway profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayProfile] operation results.
    #
    def begin_get_profile(resource_group_name, gateway_name, custom_headers = nil)
      response = begin_get_profile_async(resource_group_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a gateway profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_profile_with_http_info(resource_group_name, gateway_name, custom_headers = nil)
      begin_get_profile_async(resource_group_name, gateway_name, custom_headers).value!
    end

    #
    # Gets a gateway profile
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param gateway_name [String] The gateway name (256 characters maximum).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_profile_async(resource_group_name, gateway_name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/gateways/{gatewayName}/profile'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'gatewayName' => gateway_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayProfile.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns gateways in a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResources] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns gateways in a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Returns gateways in a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResources.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns gateways in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayResources] operation results.
    #
    def list_for_resource_group_next(next_page_link, custom_headers = nil)
      response = list_for_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns gateways in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_for_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_for_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Returns gateways in a resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful
    # call to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_for_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = GatewayResources.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
