// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/genomics/v1/variants.proto
// DO NOT EDIT!

package google_genomics_v1 // import "google.golang.org/genproto/googleapis/genomics/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf"
import google_protobuf3 "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Operations to be performed during import on Variant info fields.
// These operations are set for each info field in the info_merge_config
// map of ImportVariantsRequest, which is plumbed down to the
// MergeVariantRequests generated by the import job.
type InfoMergeOperation int32

const (
	InfoMergeOperation_INFO_MERGE_OPERATION_UNSPECIFIED InfoMergeOperation = 0
	// By default, Variant info fields are persisted if the Variant doesn't
	// already exist in the variantset.  If the Variant is equivalent to a
	// Variant already in the variantset, the incoming Variant's info field
	// is ignored in favor of that of the already persisted Variant.
	InfoMergeOperation_IGNORE_NEW InfoMergeOperation = 1
	// This operation removes an info field from the incoming Variant
	// and persists this info field in each of the incoming Variant's Calls.
	InfoMergeOperation_MOVE_TO_CALLS InfoMergeOperation = 2
)

var InfoMergeOperation_name = map[int32]string{
	0: "INFO_MERGE_OPERATION_UNSPECIFIED",
	1: "IGNORE_NEW",
	2: "MOVE_TO_CALLS",
}
var InfoMergeOperation_value = map[string]int32{
	"INFO_MERGE_OPERATION_UNSPECIFIED": 0,
	"IGNORE_NEW":                       1,
	"MOVE_TO_CALLS":                    2,
}

func (x InfoMergeOperation) String() string {
	return proto.EnumName(InfoMergeOperation_name, int32(x))
}
func (InfoMergeOperation) EnumDescriptor() ([]byte, []int) { return fileDescriptor11, []int{0} }

type VariantSetMetadata_Type int32

const (
	VariantSetMetadata_TYPE_UNSPECIFIED VariantSetMetadata_Type = 0
	VariantSetMetadata_INTEGER          VariantSetMetadata_Type = 1
	VariantSetMetadata_FLOAT            VariantSetMetadata_Type = 2
	VariantSetMetadata_FLAG             VariantSetMetadata_Type = 3
	VariantSetMetadata_CHARACTER        VariantSetMetadata_Type = 4
	VariantSetMetadata_STRING           VariantSetMetadata_Type = 5
)

var VariantSetMetadata_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "INTEGER",
	2: "FLOAT",
	3: "FLAG",
	4: "CHARACTER",
	5: "STRING",
}
var VariantSetMetadata_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"INTEGER":          1,
	"FLOAT":            2,
	"FLAG":             3,
	"CHARACTER":        4,
	"STRING":           5,
}

func (x VariantSetMetadata_Type) String() string {
	return proto.EnumName(VariantSetMetadata_Type_name, int32(x))
}
func (VariantSetMetadata_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor11, []int{0, 0} }

type ImportVariantsRequest_Format int32

const (
	ImportVariantsRequest_FORMAT_UNSPECIFIED ImportVariantsRequest_Format = 0
	// VCF (Variant Call Format). The VCF files should be uncompressed. gVCF is
	// also supported.
	ImportVariantsRequest_FORMAT_VCF ImportVariantsRequest_Format = 1
	// Complete Genomics masterVarBeta format. The masterVarBeta files should
	// be bzip2 compressed.
	ImportVariantsRequest_FORMAT_COMPLETE_GENOMICS ImportVariantsRequest_Format = 2
)

var ImportVariantsRequest_Format_name = map[int32]string{
	0: "FORMAT_UNSPECIFIED",
	1: "FORMAT_VCF",
	2: "FORMAT_COMPLETE_GENOMICS",
}
var ImportVariantsRequest_Format_value = map[string]int32{
	"FORMAT_UNSPECIFIED":       0,
	"FORMAT_VCF":               1,
	"FORMAT_COMPLETE_GENOMICS": 2,
}

func (x ImportVariantsRequest_Format) String() string {
	return proto.EnumName(ImportVariantsRequest_Format_name, int32(x))
}
func (ImportVariantsRequest_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor11, []int{6, 0}
}

type ExportVariantSetRequest_Format int32

const (
	ExportVariantSetRequest_FORMAT_UNSPECIFIED ExportVariantSetRequest_Format = 0
	// Export the data to Google BigQuery.
	ExportVariantSetRequest_FORMAT_BIGQUERY ExportVariantSetRequest_Format = 1
)

var ExportVariantSetRequest_Format_name = map[int32]string{
	0: "FORMAT_UNSPECIFIED",
	1: "FORMAT_BIGQUERY",
}
var ExportVariantSetRequest_Format_value = map[string]int32{
	"FORMAT_UNSPECIFIED": 0,
	"FORMAT_BIGQUERY":    1,
}

func (x ExportVariantSetRequest_Format) String() string {
	return proto.EnumName(ExportVariantSetRequest_Format_name, int32(x))
}
func (ExportVariantSetRequest_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor11, []int{9, 0}
}

// Metadata describes a single piece of variant call metadata.
// These data include a top level key and either a single value string (value)
// or a list of key-value pairs (info.)
// Value and info are mutually exclusive.
type VariantSetMetadata struct {
	// The top-level key.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The value field for simple metadata
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// User-provided ID field, not enforced by this API.
	// Two or more pieces of structured metadata with identical
	// id and key fields are considered equivalent.
	Id string `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
	// The type of data. Possible types include: Integer, Float,
	// Flag, Character, and String.
	Type VariantSetMetadata_Type `protobuf:"varint,5,opt,name=type,enum=google.genomics.v1.VariantSetMetadata_Type" json:"type,omitempty"`
	// The number of values that can be included in a field described by this
	// metadata.
	Number string `protobuf:"bytes,8,opt,name=number" json:"number,omitempty"`
	// A textual description of this metadata.
	Description string `protobuf:"bytes,7,opt,name=description" json:"description,omitempty"`
	// Remaining structured metadata key-value pairs. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,3,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VariantSetMetadata) Reset()                    { *m = VariantSetMetadata{} }
func (m *VariantSetMetadata) String() string            { return proto.CompactTextString(m) }
func (*VariantSetMetadata) ProtoMessage()               {}
func (*VariantSetMetadata) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{0} }

func (m *VariantSetMetadata) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// A variant set is a collection of call sets and variants. It contains summary
// statistics of those contents. A variant set belongs to a dataset.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type VariantSet struct {
	// The dataset to which this variant set belongs.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The server-generated variant set ID, unique across all variant sets.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// The reference set to which the variant set is mapped. The reference set
	// describes the alignment provenance of the variant set, while the
	// `referenceBounds` describe the shape of the actual variant data. The
	// reference set's reference names are a superset of those found in the
	// `referenceBounds`.
	//
	// For example, given a variant set that is mapped to the GRCh38 reference set
	// and contains a single variant on reference 'X', `referenceBounds` would
	// contain only an entry for 'X', while the associated reference set
	// enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
	ReferenceSetId string `protobuf:"bytes,6,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// A list of all references used by the variants in a variant set
	// with associated coordinate upper bounds for each one.
	ReferenceBounds []*ReferenceBound `protobuf:"bytes,5,rep,name=reference_bounds,json=referenceBounds" json:"reference_bounds,omitempty"`
	// The metadata associated with this variant set.
	Metadata []*VariantSetMetadata `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty"`
	// User-specified, mutable name.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
	// A textual description of this variant set.
	Description string `protobuf:"bytes,8,opt,name=description" json:"description,omitempty"`
}

func (m *VariantSet) Reset()                    { *m = VariantSet{} }
func (m *VariantSet) String() string            { return proto.CompactTextString(m) }
func (*VariantSet) ProtoMessage()               {}
func (*VariantSet) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{1} }

func (m *VariantSet) GetReferenceBounds() []*ReferenceBound {
	if m != nil {
		return m.ReferenceBounds
	}
	return nil
}

func (m *VariantSet) GetMetadata() []*VariantSetMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// A variant represents a change in DNA sequence relative to a reference
// sequence. For example, a variant could represent a SNP or an insertion.
// Variants belong to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
//
// Each of the calls on a variant represent a determination of genotype with
// respect to that variant. For example, a call might assign probability of 0.32
// to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
// belongs to a call set, which contains related calls typically from one
// sample.
type Variant struct {
	// The ID of the variant set this variant belongs to.
	VariantSetId string `protobuf:"bytes,15,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The server-generated variant ID, unique across all variants.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Names for the variant, for example a RefSNP ID.
	Names []string `protobuf:"bytes,3,rep,name=names" json:"names,omitempty"`
	// The date this variant was created, in milliseconds from the epoch.
	Created int64 `protobuf:"varint,12,opt,name=created" json:"created,omitempty"`
	// The reference on which this variant occurs.
	// (such as `chr20` or `X`)
	ReferenceName string `protobuf:"bytes,14,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The position at which this variant occurs (0-based).
	// This corresponds to the first base of the string of reference bases.
	Start int64 `protobuf:"varint,16,opt,name=start" json:"start,omitempty"`
	// The end position (0-based) of this variant. This corresponds to the first
	// base after the last base in the reference allele. So, the length of
	// the reference allele is (end - start). This is useful for variants
	// that don't explicitly give alternate bases, for example large deletions.
	End int64 `protobuf:"varint,13,opt,name=end" json:"end,omitempty"`
	// The reference bases for this variant. They start at the given
	// position.
	ReferenceBases string `protobuf:"bytes,6,opt,name=reference_bases,json=referenceBases" json:"reference_bases,omitempty"`
	// The bases that appear instead of the reference bases.
	AlternateBases []string `protobuf:"bytes,7,rep,name=alternate_bases,json=alternateBases" json:"alternate_bases,omitempty"`
	// A measure of how likely this variant is to be real.
	// A higher value is better.
	Quality float64 `protobuf:"fixed64,8,opt,name=quality" json:"quality,omitempty"`
	// A list of filters (normally quality filters) this variant has failed.
	// `PASS` indicates this variant has passed all filters.
	Filter []string `protobuf:"bytes,9,rep,name=filter" json:"filter,omitempty"`
	// A map of additional variant information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,10,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The variant calls for this particular variant. Each one represents the
	// determination of genotype with respect to this variant.
	Calls []*VariantCall `protobuf:"bytes,11,rep,name=calls" json:"calls,omitempty"`
}

func (m *Variant) Reset()                    { *m = Variant{} }
func (m *Variant) String() string            { return proto.CompactTextString(m) }
func (*Variant) ProtoMessage()               {}
func (*Variant) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{2} }

func (m *Variant) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Variant) GetCalls() []*VariantCall {
	if m != nil {
		return m.Calls
	}
	return nil
}

// A call represents the determination of genotype with respect to a particular
// variant. It may include associated information such as quality and phasing.
// For example, a call might assign a probability of 0.32 to the occurrence of
// a SNP named rs1234 in a call set with the name NA12345.
type VariantCall struct {
	// The ID of the call set this variant call belongs to.
	CallSetId string `protobuf:"bytes,8,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
	// The name of the call set this variant call belongs to.
	CallSetName string `protobuf:"bytes,9,opt,name=call_set_name,json=callSetName" json:"call_set_name,omitempty"`
	// The genotype of this variant call. Each value represents either the value
	// of the `referenceBases` field or a 1-based index into
	// `alternateBases`. If a variant had a `referenceBases`
	// value of `T` and an `alternateBases`
	// value of `["A", "C"]`, and the `genotype` was
	// `[2, 1]`, that would mean the call
	// represented the heterozygous value `CA` for this variant.
	// If the `genotype` was instead `[0, 1]`, the
	// represented value would be `TA`. Ordering of the
	// genotype values is important if the `phaseset` is present.
	// If a genotype is not called (that is, a `.` is present in the
	// GT string) -1 is returned.
	Genotype []int32 `protobuf:"varint,7,rep,packed,name=genotype" json:"genotype,omitempty"`
	// If this field is present, this variant call's genotype ordering implies
	// the phase of the bases and is consistent with any other variant calls in
	// the same reference sequence which have the same phaseset value.
	// When importing data from VCF, if the genotype data was phased but no
	// phase set was specified this field will be set to `*`.
	Phaseset string `protobuf:"bytes,5,opt,name=phaseset" json:"phaseset,omitempty"`
	// The genotype likelihoods for this variant call. Each array entry
	// represents how likely a specific genotype is for this call. The value
	// ordering is defined by the GL tag in the VCF spec.
	// If Phred-scaled genotype likelihood scores (PL) are available and
	// log10(P) genotype likelihood scores (GL) are not, PL scores are converted
	// to GL scores.  If both are available, PL scores are stored in `info`.
	GenotypeLikelihood []float64 `protobuf:"fixed64,6,rep,packed,name=genotype_likelihood,json=genotypeLikelihood" json:"genotype_likelihood,omitempty"`
	// A map of additional variant call information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,2,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VariantCall) Reset()                    { *m = VariantCall{} }
func (m *VariantCall) String() string            { return proto.CompactTextString(m) }
func (*VariantCall) ProtoMessage()               {}
func (*VariantCall) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{3} }

func (m *VariantCall) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// A call set is a collection of variant calls, typically for one sample. It
// belongs to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type CallSet struct {
	// The server-generated call set ID, unique across all call sets.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The call set name.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The sample ID this call set corresponds to.
	SampleId string `protobuf:"bytes,7,opt,name=sample_id,json=sampleId" json:"sample_id,omitempty"`
	// The IDs of the variant sets this call set belongs to. This field must
	// have exactly length one, as a call set belongs to a single variant set.
	// This field is repeated for compatibility with the
	// [GA4GH 0.5.1
	// API](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variants.avdl#L76).
	VariantSetIds []string `protobuf:"bytes,6,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// The date this call set was created in milliseconds from the epoch.
	Created int64 `protobuf:"varint,5,opt,name=created" json:"created,omitempty"`
	// A map of additional call set information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,4,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CallSet) Reset()                    { *m = CallSet{} }
func (m *CallSet) String() string            { return proto.CompactTextString(m) }
func (*CallSet) ProtoMessage()               {}
func (*CallSet) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{4} }

func (m *CallSet) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// ReferenceBound records an upper bound for the starting coordinate of
// variants in a particular reference.
type ReferenceBound struct {
	// The name of the reference associated with this reference bound.
	ReferenceName string `protobuf:"bytes,1,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// An upper bound (inclusive) on the starting coordinate of any
	// variant in the reference sequence.
	UpperBound int64 `protobuf:"varint,2,opt,name=upper_bound,json=upperBound" json:"upper_bound,omitempty"`
}

func (m *ReferenceBound) Reset()                    { *m = ReferenceBound{} }
func (m *ReferenceBound) String() string            { return proto.CompactTextString(m) }
func (*ReferenceBound) ProtoMessage()               {}
func (*ReferenceBound) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{5} }

// The variant data import request.
type ImportVariantsRequest struct {
	// Required. The variant set to which variant data should be imported.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// A list of URIs referencing variant files in Google Cloud Storage. URIs can
	// include wildcards [as described
	// here](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames).
	// Note that recursive wildcards ('**') are not supported.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris" json:"source_uris,omitempty"`
	// The format of the variant data being imported. If unspecified, defaults to
	// to `VCF`.
	Format ImportVariantsRequest_Format `protobuf:"varint,3,opt,name=format,enum=google.genomics.v1.ImportVariantsRequest_Format" json:"format,omitempty"`
	// Convert reference names to the canonical representation.
	// hg19 haploytypes (those reference names containing "_hap")
	// are not modified in any way.
	// All other reference names are modified according to the following rules:
	// The reference name is capitalized.
	// The "chr" prefix is dropped for all autosomes and sex chromsomes.
	// For example "chr17" becomes "17" and "chrX" becomes "X".
	// All mitochondrial chromosomes ("chrM", "chrMT", etc) become "MT".
	NormalizeReferenceNames bool `protobuf:"varint,5,opt,name=normalize_reference_names,json=normalizeReferenceNames" json:"normalize_reference_names,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them. This is plumbed down to the MergeVariantRequests
	// generated by the resulting import job.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,6,rep,name=info_merge_config,json=infoMergeConfig" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.genomics.v1.InfoMergeOperation"`
}

func (m *ImportVariantsRequest) Reset()                    { *m = ImportVariantsRequest{} }
func (m *ImportVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportVariantsRequest) ProtoMessage()               {}
func (*ImportVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{6} }

func (m *ImportVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if m != nil {
		return m.InfoMergeConfig
	}
	return nil
}

// The variant data import response.
type ImportVariantsResponse struct {
	// IDs of the call sets created during the import.
	CallSetIds []string `protobuf:"bytes,1,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
}

func (m *ImportVariantsResponse) Reset()                    { *m = ImportVariantsResponse{} }
func (m *ImportVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportVariantsResponse) ProtoMessage()               {}
func (*ImportVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{7} }

// The CreateVariantSet request
type CreateVariantSetRequest struct {
	// Required. The variant set to be created. Must have a valid `datasetId`.
	VariantSet *VariantSet `protobuf:"bytes,1,opt,name=variant_set,json=variantSet" json:"variant_set,omitempty"`
}

func (m *CreateVariantSetRequest) Reset()                    { *m = CreateVariantSetRequest{} }
func (m *CreateVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariantSetRequest) ProtoMessage()               {}
func (*CreateVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{8} }

func (m *CreateVariantSetRequest) GetVariantSet() *VariantSet {
	if m != nil {
		return m.VariantSet
	}
	return nil
}

// The variant data export request.
type ExportVariantSetRequest struct {
	// Required. The ID of the variant set that contains variant data which
	// should be exported. The caller must have READ access to this variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// If provided, only variant call information from the specified call sets
	// will be exported. By default all variant calls are exported.
	CallSetIds []string `protobuf:"bytes,2,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. The Google Cloud project ID that owns the destination
	// BigQuery dataset. The caller must have WRITE access to this project.  This
	// project will also own the resulting export job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The format for the exported data.
	Format ExportVariantSetRequest_Format `protobuf:"varint,4,opt,name=format,enum=google.genomics.v1.ExportVariantSetRequest_Format" json:"format,omitempty"`
	// Required. The BigQuery dataset to export data to. This dataset must already
	// exist. Note that this is distinct from the Genomics concept of "dataset".
	BigqueryDataset string `protobuf:"bytes,5,opt,name=bigquery_dataset,json=bigqueryDataset" json:"bigquery_dataset,omitempty"`
	// Required. The BigQuery table to export data to.
	// If the table doesn't exist, it will be created. If it already exists, it
	// will be overwritten.
	BigqueryTable string `protobuf:"bytes,6,opt,name=bigquery_table,json=bigqueryTable" json:"bigquery_table,omitempty"`
}

func (m *ExportVariantSetRequest) Reset()                    { *m = ExportVariantSetRequest{} }
func (m *ExportVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportVariantSetRequest) ProtoMessage()               {}
func (*ExportVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{9} }

// The variant set request.
type GetVariantSetRequest struct {
	// Required. The ID of the variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
}

func (m *GetVariantSetRequest) Reset()                    { *m = GetVariantSetRequest{} }
func (m *GetVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariantSetRequest) ProtoMessage()               {}
func (*GetVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{10} }

// The search variant sets request.
type SearchVariantSetsRequest struct {
	// Exactly one dataset ID must be provided here. Only variant sets which
	// belong to this dataset will be returned.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds" json:"dataset_ids,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchVariantSetsRequest) Reset()                    { *m = SearchVariantSetsRequest{} }
func (m *SearchVariantSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantSetsRequest) ProtoMessage()               {}
func (*SearchVariantSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{11} }

// The search variant sets response.
type SearchVariantSetsResponse struct {
	// The variant sets belonging to the requested dataset.
	VariantSets []*VariantSet `protobuf:"bytes,1,rep,name=variant_sets,json=variantSets" json:"variant_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchVariantSetsResponse) Reset()                    { *m = SearchVariantSetsResponse{} }
func (m *SearchVariantSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantSetsResponse) ProtoMessage()               {}
func (*SearchVariantSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{12} }

func (m *SearchVariantSetsResponse) GetVariantSets() []*VariantSet {
	if m != nil {
		return m.VariantSets
	}
	return nil
}

// The delete variant set request.
type DeleteVariantSetRequest struct {
	// The ID of the variant set to be deleted.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
}

func (m *DeleteVariantSetRequest) Reset()                    { *m = DeleteVariantSetRequest{} }
func (m *DeleteVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariantSetRequest) ProtoMessage()               {}
func (*DeleteVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{13} }

type UpdateVariantSetRequest struct {
	// The ID of the variant to be updated (must already exist).
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The new variant data. Only the variant_set.metadata will be considered
	// for update.
	VariantSet *VariantSet `protobuf:"bytes,2,opt,name=variant_set,json=variantSet" json:"variant_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [metadata][google.genomics.v1.VariantSet.metadata].
	// * [name][google.genomics.v1.VariantSet.name].
	// * [description][google.genomics.v1.VariantSet.description].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateVariantSetRequest) Reset()                    { *m = UpdateVariantSetRequest{} }
func (m *UpdateVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariantSetRequest) ProtoMessage()               {}
func (*UpdateVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{14} }

func (m *UpdateVariantSetRequest) GetVariantSet() *VariantSet {
	if m != nil {
		return m.VariantSet
	}
	return nil
}

func (m *UpdateVariantSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The variant search request.
type SearchVariantsRequest struct {
	// At most one variant set ID must be provided. Only variants from this
	// variant set will be returned. If omitted, a call set id must be included in
	// the request.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// Only return variants which have exactly this name.
	VariantName string `protobuf:"bytes,2,opt,name=variant_name,json=variantName" json:"variant_name,omitempty"`
	// Only return variant calls which belong to call sets with these ids.
	// Leaving this blank returns all variant calls. If a variant has no
	// calls belonging to any of these call sets, it won't be returned at all.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned. If unspecified, defaults to 0.
	Start int64 `protobuf:"varint,5,opt,name=start" json:"start,omitempty"`
	// The end of the window, 0-based exclusive. If unspecified or 0, defaults to
	// the length of the reference.
	End int64 `protobuf:"varint,6,opt,name=end" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of variants to return in a single page. If unspecified,
	// defaults to 5000. The maximum value is 10000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The maximum number of calls to return in a single page. Note that this
	// limit may be exceeded in the event that a matching variant contains more
	// calls than the requested maximum. If unspecified, defaults to 5000. The
	// maximum value is 10000.
	MaxCalls int32 `protobuf:"varint,9,opt,name=max_calls,json=maxCalls" json:"max_calls,omitempty"`
}

func (m *SearchVariantsRequest) Reset()                    { *m = SearchVariantsRequest{} }
func (m *SearchVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantsRequest) ProtoMessage()               {}
func (*SearchVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{15} }

// The variant search response.
type SearchVariantsResponse struct {
	// The list of matching Variants.
	Variants []*Variant `protobuf:"bytes,1,rep,name=variants" json:"variants,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchVariantsResponse) Reset()                    { *m = SearchVariantsResponse{} }
func (m *SearchVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantsResponse) ProtoMessage()               {}
func (*SearchVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{16} }

func (m *SearchVariantsResponse) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

type CreateVariantRequest struct {
	// The variant to be created.
	Variant *Variant `protobuf:"bytes,1,opt,name=variant" json:"variant,omitempty"`
}

func (m *CreateVariantRequest) Reset()                    { *m = CreateVariantRequest{} }
func (m *CreateVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariantRequest) ProtoMessage()               {}
func (*CreateVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{17} }

func (m *CreateVariantRequest) GetVariant() *Variant {
	if m != nil {
		return m.Variant
	}
	return nil
}

type UpdateVariantRequest struct {
	// The ID of the variant to be updated.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
	// The new variant data.
	Variant *Variant `protobuf:"bytes,2,opt,name=variant" json:"variant,omitempty"`
	// An optional mask specifying which fields to update. At this time, mutable
	// fields are [names][google.genomics.v1.Variant.names] and
	// [info][google.genomics.v1.Variant.info]. Acceptable values are "names" and
	// "info". If unspecified, all mutable fields will be updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateVariantRequest) Reset()                    { *m = UpdateVariantRequest{} }
func (m *UpdateVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariantRequest) ProtoMessage()               {}
func (*UpdateVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{18} }

func (m *UpdateVariantRequest) GetVariant() *Variant {
	if m != nil {
		return m.Variant
	}
	return nil
}

func (m *UpdateVariantRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteVariantRequest struct {
	// The ID of the variant to be deleted.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
}

func (m *DeleteVariantRequest) Reset()                    { *m = DeleteVariantRequest{} }
func (m *DeleteVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariantRequest) ProtoMessage()               {}
func (*DeleteVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{19} }

type GetVariantRequest struct {
	// The ID of the variant.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
}

func (m *GetVariantRequest) Reset()                    { *m = GetVariantRequest{} }
func (m *GetVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariantRequest) ProtoMessage()               {}
func (*GetVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{20} }

type MergeVariantsRequest struct {
	// The destination variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The variants to be merged with existing variants.
	Variants []*Variant `protobuf:"bytes,2,rep,name=variants" json:"variants,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,3,rep,name=info_merge_config,json=infoMergeConfig" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.genomics.v1.InfoMergeOperation"`
}

func (m *MergeVariantsRequest) Reset()                    { *m = MergeVariantsRequest{} }
func (m *MergeVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*MergeVariantsRequest) ProtoMessage()               {}
func (*MergeVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{21} }

func (m *MergeVariantsRequest) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

func (m *MergeVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if m != nil {
		return m.InfoMergeConfig
	}
	return nil
}

// The call set search request.
type SearchCallSetsRequest struct {
	// Restrict the query to call sets within the given variant sets. At least one
	// ID must be provided.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// Only return call sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchCallSetsRequest) Reset()                    { *m = SearchCallSetsRequest{} }
func (m *SearchCallSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchCallSetsRequest) ProtoMessage()               {}
func (*SearchCallSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{22} }

// The call set search response.
type SearchCallSetsResponse struct {
	// The list of matching call sets.
	CallSets []*CallSet `protobuf:"bytes,1,rep,name=call_sets,json=callSets" json:"call_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchCallSetsResponse) Reset()                    { *m = SearchCallSetsResponse{} }
func (m *SearchCallSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchCallSetsResponse) ProtoMessage()               {}
func (*SearchCallSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{23} }

func (m *SearchCallSetsResponse) GetCallSets() []*CallSet {
	if m != nil {
		return m.CallSets
	}
	return nil
}

type CreateCallSetRequest struct {
	// The call set to be created.
	CallSet *CallSet `protobuf:"bytes,1,opt,name=call_set,json=callSet" json:"call_set,omitempty"`
}

func (m *CreateCallSetRequest) Reset()                    { *m = CreateCallSetRequest{} }
func (m *CreateCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCallSetRequest) ProtoMessage()               {}
func (*CreateCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{24} }

func (m *CreateCallSetRequest) GetCallSet() *CallSet {
	if m != nil {
		return m.CallSet
	}
	return nil
}

type UpdateCallSetRequest struct {
	// The ID of the call set to be updated.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
	// The new call set data.
	CallSet *CallSet `protobuf:"bytes,2,opt,name=call_set,json=callSet" json:"call_set,omitempty"`
	// An optional mask specifying which fields to update. At this time, the only
	// mutable field is [name][google.genomics.v1.CallSet.name]. The only
	// acceptable value is "name". If unspecified, all mutable fields will be
	// updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateCallSetRequest) Reset()                    { *m = UpdateCallSetRequest{} }
func (m *UpdateCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateCallSetRequest) ProtoMessage()               {}
func (*UpdateCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{25} }

func (m *UpdateCallSetRequest) GetCallSet() *CallSet {
	if m != nil {
		return m.CallSet
	}
	return nil
}

func (m *UpdateCallSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteCallSetRequest struct {
	// The ID of the call set to be deleted.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
}

func (m *DeleteCallSetRequest) Reset()                    { *m = DeleteCallSetRequest{} }
func (m *DeleteCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCallSetRequest) ProtoMessage()               {}
func (*DeleteCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{26} }

type GetCallSetRequest struct {
	// The ID of the call set.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
}

func (m *GetCallSetRequest) Reset()                    { *m = GetCallSetRequest{} }
func (m *GetCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCallSetRequest) ProtoMessage()               {}
func (*GetCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{27} }

// The stream variants request.
type StreamVariantsRequest struct {
	// The Google Developers Console project ID or number which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The variant set ID from which to stream variants.
	VariantSetId string `protobuf:"bytes,2,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// Only return variant calls which belong to call sets with these IDs.
	// Leaving this blank returns all variant calls.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned.
	Start int64 `protobuf:"varint,5,opt,name=start" json:"start,omitempty"`
	// The end of the window (0-based, exclusive) for which overlapping
	// variants should be returned.
	End int64 `protobuf:"varint,6,opt,name=end" json:"end,omitempty"`
}

func (m *StreamVariantsRequest) Reset()                    { *m = StreamVariantsRequest{} }
func (m *StreamVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamVariantsRequest) ProtoMessage()               {}
func (*StreamVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{28} }

type StreamVariantsResponse struct {
	Variants []*Variant `protobuf:"bytes,1,rep,name=variants" json:"variants,omitempty"`
}

func (m *StreamVariantsResponse) Reset()                    { *m = StreamVariantsResponse{} }
func (m *StreamVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamVariantsResponse) ProtoMessage()               {}
func (*StreamVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{29} }

func (m *StreamVariantsResponse) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

func init() {
	proto.RegisterType((*VariantSetMetadata)(nil), "google.genomics.v1.VariantSetMetadata")
	proto.RegisterType((*VariantSet)(nil), "google.genomics.v1.VariantSet")
	proto.RegisterType((*Variant)(nil), "google.genomics.v1.Variant")
	proto.RegisterType((*VariantCall)(nil), "google.genomics.v1.VariantCall")
	proto.RegisterType((*CallSet)(nil), "google.genomics.v1.CallSet")
	proto.RegisterType((*ReferenceBound)(nil), "google.genomics.v1.ReferenceBound")
	proto.RegisterType((*ImportVariantsRequest)(nil), "google.genomics.v1.ImportVariantsRequest")
	proto.RegisterType((*ImportVariantsResponse)(nil), "google.genomics.v1.ImportVariantsResponse")
	proto.RegisterType((*CreateVariantSetRequest)(nil), "google.genomics.v1.CreateVariantSetRequest")
	proto.RegisterType((*ExportVariantSetRequest)(nil), "google.genomics.v1.ExportVariantSetRequest")
	proto.RegisterType((*GetVariantSetRequest)(nil), "google.genomics.v1.GetVariantSetRequest")
	proto.RegisterType((*SearchVariantSetsRequest)(nil), "google.genomics.v1.SearchVariantSetsRequest")
	proto.RegisterType((*SearchVariantSetsResponse)(nil), "google.genomics.v1.SearchVariantSetsResponse")
	proto.RegisterType((*DeleteVariantSetRequest)(nil), "google.genomics.v1.DeleteVariantSetRequest")
	proto.RegisterType((*UpdateVariantSetRequest)(nil), "google.genomics.v1.UpdateVariantSetRequest")
	proto.RegisterType((*SearchVariantsRequest)(nil), "google.genomics.v1.SearchVariantsRequest")
	proto.RegisterType((*SearchVariantsResponse)(nil), "google.genomics.v1.SearchVariantsResponse")
	proto.RegisterType((*CreateVariantRequest)(nil), "google.genomics.v1.CreateVariantRequest")
	proto.RegisterType((*UpdateVariantRequest)(nil), "google.genomics.v1.UpdateVariantRequest")
	proto.RegisterType((*DeleteVariantRequest)(nil), "google.genomics.v1.DeleteVariantRequest")
	proto.RegisterType((*GetVariantRequest)(nil), "google.genomics.v1.GetVariantRequest")
	proto.RegisterType((*MergeVariantsRequest)(nil), "google.genomics.v1.MergeVariantsRequest")
	proto.RegisterType((*SearchCallSetsRequest)(nil), "google.genomics.v1.SearchCallSetsRequest")
	proto.RegisterType((*SearchCallSetsResponse)(nil), "google.genomics.v1.SearchCallSetsResponse")
	proto.RegisterType((*CreateCallSetRequest)(nil), "google.genomics.v1.CreateCallSetRequest")
	proto.RegisterType((*UpdateCallSetRequest)(nil), "google.genomics.v1.UpdateCallSetRequest")
	proto.RegisterType((*DeleteCallSetRequest)(nil), "google.genomics.v1.DeleteCallSetRequest")
	proto.RegisterType((*GetCallSetRequest)(nil), "google.genomics.v1.GetCallSetRequest")
	proto.RegisterType((*StreamVariantsRequest)(nil), "google.genomics.v1.StreamVariantsRequest")
	proto.RegisterType((*StreamVariantsResponse)(nil), "google.genomics.v1.StreamVariantsResponse")
	proto.RegisterEnum("google.genomics.v1.InfoMergeOperation", InfoMergeOperation_name, InfoMergeOperation_value)
	proto.RegisterEnum("google.genomics.v1.VariantSetMetadata_Type", VariantSetMetadata_Type_name, VariantSetMetadata_Type_value)
	proto.RegisterEnum("google.genomics.v1.ImportVariantsRequest_Format", ImportVariantsRequest_Format_name, ImportVariantsRequest_Format_value)
	proto.RegisterEnum("google.genomics.v1.ExportVariantSetRequest_Format", ExportVariantSetRequest_Format_name, ExportVariantSetRequest_Format_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for StreamingVariantService service

type StreamingVariantServiceClient interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error)
}

type streamingVariantServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingVariantServiceClient(cc *grpc.ClientConn) StreamingVariantServiceClient {
	return &streamingVariantServiceClient{cc}
}

func (c *streamingVariantServiceClient) StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_StreamingVariantService_serviceDesc.Streams[0], c.cc, "/google.genomics.v1.StreamingVariantService/StreamVariants", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVariantServiceStreamVariantsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingVariantService_StreamVariantsClient interface {
	Recv() (*StreamVariantsResponse, error)
	grpc.ClientStream
}

type streamingVariantServiceStreamVariantsClient struct {
	grpc.ClientStream
}

func (x *streamingVariantServiceStreamVariantsClient) Recv() (*StreamVariantsResponse, error) {
	m := new(StreamVariantsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for StreamingVariantService service

type StreamingVariantServiceServer interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(*StreamVariantsRequest, StreamingVariantService_StreamVariantsServer) error
}

func RegisterStreamingVariantServiceServer(s *grpc.Server, srv StreamingVariantServiceServer) {
	s.RegisterService(&_StreamingVariantService_serviceDesc, srv)
}

func _StreamingVariantService_StreamVariants_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamVariantsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingVariantServiceServer).StreamVariants(m, &streamingVariantServiceStreamVariantsServer{stream})
}

type StreamingVariantService_StreamVariantsServer interface {
	Send(*StreamVariantsResponse) error
	grpc.ServerStream
}

type streamingVariantServiceStreamVariantsServer struct {
	grpc.ServerStream
}

func (x *streamingVariantServiceStreamVariantsServer) Send(m *StreamVariantsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingVariantService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingVariantService",
	HandlerType: (*StreamingVariantServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamVariants",
			Handler:       _StreamingVariantService_StreamVariants_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/genomics/v1/variants.proto",
}

// Client API for VariantServiceV1 service

type VariantServiceV1Client interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
}

type variantServiceV1Client struct {
	cc *grpc.ClientConn
}

func NewVariantServiceV1Client(cc *grpc.ClientConn) VariantServiceV1Client {
	return &variantServiceV1Client{cc}
}

func (c *variantServiceV1Client) ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ImportVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ExportVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error) {
	out := new(SearchVariantSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariantSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error) {
	out := new(SearchVariantsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/MergeVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error) {
	out := new(SearchCallSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchCallSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VariantServiceV1 service

type VariantServiceV1Server interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(context.Context, *ImportVariantsRequest) (*google_longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(context.Context, *CreateVariantSetRequest) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(context.Context, *ExportVariantSetRequest) (*google_longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(context.Context, *GetVariantSetRequest) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(context.Context, *SearchVariantSetsRequest) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(context.Context, *DeleteVariantSetRequest) (*google_protobuf1.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(context.Context, *UpdateVariantSetRequest) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(context.Context, *SearchVariantsRequest) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(context.Context, *CreateVariantRequest) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(context.Context, *UpdateVariantRequest) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(context.Context, *DeleteVariantRequest) (*google_protobuf1.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(context.Context, *GetVariantRequest) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(context.Context, *MergeVariantsRequest) (*google_protobuf1.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(context.Context, *SearchCallSetsRequest) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(context.Context, *CreateCallSetRequest) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(context.Context, *UpdateCallSetRequest) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(context.Context, *DeleteCallSetRequest) (*google_protobuf1.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(context.Context, *GetCallSetRequest) (*CallSet, error)
}

func RegisterVariantServiceV1Server(s *grpc.Server, srv VariantServiceV1Server) {
	s.RegisterService(&_VariantServiceV1_serviceDesc, srv)
}

func _VariantServiceV1_ImportVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ImportVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, req.(*ImportVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, req.(*CreateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_ExportVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ExportVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, req.(*ExportVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, req.(*GetVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariantSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariantSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, req.(*SearchVariantSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, req.(*DeleteVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, req.(*UpdateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, req.(*SearchVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, req.(*CreateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, req.(*UpdateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, req.(*DeleteVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariant(ctx, req.(*GetVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_MergeVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/MergeVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, req.(*MergeVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchCallSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCallSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchCallSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, req.(*SearchCallSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, req.(*CreateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, req.(*UpdateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, req.(*DeleteCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, req.(*GetCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VariantServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.VariantServiceV1",
	HandlerType: (*VariantServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportVariants",
			Handler:    _VariantServiceV1_ImportVariants_Handler,
		},
		{
			MethodName: "CreateVariantSet",
			Handler:    _VariantServiceV1_CreateVariantSet_Handler,
		},
		{
			MethodName: "ExportVariantSet",
			Handler:    _VariantServiceV1_ExportVariantSet_Handler,
		},
		{
			MethodName: "GetVariantSet",
			Handler:    _VariantServiceV1_GetVariantSet_Handler,
		},
		{
			MethodName: "SearchVariantSets",
			Handler:    _VariantServiceV1_SearchVariantSets_Handler,
		},
		{
			MethodName: "DeleteVariantSet",
			Handler:    _VariantServiceV1_DeleteVariantSet_Handler,
		},
		{
			MethodName: "UpdateVariantSet",
			Handler:    _VariantServiceV1_UpdateVariantSet_Handler,
		},
		{
			MethodName: "SearchVariants",
			Handler:    _VariantServiceV1_SearchVariants_Handler,
		},
		{
			MethodName: "CreateVariant",
			Handler:    _VariantServiceV1_CreateVariant_Handler,
		},
		{
			MethodName: "UpdateVariant",
			Handler:    _VariantServiceV1_UpdateVariant_Handler,
		},
		{
			MethodName: "DeleteVariant",
			Handler:    _VariantServiceV1_DeleteVariant_Handler,
		},
		{
			MethodName: "GetVariant",
			Handler:    _VariantServiceV1_GetVariant_Handler,
		},
		{
			MethodName: "MergeVariants",
			Handler:    _VariantServiceV1_MergeVariants_Handler,
		},
		{
			MethodName: "SearchCallSets",
			Handler:    _VariantServiceV1_SearchCallSets_Handler,
		},
		{
			MethodName: "CreateCallSet",
			Handler:    _VariantServiceV1_CreateCallSet_Handler,
		},
		{
			MethodName: "UpdateCallSet",
			Handler:    _VariantServiceV1_UpdateCallSet_Handler,
		},
		{
			MethodName: "DeleteCallSet",
			Handler:    _VariantServiceV1_DeleteCallSet_Handler,
		},
		{
			MethodName: "GetCallSet",
			Handler:    _VariantServiceV1_GetCallSet_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/genomics/v1/variants.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/genomics/v1/variants.proto", fileDescriptor11)
}

var fileDescriptor11 = []byte{
	// 2369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xcc, 0x59, 0x5f, 0x6f, 0x1b, 0xc7,
	0x11, 0xef, 0x1d, 0x49, 0x89, 0x1c, 0x8a, 0x14, 0xbd, 0x51, 0xa4, 0x0b, 0x13, 0xdb, 0xca, 0xc1,
	0x76, 0x14, 0xd5, 0x25, 0x6d, 0xba, 0x4a, 0x53, 0x35, 0xa9, 0x2b, 0xd1, 0x94, 0xc2, 0x42, 0x22,
	0x95, 0x13, 0xed, 0xd6, 0x05, 0x0a, 0xe2, 0x44, 0xae, 0xe8, 0xb3, 0xc9, 0x3b, 0xfa, 0xee, 0xa8,
	0x5a, 0x36, 0xfc, 0xd0, 0xf4, 0x1f, 0x02, 0x14, 0x28, 0xd0, 0x00, 0x7d, 0xea, 0x6b, 0x1f, 0x8a,
	0x16, 0xfd, 0x06, 0xfe, 0x06, 0x6d, 0x5f, 0x8a, 0x7e, 0x83, 0x7e, 0x88, 0x3e, 0x16, 0xbb, 0xb7,
	0x7b, 0xbc, 0x3b, 0x2e, 0x8f, 0x94, 0x83, 0x04, 0x7d, 0xb1, 0xb9, 0xb3, 0xb3, 0x33, 0xb3, 0x33,
	0xbf, 0x99, 0x9d, 0x39, 0xc1, 0x0f, 0x7a, 0x96, 0xd5, 0xeb, 0xe3, 0x52, 0xcf, 0xea, 0xeb, 0x66,
	0xaf, 0x64, 0xd9, 0xbd, 0x72, 0x0f, 0x9b, 0x43, 0xdb, 0x72, 0xad, 0xb2, 0xb7, 0xa5, 0x0f, 0x0d,
	0x87, 0xd0, 0xac, 0x81, 0xd1, 0x71, 0xca, 0x67, 0xb7, 0xcb, 0x67, 0xba, 0x6d, 0xe8, 0xa6, 0xeb,
	0x94, 0x28, 0x17, 0x42, 0x5c, 0x02, 0x63, 0x29, 0x9d, 0xdd, 0x2e, 0xd6, 0xe7, 0x93, 0xaa, 0x0f,
	0x8d, 0xb2, 0x83, 0xed, 0x33, 0xa3, 0x83, 0x3b, 0x96, 0x79, 0x6a, 0xf4, 0xca, 0xba, 0x69, 0x5a,
	0xae, 0xee, 0x1a, 0x96, 0xc9, 0xc4, 0x17, 0x77, 0xe7, 0x13, 0xd5, 0xb7, 0xcc, 0x9e, 0x3d, 0x32,
	0x4d, 0xc3, 0xec, 0x95, 0xad, 0x21, 0xb6, 0x43, 0x32, 0xee, 0xf4, 0x0c, 0xf7, 0xd1, 0xe8, 0xa4,
	0xd4, 0xb1, 0x06, 0x65, 0x4f, 0x4e, 0x99, 0x6e, 0x9c, 0x8c, 0x4e, 0xcb, 0x43, 0xf7, 0x7c, 0x88,
	0x9d, 0x32, 0x1e, 0x0c, 0xdd, 0x73, 0xef, 0x5f, 0x76, 0xe8, 0xdb, 0x31, 0x8a, 0xfd, 0xd3, 0xa7,
	0x06, 0xee, 0x77, 0xdb, 0x03, 0xdd, 0x79, 0xc2, 0x4e, 0x6d, 0xcd, 0x56, 0xe5, 0xb8, 0xf6, 0xa8,
	0xe3, 0xb2, 0xff, 0xbc, 0x63, 0xea, 0xab, 0x04, 0xa0, 0x07, 0x9e, 0x5f, 0x8f, 0xb1, 0x7b, 0x88,
	0x5d, 0xbd, 0xab, 0xbb, 0x3a, 0x2a, 0x40, 0xe2, 0x09, 0x3e, 0x57, 0xa4, 0x75, 0x69, 0x23, 0xa3,
	0x91, 0x9f, 0x68, 0x05, 0x52, 0x67, 0x7a, 0x7f, 0x84, 0x15, 0x99, 0xd2, 0xbc, 0x05, 0xca, 0x83,
	0x6c, 0x74, 0x95, 0x24, 0x25, 0xc9, 0x46, 0x17, 0xdd, 0x85, 0x24, 0xd1, 0xa5, 0xa4, 0xd6, 0xa5,
	0x8d, 0x7c, 0xe5, 0x9b, 0xa5, 0xc9, 0x10, 0x95, 0x26, 0xb5, 0x95, 0x5a, 0xe7, 0x43, 0xac, 0xd1,
	0x83, 0x68, 0x15, 0x16, 0xcc, 0xd1, 0xe0, 0x04, 0xdb, 0x4a, 0x9a, 0x0a, 0x65, 0x2b, 0xb4, 0x0e,
	0xd9, 0x2e, 0x76, 0x3a, 0xb6, 0x31, 0x24, 0xfe, 0x55, 0x16, 0xe9, 0x66, 0x90, 0x84, 0xee, 0x41,
	0xd2, 0x30, 0x4f, 0x2d, 0x25, 0xb1, 0x9e, 0xd8, 0xc8, 0x56, 0x6e, 0xcd, 0xa9, 0xba, 0x6e, 0x9e,
	0x5a, 0x35, 0xd3, 0xb5, 0xcf, 0x35, 0x7a, 0xba, 0x78, 0x0c, 0x19, 0x9f, 0x24, 0xf0, 0xc2, 0xad,
	0xa0, 0x17, 0xb2, 0x95, 0x22, 0xd7, 0xc2, 0x5d, 0x5d, 0x3a, 0x30, 0x1c, 0xf7, 0x01, 0xe1, 0x60,
	0x1e, 0xda, 0x96, 0x3f, 0x94, 0xd4, 0x87, 0x90, 0x24, 0x57, 0x44, 0x2b, 0x50, 0x68, 0x3d, 0x3c,
	0xaa, 0xb5, 0xef, 0x37, 0x8e, 0x8f, 0x6a, 0xd5, 0xfa, 0x5e, 0xbd, 0x76, 0xaf, 0xf0, 0x0d, 0x94,
	0x85, 0xc5, 0x7a, 0xa3, 0x55, 0xdb, 0xaf, 0x69, 0x05, 0x09, 0x65, 0x20, 0xb5, 0x77, 0xd0, 0xdc,
	0x69, 0x15, 0x64, 0x94, 0x86, 0xe4, 0xde, 0xc1, 0xce, 0x7e, 0x21, 0x81, 0x72, 0x90, 0xa9, 0x7e,
	0xb2, 0xa3, 0xed, 0x54, 0x5b, 0x35, 0xad, 0x90, 0x44, 0x00, 0x0b, 0xc7, 0x2d, 0xad, 0xde, 0xd8,
	0x2f, 0xa4, 0xd4, 0xbf, 0xc9, 0x00, 0xe3, 0x6b, 0xa1, 0xcb, 0x00, 0xe4, 0x5a, 0x0e, 0x76, 0xdb,
	0x46, 0x97, 0x19, 0x9e, 0x61, 0x94, 0x7a, 0x97, 0x85, 0x4b, 0xf6, 0xc3, 0xb5, 0x01, 0x05, 0x1b,
	0x9f, 0x62, 0x1b, 0x9b, 0x1d, 0xdc, 0x66, 0x87, 0x16, 0xe8, 0x6e, 0xde, 0xa7, 0x1f, 0xd3, 0x93,
	0x87, 0x41, 0xce, 0x13, 0x6b, 0x64, 0x76, 0x1d, 0x25, 0x45, 0x3d, 0xad, 0x8a, 0x3c, 0xad, 0x71,
	0xde, 0x5d, 0xc2, 0xaa, 0x2d, 0xdb, 0xa1, 0xb5, 0x83, 0x76, 0x21, 0x3d, 0x60, 0x21, 0x50, 0x92,
	0x54, 0xcc, 0x8d, 0xf9, 0x02, 0xa6, 0xf9, 0xe7, 0x10, 0x82, 0xa4, 0xa9, 0x0f, 0x30, 0xc3, 0x02,
	0xfd, 0x1d, 0x85, 0x49, 0x7a, 0x02, 0x26, 0xea, 0xe7, 0x49, 0x58, 0x64, 0x62, 0xd1, 0x35, 0xc8,
	0xb3, 0x9a, 0xc2, 0x2f, 0xbf, 0x4c, 0x0f, 0x2c, 0x9d, 0xf9, 0x7a, 0x05, 0x4e, 0x5b, 0x81, 0x14,
	0xd1, 0xe5, 0x50, 0xa4, 0x65, 0x34, 0x6f, 0x81, 0x14, 0x58, 0xec, 0xd8, 0x58, 0x77, 0x71, 0x57,
	0x59, 0x5a, 0x97, 0x36, 0x12, 0x1a, 0x5f, 0xa2, 0xeb, 0x30, 0x76, 0x66, 0x9b, 0x5a, 0x9c, 0xa7,
	0xb2, 0x72, 0x3e, 0xb5, 0x41, 0x4c, 0x5f, 0x81, 0x94, 0xe3, 0xea, 0xb6, 0xab, 0x14, 0xe8, 0x71,
	0x6f, 0x41, 0x20, 0x88, 0xcd, 0xae, 0x92, 0xa3, 0x34, 0xf2, 0x13, 0xbd, 0x07, 0xcb, 0x81, 0x48,
	0xe8, 0x0e, 0x76, 0x26, 0x42, 0xb6, 0x4b, 0xa8, 0x84, 0x51, 0xef, 0xbb, 0xd8, 0x36, 0x75, 0x97,
	0x33, 0x2e, 0x52, 0x8b, 0xf3, 0x3e, 0xd9, 0x63, 0x54, 0x60, 0xf1, 0xe9, 0x48, 0xef, 0x1b, 0xee,
	0x39, 0x75, 0x98, 0xa4, 0xf1, 0x25, 0xc9, 0xc6, 0x53, 0x83, 0x30, 0x2b, 0x19, 0x7a, 0x92, 0xad,
	0xd0, 0x77, 0x59, 0xae, 0x01, 0x0d, 0xdd, 0xf5, 0x98, 0xd0, 0x45, 0x13, 0x0c, 0x6d, 0x41, 0xaa,
	0xa3, 0xf7, 0xfb, 0x8e, 0x92, 0xa5, 0x67, 0xaf, 0xc6, 0x9c, 0xad, 0xea, 0xfd, 0xbe, 0xe6, 0x71,
	0x7f, 0x35, 0x79, 0xf9, 0x4f, 0x19, 0xb2, 0x01, 0x5d, 0xe8, 0x0a, 0x64, 0x89, 0x36, 0x0e, 0x06,
	0x0f, 0x3d, 0x19, 0x42, 0xf2, 0x90, 0xa0, 0x42, 0xce, 0xdf, 0xa7, 0x81, 0xcc, 0x78, 0xf8, 0x62,
	0x1c, 0x34, 0x8c, 0x45, 0x48, 0x93, 0xab, 0xd0, 0x2a, 0x48, 0xdc, 0x9d, 0xd2, 0xfc, 0x35, 0xd9,
	0x1b, 0x3e, 0x22, 0x2e, 0xc7, 0x2e, 0xad, 0x90, 0x19, 0xcd, 0x5f, 0xa3, 0x32, 0xbc, 0xc1, 0xf9,
	0xda, 0x7d, 0xe3, 0x09, 0xee, 0x1b, 0x8f, 0x2c, 0x8b, 0x64, 0x63, 0x62, 0x43, 0xd2, 0x10, 0xdf,
	0x3a, 0xf0, 0x77, 0xd0, 0xc7, 0x2c, 0x06, 0x32, 0xf5, 0xe3, 0xfb, 0x33, 0xfc, 0xf8, 0xf5, 0x14,
	0xba, 0x3f, 0xca, 0xb0, 0x58, 0xf5, 0x9c, 0xc1, 0xd2, 0x46, 0xf2, 0xd3, 0x86, 0xa7, 0xab, 0x1c,
	0x48, 0xd7, 0xb7, 0x21, 0xe3, 0xe8, 0x83, 0x61, 0x1f, 0x13, 0x77, 0x7b, 0x79, 0x9c, 0xf6, 0x08,
	0xf5, 0x2e, 0xba, 0x01, 0xcb, 0xe1, 0xec, 0x74, 0xa8, 0x37, 0x32, 0x5a, 0x2e, 0x98, 0x9e, 0xa1,
	0xcc, 0x4b, 0x85, 0x33, 0x8f, 0xc3, 0x34, 0x39, 0x1d, 0xa6, 0xcc, 0xda, 0xaf, 0xc7, 0x3d, 0x3f,
	0x86, 0x7c, 0xb8, 0x30, 0x0a, 0x6a, 0x83, 0x24, 0xaa, 0x0d, 0x57, 0x21, 0x3b, 0x1a, 0x0e, 0xb1,
	0xed, 0x55, 0x5e, 0xaa, 0x34, 0xa1, 0x01, 0x25, 0x51, 0x39, 0xea, 0x6f, 0x93, 0xf0, 0x66, 0x7d,
	0x30, 0xb4, 0x6c, 0x97, 0xc5, 0xdc, 0xd1, 0xf0, 0xd3, 0x11, 0x76, 0x44, 0x35, 0x4e, 0x12, 0xd4,
	0xb8, 0xab, 0x90, 0x75, 0xac, 0x91, 0xdd, 0xc1, 0xed, 0x91, 0x6d, 0x38, 0x14, 0x53, 0x19, 0x0d,
	0x3c, 0xd2, 0x7d, 0xdb, 0x70, 0xd0, 0x27, 0xb0, 0x70, 0x6a, 0xd9, 0x03, 0xdd, 0x55, 0x12, 0xf4,
	0x69, 0x17, 0xbe, 0xaf, 0x42, 0x0b, 0x4a, 0x7b, 0xf4, 0x9c, 0xc6, 0xce, 0xa3, 0x6d, 0x78, 0xcb,
	0x24, 0xbf, 0xfa, 0xc6, 0x73, 0xdc, 0x0e, 0x5f, 0xde, 0xa1, 0x01, 0x4c, 0x6b, 0x6b, 0x3e, 0x83,
	0x16, 0x74, 0x83, 0x83, 0x1e, 0xc3, 0x25, 0x12, 0x9d, 0xf6, 0x00, 0xdb, 0x3d, 0xdc, 0xf6, 0x5a,
	0x37, 0x0a, 0x8a, 0x6c, 0xe5, 0xfb, 0xf3, 0x1b, 0x44, 0x02, 0x7b, 0x48, 0x24, 0x54, 0xa9, 0x00,
	0x2f, 0xec, 0xcb, 0x46, 0x98, 0x5a, 0x7c, 0x0c, 0x2b, 0x22, 0x46, 0x01, 0x18, 0x3e, 0x0a, 0x82,
	0x21, 0x2f, 0x7e, 0xc9, 0x7c, 0x51, 0x4d, 0xde, 0x23, 0x06, 0x81, 0xd1, 0x80, 0x05, 0xcf, 0x4b,
	0x68, 0x15, 0xd0, 0x5e, 0x53, 0x3b, 0xdc, 0x69, 0x45, 0x9a, 0x84, 0x3c, 0x00, 0xa3, 0x3f, 0xa8,
	0xee, 0x15, 0x24, 0xf4, 0x0e, 0x28, 0x6c, 0x5d, 0x6d, 0x1e, 0x1e, 0x1d, 0xd4, 0x5a, 0xb5, 0xf6,
	0x7e, 0xad, 0xd1, 0x3c, 0xac, 0x57, 0x8f, 0x0b, 0xb2, 0xba, 0x0d, 0xab, 0xd1, 0xab, 0x3b, 0x43,
	0xcb, 0x74, 0xc8, 0x03, 0xb9, 0x14, 0x28, 0x71, 0x8e, 0x22, 0x79, 0x91, 0xf6, 0x6b, 0x9c, 0xa3,
	0xfe, 0x04, 0xd6, 0xaa, 0x34, 0x7f, 0xc6, 0x8f, 0x2f, 0xc7, 0xd2, 0x5d, 0xc8, 0x06, 0xb0, 0x44,
	0x5d, 0x90, 0xad, 0x5c, 0x89, 0x7f, 0xb8, 0x35, 0x18, 0x03, 0x4d, 0xfd, 0xb7, 0x0c, 0x6b, 0xb5,
	0x67, 0x01, 0xc3, 0x02, 0xc2, 0xe7, 0x03, 0x6a, 0xd4, 0x7e, 0x39, 0x6a, 0x3f, 0x69, 0x81, 0x86,
	0xb6, 0xf5, 0x18, 0x77, 0xa8, 0x8c, 0x84, 0x57, 0xc3, 0x19, 0xa5, 0xde, 0x45, 0x3f, 0xf4, 0x81,
	0x9c, 0xa4, 0xd1, 0xaa, 0x88, 0xcc, 0x9f, 0x62, 0x63, 0x14, 0xca, 0xef, 0x43, 0xe1, 0xc4, 0xe8,
	0x3d, 0x1d, 0x61, 0xfb, 0xbc, 0xcd, 0x9a, 0x2c, 0x56, 0xd7, 0x97, 0x39, 0xfd, 0x9e, 0x47, 0x26,
	0x89, 0xee, 0xb3, 0xba, 0xfa, 0x49, 0x1f, 0xb3, 0x47, 0x3b, 0xc7, 0xa9, 0x2d, 0x42, 0x54, 0xb7,
	0x66, 0x02, 0xe1, 0x0d, 0x58, 0x66, 0xf4, 0xdd, 0xfa, 0xfe, 0xa7, 0xf7, 0x6b, 0xda, 0xc3, 0x82,
	0xa4, 0x7e, 0x04, 0x2b, 0xfb, 0xf8, 0x75, 0x7d, 0xaa, 0xfe, 0x0c, 0x94, 0x63, 0xac, 0xdb, 0x9d,
	0x47, 0x63, 0x01, 0x7e, 0xf9, 0xb8, 0x0a, 0xd9, 0x71, 0x43, 0xe9, 0xc3, 0xc5, 0xef, 0x28, 0x3d,
	0x77, 0xeb, 0x3d, 0xdc, 0x76, 0xad, 0x27, 0xd8, 0x64, 0xc5, 0x3d, 0x43, 0x28, 0x2d, 0x42, 0x20,
	0x15, 0x9e, 0x6e, 0x3b, 0xc6, 0x73, 0x4c, 0x83, 0x91, 0xd2, 0xd2, 0x84, 0x70, 0x6c, 0x3c, 0xc7,
	0xea, 0xaf, 0x25, 0x78, 0x4b, 0xa0, 0x99, 0x41, 0x75, 0x07, 0x96, 0x02, 0xc6, 0x7b, 0xba, 0x67,
	0xc3, 0x2d, 0x3b, 0xbe, 0x9a, 0x43, 0x9e, 0x10, 0x13, 0x3f, 0x73, 0xdb, 0x13, 0x16, 0xe6, 0x08,
	0xf9, 0x88, 0x5b, 0xa9, 0xde, 0x85, 0xb5, 0x7b, 0xb8, 0x8f, 0x45, 0x98, 0x9f, 0xcf, 0x85, 0xaf,
	0x24, 0x58, 0xbb, 0x3f, 0xec, 0xea, 0xaf, 0x2d, 0x21, 0x9a, 0x5b, 0xf2, 0x45, 0x73, 0x0b, 0x7d,
	0x8f, 0xbc, 0x11, 0xc4, 0x02, 0x3a, 0x15, 0x52, 0x1c, 0x8a, 0x1e, 0xa6, 0x3d, 0x32, 0x38, 0x1e,
	0xea, 0xce, 0x13, 0xf2, 0x7e, 0x10, 0x76, 0xf2, 0x5b, 0xfd, 0xab, 0x0c, 0x6f, 0x86, 0x22, 0xe1,
	0x03, 0x40, 0xf0, 0x0a, 0x4b, 0xa2, 0x57, 0xf8, 0xdd, 0x71, 0xb4, 0x02, 0xcf, 0x3c, 0xbf, 0x53,
	0xc3, 0x6b, 0xce, 0xc3, 0xb9, 0x9b, 0x98, 0xc8, 0xdd, 0xc9, 0xe7, 0x30, 0x19, 0xdb, 0x2a, 0xa7,
	0x04, 0xad, 0xf2, 0xc2, 0xb8, 0x55, 0x0e, 0x63, 0x73, 0x31, 0x16, 0x9b, 0xe9, 0x30, 0x36, 0xc9,
	0xe6, 0x40, 0x7f, 0xd6, 0xf6, 0x7a, 0xd5, 0x8c, 0xb7, 0x39, 0xd0, 0x9f, 0x91, 0x7e, 0xc1, 0x51,
	0xcf, 0x61, 0x35, 0xea, 0x2d, 0x06, 0xda, 0xef, 0x40, 0x9a, 0x7f, 0xa6, 0x60, 0x80, 0x7d, 0x3b,
	0x26, 0x86, 0x9a, 0xcf, 0x3c, 0x37, 0x54, 0x0f, 0x61, 0x25, 0x54, 0x9e, 0x79, 0x9c, 0xb6, 0x60,
	0x91, 0xc9, 0x62, 0x75, 0x39, 0x56, 0x2f, 0xe7, 0x55, 0xff, 0x2c, 0xc1, 0x4a, 0x08, 0xb8, 0x5c,
	0xde, 0x65, 0xe0, 0xe0, 0x0a, 0x4c, 0x92, 0x8c, 0x52, 0xef, 0x06, 0xd5, 0xc9, 0xf3, 0xab, 0x8b,
	0x82, 0x34, 0x71, 0x21, 0x90, 0x6e, 0xc1, 0x4a, 0x28, 0x4b, 0xe7, 0x33, 0x55, 0xad, 0xc0, 0xa5,
	0x71, 0x71, 0x9c, 0xf3, 0xcc, 0xdf, 0x65, 0x58, 0xa1, 0xcf, 0xf5, 0xeb, 0xb5, 0x53, 0x41, 0x14,
	0xc8, 0x17, 0x41, 0x81, 0x21, 0x6a, 0x70, 0xbc, 0x2f, 0x1a, 0x1f, 0x8b, 0x24, 0x88, 0x6c, 0xfc,
	0x3f, 0xec, 0x6f, 0x7e, 0x27, 0xf1, 0xf2, 0xc2, 0xfa, 0xed, 0x0b, 0x97, 0x17, 0xd1, 0xf4, 0x10,
	0x4e, 0xef, 0x44, 0x6c, 0x7a, 0x27, 0x23, 0x4f, 0xcf, 0x73, 0x9e, 0xc1, 0x63, 0x83, 0x58, 0x06,
	0x7f, 0x08, 0x19, 0x5e, 0xa5, 0x62, 0x53, 0x98, 0x1d, 0xd4, 0xd2, 0xac, 0x7e, 0xcd, 0x9f, 0xc2,
	0x0d, 0x9e, 0xc2, 0x5c, 0x04, 0xf3, 0xc5, 0x07, 0x90, 0xe6, 0x9a, 0xe3, 0x72, 0x98, 0x9f, 0x5a,
	0x64, 0x8a, 0xd5, 0xbf, 0xf8, 0x39, 0x1c, 0x11, 0x18, 0x99, 0x67, 0xa5, 0xe8, 0x3c, 0x1b, 0x54,
	0x28, 0xcf, 0xaf, 0xf0, 0xcb, 0x65, 0xf1, 0x07, 0x3c, 0x8b, 0x2f, 0x66, 0xac, 0x7a, 0x87, 0xa6,
	0xf1, 0x05, 0x0f, 0xfd, 0x83, 0x00, 0xcf, 0xb5, 0xb1, 0x3e, 0x88, 0x26, 0x72, 0xb8, 0x4d, 0x94,
	0xa2, 0x6d, 0xe2, 0x64, 0x9e, 0xcb, 0x73, 0x74, 0xa3, 0x5f, 0xf5, 0x8b, 0xa6, 0x7e, 0x0a, 0xab,
	0xd1, 0xeb, 0x7c, 0xc9, 0x87, 0x67, 0xf3, 0xa7, 0x80, 0x26, 0x93, 0x17, 0x5d, 0x83, 0xf5, 0x7a,
	0x63, 0xaf, 0xd9, 0x3e, 0xac, 0x69, 0xfb, 0xb5, 0x76, 0xf3, 0xa8, 0xa6, 0xed, 0xb4, 0xea, 0xcd,
	0xc6, 0xe4, 0x54, 0x52, 0xdf, 0x6f, 0x34, 0xb5, 0x5a, 0xbb, 0x51, 0xfb, 0x51, 0x41, 0x42, 0x97,
	0x20, 0x77, 0xd8, 0x7c, 0x50, 0x6b, 0xb7, 0x9a, 0xed, 0xea, 0xce, 0xc1, 0xc1, 0x71, 0x41, 0xae,
	0xfc, 0x49, 0x82, 0x35, 0xcf, 0x64, 0xc3, 0xec, 0xf9, 0xad, 0x0b, 0xfd, 0xf4, 0x8e, 0x3e, 0x97,
	0x20, 0x1f, 0xbe, 0x0e, 0x12, 0x7e, 0xc7, 0x10, 0x46, 0xb0, 0xb8, 0x39, 0x0f, 0xab, 0xe7, 0x1d,
	0xf5, 0xca, 0x67, 0xff, 0xfa, 0xcf, 0x17, 0xb2, 0xa2, 0xbe, 0x11, 0xfc, 0x3b, 0xc2, 0xb6, 0x43,
	0x99, 0xb7, 0xa5, 0xcd, 0x5b, 0x52, 0xe5, 0x15, 0x82, 0x42, 0xd8, 0xbc, 0x07, 0xb7, 0xd1, 0x73,
	0xc8, 0x87, 0xe7, 0x28, 0xb1, 0x7d, 0xc2, 0x31, 0xb3, 0x78, 0x99, 0xb3, 0x06, 0xfe, 0x44, 0x50,
	0xf2, 0x3d, 0x3c, 0xc5, 0x24, 0x83, 0x8a, 0xda, 0x96, 0x36, 0xd1, 0xaf, 0x24, 0x28, 0x44, 0x07,
	0x31, 0x24, 0xfc, 0xa2, 0x3e, 0x65, 0x5c, 0x2b, 0xce, 0xe8, 0x1e, 0xd5, 0x6b, 0xd4, 0x82, 0x2b,
	0xea, 0x72, 0xd0, 0x02, 0xec, 0x3a, 0xdb, 0xc1, 0x4e, 0x14, 0xfd, 0x5e, 0x82, 0x42, 0x74, 0x1e,
	0x12, 0xdb, 0x31, 0x65, 0x6a, 0x9a, 0xe5, 0x88, 0x0a, 0x35, 0xe3, 0xa6, 0xfa, 0x5e, 0xc4, 0x8c,
	0xf2, 0x8b, 0x70, 0x06, 0xbe, 0xdc, 0xc6, 0xcf, 0xb8, 0x73, 0x7e, 0x21, 0x41, 0x2e, 0x34, 0xf1,
	0xa0, 0x0d, 0x91, 0x45, 0xa2, 0xa1, 0x68, 0xa6, 0x5b, 0x36, 0xa8, 0x3d, 0x2a, 0x5a, 0x9f, 0x65,
	0x0f, 0xfa, 0x42, 0x82, 0x4b, 0x13, 0xf3, 0x0b, 0xba, 0x29, 0xc4, 0xe5, 0x94, 0x01, 0xab, 0xf8,
	0xad, 0x39, 0xb9, 0x19, 0x90, 0xdf, 0xa5, 0xc6, 0xbd, 0xad, 0xae, 0x46, 0x8d, 0x73, 0xe8, 0x11,
	0xe2, 0x9b, 0x9f, 0x4b, 0x50, 0x88, 0x4e, 0x33, 0xe2, 0x80, 0x4d, 0x99, 0x79, 0x8a, 0xab, 0x13,
	0xa5, 0xbc, 0x36, 0x18, 0xba, 0xe7, 0xdc, 0x33, 0x9b, 0xb3, 0x3d, 0xf3, 0x07, 0x09, 0x0a, 0xd1,
	0x79, 0x48, 0x6c, 0xc3, 0x94, 0xa9, 0x69, 0x66, 0x94, 0xb6, 0xa8, 0x2d, 0xe5, 0xca, 0x4c, 0x5b,
	0xc2, 0x68, 0xfe, 0x0d, 0x29, 0x39, 0xa1, 0xd6, 0x7d, 0x4a, 0xc9, 0x11, 0x0d, 0x43, 0x53, 0x4a,
	0x8e, 0x70, 0x12, 0x10, 0xe7, 0x77, 0x20, 0x4c, 0x23, 0xc8, 0x85, 0x12, 0x57, 0x8c, 0x60, 0x51,
	0xaf, 0x5f, 0x8c, 0xab, 0xec, 0xea, 0x65, 0xaa, 0x77, 0x4d, 0x5d, 0x0a, 0xd5, 0x15, 0xbf, 0x03,
	0xff, 0x4c, 0x82, 0x5c, 0xc8, 0xe7, 0x62, 0xbd, 0xa2, 0x99, 0x20, 0x5e, 0xef, 0x26, 0xd5, 0x7b,
	0xad, 0xf2, 0x56, 0xe8, 0xbe, 0x2f, 0xc6, 0x5d, 0xf6, 0xcb, 0xb1, 0x11, 0x2e, 0xe4, 0x42, 0xd8,
	0x13, 0xdb, 0x20, 0x6a, 0xf6, 0xa7, 0x62, 0x93, 0x25, 0xc6, 0xe6, 0x74, 0xf5, 0xc8, 0x01, 0x18,
	0x17, 0x04, 0x74, 0x3d, 0xbe, 0x60, 0xcc, 0x75, 0x67, 0xa6, 0x14, 0xc5, 0x28, 0x1d, 0x42, 0x2e,
	0xd4, 0xa4, 0x8b, 0xaf, 0x2a, 0xea, 0xe3, 0xa7, 0x5e, 0x95, 0x47, 0x18, 0x85, 0x22, 0x4c, 0x47,
	0x06, 0x02, 0xac, 0x31, 0xc4, 0x79, 0x6f, 0x1b, 0x07, 0xf1, 0x48, 0x43, 0x1e, 0x07, 0xf1, 0x68,
	0xab, 0x1c, 0x86, 0x38, 0x9d, 0x94, 0xc3, 0x95, 0xe8, 0x8c, 0x43, 0x9c, 0xff, 0x4d, 0x20, 0x06,
	0xe2, 0xe1, 0xc6, 0xae, 0x18, 0xd7, 0x88, 0xfa, 0x7a, 0x97, 0x82, 0x7a, 0xb7, 0xfd, 0x5e, 0x16,
	0xfd, 0xd2, 0xc7, 0x78, 0xac, 0x62, 0x51, 0xcf, 0x1c, 0xaf, 0xf8, 0x26, 0x55, 0x7c, 0xa3, 0x52,
	0x0c, 0x5d, 0xf8, 0x45, 0xa0, 0x07, 0x7c, 0x19, 0x30, 0x63, 0xc4, 0x51, 0x1e, 0x6b, 0x85, 0xa8,
	0x19, 0x9e, 0x1a, 0x7a, 0x95, 0x1a, 0xf0, 0xce, 0x66, 0x8c, 0x01, 0xc8, 0xa5, 0x30, 0xe7, 0x3a,
	0xa7, 0xc1, 0xfc, 0x22, 0xd7, 0x66, 0x5a, 0x51, 0x8c, 0xd6, 0xdd, 0x9b, 0xb0, 0xda, 0xb1, 0x06,
	0x02, 0x29, 0xbb, 0x39, 0x8e, 0xeb, 0x23, 0x72, 0x97, 0x23, 0xe9, 0xbf, 0x92, 0x74, 0xb2, 0x40,
	0xef, 0x75, 0xe7, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc2, 0x72, 0x79, 0xf0, 0x06, 0x22, 0x00,
	0x00,
}
