// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/source/v1/source_context.proto
// DO NOT EDIT!

/*
Package google_devtools_source_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/devtools/source/v1/source_context.proto

It has these top-level messages:
	SourceContext
	ExtendedSourceContext
	AliasContext
	CloudRepoSourceContext
	CloudWorkspaceSourceContext
	GerritSourceContext
	GitSourceContext
	RepoId
	ProjectRepoId
	CloudWorkspaceId
*/
package google_devtools_source_v1 // import "google.golang.org/genproto/googleapis/devtools/source/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The type of an Alias.
type AliasContext_Kind int32

const (
	// Do not use.
	AliasContext_ANY AliasContext_Kind = 0
	// Git tag
	AliasContext_FIXED AliasContext_Kind = 1
	// Git branch
	AliasContext_MOVABLE AliasContext_Kind = 2
	// OTHER is used to specify non-standard aliases, those not of the kinds
	// above. For example, if a Git repo has a ref named "refs/foo/bar", it
	// is considered to be of kind OTHER.
	AliasContext_OTHER AliasContext_Kind = 4
)

var AliasContext_Kind_name = map[int32]string{
	0: "ANY",
	1: "FIXED",
	2: "MOVABLE",
	4: "OTHER",
}
var AliasContext_Kind_value = map[string]int32{
	"ANY":     0,
	"FIXED":   1,
	"MOVABLE": 2,
	"OTHER":   4,
}

func (x AliasContext_Kind) String() string {
	return proto.EnumName(AliasContext_Kind_name, int32(x))
}
func (AliasContext_Kind) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// A SourceContext is a reference to a tree of files. A SourceContext together
// with a path point to a unique revision of a single file or directory.
type SourceContext struct {
	// A SourceContext can refer any one of the following types of repositories.
	//
	// Types that are valid to be assigned to Context:
	//	*SourceContext_CloudRepo
	//	*SourceContext_CloudWorkspace
	//	*SourceContext_Gerrit
	//	*SourceContext_Git
	Context isSourceContext_Context `protobuf_oneof:"context"`
}

func (m *SourceContext) Reset()                    { *m = SourceContext{} }
func (m *SourceContext) String() string            { return proto.CompactTextString(m) }
func (*SourceContext) ProtoMessage()               {}
func (*SourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isSourceContext_Context interface {
	isSourceContext_Context()
}

type SourceContext_CloudRepo struct {
	CloudRepo *CloudRepoSourceContext `protobuf:"bytes,1,opt,name=cloud_repo,json=cloudRepo,oneof"`
}
type SourceContext_CloudWorkspace struct {
	CloudWorkspace *CloudWorkspaceSourceContext `protobuf:"bytes,2,opt,name=cloud_workspace,json=cloudWorkspace,oneof"`
}
type SourceContext_Gerrit struct {
	Gerrit *GerritSourceContext `protobuf:"bytes,3,opt,name=gerrit,oneof"`
}
type SourceContext_Git struct {
	Git *GitSourceContext `protobuf:"bytes,6,opt,name=git,oneof"`
}

func (*SourceContext_CloudRepo) isSourceContext_Context()      {}
func (*SourceContext_CloudWorkspace) isSourceContext_Context() {}
func (*SourceContext_Gerrit) isSourceContext_Context()         {}
func (*SourceContext_Git) isSourceContext_Context()            {}

func (m *SourceContext) GetContext() isSourceContext_Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *SourceContext) GetCloudRepo() *CloudRepoSourceContext {
	if x, ok := m.GetContext().(*SourceContext_CloudRepo); ok {
		return x.CloudRepo
	}
	return nil
}

func (m *SourceContext) GetCloudWorkspace() *CloudWorkspaceSourceContext {
	if x, ok := m.GetContext().(*SourceContext_CloudWorkspace); ok {
		return x.CloudWorkspace
	}
	return nil
}

func (m *SourceContext) GetGerrit() *GerritSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Gerrit); ok {
		return x.Gerrit
	}
	return nil
}

func (m *SourceContext) GetGit() *GitSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Git); ok {
		return x.Git
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SourceContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SourceContext_OneofMarshaler, _SourceContext_OneofUnmarshaler, _SourceContext_OneofSizer, []interface{}{
		(*SourceContext_CloudRepo)(nil),
		(*SourceContext_CloudWorkspace)(nil),
		(*SourceContext_Gerrit)(nil),
		(*SourceContext_Git)(nil),
	}
}

func _SourceContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SourceContext)
	// context
	switch x := m.Context.(type) {
	case *SourceContext_CloudRepo:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudRepo); err != nil {
			return err
		}
	case *SourceContext_CloudWorkspace:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudWorkspace); err != nil {
			return err
		}
	case *SourceContext_Gerrit:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gerrit); err != nil {
			return err
		}
	case *SourceContext_Git:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Git); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SourceContext.Context has unexpected type %T", x)
	}
	return nil
}

func _SourceContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SourceContext)
	switch tag {
	case 1: // context.cloud_repo
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudRepoSourceContext)
		err := b.DecodeMessage(msg)
		m.Context = &SourceContext_CloudRepo{msg}
		return true, err
	case 2: // context.cloud_workspace
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudWorkspaceSourceContext)
		err := b.DecodeMessage(msg)
		m.Context = &SourceContext_CloudWorkspace{msg}
		return true, err
	case 3: // context.gerrit
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GerritSourceContext)
		err := b.DecodeMessage(msg)
		m.Context = &SourceContext_Gerrit{msg}
		return true, err
	case 6: // context.git
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GitSourceContext)
		err := b.DecodeMessage(msg)
		m.Context = &SourceContext_Git{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SourceContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SourceContext)
	// context
	switch x := m.Context.(type) {
	case *SourceContext_CloudRepo:
		s := proto.Size(x.CloudRepo)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SourceContext_CloudWorkspace:
		s := proto.Size(x.CloudWorkspace)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SourceContext_Gerrit:
		s := proto.Size(x.Gerrit)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SourceContext_Git:
		s := proto.Size(x.Git)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An ExtendedSourceContext is a SourceContext combined with additional
// details describing the context.
type ExtendedSourceContext struct {
	// Any source context.
	Context *SourceContext `protobuf:"bytes,1,opt,name=context" json:"context,omitempty"`
	// Labels with user defined metadata.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ExtendedSourceContext) Reset()                    { *m = ExtendedSourceContext{} }
func (m *ExtendedSourceContext) String() string            { return proto.CompactTextString(m) }
func (*ExtendedSourceContext) ProtoMessage()               {}
func (*ExtendedSourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ExtendedSourceContext) GetContext() *SourceContext {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ExtendedSourceContext) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// An alias to a repo revision.
type AliasContext struct {
	// The alias kind.
	Kind AliasContext_Kind `protobuf:"varint,1,opt,name=kind,enum=google.devtools.source.v1.AliasContext_Kind" json:"kind,omitempty"`
	// The alias name.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *AliasContext) Reset()                    { *m = AliasContext{} }
func (m *AliasContext) String() string            { return proto.CompactTextString(m) }
func (*AliasContext) ProtoMessage()               {}
func (*AliasContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// A CloudRepoSourceContext denotes a particular revision in a cloud
// repo (a repo hosted by the Google Cloud Platform).
type CloudRepoSourceContext struct {
	// The ID of the repo.
	RepoId *RepoId `protobuf:"bytes,1,opt,name=repo_id,json=repoId" json:"repo_id,omitempty"`
	// A revision in a cloud repository can be identified by either its revision
	// ID or its Alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*CloudRepoSourceContext_RevisionId
	//	*CloudRepoSourceContext_AliasName
	//	*CloudRepoSourceContext_AliasContext
	Revision isCloudRepoSourceContext_Revision `protobuf_oneof:"revision"`
}

func (m *CloudRepoSourceContext) Reset()                    { *m = CloudRepoSourceContext{} }
func (m *CloudRepoSourceContext) String() string            { return proto.CompactTextString(m) }
func (*CloudRepoSourceContext) ProtoMessage()               {}
func (*CloudRepoSourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type isCloudRepoSourceContext_Revision interface {
	isCloudRepoSourceContext_Revision()
}

type CloudRepoSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,oneof"`
}
type CloudRepoSourceContext_AliasName struct {
	AliasName string `protobuf:"bytes,3,opt,name=alias_name,json=aliasName,oneof"`
}
type CloudRepoSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,4,opt,name=alias_context,json=aliasContext,oneof"`
}

func (*CloudRepoSourceContext_RevisionId) isCloudRepoSourceContext_Revision()   {}
func (*CloudRepoSourceContext_AliasName) isCloudRepoSourceContext_Revision()    {}
func (*CloudRepoSourceContext_AliasContext) isCloudRepoSourceContext_Revision() {}

func (m *CloudRepoSourceContext) GetRevision() isCloudRepoSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CloudRepoSourceContext) GetRepoId() *RepoId {
	if m != nil {
		return m.RepoId
	}
	return nil
}

func (m *CloudRepoSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *CloudRepoSourceContext) GetAliasName() string {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_AliasName); ok {
		return x.AliasName
	}
	return ""
}

func (m *CloudRepoSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CloudRepoSourceContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CloudRepoSourceContext_OneofMarshaler, _CloudRepoSourceContext_OneofUnmarshaler, _CloudRepoSourceContext_OneofSizer, []interface{}{
		(*CloudRepoSourceContext_RevisionId)(nil),
		(*CloudRepoSourceContext_AliasName)(nil),
		(*CloudRepoSourceContext_AliasContext)(nil),
	}
}

func _CloudRepoSourceContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CloudRepoSourceContext)
	// revision
	switch x := m.Revision.(type) {
	case *CloudRepoSourceContext_RevisionId:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.RevisionId)
	case *CloudRepoSourceContext_AliasName:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.AliasName)
	case *CloudRepoSourceContext_AliasContext:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AliasContext); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CloudRepoSourceContext.Revision has unexpected type %T", x)
	}
	return nil
}

func _CloudRepoSourceContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CloudRepoSourceContext)
	switch tag {
	case 2: // revision.revision_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &CloudRepoSourceContext_RevisionId{x}
		return true, err
	case 3: // revision.alias_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &CloudRepoSourceContext_AliasName{x}
		return true, err
	case 4: // revision.alias_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AliasContext)
		err := b.DecodeMessage(msg)
		m.Revision = &CloudRepoSourceContext_AliasContext{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CloudRepoSourceContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CloudRepoSourceContext)
	// revision
	switch x := m.Revision.(type) {
	case *CloudRepoSourceContext_RevisionId:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RevisionId)))
		n += len(x.RevisionId)
	case *CloudRepoSourceContext_AliasName:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AliasName)))
		n += len(x.AliasName)
	case *CloudRepoSourceContext_AliasContext:
		s := proto.Size(x.AliasContext)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A CloudWorkspaceSourceContext denotes a workspace at a particular snapshot.
type CloudWorkspaceSourceContext struct {
	// The ID of the workspace.
	WorkspaceId *CloudWorkspaceId `protobuf:"bytes,1,opt,name=workspace_id,json=workspaceId" json:"workspace_id,omitempty"`
	// The ID of the snapshot.
	// An empty snapshot_id refers to the most recent snapshot.
	SnapshotId string `protobuf:"bytes,2,opt,name=snapshot_id,json=snapshotId" json:"snapshot_id,omitempty"`
}

func (m *CloudWorkspaceSourceContext) Reset()                    { *m = CloudWorkspaceSourceContext{} }
func (m *CloudWorkspaceSourceContext) String() string            { return proto.CompactTextString(m) }
func (*CloudWorkspaceSourceContext) ProtoMessage()               {}
func (*CloudWorkspaceSourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *CloudWorkspaceSourceContext) GetWorkspaceId() *CloudWorkspaceId {
	if m != nil {
		return m.WorkspaceId
	}
	return nil
}

// A SourceContext referring to a Gerrit project.
type GerritSourceContext struct {
	// The URI of a running Gerrit instance.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri" json:"host_uri,omitempty"`
	// The full project name within the host. Projects may be nested, so
	// "project/subproject" is a valid project name.
	// The "repo name" is hostURI/project.
	GerritProject string `protobuf:"bytes,2,opt,name=gerrit_project,json=gerritProject" json:"gerrit_project,omitempty"`
	// A revision in a Gerrit project can be identified by either its revision ID
	// or its alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*GerritSourceContext_RevisionId
	//	*GerritSourceContext_AliasName
	//	*GerritSourceContext_AliasContext
	Revision isGerritSourceContext_Revision `protobuf_oneof:"revision"`
}

func (m *GerritSourceContext) Reset()                    { *m = GerritSourceContext{} }
func (m *GerritSourceContext) String() string            { return proto.CompactTextString(m) }
func (*GerritSourceContext) ProtoMessage()               {}
func (*GerritSourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isGerritSourceContext_Revision interface {
	isGerritSourceContext_Revision()
}

type GerritSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,oneof"`
}
type GerritSourceContext_AliasName struct {
	AliasName string `protobuf:"bytes,4,opt,name=alias_name,json=aliasName,oneof"`
}
type GerritSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,5,opt,name=alias_context,json=aliasContext,oneof"`
}

func (*GerritSourceContext_RevisionId) isGerritSourceContext_Revision()   {}
func (*GerritSourceContext_AliasName) isGerritSourceContext_Revision()    {}
func (*GerritSourceContext_AliasContext) isGerritSourceContext_Revision() {}

func (m *GerritSourceContext) GetRevision() isGerritSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GerritSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*GerritSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *GerritSourceContext) GetAliasName() string {
	if x, ok := m.GetRevision().(*GerritSourceContext_AliasName); ok {
		return x.AliasName
	}
	return ""
}

func (m *GerritSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*GerritSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GerritSourceContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GerritSourceContext_OneofMarshaler, _GerritSourceContext_OneofUnmarshaler, _GerritSourceContext_OneofSizer, []interface{}{
		(*GerritSourceContext_RevisionId)(nil),
		(*GerritSourceContext_AliasName)(nil),
		(*GerritSourceContext_AliasContext)(nil),
	}
}

func _GerritSourceContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GerritSourceContext)
	// revision
	switch x := m.Revision.(type) {
	case *GerritSourceContext_RevisionId:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.RevisionId)
	case *GerritSourceContext_AliasName:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.AliasName)
	case *GerritSourceContext_AliasContext:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AliasContext); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GerritSourceContext.Revision has unexpected type %T", x)
	}
	return nil
}

func _GerritSourceContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GerritSourceContext)
	switch tag {
	case 3: // revision.revision_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &GerritSourceContext_RevisionId{x}
		return true, err
	case 4: // revision.alias_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &GerritSourceContext_AliasName{x}
		return true, err
	case 5: // revision.alias_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AliasContext)
		err := b.DecodeMessage(msg)
		m.Revision = &GerritSourceContext_AliasContext{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GerritSourceContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GerritSourceContext)
	// revision
	switch x := m.Revision.(type) {
	case *GerritSourceContext_RevisionId:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RevisionId)))
		n += len(x.RevisionId)
	case *GerritSourceContext_AliasName:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AliasName)))
		n += len(x.AliasName)
	case *GerritSourceContext_AliasContext:
		s := proto.Size(x.AliasContext)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A GitSourceContext denotes a particular revision in a third party Git
// repository (e.g. GitHub).
type GitSourceContext struct {
	// Git repository URL.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// Git commit hash.
	// required.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId" json:"revision_id,omitempty"`
}

func (m *GitSourceContext) Reset()                    { *m = GitSourceContext{} }
func (m *GitSourceContext) String() string            { return proto.CompactTextString(m) }
func (*GitSourceContext) ProtoMessage()               {}
func (*GitSourceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// A unique identifier for a cloud repo.
type RepoId struct {
	// A cloud repository can be identified by either its project ID and
	// repository name combination, or its globally unique identifier.
	//
	// Types that are valid to be assigned to Id:
	//	*RepoId_ProjectRepoId
	//	*RepoId_Uid
	Id isRepoId_Id `protobuf_oneof:"id"`
}

func (m *RepoId) Reset()                    { *m = RepoId{} }
func (m *RepoId) String() string            { return proto.CompactTextString(m) }
func (*RepoId) ProtoMessage()               {}
func (*RepoId) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isRepoId_Id interface {
	isRepoId_Id()
}

type RepoId_ProjectRepoId struct {
	ProjectRepoId *ProjectRepoId `protobuf:"bytes,1,opt,name=project_repo_id,json=projectRepoId,oneof"`
}
type RepoId_Uid struct {
	Uid string `protobuf:"bytes,2,opt,name=uid,oneof"`
}

func (*RepoId_ProjectRepoId) isRepoId_Id() {}
func (*RepoId_Uid) isRepoId_Id()           {}

func (m *RepoId) GetId() isRepoId_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *RepoId) GetProjectRepoId() *ProjectRepoId {
	if x, ok := m.GetId().(*RepoId_ProjectRepoId); ok {
		return x.ProjectRepoId
	}
	return nil
}

func (m *RepoId) GetUid() string {
	if x, ok := m.GetId().(*RepoId_Uid); ok {
		return x.Uid
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RepoId) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RepoId_OneofMarshaler, _RepoId_OneofUnmarshaler, _RepoId_OneofSizer, []interface{}{
		(*RepoId_ProjectRepoId)(nil),
		(*RepoId_Uid)(nil),
	}
}

func _RepoId_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RepoId)
	// id
	switch x := m.Id.(type) {
	case *RepoId_ProjectRepoId:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProjectRepoId); err != nil {
			return err
		}
	case *RepoId_Uid:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Uid)
	case nil:
	default:
		return fmt.Errorf("RepoId.Id has unexpected type %T", x)
	}
	return nil
}

func _RepoId_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RepoId)
	switch tag {
	case 1: // id.project_repo_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProjectRepoId)
		err := b.DecodeMessage(msg)
		m.Id = &RepoId_ProjectRepoId{msg}
		return true, err
	case 2: // id.uid
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Id = &RepoId_Uid{x}
		return true, err
	default:
		return false, nil
	}
}

func _RepoId_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RepoId)
	// id
	switch x := m.Id.(type) {
	case *RepoId_ProjectRepoId:
		s := proto.Size(x.ProjectRepoId)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RepoId_Uid:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Uid)))
		n += len(x.Uid)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Selects a repo using a Google Cloud Platform project ID
// (e.g. winged-cargo-31) and a repo name within that project.
type ProjectRepoId struct {
	// The ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the repo. Leave empty for the default repo.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName" json:"repo_name,omitempty"`
}

func (m *ProjectRepoId) Reset()                    { *m = ProjectRepoId{} }
func (m *ProjectRepoId) String() string            { return proto.CompactTextString(m) }
func (*ProjectRepoId) ProtoMessage()               {}
func (*ProjectRepoId) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// A CloudWorkspaceId is a unique identifier for a cloud workspace.
// A cloud workspace is a place associated with a repo where modified files
// can be stored before they are committed.
type CloudWorkspaceId struct {
	// The ID of the repo containing the workspace.
	RepoId *RepoId `protobuf:"bytes,1,opt,name=repo_id,json=repoId" json:"repo_id,omitempty"`
	// The unique name of the workspace within the repo.  This is the name
	// chosen by the client in the Source API's CreateWorkspace method.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *CloudWorkspaceId) Reset()                    { *m = CloudWorkspaceId{} }
func (m *CloudWorkspaceId) String() string            { return proto.CompactTextString(m) }
func (*CloudWorkspaceId) ProtoMessage()               {}
func (*CloudWorkspaceId) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CloudWorkspaceId) GetRepoId() *RepoId {
	if m != nil {
		return m.RepoId
	}
	return nil
}

func init() {
	proto.RegisterType((*SourceContext)(nil), "google.devtools.source.v1.SourceContext")
	proto.RegisterType((*ExtendedSourceContext)(nil), "google.devtools.source.v1.ExtendedSourceContext")
	proto.RegisterType((*AliasContext)(nil), "google.devtools.source.v1.AliasContext")
	proto.RegisterType((*CloudRepoSourceContext)(nil), "google.devtools.source.v1.CloudRepoSourceContext")
	proto.RegisterType((*CloudWorkspaceSourceContext)(nil), "google.devtools.source.v1.CloudWorkspaceSourceContext")
	proto.RegisterType((*GerritSourceContext)(nil), "google.devtools.source.v1.GerritSourceContext")
	proto.RegisterType((*GitSourceContext)(nil), "google.devtools.source.v1.GitSourceContext")
	proto.RegisterType((*RepoId)(nil), "google.devtools.source.v1.RepoId")
	proto.RegisterType((*ProjectRepoId)(nil), "google.devtools.source.v1.ProjectRepoId")
	proto.RegisterType((*CloudWorkspaceId)(nil), "google.devtools.source.v1.CloudWorkspaceId")
	proto.RegisterEnum("google.devtools.source.v1.AliasContext_Kind", AliasContext_Kind_name, AliasContext_Kind_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/source/v1/source_context.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 761 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x55, 0x5d, 0x4f, 0xdb, 0x3c,
	0x14, 0x6e, 0x9a, 0xd2, 0x92, 0x53, 0x0a, 0x95, 0xdf, 0x0f, 0x15, 0x10, 0x02, 0x22, 0xbd, 0x7a,
	0x91, 0x98, 0x52, 0xd1, 0x69, 0xd3, 0x86, 0x26, 0x6d, 0x94, 0x75, 0x6b, 0x05, 0x14, 0xe4, 0xb1,
	0xaf, 0xab, 0xca, 0x24, 0x5e, 0xf0, 0x08, 0x71, 0xe4, 0xa4, 0x05, 0xfe, 0xc4, 0xae, 0xf7, 0xe3,
	0xf6, 0x13, 0x76, 0x39, 0x69, 0xb7, 0x93, 0x9d, 0x04, 0xda, 0x52, 0x42, 0xa5, 0xed, 0x2a, 0xf6,
	0xe3, 0xf3, 0x3c, 0xe7, 0xf8, 0x7c, 0x38, 0x70, 0xe0, 0x72, 0xee, 0x7a, 0xd4, 0x72, 0xb9, 0x47,
	0x7c, 0xd7, 0xe2, 0xc2, 0xad, 0xbb, 0xd4, 0x0f, 0x04, 0x8f, 0x78, 0x3d, 0x3e, 0x22, 0x01, 0x0b,
	0xeb, 0x0e, 0x1d, 0x44, 0x9c, 0x7b, 0x61, 0x3d, 0xe4, 0x7d, 0x61, 0xd3, 0xfa, 0x60, 0x2b, 0x59,
	0xf5, 0x6c, 0xee, 0x47, 0xf4, 0x32, 0xb2, 0x14, 0x05, 0x2d, 0x26, 0x72, 0xa9, 0xbd, 0x15, 0x5b,
	0x59, 0x83, 0xad, 0xa5, 0xce, 0x74, 0x9e, 0x48, 0xc0, 0xea, 0x21, 0x15, 0x03, 0x66, 0x53, 0x9b,
	0xfb, 0x9f, 0x98, 0x5b, 0x27, 0xbe, 0xcf, 0x23, 0x12, 0x31, 0xee, 0x87, 0xb1, 0x17, 0xf3, 0x5b,
	0x1e, 0x2a, 0x6f, 0x94, 0xf0, 0x6e, 0xec, 0x1d, 0x61, 0x00, 0xdb, 0xe3, 0x7d, 0xa7, 0x27, 0x68,
	0xc0, 0x6b, 0xda, 0x9a, 0xb6, 0x51, 0x6e, 0x6c, 0x59, 0x77, 0x06, 0x63, 0xed, 0x4a, 0x63, 0x4c,
	0x03, 0x3e, 0x22, 0xd3, 0xce, 0x61, 0xc3, 0x4e, 0x4f, 0x10, 0x81, 0x85, 0x58, 0xf3, 0x82, 0x8b,
	0xb3, 0x30, 0x20, 0x36, 0xad, 0xe5, 0x95, 0xf0, 0xe3, 0xfb, 0x84, 0xdf, 0xa7, 0x84, 0x71, 0xf5,
	0x79, 0x7b, 0xe4, 0x18, 0xb5, 0xa1, 0xe8, 0x52, 0x21, 0x58, 0x54, 0xd3, 0x95, 0xb2, 0x95, 0xa1,
	0xfc, 0x5a, 0x19, 0x8e, 0x2b, 0x26, 0x7c, 0xf4, 0x1c, 0x74, 0x97, 0x45, 0xb5, 0xa2, 0x92, 0xd9,
	0xcc, 0x92, 0xb9, 0xad, 0x21, 0x99, 0x4d, 0x03, 0x4a, 0x49, 0x29, 0xcd, 0xef, 0x1a, 0xfc, 0xd3,
	0xba, 0x8c, 0xa8, 0xef, 0x50, 0x67, 0x34, 0xcd, 0xcd, 0x6b, 0xa3, 0x24, 0xc7, 0x1b, 0x19, 0x9e,
	0x46, 0xa8, 0x38, 0x25, 0xa2, 0x63, 0x28, 0x7a, 0xe4, 0x84, 0x7a, 0x61, 0x2d, 0xbf, 0xa6, 0x6f,
	0x94, 0x1b, 0xcf, 0x32, 0x24, 0x26, 0x46, 0x61, 0xed, 0x2b, 0x7a, 0xcb, 0x8f, 0xc4, 0x15, 0x4e,
	0xb4, 0x96, 0x9e, 0x42, 0x79, 0x08, 0x46, 0x55, 0xd0, 0xcf, 0xe8, 0x95, 0x0a, 0xd2, 0xc0, 0x72,
	0x89, 0xfe, 0x86, 0x99, 0x01, 0xf1, 0xfa, 0x71, 0x0d, 0x0d, 0x1c, 0x6f, 0xb6, 0xf3, 0x4f, 0x34,
	0xf3, 0xab, 0x06, 0x73, 0x3b, 0x1e, 0x23, 0x61, 0x7a, 0xcb, 0x17, 0x50, 0x38, 0x63, 0xbe, 0xa3,
	0xd8, 0xf3, 0x8d, 0x07, 0x19, 0xf1, 0x0d, 0xd3, 0xac, 0x3d, 0xe6, 0x3b, 0x58, 0x31, 0x11, 0x82,
	0x82, 0x4f, 0xce, 0x53, 0x5f, 0x6a, 0x6d, 0x36, 0xa0, 0x20, 0x2d, 0x50, 0x09, 0xf4, 0x9d, 0xee,
	0xc7, 0x6a, 0x0e, 0x19, 0x30, 0xf3, 0xaa, 0xf3, 0xa1, 0xf5, 0xb2, 0xaa, 0xa1, 0x32, 0x94, 0x0e,
	0x0e, 0xdf, 0xed, 0x34, 0xf7, 0x5b, 0xd5, 0xbc, 0xc4, 0x0f, 0x8f, 0xdb, 0x2d, 0x5c, 0x2d, 0x98,
	0x3f, 0x34, 0xf8, 0x77, 0x72, 0xab, 0xa2, 0x6d, 0x28, 0xc9, 0x5e, 0xef, 0x31, 0x27, 0x29, 0xc5,
	0x7a, 0x46, 0x9c, 0x92, 0xde, 0x71, 0x70, 0x51, 0xa8, 0x2f, 0x5a, 0x87, 0xb2, 0xa0, 0x03, 0x16,
	0x32, 0xee, 0x4b, 0xbe, 0x8a, 0xb2, 0x9d, 0xc3, 0x90, 0x82, 0x1d, 0x07, 0xad, 0x02, 0x10, 0x79,
	0xb9, 0x9e, 0xba, 0x87, 0x9e, 0x58, 0x18, 0x0a, 0xeb, 0x92, 0x73, 0x8a, 0xba, 0x50, 0x89, 0x0d,
	0xd2, 0x86, 0x28, 0xa8, 0x28, 0xfe, 0x9f, 0x32, 0x5b, 0xed, 0x1c, 0x9e, 0x23, 0x43, 0xfb, 0x26,
	0xc0, 0x6c, 0xea, 0xde, 0xfc, 0xa2, 0xc1, 0x72, 0xc6, 0x20, 0xa1, 0x2e, 0xcc, 0x5d, 0xcf, 0xe4,
	0x4d, 0x02, 0x36, 0xa7, 0x1e, 0xcb, 0x8e, 0x83, 0xcb, 0x17, 0x37, 0x1b, 0xb4, 0x0a, 0xe5, 0xd0,
	0x27, 0x41, 0x78, 0xca, 0xa3, 0xeb, 0x7c, 0x60, 0x48, 0xa1, 0x8e, 0x63, 0xfe, 0xd4, 0xe0, 0xaf,
	0x09, 0xf3, 0x87, 0x16, 0x61, 0xf6, 0x94, 0x87, 0x51, 0xaf, 0x2f, 0x58, 0xd2, 0x6b, 0x25, 0xb9,
	0x7f, 0x2b, 0x18, 0xfa, 0x0f, 0xe6, 0xe3, 0xd1, 0xec, 0x05, 0x82, 0x7f, 0xa6, 0x76, 0x94, 0xc8,
	0x56, 0x62, 0xf4, 0x28, 0x06, 0xc7, 0x4b, 0xa1, 0xdf, 0x5b, 0x8a, 0xc2, 0x14, 0xa5, 0x98, 0xf9,
	0x73, 0xa5, 0x68, 0x41, 0x75, 0xfc, 0xc5, 0x90, 0xc3, 0xd5, 0x17, 0x5e, 0x3a, 0x5c, 0x7d, 0xe1,
	0xc9, 0x04, 0xde, 0x6a, 0xa8, 0xe1, 0x3b, 0x98, 0x03, 0x28, 0xc6, 0x3d, 0x88, 0x30, 0x2c, 0x24,
	0x09, 0xe9, 0x8d, 0xf6, 0x6f, 0xd6, 0x53, 0x92, 0x64, 0x2b, 0x96, 0x68, 0xe7, 0x70, 0x25, 0x18,
	0x06, 0x10, 0x02, 0xbd, 0x3f, 0xd4, 0xc7, 0x72, 0xd3, 0x2c, 0x40, 0x9e, 0x39, 0xe6, 0x1e, 0x54,
	0x46, 0xb8, 0x68, 0x05, 0x20, 0x75, 0x9f, 0x78, 0x36, 0xb0, 0x91, 0x20, 0x1d, 0x07, 0x2d, 0x83,
	0xa1, 0xa2, 0x1a, 0x9a, 0xde, 0x59, 0x09, 0xc8, 0x3c, 0x9b, 0x27, 0x50, 0x1d, 0xef, 0xa3, 0xdf,
	0x1a, 0xc3, 0x09, 0xaf, 0x44, 0xf3, 0x11, 0xac, 0xd8, 0xfc, 0xfc, 0x6e, 0x8d, 0x26, 0x1a, 0xa9,
	0xc5, 0x91, 0xfc, 0x1f, 0x1e, 0x69, 0x27, 0x45, 0xf5, 0x63, 0x7c, 0xf8, 0x2b, 0x00, 0x00, 0xff,
	0xff, 0xee, 0x8d, 0xe8, 0x1b, 0xcf, 0x07, 0x00, 0x00,
}
