// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/cloudtrace/v1/trace.proto
// DO NOT EDIT!

/*
Package google_devtools_cloudtrace_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/devtools/cloudtrace/v1/trace.proto

It has these top-level messages:
	Trace
	Traces
	TraceSpan
	ListTracesRequest
	ListTracesResponse
	GetTraceRequest
	PatchTracesRequest
*/
package google_devtools_cloudtrace_v1 // import "google.golang.org/genproto/googleapis/devtools/cloudtrace/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type TraceSpan_SpanKind int32

const (
	// Unspecified.
	TraceSpan_SPAN_KIND_UNSPECIFIED TraceSpan_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	TraceSpan_RPC_SERVER TraceSpan_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	TraceSpan_RPC_CLIENT TraceSpan_SpanKind = 2
)

var TraceSpan_SpanKind_name = map[int32]string{
	0: "SPAN_KIND_UNSPECIFIED",
	1: "RPC_SERVER",
	2: "RPC_CLIENT",
}
var TraceSpan_SpanKind_value = map[string]int32{
	"SPAN_KIND_UNSPECIFIED": 0,
	"RPC_SERVER":            1,
	"RPC_CLIENT":            2,
}

func (x TraceSpan_SpanKind) String() string {
	return proto.EnumName(TraceSpan_SpanKind_name, int32(x))
}
func (TraceSpan_SpanKind) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// Type of data returned for traces in the list.
type ListTracesRequest_ViewType int32

const (
	// Default is `MINIMAL` if unspecified.
	ListTracesRequest_VIEW_TYPE_UNSPECIFIED ListTracesRequest_ViewType = 0
	// Minimal view of the trace record that contains only the project
	// and trace IDs.
	ListTracesRequest_MINIMAL ListTracesRequest_ViewType = 1
	// Root span view of the trace record that returns the root spans along
	// with the minimal trace data.
	ListTracesRequest_ROOTSPAN ListTracesRequest_ViewType = 2
	// Complete view of the trace record that contains the actual trace data.
	// This is equivalent to calling the REST `get` or RPC `GetTrace` method
	// using the ID of each listed trace.
	ListTracesRequest_COMPLETE ListTracesRequest_ViewType = 3
)

var ListTracesRequest_ViewType_name = map[int32]string{
	0: "VIEW_TYPE_UNSPECIFIED",
	1: "MINIMAL",
	2: "ROOTSPAN",
	3: "COMPLETE",
}
var ListTracesRequest_ViewType_value = map[string]int32{
	"VIEW_TYPE_UNSPECIFIED": 0,
	"MINIMAL":               1,
	"ROOTSPAN":              2,
	"COMPLETE":              3,
}

func (x ListTracesRequest_ViewType) String() string {
	return proto.EnumName(ListTracesRequest_ViewType_name, int32(x))
}
func (ListTracesRequest_ViewType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{3, 0}
}

// A trace describes how long it takes for an application to perform an
// operation. It consists of a set of spans, each of which represent a single
// timed event within the operation.
type Trace struct {
	// Project ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Globally unique identifier for the trace. This identifier is a 128-bit
	// numeric value formatted as a 32-byte hex string.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId" json:"trace_id,omitempty"`
	// Collection of spans in the trace.
	Spans []*TraceSpan `protobuf:"bytes,3,rep,name=spans" json:"spans,omitempty"`
}

func (m *Trace) Reset()                    { *m = Trace{} }
func (m *Trace) String() string            { return proto.CompactTextString(m) }
func (*Trace) ProtoMessage()               {}
func (*Trace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Trace) GetSpans() []*TraceSpan {
	if m != nil {
		return m.Spans
	}
	return nil
}

// List of new or updated traces.
type Traces struct {
	// List of traces.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces" json:"traces,omitempty"`
}

func (m *Traces) Reset()                    { *m = Traces{} }
func (m *Traces) String() string            { return proto.CompactTextString(m) }
func (*Traces) ProtoMessage()               {}
func (*Traces) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Traces) GetTraces() []*Trace {
	if m != nil {
		return m.Traces
	}
	return nil
}

// A span represents a single timed event within a trace. Spans can be nested
// and form a trace tree. Often, a trace contains a root span that describes the
// end-to-end latency of an operation and, optionally, one or more subspans for
// its suboperations. Spans do not need to be contiguous. There may be gaps
// between spans in a trace.
type TraceSpan struct {
	// Identifier for the span. Must be a 64-bit integer other than 0 and
	// unique within a trace.
	SpanId uint64 `protobuf:"fixed64,1,opt,name=span_id,json=spanId" json:"span_id,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `RPC_CLIENT`
	// and `RPC_SERVER` to identify queueing latency associated with the span.
	Kind TraceSpan_SpanKind `protobuf:"varint,2,opt,name=kind,enum=google.devtools.cloudtrace.v1.TraceSpan_SpanKind" json:"kind,omitempty"`
	// Name of the trace. The trace name is sanitized and displayed in the
	// Stackdriver Trace tool in the Google Developers Console.
	// The name may be a method name or some other per-call site name.
	// For the same executable and the same call point, a best practice is
	// to use a consistent name, which makes it easier to correlate
	// cross-trace spans.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// Start time of the span in nanoseconds from the UNIX epoch.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End time of the span in nanoseconds from the UNIX epoch.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// ID of the parent span, if any. Optional.
	ParentSpanId uint64 `protobuf:"fixed64,6,opt,name=parent_span_id,json=parentSpanId" json:"parent_span_id,omitempty"`
	// Collection of labels associated with the span.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *TraceSpan) Reset()                    { *m = TraceSpan{} }
func (m *TraceSpan) String() string            { return proto.CompactTextString(m) }
func (*TraceSpan) ProtoMessage()               {}
func (*TraceSpan) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *TraceSpan) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TraceSpan) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TraceSpan) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// The request message for the `ListTraces` method. All fields are required
// unless specified.
type ListTracesRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Type of data returned for traces in the list. Optional. Default is
	// `MINIMAL`.
	View ListTracesRequest_ViewType `protobuf:"varint,2,opt,name=view,enum=google.devtools.cloudtrace.v1.ListTracesRequest_ViewType" json:"view,omitempty"`
	// Maximum number of traces to return. If not specified or <= 0, the
	// implementation selects a reasonable value.  The implementation may
	// return fewer traces than the requested page size. Optional.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token identifying the page of results to return. If provided, use the
	// value of the `next_page_token` field from a previous request. Optional.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// End of the time interval (inclusive) during which the trace data was
	// collected from the application.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Start of the time interval (inclusive) during which the trace data was
	// collected from the application.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// An optional filter for the request.
	Filter string `protobuf:"bytes,7,opt,name=filter" json:"filter,omitempty"`
	// Field used to sort the returned traces. Optional.
	// Can be one of the following:
	//
	// *   `trace_id`
	// *   `name` (`name` field of root span in the trace)
	// *   `duration` (difference between `end_time` and `start_time` fields of
	//      the root span)
	// *   `start` (`start_time` field of the root span)
	//
	// Descending order can be specified by appending `desc` to the sort field
	// (for example, `name desc`).
	//
	// Only one sort field is permitted.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
}

func (m *ListTracesRequest) Reset()                    { *m = ListTracesRequest{} }
func (m *ListTracesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTracesRequest) ProtoMessage()               {}
func (*ListTracesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListTracesRequest) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ListTracesRequest) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// The response message for the `ListTraces` method.
type ListTracesResponse struct {
	// List of trace records returned.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces" json:"traces,omitempty"`
	// If defined, indicates that there are more traces that match the request
	// and that this value should be passed to the next request to continue
	// retrieving additional traces.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTracesResponse) Reset()                    { *m = ListTracesResponse{} }
func (m *ListTracesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTracesResponse) ProtoMessage()               {}
func (*ListTracesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ListTracesResponse) GetTraces() []*Trace {
	if m != nil {
		return m.Traces
	}
	return nil
}

// The request message for the `GetTrace` method.
type GetTraceRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the trace to return.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId" json:"trace_id,omitempty"`
}

func (m *GetTraceRequest) Reset()                    { *m = GetTraceRequest{} }
func (m *GetTraceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTraceRequest) ProtoMessage()               {}
func (*GetTraceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// The request message for the `PatchTraces` method.
type PatchTracesRequest struct {
	// ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The body of the message.
	Traces *Traces `protobuf:"bytes,2,opt,name=traces" json:"traces,omitempty"`
}

func (m *PatchTracesRequest) Reset()                    { *m = PatchTracesRequest{} }
func (m *PatchTracesRequest) String() string            { return proto.CompactTextString(m) }
func (*PatchTracesRequest) ProtoMessage()               {}
func (*PatchTracesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *PatchTracesRequest) GetTraces() *Traces {
	if m != nil {
		return m.Traces
	}
	return nil
}

func init() {
	proto.RegisterType((*Trace)(nil), "google.devtools.cloudtrace.v1.Trace")
	proto.RegisterType((*Traces)(nil), "google.devtools.cloudtrace.v1.Traces")
	proto.RegisterType((*TraceSpan)(nil), "google.devtools.cloudtrace.v1.TraceSpan")
	proto.RegisterType((*ListTracesRequest)(nil), "google.devtools.cloudtrace.v1.ListTracesRequest")
	proto.RegisterType((*ListTracesResponse)(nil), "google.devtools.cloudtrace.v1.ListTracesResponse")
	proto.RegisterType((*GetTraceRequest)(nil), "google.devtools.cloudtrace.v1.GetTraceRequest")
	proto.RegisterType((*PatchTracesRequest)(nil), "google.devtools.cloudtrace.v1.PatchTracesRequest")
	proto.RegisterEnum("google.devtools.cloudtrace.v1.TraceSpan_SpanKind", TraceSpan_SpanKind_name, TraceSpan_SpanKind_value)
	proto.RegisterEnum("google.devtools.cloudtrace.v1.ListTracesRequest_ViewType", ListTracesRequest_ViewType_name, ListTracesRequest_ViewType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for TraceService service

type TraceServiceClient interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type traceServiceClient struct {
	cc *grpc.ClientConn
}

func NewTraceServiceClient(cc *grpc.ClientConn) TraceServiceClient {
	return &traceServiceClient{cc}
}

func (c *traceServiceClient) ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error) {
	out := new(ListTracesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/ListTraces", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error) {
	out := new(Trace)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/GetTrace", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/PatchTraces", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for TraceService service

type TraceServiceServer interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(context.Context, *ListTracesRequest) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(context.Context, *GetTraceRequest) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(context.Context, *PatchTracesRequest) (*google_protobuf1.Empty, error)
}

func RegisterTraceServiceServer(s *grpc.Server, srv TraceServiceServer) {
	s.RegisterService(&_TraceService_serviceDesc, srv)
}

func _TraceService_ListTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).ListTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/ListTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).ListTraces(ctx, req.(*ListTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_GetTrace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTraceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).GetTrace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/GetTrace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).GetTrace(ctx, req.(*GetTraceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_PatchTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).PatchTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/PatchTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).PatchTraces(ctx, req.(*PatchTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TraceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudtrace.v1.TraceService",
	HandlerType: (*TraceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTraces",
			Handler:    _TraceService_ListTraces_Handler,
		},
		{
			MethodName: "GetTrace",
			Handler:    _TraceService_GetTrace_Handler,
		},
		{
			MethodName: "PatchTraces",
			Handler:    _TraceService_PatchTraces_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/devtools/cloudtrace/v1/trace.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/cloudtrace/v1/trace.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 884 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x55, 0x6d, 0x6f, 0xdb, 0x44,
	0x1c, 0xc7, 0x49, 0xe3, 0x24, 0xff, 0x94, 0x2e, 0x9c, 0x60, 0x64, 0x41, 0x93, 0x8a, 0x35, 0x50,
	0x04, 0xc2, 0x5e, 0x52, 0x90, 0xe8, 0x78, 0x90, 0xd6, 0xce, 0x03, 0xab, 0x69, 0x6a, 0x39, 0xa1,
	0x88, 0x57, 0xd6, 0x25, 0xbe, 0x7a, 0xa6, 0xc9, 0x9d, 0xf1, 0x5d, 0x32, 0xd2, 0x69, 0x2f, 0xe0,
	0x25, 0x6f, 0x11, 0xaf, 0xf8, 0x16, 0x7c, 0x13, 0xc4, 0x57, 0x40, 0xe2, 0x6b, 0xa0, 0xbb, 0xb3,
	0xd7, 0xa8, 0x15, 0x4b, 0xca, 0xde, 0x44, 0xf7, 0xbf, 0xbb, 0xff, 0xc3, 0xef, 0xe1, 0x62, 0xf8,
	0x3a, 0x66, 0x2c, 0x9e, 0x12, 0x3b, 0x66, 0x53, 0x4c, 0x63, 0x9b, 0x65, 0xb1, 0x13, 0x13, 0x9a,
	0x66, 0x4c, 0x30, 0x47, 0x1f, 0xe1, 0x34, 0xe1, 0x4e, 0x44, 0x16, 0x82, 0xb1, 0x29, 0x77, 0x26,
	0x53, 0x36, 0x8f, 0x44, 0x86, 0x27, 0xc4, 0x59, 0x74, 0x1d, 0xb5, 0xb0, 0xd5, 0x6d, 0x74, 0x37,
	0xaf, 0x54, 0x5c, 0xb5, 0x2f, 0xaf, 0xda, 0x8b, 0x6e, 0xdb, 0xdb, 0xac, 0x11, 0x4e, 0x13, 0x87,
	0x93, 0x6c, 0x91, 0x4c, 0xc8, 0x84, 0xd1, 0xb3, 0x24, 0x76, 0x30, 0xa5, 0x4c, 0x60, 0x91, 0x30,
	0xca, 0x75, 0xa7, 0xf6, 0x5e, 0x9c, 0x88, 0x27, 0xf3, 0xb1, 0x3d, 0x61, 0x33, 0x47, 0x97, 0x73,
	0xd4, 0xc1, 0x78, 0x7e, 0xe6, 0xa4, 0x62, 0x99, 0x12, 0xee, 0x90, 0x59, 0x2a, 0x96, 0xfa, 0x37,
	0x4f, 0xfa, 0x6c, 0x7d, 0x92, 0x48, 0x66, 0x84, 0x0b, 0x3c, 0x4b, 0x2f, 0x57, 0x3a, 0xd9, 0xfa,
	0xc9, 0x80, 0xca, 0x48, 0x22, 0x41, 0x77, 0x01, 0xd2, 0x8c, 0x7d, 0x4f, 0x26, 0x22, 0x4c, 0xa2,
	0x96, 0xb1, 0x6b, 0x74, 0xea, 0x41, 0x3d, 0xdf, 0xf1, 0x22, 0x74, 0x07, 0x6a, 0x0a, 0xb1, 0x3c,
	0x2c, 0xa9, 0xc3, 0xaa, 0x8a, 0xbd, 0x08, 0x7d, 0x09, 0x15, 0x9e, 0x62, 0xca, 0x5b, 0xe5, 0xdd,
	0x72, 0xa7, 0xd1, 0xeb, 0xd8, 0x2f, 0xe5, 0xcb, 0x56, 0xed, 0x86, 0x29, 0xa6, 0x81, 0x4e, 0xb3,
	0x1e, 0x83, 0xa9, 0xf6, 0x38, 0xfa, 0x1c, 0x4c, 0x75, 0x8d, 0xb7, 0x0c, 0x55, 0xea, 0xde, 0x26,
	0xa5, 0x82, 0x3c, 0xc7, 0xfa, 0xa7, 0x0c, 0xf5, 0x17, 0xc5, 0xd1, 0xdb, 0x50, 0x95, 0xe5, 0x0b,
	0x30, 0x66, 0x60, 0xca, 0xd0, 0x8b, 0x90, 0x0b, 0x5b, 0xe7, 0x09, 0xd5, 0x28, 0x76, 0x7a, 0xdd,
	0x4d, 0xa7, 0xb5, 0xe5, 0xcf, 0x51, 0x42, 0xa3, 0x40, 0xa5, 0x23, 0x04, 0x5b, 0x14, 0xcf, 0x48,
	0xab, 0xac, 0xc8, 0x50, 0x6b, 0xb4, 0x0f, 0xc0, 0x05, 0xce, 0x44, 0x28, 0x69, 0x6e, 0x6d, 0xed,
	0x1a, 0x9d, 0x46, 0xaf, 0x5d, 0x34, 0x28, 0x44, 0xb1, 0x47, 0x85, 0x06, 0x41, 0x5d, 0xdd, 0x96,
	0x31, 0xfa, 0x04, 0x6a, 0x84, 0x46, 0x3a, 0xb1, 0xb2, 0x36, 0xb1, 0x4a, 0x68, 0xa4, 0xd2, 0xee,
	0xc1, 0x4e, 0x8a, 0x33, 0x42, 0x45, 0x58, 0x80, 0x35, 0x15, 0xd8, 0x6d, 0xbd, 0x3b, 0xd4, 0x90,
	0xfb, 0x60, 0x4e, 0xf1, 0x98, 0x4c, 0x79, 0xab, 0xaa, 0x78, 0xfd, 0x78, 0x63, 0xd0, 0x7d, 0x95,
	0xe6, 0x52, 0x91, 0x2d, 0x83, 0xbc, 0x46, 0x7b, 0x1f, 0x1a, 0x2b, 0xdb, 0xa8, 0x09, 0xe5, 0x73,
	0xb2, 0xcc, 0x1d, 0x23, 0x97, 0xe8, 0x4d, 0xa8, 0x2c, 0xf0, 0x74, 0x4e, 0x72, 0xa3, 0xe8, 0xe0,
	0x41, 0xe9, 0x53, 0xc3, 0x72, 0xa1, 0x56, 0xd0, 0x88, 0xee, 0xc0, 0x5b, 0x43, 0xff, 0xe1, 0x20,
	0x3c, 0xf2, 0x06, 0x8f, 0xc2, 0x6f, 0x06, 0x43, 0xdf, 0x3d, 0xf4, 0x1e, 0x7b, 0xee, 0xa3, 0xe6,
	0x6b, 0x68, 0x07, 0x20, 0xf0, 0x0f, 0xc3, 0xa1, 0x1b, 0x9c, 0xba, 0x41, 0xd3, 0x28, 0xe2, 0xc3,
	0xbe, 0xe7, 0x0e, 0x46, 0xcd, 0x92, 0xf5, 0x47, 0x19, 0xde, 0xe8, 0x27, 0x5c, 0x68, 0xdb, 0x04,
	0xe4, 0x87, 0x39, 0xe1, 0x62, 0x9d, 0x83, 0x8f, 0x61, 0x6b, 0x91, 0x90, 0xa7, 0xb9, 0xee, 0xfb,
	0x6b, 0x28, 0xb8, 0x56, 0xde, 0x3e, 0x4d, 0xc8, 0xd3, 0xd1, 0x32, 0x25, 0x81, 0x2a, 0x83, 0xde,
	0x81, 0x7a, 0x8a, 0x63, 0x12, 0xf2, 0xe4, 0x42, 0x9b, 0xa0, 0x12, 0xd4, 0xe4, 0xc6, 0x30, 0xb9,
	0xd0, 0x8f, 0x49, 0x1e, 0x0a, 0x76, 0x4e, 0xa8, 0x32, 0x82, 0x1c, 0x05, 0xc7, 0x64, 0x24, 0x37,
	0xae, 0xf8, 0xa4, 0xf2, 0x7f, 0x7d, 0x62, 0x6e, 0xee, 0x93, 0xdb, 0x60, 0x9e, 0x25, 0x53, 0x41,
	0xb2, 0x56, 0x55, 0x0d, 0x93, 0x47, 0xf2, 0x59, 0xb3, 0x2c, 0x22, 0x59, 0x38, 0x5e, 0xb6, 0x6a,
	0xfa, 0x59, 0xab, 0xf8, 0x60, 0x69, 0x0d, 0xa0, 0x56, 0x40, 0x96, 0x5a, 0x9d, 0x7a, 0xee, 0xb7,
	0xe1, 0xe8, 0x3b, 0xdf, 0xbd, 0xa2, 0x55, 0x03, 0xaa, 0xc7, 0xde, 0xc0, 0x3b, 0x7e, 0xd8, 0x6f,
	0x1a, 0x68, 0x1b, 0x6a, 0xc1, 0xc9, 0xc9, 0x48, 0xea, 0xda, 0x2c, 0xc9, 0xe8, 0xf0, 0xe4, 0xd8,
	0xef, 0xbb, 0x23, 0xb7, 0x59, 0xb6, 0x2e, 0x00, 0xad, 0x92, 0xca, 0x53, 0x46, 0x39, 0x79, 0xb5,
	0x27, 0x8f, 0xde, 0x87, 0x5b, 0x94, 0xfc, 0x28, 0xc2, 0x15, 0xb2, 0xb5, 0xe7, 0x5e, 0x97, 0xdb,
	0x7e, 0x41, 0xb8, 0x75, 0x04, 0xb7, 0xbe, 0x22, 0xba, 0xf5, 0x86, 0x6e, 0xf9, 0xef, 0xff, 0x3b,
	0x2b, 0x03, 0xe4, 0x63, 0x31, 0x79, 0x72, 0x23, 0xf7, 0x7d, 0xf1, 0x02, 0x67, 0x49, 0xa9, 0xf6,
	0xde, 0x26, 0x38, 0x79, 0x01, 0xb4, 0xf7, 0x67, 0x19, 0xb6, 0xf5, 0xab, 0xd4, 0x9f, 0x10, 0xf4,
	0xbb, 0x01, 0x70, 0x49, 0x27, 0xba, 0x7f, 0x53, 0x3b, 0xb7, 0xbb, 0x37, 0xc8, 0xd0, 0x5a, 0x59,
	0x9d, 0x9f, 0xff, 0xfa, 0xfb, 0xd7, 0x92, 0x85, 0x76, 0xe5, 0x17, 0x32, 0x87, 0xc6, 0x9d, 0x67,
	0x97, 0xb0, 0x9f, 0x3b, 0xb9, 0x2e, 0xbf, 0x19, 0x50, 0x2b, 0x08, 0x47, 0xf6, 0x9a, 0x4e, 0x57,
	0x94, 0x69, 0x6f, 0x64, 0x01, 0x6b, 0x4f, 0x0d, 0xf3, 0x11, 0xfa, 0x70, 0xdd, 0x30, 0xce, 0xb3,
	0x42, 0xc8, 0xe7, 0xe8, 0x17, 0x03, 0x1a, 0x2b, 0xda, 0xa1, 0x75, 0x24, 0x5c, 0xd7, 0xb9, 0x7d,
	0xfb, 0xda, 0x73, 0x73, 0xe5, 0xc7, 0xd8, 0xba, 0xaf, 0xe6, 0xf9, 0xa0, 0xb7, 0x96, 0x9c, 0x07,
	0xb9, 0xa6, 0x07, 0x5d, 0x78, 0x77, 0xc2, 0x66, 0x2f, 0x9f, 0xe0, 0x00, 0x54, 0x77, 0x5f, 0xf6,
	0xf2, 0x8d, 0xb1, 0xa9, 0x9a, 0xee, 0xfd, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x53, 0x38, 0x4b, 0x28,
	0xdd, 0x08, 0x00, 0x00,
}
