// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/bytestream/bytestream.proto
// DO NOT EDIT!

/*
Package google_bytestream is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/bytestream/bytestream.proto

It has these top-level messages:
	ReadRequest
	ReadResponse
	WriteRequest
	WriteResponse
	QueryWriteStatusRequest
	QueryWriteStatusResponse
*/
package google_bytestream // import "google.golang.org/genproto/googleapis/bytestream"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import _ "github.com/golang/protobuf/ptypes/wrappers"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request object for ByteStream.Read.
type ReadRequest struct {
	// The name of the resource to read.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName" json:"resource_name,omitempty"`
	// The offset for the first byte to return in the read, relative to the start
	// of the resource.
	//
	// A `read_offset` that is negative or greater than the size of the resource
	// will cause an `OUT_OF_RANGE` error.
	ReadOffset int64 `protobuf:"varint,2,opt,name=read_offset,json=readOffset" json:"read_offset,omitempty"`
	// The maximum number of `data` bytes the server is allowed to return in the
	// sum of all `ReadResponse` messages. A `read_limit` of zero indicates that
	// there is no limit, and a negative `read_limit` will cause an error.
	//
	// If the stream returns fewer bytes than allowed by the `read_limit` and no
	// error occurred, the stream includes all data from the `read_offset` to the
	// end of the resource.
	ReadLimit int64 `protobuf:"varint,3,opt,name=read_limit,json=readLimit" json:"read_limit,omitempty"`
}

func (m *ReadRequest) Reset()                    { *m = ReadRequest{} }
func (m *ReadRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadRequest) ProtoMessage()               {}
func (*ReadRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Response object for ByteStream.Read.
type ReadResponse struct {
	// A portion of the data for the resource. The service **may** leave `data`
	// empty for any given `ReadResponse`. This enables the service to inform the
	// client that the request is still live while it is running an operation to
	// generate more data.
	Data []byte `protobuf:"bytes,10,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *ReadResponse) Reset()                    { *m = ReadResponse{} }
func (m *ReadResponse) String() string            { return proto.CompactTextString(m) }
func (*ReadResponse) ProtoMessage()               {}
func (*ReadResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Request object for ByteStream.Write.
type WriteRequest struct {
	// The name of the resource to write. This **must** be set on the first
	// `WriteRequest` of each `Write()` action. If it is set on subsequent calls,
	// it **must** match the value of the first request.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName" json:"resource_name,omitempty"`
	// The offset from the beginning of the resource at which the data should be
	// written. It is required on all `WriteRequest`s.
	//
	// In the first `WriteRequest` of a `Write()` action, it indicates
	// the initial offset for the `Write()` call. The value **must** be equal to
	// the `committed_size` that a call to `QueryWriteStatus()` would return.
	//
	// On subsequent calls, this value **must** be set and **must** be equal to
	// the sum of the first `write_offset` and the sizes of all `data` bundles
	// sent previously on this stream.
	//
	// An incorrect value will cause an error.
	WriteOffset int64 `protobuf:"varint,2,opt,name=write_offset,json=writeOffset" json:"write_offset,omitempty"`
	// If `true`, this indicates that the write is complete. Sending any
	// `WriteRequest`s subsequent to one in which `finish_write` is `true` will
	// cause an error.
	FinishWrite bool `protobuf:"varint,3,opt,name=finish_write,json=finishWrite" json:"finish_write,omitempty"`
	// A portion of the data for the resource. The client **may** leave `data`
	// empty for any given `WriteRequest`. This enables the client to inform the
	// service that the request is still live while it is running an operation to
	// generate more data.
	Data []byte `protobuf:"bytes,10,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *WriteRequest) Reset()                    { *m = WriteRequest{} }
func (m *WriteRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()               {}
func (*WriteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Response object for ByteStream.Write.
type WriteResponse struct {
	// The number of bytes that have been processed for the given resource.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize" json:"committed_size,omitempty"`
}

func (m *WriteResponse) Reset()                    { *m = WriteResponse{} }
func (m *WriteResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteResponse) ProtoMessage()               {}
func (*WriteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Request object for ByteStream.QueryWriteStatus.
type QueryWriteStatusRequest struct {
	// The name of the resource whose write status is being requested.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName" json:"resource_name,omitempty"`
}

func (m *QueryWriteStatusRequest) Reset()                    { *m = QueryWriteStatusRequest{} }
func (m *QueryWriteStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryWriteStatusRequest) ProtoMessage()               {}
func (*QueryWriteStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Response object for ByteStream.QueryWriteStatus.
type QueryWriteStatusResponse struct {
	// The number of bytes that have been processed for the given resource.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize" json:"committed_size,omitempty"`
	// `complete` is `true` only if the client has sent a `WriteRequest` with
	// `finish_write` set to true, and the server has processed that request.
	Complete bool `protobuf:"varint,2,opt,name=complete" json:"complete,omitempty"`
}

func (m *QueryWriteStatusResponse) Reset()                    { *m = QueryWriteStatusResponse{} }
func (m *QueryWriteStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryWriteStatusResponse) ProtoMessage()               {}
func (*QueryWriteStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func init() {
	proto.RegisterType((*ReadRequest)(nil), "google.bytestream.ReadRequest")
	proto.RegisterType((*ReadResponse)(nil), "google.bytestream.ReadResponse")
	proto.RegisterType((*WriteRequest)(nil), "google.bytestream.WriteRequest")
	proto.RegisterType((*WriteResponse)(nil), "google.bytestream.WriteResponse")
	proto.RegisterType((*QueryWriteStatusRequest)(nil), "google.bytestream.QueryWriteStatusRequest")
	proto.RegisterType((*QueryWriteStatusResponse)(nil), "google.bytestream.QueryWriteStatusResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ByteStream service

type ByteStreamClient interface {
	// `Read()` is used to retrieve the contents of a resource as a sequence
	// of bytes. The bytes are returned in a sequence of responses, and the
	// responses are delivered as the results of a server-side streaming RPC.
	Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (ByteStream_ReadClient, error)
	// `Write()` is used to send the contents of a resource as a sequence of
	// bytes. The bytes are sent in a sequence of request protos of a client-side
	// streaming RPC.
	//
	// A `Write()` action is resumable. If there is an error or the connection is
	// broken during the `Write()`, the client should check the status of the
	// `Write()` by calling `QueryWriteStatus()` and continue writing from the
	// returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// Calling `Write()` on a resource name that was previously written and
	// finalized could cause an error, depending on whether the underlying service
	// allows over-writing of previously written resources.
	//
	// When the client closes the request channel, the service will respond with
	// a `WriteResponse`. The service will not view the resource as `complete`
	// until the client has sent a `WriteRequest` with `finish_write` set to
	// `true`. Sending any requests on a stream after sending a request with
	// `finish_write` set to `true` will cause an error. The client **should**
	// check the `WriteResponse` it receives to determine how much data the
	// service was able to commit and whether the service views the resource as
	// `complete` or not.
	Write(ctx context.Context, opts ...grpc.CallOption) (ByteStream_WriteClient, error)
	// `QueryWriteStatus()` is used to find the `committed_size` for a resource
	// that is being written, which can then be used as the `write_offset` for
	// the next `Write()` call.
	//
	// If the resource does not exist (i.e., the resource has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this resource. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// resource name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error)
}

type byteStreamClient struct {
	cc *grpc.ClientConn
}

func NewByteStreamClient(cc *grpc.ClientConn) ByteStreamClient {
	return &byteStreamClient{cc}
}

func (c *byteStreamClient) Read(ctx context.Context, in *ReadRequest, opts ...grpc.CallOption) (ByteStream_ReadClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ByteStream_serviceDesc.Streams[0], c.cc, "/google.bytestream.ByteStream/Read", opts...)
	if err != nil {
		return nil, err
	}
	x := &byteStreamReadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ByteStream_ReadClient interface {
	Recv() (*ReadResponse, error)
	grpc.ClientStream
}

type byteStreamReadClient struct {
	grpc.ClientStream
}

func (x *byteStreamReadClient) Recv() (*ReadResponse, error) {
	m := new(ReadResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *byteStreamClient) Write(ctx context.Context, opts ...grpc.CallOption) (ByteStream_WriteClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ByteStream_serviceDesc.Streams[1], c.cc, "/google.bytestream.ByteStream/Write", opts...)
	if err != nil {
		return nil, err
	}
	x := &byteStreamWriteClient{stream}
	return x, nil
}

type ByteStream_WriteClient interface {
	Send(*WriteRequest) error
	CloseAndRecv() (*WriteResponse, error)
	grpc.ClientStream
}

type byteStreamWriteClient struct {
	grpc.ClientStream
}

func (x *byteStreamWriteClient) Send(m *WriteRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *byteStreamWriteClient) CloseAndRecv() (*WriteResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(WriteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *byteStreamClient) QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error) {
	out := new(QueryWriteStatusResponse)
	err := grpc.Invoke(ctx, "/google.bytestream.ByteStream/QueryWriteStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ByteStream service

type ByteStreamServer interface {
	// `Read()` is used to retrieve the contents of a resource as a sequence
	// of bytes. The bytes are returned in a sequence of responses, and the
	// responses are delivered as the results of a server-side streaming RPC.
	Read(*ReadRequest, ByteStream_ReadServer) error
	// `Write()` is used to send the contents of a resource as a sequence of
	// bytes. The bytes are sent in a sequence of request protos of a client-side
	// streaming RPC.
	//
	// A `Write()` action is resumable. If there is an error or the connection is
	// broken during the `Write()`, the client should check the status of the
	// `Write()` by calling `QueryWriteStatus()` and continue writing from the
	// returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// Calling `Write()` on a resource name that was previously written and
	// finalized could cause an error, depending on whether the underlying service
	// allows over-writing of previously written resources.
	//
	// When the client closes the request channel, the service will respond with
	// a `WriteResponse`. The service will not view the resource as `complete`
	// until the client has sent a `WriteRequest` with `finish_write` set to
	// `true`. Sending any requests on a stream after sending a request with
	// `finish_write` set to `true` will cause an error. The client **should**
	// check the `WriteResponse` it receives to determine how much data the
	// service was able to commit and whether the service views the resource as
	// `complete` or not.
	Write(ByteStream_WriteServer) error
	// `QueryWriteStatus()` is used to find the `committed_size` for a resource
	// that is being written, which can then be used as the `write_offset` for
	// the next `Write()` call.
	//
	// If the resource does not exist (i.e., the resource has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this resource. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// resource name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error)
}

func RegisterByteStreamServer(s *grpc.Server, srv ByteStreamServer) {
	s.RegisterService(&_ByteStream_serviceDesc, srv)
}

func _ByteStream_Read_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ByteStreamServer).Read(m, &byteStreamReadServer{stream})
}

type ByteStream_ReadServer interface {
	Send(*ReadResponse) error
	grpc.ServerStream
}

type byteStreamReadServer struct {
	grpc.ServerStream
}

func (x *byteStreamReadServer) Send(m *ReadResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ByteStream_Write_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ByteStreamServer).Write(&byteStreamWriteServer{stream})
}

type ByteStream_WriteServer interface {
	SendAndClose(*WriteResponse) error
	Recv() (*WriteRequest, error)
	grpc.ServerStream
}

type byteStreamWriteServer struct {
	grpc.ServerStream
}

func (x *byteStreamWriteServer) SendAndClose(m *WriteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *byteStreamWriteServer) Recv() (*WriteRequest, error) {
	m := new(WriteRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ByteStream_QueryWriteStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWriteStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ByteStreamServer).QueryWriteStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bytestream.ByteStream/QueryWriteStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ByteStreamServer).QueryWriteStatus(ctx, req.(*QueryWriteStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ByteStream_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bytestream.ByteStream",
	HandlerType: (*ByteStreamServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryWriteStatus",
			Handler:    _ByteStream_QueryWriteStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Read",
			Handler:       _ByteStream_Read_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Write",
			Handler:       _ByteStream_Write_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/bytestream/bytestream.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/bytestream/bytestream.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 464 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x53, 0x5d, 0x6b, 0x13, 0x41,
	0x14, 0x65, 0xdb, 0x2a, 0xe9, 0xcd, 0xc6, 0x8f, 0x01, 0x71, 0x59, 0xd0, 0xa6, 0x2b, 0xc2, 0xa2,
	0xb0, 0x23, 0x0a, 0x82, 0x2f, 0x82, 0x79, 0x2b, 0x14, 0x3f, 0xb6, 0x0f, 0x3e, 0xc9, 0x32, 0xd9,
	0xdc, 0xdd, 0x0e, 0x66, 0x3e, 0x9c, 0x99, 0xb5, 0xa4, 0xff, 0xc1, 0x17, 0x7f, 0xb1, 0xec, 0x4c,
	0x6c, 0xa2, 0x49, 0xa0, 0x79, 0xbb, 0x73, 0xee, 0x3d, 0xe7, 0x9e, 0xb9, 0x73, 0x07, 0x3e, 0xb4,
	0x4a, 0xb5, 0x73, 0x2c, 0x5a, 0x35, 0x67, 0xb2, 0x2d, 0x94, 0x69, 0x69, 0x8b, 0x52, 0x1b, 0xe5,
	0x14, 0x0d, 0x29, 0xa6, 0xb9, 0xa5, 0xd3, 0x85, 0x43, 0xeb, 0x0c, 0x32, 0xb1, 0x16, 0x16, 0xbe,
	0x8c, 0x3c, 0x5c, 0x4a, 0xac, 0x12, 0xe9, 0xd9, 0xed, 0x54, 0x99, 0xe6, 0xd4, 0xa2, 0xf9, 0xc9,
	0x6b, 0xac, 0x95, 0x6c, 0x78, 0x4b, 0x99, 0x94, 0xca, 0x31, 0xc7, 0x95, 0xb4, 0x41, 0x3d, 0x7d,
	0xd7, 0x72, 0x77, 0xd9, 0x4d, 0x8b, 0x5a, 0x09, 0x1a, 0xe4, 0xa8, 0x4f, 0x4c, 0xbb, 0x86, 0x6a,
	0xb7, 0xd0, 0x68, 0xe9, 0x95, 0x61, 0x5a, 0xa3, 0x59, 0x05, 0x81, 0x9a, 0x19, 0x18, 0x96, 0xc8,
	0x66, 0x25, 0xfe, 0xe8, 0xd0, 0x3a, 0xf2, 0x0c, 0x46, 0x06, 0xad, 0xea, 0x4c, 0x8d, 0x95, 0x64,
	0x02, 0x93, 0x68, 0x1c, 0xe5, 0xc7, 0x65, 0xfc, 0x17, 0xfc, 0xc8, 0x04, 0x92, 0x13, 0x18, 0x1a,
	0x64, 0xb3, 0x4a, 0x35, 0x8d, 0x45, 0x97, 0x1c, 0x8c, 0xa3, 0xfc, 0xb0, 0x84, 0x1e, 0xfa, 0xe4,
	0x11, 0xf2, 0x04, 0xfc, 0xa9, 0x9a, 0x73, 0xc1, 0x5d, 0x72, 0xe8, 0xf3, 0xc7, 0x3d, 0x72, 0xde,
	0x03, 0x59, 0x06, 0x71, 0xe8, 0x69, 0xb5, 0x92, 0x16, 0x09, 0x81, 0xa3, 0x19, 0x73, 0x2c, 0x81,
	0x71, 0x94, 0xc7, 0xa5, 0x8f, 0xb3, 0x5f, 0x11, 0xc4, 0x5f, 0x0d, 0x77, 0xb8, 0x97, 0xb3, 0x53,
	0x88, 0xaf, 0x7a, 0xd2, 0xbf, 0xd6, 0x86, 0x1e, 0x5b, 0x7a, 0x3b, 0x85, 0xb8, 0xe1, 0x92, 0xdb,
	0xcb, 0xca, 0xa3, 0xde, 0xdd, 0xa0, 0x1c, 0x06, 0xcc, 0x77, 0xdc, 0xea, 0xe7, 0x2d, 0x8c, 0x96,
	0x76, 0x96, 0xa6, 0x9f, 0xc3, 0xbd, 0x5a, 0x09, 0xc1, 0x9d, 0xc3, 0x59, 0x65, 0xf9, 0x75, 0x30,
	0x74, 0x58, 0x8e, 0x6e, 0xd0, 0x0b, 0x7e, 0x8d, 0xd9, 0x7b, 0x78, 0xfc, 0xa5, 0x43, 0xb3, 0xf0,
	0xe4, 0x0b, 0xc7, 0x5c, 0x67, 0xf7, 0xb9, 0x51, 0xf6, 0x0d, 0x92, 0x4d, 0xfe, 0x5e, 0x16, 0x48,
	0x0a, 0x83, 0x5a, 0x09, 0x3d, 0x47, 0x87, 0x7e, 0x20, 0x83, 0xf2, 0xe6, 0xfc, 0xfa, 0xf7, 0x01,
	0xc0, 0x64, 0xd1, 0x2b, 0xf7, 0x3b, 0x49, 0xce, 0xe0, 0xa8, 0x7f, 0x19, 0xf2, 0xb4, 0xd8, 0xd8,
	0xd7, 0x62, 0x6d, 0x4d, 0xd2, 0x93, 0x9d, 0xf9, 0x60, 0xed, 0x55, 0x44, 0xce, 0xe1, 0x4e, 0x98,
	0xe6, 0xb6, 0xda, 0xf5, 0x97, 0x4d, 0xc7, 0xbb, 0x0b, 0x82, 0x5a, 0x1e, 0x91, 0xef, 0xf0, 0xe0,
	0xff, 0x31, 0x90, 0x17, 0x5b, 0x78, 0x3b, 0x66, 0x9d, 0xbe, 0xbc, 0x55, 0x6d, 0x68, 0x37, 0xc9,
	0xe1, 0x51, 0xad, 0xc4, 0x26, 0x63, 0x72, 0x7f, 0x35, 0xaa, 0xcf, 0xfe, 0x7f, 0xdd, 0xf5, 0x9f,
	0xe8, 0xcd, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc3, 0x2d, 0x1b, 0x69, 0x22, 0x04, 0x00, 0x00,
}
