// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/appengine/v1/application.proto
// DO NOT EDIT!

package google_appengine_v1 // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// An Application resource contains the top-level configuration of an App
// Engine application.
type Application struct {
	// Full path to the Application resource in the API.
	// Example: `apps/myapp`.
	//
	// @OutputOnly
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Identifier of the Application resource. This identifier is equivalent
	// to the project ID of the Google Cloud Platform project where you want to
	// deploy your application.
	// Example: `myapp`.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// HTTP path dispatch rules for requests to the application that do not
	// explicitly target a service or version. Rules are order-dependent.
	//
	// @OutputOnly
	DispatchRules []*UrlDispatchRule `protobuf:"bytes,3,rep,name=dispatch_rules,json=dispatchRules" json:"dispatch_rules,omitempty"`
	// Google Apps authentication domain that controls which users can access
	// this application.
	//
	// Defaults to open access for any Google Account.
	AuthDomain string `protobuf:"bytes,6,opt,name=auth_domain,json=authDomain" json:"auth_domain,omitempty"`
	// Location from which this application will be run. Application instances
	// will run out of data centers in the chosen location, which is also where
	// all of the application's end user content is stored.
	//
	// Defaults to `us-central`.
	//
	// Options are:
	//
	// `us-central` - Central US
	//
	// `europe-west` - Western Europe
	//
	// `us-east1` - Eastern US
	LocationId string `protobuf:"bytes,7,opt,name=location_id,json=locationId" json:"location_id,omitempty"`
	// Google Cloud Storage bucket that can be used for storing files
	// associated with this application. This bucket is associated with the
	// application and can be used by the gcloud deployment commands.
	//
	// @OutputOnly
	CodeBucket string `protobuf:"bytes,8,opt,name=code_bucket,json=codeBucket" json:"code_bucket,omitempty"`
	// Cookie expiration policy for this application.
	//
	// @OutputOnly
	DefaultCookieExpiration *google_protobuf1.Duration `protobuf:"bytes,9,opt,name=default_cookie_expiration,json=defaultCookieExpiration" json:"default_cookie_expiration,omitempty"`
	// Hostname used to reach this application, as resolved by App Engine.
	//
	// @OutputOnly
	DefaultHostname string `protobuf:"bytes,11,opt,name=default_hostname,json=defaultHostname" json:"default_hostname,omitempty"`
	// Google Cloud Storage bucket that can be used by this application to store
	// content.
	//
	// @OutputOnly
	DefaultBucket string `protobuf:"bytes,12,opt,name=default_bucket,json=defaultBucket" json:"default_bucket,omitempty"`
}

func (m *Application) Reset()                    { *m = Application{} }
func (m *Application) String() string            { return proto.CompactTextString(m) }
func (*Application) ProtoMessage()               {}
func (*Application) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Application) GetDispatchRules() []*UrlDispatchRule {
	if m != nil {
		return m.DispatchRules
	}
	return nil
}

func (m *Application) GetDefaultCookieExpiration() *google_protobuf1.Duration {
	if m != nil {
		return m.DefaultCookieExpiration
	}
	return nil
}

// Rules to match an HTTP request and dispatch that request to a service.
type UrlDispatchRule struct {
	// Domain name to match against. The wildcard "`*`" is supported if
	// specified before a period: "`*.`".
	//
	// Defaults to matching all domains: "`*`".
	Domain string `protobuf:"bytes,1,opt,name=domain" json:"domain,omitempty"`
	// Pathname within the host. Must start with a "`/`". A
	// single "`*`" can be included at the end of the path. The sum
	// of the lengths of the domain and path may not exceed 100
	// characters.
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Resource ID of a service in this application that should
	// serve the matched request. The service must already
	// exist. Example: `default`.
	Service string `protobuf:"bytes,3,opt,name=service" json:"service,omitempty"`
}

func (m *UrlDispatchRule) Reset()                    { *m = UrlDispatchRule{} }
func (m *UrlDispatchRule) String() string            { return proto.CompactTextString(m) }
func (*UrlDispatchRule) ProtoMessage()               {}
func (*UrlDispatchRule) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func init() {
	proto.RegisterType((*Application)(nil), "google.appengine.v1.Application")
	proto.RegisterType((*UrlDispatchRule)(nil), "google.appengine.v1.UrlDispatchRule")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/appengine/v1/application.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 424 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x52, 0xc1, 0x6e, 0x13, 0x31,
	0x10, 0x55, 0x12, 0x94, 0x52, 0x2f, 0x4d, 0x2b, 0x23, 0x51, 0xb7, 0x17, 0xa2, 0x0a, 0xa4, 0x70,
	0x60, 0xad, 0x96, 0x13, 0x47, 0x42, 0x90, 0xa8, 0xb8, 0x54, 0x91, 0x2a, 0x8e, 0x2b, 0xc7, 0x76,
	0xbc, 0x56, 0x37, 0x1e, 0x6b, 0xd7, 0x8e, 0xe0, 0x17, 0xf8, 0x6a, 0xb4, 0x63, 0x6f, 0xa8, 0x50,
	0x0f, 0xbd, 0xcd, 0x3c, 0xbf, 0x79, 0x1e, 0xbf, 0x67, 0xb2, 0x32, 0x00, 0xa6, 0xd1, 0xa5, 0x81,
	0x46, 0x38, 0x53, 0x42, 0x6b, 0xb8, 0xd1, 0xce, 0xb7, 0x10, 0x80, 0xa7, 0x23, 0xe1, 0x6d, 0xc7,
	0x85, 0xf7, 0xda, 0x19, 0xeb, 0x34, 0xdf, 0x5f, 0xf7, 0x4d, 0x63, 0xa5, 0x08, 0x16, 0x5c, 0x89,
	0x4c, 0xfa, 0x3a, 0xab, 0x1c, 0x68, 0xe5, 0xfe, 0xfa, 0xf2, 0xf6, 0xb9, 0xd2, 0x96, 0x77, 0xba,
	0xdd, 0x5b, 0xa9, 0x25, 0xb8, 0xad, 0x35, 0x5c, 0x38, 0x07, 0x01, 0xe5, 0xbb, 0xa4, 0x7f, 0xf9,
	0xd9, 0xd8, 0x50, 0xc7, 0x4d, 0x29, 0x61, 0xc7, 0x93, 0x1c, 0xc7, 0x83, 0x4d, 0xdc, 0x72, 0x1f,
	0x7e, 0x7b, 0xdd, 0x71, 0x15, 0x5b, 0x1c, 0x39, 0x14, 0x69, 0xf4, 0xea, 0xcf, 0x84, 0x14, 0x5f,
	0xfe, 0x2d, 0x4c, 0x29, 0x79, 0xe1, 0xc4, 0x4e, 0xb3, 0xd1, 0x7c, 0xb4, 0x38, 0x5e, 0x63, 0x4d,
	0x67, 0x64, 0x6c, 0x15, 0x1b, 0x23, 0x32, 0xb6, 0x8a, 0xfe, 0x20, 0x33, 0x65, 0x3b, 0x2f, 0x82,
	0xac, 0xab, 0x36, 0x36, 0xba, 0x63, 0x93, 0xf9, 0x64, 0x51, 0xdc, 0xbc, 0x2b, 0x9f, 0x78, 0x67,
	0x79, 0xdf, 0x36, 0xab, 0xcc, 0x5e, 0xc7, 0x46, 0xaf, 0x4f, 0xd4, 0xa3, 0xae, 0xa3, 0x6f, 0x49,
	0x21, 0x62, 0xa8, 0x2b, 0x05, 0x3b, 0x61, 0x1d, 0x9b, 0xe2, 0x2d, 0xa4, 0x87, 0x56, 0x88, 0xf4,
	0x84, 0x06, 0xd2, 0x76, 0x95, 0x55, 0xec, 0x28, 0x11, 0x06, 0xe8, 0x56, 0xf5, 0x04, 0x09, 0x4a,
	0x57, 0x9b, 0x28, 0x1f, 0x74, 0x60, 0x2f, 0x13, 0xa1, 0x87, 0x96, 0x88, 0xd0, 0x7b, 0x72, 0xa1,
	0xf4, 0x56, 0xc4, 0x26, 0x54, 0x12, 0xe0, 0xc1, 0xea, 0x4a, 0xff, 0xf2, 0x36, 0xd9, 0xc0, 0x8e,
	0xe7, 0xa3, 0x45, 0x71, 0x73, 0x31, 0xac, 0x3e, 0xf8, 0x56, 0xae, 0xb2, 0x4f, 0xeb, 0xf3, 0x3c,
	0xfb, 0x15, 0x47, 0xbf, 0x1d, 0x26, 0xe9, 0x07, 0x72, 0x36, 0xc8, 0xd6, 0xd0, 0x05, 0xb4, 0xad,
	0xc0, 0xcb, 0x4f, 0x33, 0xfe, 0x3d, 0xc3, 0xf4, 0x3d, 0x99, 0x0d, 0xd4, 0xbc, 0xe5, 0x2b, 0x24,
	0x9e, 0x64, 0x34, 0x2d, 0x7a, 0xf5, 0x93, 0x9c, 0xfe, 0xe7, 0x16, 0x7d, 0x43, 0xa6, 0xd9, 0x99,
	0x94, 0x48, 0xee, 0xfa, 0x9c, 0xbc, 0x08, 0x75, 0x4e, 0x05, 0x6b, 0xca, 0xc8, 0x51, 0xfe, 0x29,
	0x6c, 0x82, 0xf0, 0xd0, 0x2e, 0x3f, 0x92, 0x73, 0x09, 0xbb, 0xa7, 0xe2, 0x59, 0x9e, 0x3d, 0x4a,
	0xff, 0xae, 0x7f, 0xfc, 0xdd, 0x68, 0x33, 0x45, 0x17, 0x3e, 0xfd, 0x0d, 0x00, 0x00, 0xff, 0xff,
	0x68, 0x07, 0x8c, 0xce, 0xfe, 0x02, 0x00, 0x00,
}
