// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/servicemanagement/v1/servicemanager.proto
// DO NOT EDIT!

package google_api_servicemanagement_v1 // import "google.golang.org/genproto/googleapis/api/servicemanagement/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_api17 "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import _ "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/protobuf"
import _ "github.com/golang/protobuf/ptypes/struct"
import _ "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request message for `ListServices` method.
type ListServicesRequest struct {
	// Include services produced by the specified project.
	ProducerProjectId string `protobuf:"bytes,1,opt,name=producer_project_id,json=producerProjectId" json:"producer_project_id,omitempty"`
	// Requested size of the next page of data.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token identifying which result to start with; returned by a previous list
	// call.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListServicesRequest) Reset()                    { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()               {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Response message for `ListServices` method.
type ListServicesResponse struct {
	// The results of the query.
	Services []*ManagedService `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// Token that can be passed to `ListServices` to resume a paginated query.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServicesResponse) Reset()                    { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()               {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ListServicesResponse) GetServices() []*ManagedService {
	if m != nil {
		return m.Services
	}
	return nil
}

// Request message for `GetService` method.
type GetServiceRequest struct {
	// The name of the service.  See the `ServiceManager` overview for naming
	// requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *GetServiceRequest) Reset()                    { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()               {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

// Request message for CreateService method.
type CreateServiceRequest struct {
	// Initial values for the service resource.
	Service *ManagedService `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *CreateServiceRequest) Reset()                    { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()               {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *CreateServiceRequest) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for DeleteService method.
type DeleteServiceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *DeleteServiceRequest) Reset()                    { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()               {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

// Request message for UndeleteService method.
type UndeleteServiceRequest struct {
	// The name of the service. See the [overview](/service-management/overview)
	// for naming requirements. For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
}

func (m *UndeleteServiceRequest) Reset()                    { *m = UndeleteServiceRequest{} }
func (m *UndeleteServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*UndeleteServiceRequest) ProtoMessage()               {}
func (*UndeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

// Response message for UndeleteService method.
type UndeleteServiceResponse struct {
	// Revived service resource.
	Service *ManagedService `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *UndeleteServiceResponse) Reset()                    { *m = UndeleteServiceResponse{} }
func (m *UndeleteServiceResponse) String() string            { return proto.CompactTextString(m) }
func (*UndeleteServiceResponse) ProtoMessage()               {}
func (*UndeleteServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *UndeleteServiceResponse) GetService() *ManagedService {
	if m != nil {
		return m.Service
	}
	return nil
}

// Request message for GetServiceConfig method.
type GetServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	ConfigId    string `protobuf:"bytes,2,opt,name=config_id,json=configId" json:"config_id,omitempty"`
}

func (m *GetServiceConfigRequest) Reset()                    { *m = GetServiceConfigRequest{} }
func (m *GetServiceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceConfigRequest) ProtoMessage()               {}
func (*GetServiceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

// Request message for ListServiceConfigs method.
type ListServiceConfigsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListServiceConfigsRequest) Reset()                    { *m = ListServiceConfigsRequest{} }
func (m *ListServiceConfigsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceConfigsRequest) ProtoMessage()               {}
func (*ListServiceConfigsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

// Response message for ListServiceConfigs method.
type ListServiceConfigsResponse struct {
	// The list of service configuration resources.
	ServiceConfigs []*google_api17.Service `protobuf:"bytes,1,rep,name=service_configs,json=serviceConfigs" json:"service_configs,omitempty"`
	// The token of the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServiceConfigsResponse) Reset()                    { *m = ListServiceConfigsResponse{} }
func (m *ListServiceConfigsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceConfigsResponse) ProtoMessage()               {}
func (*ListServiceConfigsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ListServiceConfigsResponse) GetServiceConfigs() []*google_api17.Service {
	if m != nil {
		return m.ServiceConfigs
	}
	return nil
}

// Request message for CreateServiceConfig method.
type CreateServiceConfigRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The service configuration resource.
	ServiceConfig *google_api17.Service `protobuf:"bytes,2,opt,name=service_config,json=serviceConfig" json:"service_config,omitempty"`
}

func (m *CreateServiceConfigRequest) Reset()                    { *m = CreateServiceConfigRequest{} }
func (m *CreateServiceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceConfigRequest) ProtoMessage()               {}
func (*CreateServiceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CreateServiceConfigRequest) GetServiceConfig() *google_api17.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for SubmitConfigSource method.
type SubmitConfigSourceRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The source configuration for the service.
	ConfigSource *ConfigSource `protobuf:"bytes,2,opt,name=config_source,json=configSource" json:"config_source,omitempty"`
	// Optional. If set, this will result in the generation of a
	// `google.api.Service` configuration based on the `ConfigSource` provided,
	// but the generated config and the sources will NOT be persisted.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly" json:"validate_only,omitempty"`
}

func (m *SubmitConfigSourceRequest) Reset()                    { *m = SubmitConfigSourceRequest{} }
func (m *SubmitConfigSourceRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitConfigSourceRequest) ProtoMessage()               {}
func (*SubmitConfigSourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *SubmitConfigSourceRequest) GetConfigSource() *ConfigSource {
	if m != nil {
		return m.ConfigSource
	}
	return nil
}

// Response message for SubmitConfigSource method.
type SubmitConfigSourceResponse struct {
	// The generated service configuration.
	ServiceConfig *google_api17.Service `protobuf:"bytes,1,opt,name=service_config,json=serviceConfig" json:"service_config,omitempty"`
}

func (m *SubmitConfigSourceResponse) Reset()                    { *m = SubmitConfigSourceResponse{} }
func (m *SubmitConfigSourceResponse) String() string            { return proto.CompactTextString(m) }
func (*SubmitConfigSourceResponse) ProtoMessage()               {}
func (*SubmitConfigSourceResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *SubmitConfigSourceResponse) GetServiceConfig() *google_api17.Service {
	if m != nil {
		return m.ServiceConfig
	}
	return nil
}

// Request message for 'CreateServiceRollout'
type CreateServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The rollout resource. The `service_name` field is output only.
	Rollout *Rollout `protobuf:"bytes,2,opt,name=rollout" json:"rollout,omitempty"`
}

func (m *CreateServiceRolloutRequest) Reset()                    { *m = CreateServiceRolloutRequest{} }
func (m *CreateServiceRolloutRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceRolloutRequest) ProtoMessage()               {}
func (*CreateServiceRolloutRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *CreateServiceRolloutRequest) GetRollout() *Rollout {
	if m != nil {
		return m.Rollout
	}
	return nil
}

// Request message for 'ListServiceRollouts'
type ListServiceRolloutsRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The token of the page to retrieve.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The max number of items to include in the response list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListServiceRolloutsRequest) Reset()                    { *m = ListServiceRolloutsRequest{} }
func (m *ListServiceRolloutsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceRolloutsRequest) ProtoMessage()               {}
func (*ListServiceRolloutsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

// Response message for ListServiceRollouts method.
type ListServiceRolloutsResponse struct {
	// The list of rollout resources.
	Rollouts []*Rollout `protobuf:"bytes,1,rep,name=rollouts" json:"rollouts,omitempty"`
	// The token of the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServiceRolloutsResponse) Reset()                    { *m = ListServiceRolloutsResponse{} }
func (m *ListServiceRolloutsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceRolloutsResponse) ProtoMessage()               {}
func (*ListServiceRolloutsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ListServiceRolloutsResponse) GetRollouts() []*Rollout {
	if m != nil {
		return m.Rollouts
	}
	return nil
}

// Request message for GetServiceRollout method.
type GetServiceRolloutRequest struct {
	// The name of the service.  See the [overview](/service-management/overview)
	// for naming requirements.  For example: `example.googleapis.com`.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The id of the rollout resource.
	RolloutId string `protobuf:"bytes,2,opt,name=rollout_id,json=rolloutId" json:"rollout_id,omitempty"`
}

func (m *GetServiceRolloutRequest) Reset()                    { *m = GetServiceRolloutRequest{} }
func (m *GetServiceRolloutRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceRolloutRequest) ProtoMessage()               {}
func (*GetServiceRolloutRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

// Request message for EnableService method.
type EnableServiceRequest struct {
	// Name of the service to enable. Specifying an unknown service name will
	// cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The identity of consumer resource which service enablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms: "project:<project_id>", "project_number:<project_number>".
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId string `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (m *EnableServiceRequest) Reset()                    { *m = EnableServiceRequest{} }
func (m *EnableServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*EnableServiceRequest) ProtoMessage()               {}
func (*EnableServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

// Request message for DisableService method.
type DisableServiceRequest struct {
	// Name of the service to disable. Specifying an unknown service name
	// will cause the request to fail.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The identity of consumer resource which service disablement will be
	// applied to.
	//
	// The Google Service Management implementation accepts the following
	// forms: "project:<project_id>", "project_number:<project_number>".
	//
	// Note: this is made compatible with
	// google.api.servicecontrol.v1.Operation.consumer_id.
	ConsumerId string `protobuf:"bytes,2,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
}

func (m *DisableServiceRequest) Reset()                    { *m = DisableServiceRequest{} }
func (m *DisableServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*DisableServiceRequest) ProtoMessage()               {}
func (*DisableServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{18} }

// Request message for GenerateConfigReport method.
type GenerateConfigReportRequest struct {
	// Service configuration for which we want to generate the report.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	NewConfig *google_protobuf1.Any `protobuf:"bytes,1,opt,name=new_config,json=newConfig" json:"new_config,omitempty"`
	// Service configuration against which the comparison will be done.
	// For this version of API, the supported types are
	// [google.api.servicemanagement.v1.ConfigRef][google.api.servicemanagement.v1.ConfigRef],
	// [google.api.servicemanagement.v1.ConfigSource][google.api.servicemanagement.v1.ConfigSource],
	// and [google.api.Service][google.api.Service]
	OldConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=old_config,json=oldConfig" json:"old_config,omitempty"`
}

func (m *GenerateConfigReportRequest) Reset()                    { *m = GenerateConfigReportRequest{} }
func (m *GenerateConfigReportRequest) String() string            { return proto.CompactTextString(m) }
func (*GenerateConfigReportRequest) ProtoMessage()               {}
func (*GenerateConfigReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{19} }

func (m *GenerateConfigReportRequest) GetNewConfig() *google_protobuf1.Any {
	if m != nil {
		return m.NewConfig
	}
	return nil
}

func (m *GenerateConfigReportRequest) GetOldConfig() *google_protobuf1.Any {
	if m != nil {
		return m.OldConfig
	}
	return nil
}

// Response message for GenerateConfigReport method.
type GenerateConfigReportResponse struct {
	// Name of the service this report belongs to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// ID of the service configuration this report belongs to.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// list of ChangeReport, each corresponding to comparison between two
	// service configurations.
	ChangeReports []*ChangeReport `protobuf:"bytes,3,rep,name=change_reports,json=changeReports" json:"change_reports,omitempty"`
	// Errors / Linter warnings associated with the service definition this
	// report
	// belongs to.
	Diagnostics []*Diagnostic `protobuf:"bytes,4,rep,name=diagnostics" json:"diagnostics,omitempty"`
}

func (m *GenerateConfigReportResponse) Reset()                    { *m = GenerateConfigReportResponse{} }
func (m *GenerateConfigReportResponse) String() string            { return proto.CompactTextString(m) }
func (*GenerateConfigReportResponse) ProtoMessage()               {}
func (*GenerateConfigReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{20} }

func (m *GenerateConfigReportResponse) GetChangeReports() []*ChangeReport {
	if m != nil {
		return m.ChangeReports
	}
	return nil
}

func (m *GenerateConfigReportResponse) GetDiagnostics() []*Diagnostic {
	if m != nil {
		return m.Diagnostics
	}
	return nil
}

func init() {
	proto.RegisterType((*ListServicesRequest)(nil), "google.api.servicemanagement.v1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.api.servicemanagement.v1.ListServicesResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "google.api.servicemanagement.v1.GetServiceRequest")
	proto.RegisterType((*CreateServiceRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.api.servicemanagement.v1.DeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceRequest)(nil), "google.api.servicemanagement.v1.UndeleteServiceRequest")
	proto.RegisterType((*UndeleteServiceResponse)(nil), "google.api.servicemanagement.v1.UndeleteServiceResponse")
	proto.RegisterType((*GetServiceConfigRequest)(nil), "google.api.servicemanagement.v1.GetServiceConfigRequest")
	proto.RegisterType((*ListServiceConfigsRequest)(nil), "google.api.servicemanagement.v1.ListServiceConfigsRequest")
	proto.RegisterType((*ListServiceConfigsResponse)(nil), "google.api.servicemanagement.v1.ListServiceConfigsResponse")
	proto.RegisterType((*CreateServiceConfigRequest)(nil), "google.api.servicemanagement.v1.CreateServiceConfigRequest")
	proto.RegisterType((*SubmitConfigSourceRequest)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceRequest")
	proto.RegisterType((*SubmitConfigSourceResponse)(nil), "google.api.servicemanagement.v1.SubmitConfigSourceResponse")
	proto.RegisterType((*CreateServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.CreateServiceRolloutRequest")
	proto.RegisterType((*ListServiceRolloutsRequest)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsRequest")
	proto.RegisterType((*ListServiceRolloutsResponse)(nil), "google.api.servicemanagement.v1.ListServiceRolloutsResponse")
	proto.RegisterType((*GetServiceRolloutRequest)(nil), "google.api.servicemanagement.v1.GetServiceRolloutRequest")
	proto.RegisterType((*EnableServiceRequest)(nil), "google.api.servicemanagement.v1.EnableServiceRequest")
	proto.RegisterType((*DisableServiceRequest)(nil), "google.api.servicemanagement.v1.DisableServiceRequest")
	proto.RegisterType((*GenerateConfigReportRequest)(nil), "google.api.servicemanagement.v1.GenerateConfigReportRequest")
	proto.RegisterType((*GenerateConfigReportResponse)(nil), "google.api.servicemanagement.v1.GenerateConfigReportResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ServiceManager service

type ServiceManagerClient interface {
	// Lists all managed services.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets a managed service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a managed service. This method will change the serivce in the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*google_api17.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*google_api17.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error)
	// Enable a managed service for a project with default setting.
	//
	// Operation<response: EnableServiceResponse>
	//
	// [google.rpc.Status][google.rpc.Status] errors may contain a
	// [google.rpc.PreconditionFailure][] error detail.
	EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Disable a managed service for a project.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type serviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewServiceManagerClient(cc *grpc.ClientConn) ServiceManagerClient {
	return &serviceManagerClient{cc}
}

func (c *serviceManagerClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*ManagedService, error) {
	out := new(ManagedService)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DeleteService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) UndeleteService(ctx context.Context, in *UndeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/UndeleteService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceConfigs(ctx context.Context, in *ListServiceConfigsRequest, opts ...grpc.CallOption) (*ListServiceConfigsResponse, error) {
	out := new(ListServiceConfigsResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceConfig(ctx context.Context, in *GetServiceConfigRequest, opts ...grpc.CallOption) (*google_api17.Service, error) {
	out := new(google_api17.Service)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceConfig(ctx context.Context, in *CreateServiceConfigRequest, opts ...grpc.CallOption) (*google_api17.Service, error) {
	out := new(google_api17.Service)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) SubmitConfigSource(ctx context.Context, in *SubmitConfigSourceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) ListServiceRollouts(ctx context.Context, in *ListServiceRolloutsRequest, opts ...grpc.CallOption) (*ListServiceRolloutsResponse, error) {
	out := new(ListServiceRolloutsResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GetServiceRollout(ctx context.Context, in *GetServiceRolloutRequest, opts ...grpc.CallOption) (*Rollout, error) {
	out := new(Rollout)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) CreateServiceRollout(ctx context.Context, in *CreateServiceRolloutRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) GenerateConfigReport(ctx context.Context, in *GenerateConfigReportRequest, opts ...grpc.CallOption) (*GenerateConfigReportResponse, error) {
	out := new(GenerateConfigReportResponse)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) EnableService(ctx context.Context, in *EnableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/EnableService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceManagerClient) DisableService(ctx context.Context, in *DisableServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.api.servicemanagement.v1.ServiceManager/DisableService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceManager service

type ServiceManagerServer interface {
	// Lists all managed services.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets a managed service.
	GetService(context.Context, *GetServiceRequest) (*ManagedService, error)
	// Creates a new managed service.
	// Please note one producer project can own no more than 20 services.
	//
	// Operation<response: ManagedService>
	CreateService(context.Context, *CreateServiceRequest) (*google_longrunning.Operation, error)
	// Deletes a managed service. This method will change the serivce in the
	// `Soft-Delete` state for 30 days. Within this period, service producers may
	// call [UndeleteService][google.api.servicemanagement.v1.ServiceManager.UndeleteService] to restore the service.
	// After 30 days, the service will be permanently deleted.
	//
	// Operation<response: google.protobuf.Empty>
	DeleteService(context.Context, *DeleteServiceRequest) (*google_longrunning.Operation, error)
	// Revives a previously deleted managed service. The method restores the
	// service using the configuration at the time the service was deleted.
	// The target service must exist and must have been deleted within the
	// last 30 days.
	//
	// Operation<response: UndeleteServiceResponse>
	UndeleteService(context.Context, *UndeleteServiceRequest) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration for a managed service,
	// from the newest to the oldest.
	ListServiceConfigs(context.Context, *ListServiceConfigsRequest) (*ListServiceConfigsResponse, error)
	// Gets a service configuration (version) for a managed service.
	GetServiceConfig(context.Context, *GetServiceConfigRequest) (*google_api17.Service, error)
	// Creates a new service configuration (version) for a managed service.
	// This method only stores the service configuration. To roll out the service
	// configuration to backend systems please call
	// [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	CreateServiceConfig(context.Context, *CreateServiceConfigRequest) (*google_api17.Service, error)
	// Creates a new service configuration (version) for a managed service based
	// on
	// user-supplied configuration source files (for example: OpenAPI
	// Specification). This method stores the source configurations as well as the
	// generated service configuration. To rollout the service configuration to
	// other services,
	// please call [CreateServiceRollout][google.api.servicemanagement.v1.ServiceManager.CreateServiceRollout].
	//
	// Operation<response: SubmitConfigSourceResponse>
	SubmitConfigSource(context.Context, *SubmitConfigSourceRequest) (*google_longrunning.Operation, error)
	// Lists the history of the service configuration rollouts for a managed
	// service, from the newest to the oldest.
	ListServiceRollouts(context.Context, *ListServiceRolloutsRequest) (*ListServiceRolloutsResponse, error)
	// Gets a service configuration [rollout][google.api.servicemanagement.v1.Rollout].
	GetServiceRollout(context.Context, *GetServiceRolloutRequest) (*Rollout, error)
	// Creates a new service configuration rollout. Based on rollout, the
	// Google Service Management will roll out the service configurations to
	// different backend services. For example, the logging configuration will be
	// pushed to Google Cloud Logging.
	//
	// Please note that any previous pending and running Rollouts and associated
	// Operations will be automatically cancelled so that the latest Rollout will
	// not be blocked by previous Rollouts.
	//
	// Operation<response: Rollout>
	CreateServiceRollout(context.Context, *CreateServiceRolloutRequest) (*google_longrunning.Operation, error)
	// Generates and returns a report (errors, warnings and changes from
	// existing configurations) associated with
	// GenerateConfigReportRequest.new_value
	//
	// If GenerateConfigReportRequest.old_value is specified,
	// GenerateConfigReportRequest will contain a single ChangeReport based on the
	// comparison between GenerateConfigReportRequest.new_value and
	// GenerateConfigReportRequest.old_value.
	// If GenerateConfigReportRequest.old_value is not specified, this method
	// will compare GenerateConfigReportRequest.new_value with the last pushed
	// service configuration.
	GenerateConfigReport(context.Context, *GenerateConfigReportRequest) (*GenerateConfigReportResponse, error)
	// Enable a managed service for a project with default setting.
	//
	// Operation<response: EnableServiceResponse>
	//
	// [google.rpc.Status][google.rpc.Status] errors may contain a
	// [google.rpc.PreconditionFailure][] error detail.
	EnableService(context.Context, *EnableServiceRequest) (*google_longrunning.Operation, error)
	// Disable a managed service for a project.
	//
	// Operation<response: DisableServiceResponse>
	DisableService(context.Context, *DisableServiceRequest) (*google_longrunning.Operation, error)
}

func RegisterServiceManagerServer(s *grpc.Server, srv ServiceManagerServer) {
	s.RegisterService(&_ServiceManager_serviceDesc, srv)
}

func _ServiceManager_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_UndeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).UndeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/UndeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).UndeleteService(ctx, req.(*UndeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceConfigs(ctx, req.(*ListServiceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceConfig(ctx, req.(*GetServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceConfig(ctx, req.(*CreateServiceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_SubmitConfigSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitConfigSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).SubmitConfigSource(ctx, req.(*SubmitConfigSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_ListServiceRollouts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceRolloutsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).ListServiceRollouts(ctx, req.(*ListServiceRolloutsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GetServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GetServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GetServiceRollout(ctx, req.(*GetServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_CreateServiceRollout_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRolloutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).CreateServiceRollout(ctx, req.(*CreateServiceRolloutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_GenerateConfigReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConfigReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).GenerateConfigReport(ctx, req.(*GenerateConfigReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_EnableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).EnableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/EnableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).EnableService(ctx, req.(*EnableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceManager_DisableService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceManagerServer).DisableService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicemanagement.v1.ServiceManager/DisableService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceManagerServer).DisableService(ctx, req.(*DisableServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicemanagement.v1.ServiceManager",
	HandlerType: (*ServiceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _ServiceManager_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _ServiceManager_GetService_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _ServiceManager_CreateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _ServiceManager_DeleteService_Handler,
		},
		{
			MethodName: "UndeleteService",
			Handler:    _ServiceManager_UndeleteService_Handler,
		},
		{
			MethodName: "ListServiceConfigs",
			Handler:    _ServiceManager_ListServiceConfigs_Handler,
		},
		{
			MethodName: "GetServiceConfig",
			Handler:    _ServiceManager_GetServiceConfig_Handler,
		},
		{
			MethodName: "CreateServiceConfig",
			Handler:    _ServiceManager_CreateServiceConfig_Handler,
		},
		{
			MethodName: "SubmitConfigSource",
			Handler:    _ServiceManager_SubmitConfigSource_Handler,
		},
		{
			MethodName: "ListServiceRollouts",
			Handler:    _ServiceManager_ListServiceRollouts_Handler,
		},
		{
			MethodName: "GetServiceRollout",
			Handler:    _ServiceManager_GetServiceRollout_Handler,
		},
		{
			MethodName: "CreateServiceRollout",
			Handler:    _ServiceManager_CreateServiceRollout_Handler,
		},
		{
			MethodName: "GenerateConfigReport",
			Handler:    _ServiceManager_GenerateConfigReport_Handler,
		},
		{
			MethodName: "EnableService",
			Handler:    _ServiceManager_EnableService_Handler,
		},
		{
			MethodName: "DisableService",
			Handler:    _ServiceManager_DisableService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/api/servicemanagement/v1/servicemanager.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/servicemanagement/v1/servicemanager.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x57, 0x4d, 0x6f, 0xdc, 0x44,
	0x18, 0xd6, 0xa4, 0x5f, 0xc9, 0x9b, 0xec, 0x96, 0x4e, 0x16, 0xba, 0x75, 0x88, 0xda, 0x3a, 0x50,
	0xa2, 0x94, 0xae, 0x95, 0xa6, 0x69, 0xe9, 0xa6, 0x3d, 0x34, 0x4d, 0x55, 0x45, 0xd0, 0x36, 0xda,
	0x14, 0x89, 0x2f, 0x69, 0xe5, 0xd8, 0x53, 0xd7, 0xd4, 0x3b, 0x63, 0x3c, 0x76, 0x4a, 0x1a, 0xf5,
	0x40, 0x55, 0x09, 0x89, 0x9e, 0x10, 0x88, 0x4a, 0x1c, 0x11, 0xe2, 0xc0, 0x81, 0x0b, 0x07, 0x24,
	0x0e, 0x48, 0xfc, 0x06, 0xfe, 0x02, 0xbf, 0x81, 0x33, 0xf2, 0x78, 0xbc, 0xf1, 0xec, 0xba, 0x6b,
	0x3b, 0x7c, 0x1c, 0x92, 0x95, 0x67, 0xfc, 0xbc, 0xef, 0x33, 0xef, 0x3c, 0xf3, 0xfa, 0x19, 0xd8,
	0x74, 0x18, 0x73, 0x3c, 0xd2, 0x72, 0x98, 0x67, 0x52, 0xa7, 0xc5, 0x02, 0xc7, 0x70, 0x08, 0xf5,
	0x03, 0x16, 0x32, 0x23, 0x99, 0x32, 0x7d, 0x97, 0x1b, 0xa6, 0xef, 0x1a, 0x9c, 0x04, 0xdb, 0xae,
	0x45, 0x7a, 0x26, 0x35, 0x1d, 0xd2, 0x23, 0x34, 0x34, 0xb6, 0x17, 0xd5, 0xc1, 0xa0, 0x25, 0x80,
	0xf8, 0xa4, 0x0c, 0x6a, 0xfa, 0x6e, 0x6b, 0x08, 0xd5, 0xda, 0x5e, 0xd4, 0xd6, 0x2b, 0x67, 0xb5,
	0x18, 0xbd, 0xe7, 0x3a, 0x86, 0x49, 0x29, 0x0b, 0xcd, 0xd0, 0x65, 0x94, 0x27, 0xb9, 0xb4, 0x1b,
	0xfb, 0x0d, 0x25, 0x9f, 0x64, 0x98, 0xdb, 0xff, 0xb0, 0x0e, 0x01, 0xe1, 0x2c, 0x0a, 0x2c, 0x92,
	0xd2, 0x5a, 0x2d, 0x17, 0xcf, 0x63, 0xd4, 0x09, 0x22, 0x4a, 0x5d, 0xea, 0x18, 0xcc, 0x27, 0x81,
	0xb2, 0x34, 0xc3, 0x71, 0xc3, 0xfb, 0xd1, 0x56, 0xcb, 0x62, 0x3d, 0x23, 0x89, 0x63, 0x88, 0x89,
	0xad, 0xe8, 0x9e, 0xe1, 0x87, 0x3b, 0x3e, 0xe1, 0x86, 0x49, 0x77, 0xe2, 0x3f, 0x09, 0x58, 0x2a,
	0x06, 0x90, 0x9e, 0x1f, 0xee, 0x24, 0xff, 0x25, 0xe8, 0xc2, 0x08, 0xa6, 0x7d, 0xf4, 0x3d, 0x97,
	0x78, 0x76, 0xb7, 0x67, 0xf2, 0x07, 0x12, 0xb5, 0x5c, 0x9c, 0x8a, 0x87, 0x41, 0x64, 0x85, 0xf2,
	0x47, 0xc2, 0xae, 0x96, 0x2b, 0x4b, 0xe0, 0x5b, 0x06, 0x0f, 0xcd, 0x30, 0xe2, 0xf2, 0x27, 0x81,
	0xeb, 0x9f, 0x21, 0x98, 0x7e, 0xc7, 0xe5, 0xe1, 0x66, 0xb2, 0x05, 0xbc, 0x43, 0x3e, 0x89, 0x08,
	0x0f, 0x71, 0x0b, 0xa6, 0xfd, 0x80, 0xd9, 0x91, 0x45, 0x82, 0xae, 0x1f, 0xb0, 0x8f, 0x89, 0x15,
	0x76, 0x5d, 0xbb, 0x89, 0x4e, 0xa1, 0xf9, 0x89, 0xce, 0xb1, 0x74, 0x6a, 0x23, 0x99, 0x59, 0xb7,
	0xf1, 0x0c, 0x4c, 0xf8, 0xa6, 0x43, 0xba, 0xdc, 0x7d, 0x44, 0x9a, 0x87, 0x4e, 0xa1, 0xf9, 0x43,
	0x9d, 0xf1, 0x78, 0x60, 0xd3, 0x7d, 0x44, 0xf0, 0x2c, 0x80, 0x98, 0x0c, 0xd9, 0x03, 0x42, 0x9b,
	0x87, 0x45, 0x0c, 0xf1, 0xfa, 0xdd, 0x78, 0x40, 0x7f, 0x86, 0xa0, 0xa1, 0x72, 0xe0, 0x3e, 0xa3,
	0x9c, 0xe0, 0xb7, 0x61, 0x5c, 0x4a, 0x83, 0x37, 0xd1, 0xa9, 0x03, 0xf3, 0x93, 0xe7, 0x8d, 0x56,
	0xc1, 0x41, 0x68, 0xdd, 0x12, 0x4f, 0xb6, 0x8c, 0xd5, 0xe9, 0x07, 0xc0, 0x67, 0xe0, 0x28, 0x25,
	0x9f, 0x86, 0xdd, 0x0c, 0x93, 0x31, 0xc1, 0xa4, 0x16, 0x0f, 0x6f, 0xf4, 0xd9, 0x5c, 0x84, 0x63,
	0x37, 0x49, 0xca, 0x25, 0x2d, 0xc7, 0x69, 0x98, 0x92, 0x81, 0xba, 0xd4, 0xec, 0x11, 0x59, 0x87,
	0x49, 0x39, 0x76, 0xdb, 0xec, 0x11, 0xdd, 0x84, 0xc6, 0xf5, 0x80, 0x98, 0x21, 0x19, 0x80, 0xae,
	0xc3, 0x11, 0xf9, 0x9a, 0x40, 0xed, 0x63, 0x0d, 0x29, 0x5e, 0xbf, 0x0c, 0x8d, 0x35, 0xe2, 0x91,
	0xa1, 0x14, 0x25, 0xd8, 0xad, 0xc0, 0x2b, 0xef, 0x52, 0x7b, 0x9f, 0x60, 0x1b, 0x8e, 0x0f, 0x81,
	0xe5, 0x16, 0xfd, 0x8b, 0xab, 0x7b, 0x1f, 0x8e, 0xef, 0x15, 0xfe, 0xba, 0x68, 0x29, 0xe5, 0x39,
	0xc6, 0x02, 0x4c, 0xda, 0x50, 0x2c, 0xd3, 0x64, 0x63, 0xc7, 0x93, 0x81, 0x75, 0x5b, 0x7f, 0x04,
	0x27, 0x32, 0x02, 0x4b, 0x62, 0xf3, 0x0a, 0xc1, 0x55, 0x01, 0x8f, 0x0d, 0x08, 0x58, 0x15, 0xff,
	0x01, 0x55, 0xfc, 0xfa, 0x13, 0x04, 0x5a, 0x5e, 0x72, 0x59, 0xc0, 0x2b, 0x70, 0x34, 0xcd, 0x9e,
	0xd0, 0x4d, 0xa5, 0x3e, 0x9d, 0x2d, 0x64, 0x5a, 0xac, 0x3a, 0x57, 0xa2, 0x94, 0x16, 0xf5, 0x2e,
	0x68, 0x8a, 0x38, 0x2b, 0x97, 0xb7, 0x0d, 0x75, 0x95, 0xa6, 0xc8, 0xf3, 0x02, 0x96, 0x35, 0x85,
	0xa5, 0xfe, 0x0b, 0x82, 0x13, 0x9b, 0xd1, 0x56, 0xcf, 0x0d, 0x93, 0x81, 0x4d, 0xd1, 0xd7, 0x2b,
	0x24, 0xef, 0x40, 0x4d, 0xee, 0x6d, 0xf2, 0x49, 0x90, 0xb9, 0xcf, 0x15, 0x4a, 0x4d, 0xc9, 0x37,
	0x65, 0x65, 0x9e, 0xf0, 0x1c, 0xd4, 0xb6, 0x4d, 0xcf, 0xb5, 0xcd, 0x90, 0x74, 0x19, 0xf5, 0x76,
	0xc4, 0xbe, 0x8d, 0x77, 0xa6, 0xd2, 0xc1, 0x3b, 0xd4, 0xdb, 0xd1, 0xdf, 0x03, 0x2d, 0x8f, 0xb8,
	0xdc, 0xba, 0xe1, 0x9a, 0xa0, 0xd2, 0x35, 0x79, 0x8a, 0x60, 0x46, 0x6d, 0x17, 0xcc, 0xf3, 0x58,
	0x14, 0x56, 0xa8, 0xca, 0x2a, 0x1c, 0x09, 0x12, 0x90, 0xac, 0xc7, 0x7c, 0x61, 0x3d, 0xd2, 0x24,
	0x29, 0x30, 0xd6, 0x45, 0x46, 0x9b, 0x72, 0xfa, 0xff, 0x3a, 0x19, 0xcf, 0x10, 0xcc, 0xe4, 0x66,
	0x97, 0xf5, 0x5d, 0x83, 0x71, 0xc9, 0x33, 0x3d, 0x13, 0xe5, 0x57, 0xd8, 0x47, 0x96, 0x3e, 0x22,
	0x1f, 0x41, 0x33, 0xd3, 0xf7, 0x2b, 0xef, 0xc6, 0x2c, 0x80, 0x4c, 0xb9, 0xd7, 0x80, 0x26, 0xe4,
	0xc8, 0xba, 0xad, 0x7f, 0x00, 0x8d, 0x1b, 0xd4, 0xdc, 0xf2, 0xaa, 0x77, 0x5f, 0x7c, 0x12, 0x26,
	0x2d, 0x46, 0x79, 0xd4, 0x23, 0xc1, 0x5e, 0x68, 0x48, 0x87, 0xd6, 0x6d, 0xfd, 0x43, 0x78, 0x79,
	0xcd, 0xe5, 0xff, 0x51, 0xf0, 0xcf, 0x11, 0xcc, 0xdc, 0x24, 0x34, 0x36, 0x52, 0xfd, 0xae, 0xe1,
	0xb3, 0xa0, 0x5f, 0x9a, 0x25, 0x00, 0x4a, 0x1e, 0xaa, 0x07, 0xa0, 0x91, 0x6e, 0x53, 0x6a, 0x60,
	0x5a, 0xd7, 0xe8, 0x4e, 0x67, 0x82, 0x92, 0x87, 0x49, 0x84, 0x18, 0xc4, 0x3c, 0x5b, 0xed, 0x24,
	0x2f, 0x00, 0x31, 0xcf, 0x96, 0x47, 0xe6, 0x2f, 0x04, 0xaf, 0xe6, 0x33, 0x91, 0x7a, 0x29, 0xb1,
	0xdc, 0x3a, 0x8c, 0xf5, 0x57, 0x39, 0xe6, 0xda, 0xf8, 0x2e, 0xd4, 0xad, 0xfb, 0x26, 0x75, 0x48,
	0x37, 0x10, 0xb1, 0x78, 0xf3, 0x80, 0x10, 0x5a, 0x89, 0xd6, 0x22, 0x60, 0x92, 0x41, 0xcd, 0xca,
	0x3c, 0x71, 0x7c, 0x0b, 0x26, 0x6d, 0xd7, 0x74, 0x28, 0xe3, 0xa1, 0x6b, 0xf1, 0xe6, 0x41, 0x11,
	0xf2, 0x6c, 0x61, 0xc8, 0xb5, 0x3e, 0xa6, 0x93, 0xc5, 0x9f, 0xff, 0x69, 0x1a, 0xea, 0x72, 0x67,
	0x93, 0x6f, 0x67, 0x80, 0xbf, 0x44, 0x30, 0x95, 0xb5, 0x4c, 0xf8, 0x42, 0x61, 0xf4, 0x1c, 0x97,
	0xa7, 0x2d, 0x57, 0x44, 0x25, 0x85, 0xd6, 0x1b, 0x4f, 0xfe, 0xf8, 0xf3, 0xab, 0xb1, 0x3a, 0x9e,
	0xca, 0xdc, 0x57, 0x38, 0xfe, 0x06, 0x01, 0xec, 0x9d, 0x20, 0x7c, 0xbe, 0x30, 0xf6, 0x90, 0xcd,
	0xd2, 0xaa, 0x9a, 0x07, 0x7d, 0x4e, 0x30, 0x99, 0xc5, 0x33, 0x59, 0x26, 0xc6, 0x6e, 0x56, 0x06,
	0x8f, 0xf1, 0x53, 0x04, 0x35, 0xa5, 0xd7, 0xe2, 0xe2, 0x75, 0xe7, 0x59, 0x39, 0x6d, 0x36, 0x85,
	0x65, 0x2e, 0x19, 0xad, 0x3b, 0xe9, 0x25, 0x43, 0x9f, 0x15, 0x64, 0x8e, 0xeb, 0x4a, 0x59, 0xda,
	0xa9, 0xbf, 0xc1, 0x5f, 0x20, 0xa8, 0x29, 0xf6, 0xad, 0x04, 0x8d, 0x3c, 0xbb, 0x57, 0x44, 0x43,
	0xd6, 0x64, 0x61, 0x64, 0x4d, 0x9e, 0x23, 0x38, 0x3a, 0xe0, 0xe9, 0xf0, 0xa5, 0x42, 0x3a, 0xf9,
	0x16, 0xb2, 0x88, 0xd0, 0x9b, 0x82, 0xd0, 0x19, 0xfd, 0xb5, 0x11, 0x84, 0xda, 0x91, 0x0c, 0x8d,
	0x7f, 0x45, 0x80, 0x87, 0xfd, 0x12, 0x6e, 0x57, 0x91, 0xaa, 0xea, 0xf0, 0xb4, 0x95, 0x7d, 0x61,
	0xa5, 0xd8, 0xcf, 0x0a, 0xf6, 0xaf, 0xe3, 0xb9, 0x11, 0xec, 0x0d, 0x69, 0xdd, 0xf0, 0xb7, 0x08,
	0x5e, 0x1a, 0x34, 0xb1, 0xf8, 0xad, 0x0a, 0x27, 0x41, 0x31, 0x66, 0x5a, 0x9e, 0x93, 0xd0, 0x2f,
	0x09, 0x42, 0x8b, 0xd8, 0x28, 0x41, 0xc8, 0xd8, 0xed, 0x9b, 0xe2, 0xc7, 0xf8, 0x7b, 0x04, 0xd3,
	0x39, 0x2e, 0x10, 0xaf, 0x54, 0x3b, 0x0d, 0x25, 0x28, 0xae, 0x08, 0x8a, 0xcb, 0x7a, 0x99, 0x9a,
	0xb5, 0x07, 0x4c, 0x14, 0xfe, 0x01, 0x01, 0x1e, 0x76, 0x5d, 0x25, 0x04, 0xf0, 0x42, 0x8f, 0x59,
	0x24, 0xd0, 0x65, 0x41, 0xd7, 0xd0, 0x17, 0xca, 0xd0, 0xe5, 0x22, 0x4b, 0x1b, 0x2d, 0xe0, 0xdf,
	0xd4, 0xbb, 0x73, 0xea, 0x5f, 0x70, 0x25, 0xb9, 0x0d, 0x78, 0x2e, 0xed, 0xca, 0xfe, 0xc0, 0x52,
	0xac, 0xf2, 0xa8, 0xe1, 0x51, 0x47, 0xcd, 0xe8, 0x5b, 0xa3, 0x9f, 0x91, 0x72, 0xd7, 0x4d, 0x86,
	0xf1, 0xe5, 0x2a, 0x8d, 0x5b, 0xf1, 0x49, 0x5a, 0x69, 0x7f, 0xa6, 0x5f, 0x16, 0x44, 0x97, 0xf0,
	0x62, 0x19, 0xa2, 0xc6, 0xee, 0x9e, 0xb5, 0x7a, 0x8c, 0x7f, 0x44, 0x83, 0x37, 0x6d, 0x49, 0xfc,
	0x4a, 0xc5, 0xae, 0xae, 0x72, 0x2f, 0xa9, 0x91, 0x52, 0x95, 0x6d, 0xa7, 0x06, 0x1b, 0xff, 0x8e,
	0xa0, 0x91, 0x67, 0x5a, 0x4a, 0x90, 0x1d, 0xe1, 0xba, 0xb4, 0xab, 0xfb, 0x44, 0xab, 0x32, 0xd1,
	0x4f, 0x2b, 0x5f, 0x2a, 0x27, 0x07, 0x12, 0xeb, 0xfc, 0x6b, 0x04, 0x35, 0xc5, 0xbc, 0x96, 0xf8,
	0x70, 0xe5, 0x99, 0xdd, 0xa2, 0x12, 0x9f, 0x13, 0xac, 0xde, 0xd0, 0xf5, 0x51, 0xdf, 0x09, 0x22,
	0x02, 0xc7, 0xb4, 0x9e, 0x23, 0xa8, 0xab, 0xbe, 0x17, 0x5f, 0x2c, 0xe1, 0xb1, 0x78, 0x75, 0x62,
	0x2d, 0x41, 0x6c, 0x7e, 0x64, 0x3b, 0x6b, 0xdb, 0x49, 0xe4, 0x36, 0x5a, 0x58, 0xbd, 0x0e, 0x73,
	0x16, 0xeb, 0x15, 0x71, 0x59, 0x9d, 0x56, 0x4d, 0xdd, 0x46, 0xec, 0x7b, 0x37, 0xd0, 0x77, 0x63,
	0x07, 0x6f, 0x5e, 0xdb, 0xbc, 0xb5, 0x75, 0x58, 0xf8, 0xe0, 0xa5, 0xbf, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xb8, 0x45, 0x92, 0x9b, 0x50, 0x16, 0x00, 0x00,
}
