// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/logging.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Logging configuration of the service.
//
// The following example shows how to configure logs to be sent to the
// producer and consumer projects. In the example,
// the `library.googleapis.com/activity_history` log is
// sent to both the producer and consumer projects, whereas
// the `library.googleapis.com/purchase_history` log is only sent to the
// producer project:
//
//     monitored_resources:
//     - type: library.googleapis.com/branch
//       labels:
//       - key: /city
//         description: The city where the library branch is located in.
//       - key: /name
//         description: The name of the branch.
//     logs:
//     - name: library.googleapis.com/activity_history
//       labels:
//       - key: /customer_id
//     - name: library.googleapis.com/purchase_history
//     logging:
//       producer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         logs:
//         - library.googleapis.com/activity_history
//         - library.googleapis.com/purchase_history
//       consumer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         logs:
//         - library.googleapis.com/activity_history
type Logging struct {
	// Logging configurations for sending logs to the producer project.
	// There can be multiple producer destinations, each one must have a
	// different monitored resource type. A log can be used in at most
	// one producer destination.
	ProducerDestinations []*Logging_LoggingDestination `protobuf:"bytes,1,rep,name=producer_destinations,json=producerDestinations" json:"producer_destinations,omitempty"`
	// Logging configurations for sending logs to the consumer project.
	// There can be multiple consumer destinations, each one must have a
	// different monitored resource type. A log can be used in at most
	// one consumer destination.
	ConsumerDestinations []*Logging_LoggingDestination `protobuf:"bytes,2,rep,name=consumer_destinations,json=consumerDestinations" json:"consumer_destinations,omitempty"`
}

func (m *Logging) Reset()                    { *m = Logging{} }
func (m *Logging) String() string            { return proto.CompactTextString(m) }
func (*Logging) ProtoMessage()               {}
func (*Logging) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0} }

func (m *Logging) GetProducerDestinations() []*Logging_LoggingDestination {
	if m != nil {
		return m.ProducerDestinations
	}
	return nil
}

func (m *Logging) GetConsumerDestinations() []*Logging_LoggingDestination {
	if m != nil {
		return m.ConsumerDestinations
	}
	return nil
}

// Configuration of a specific logging destination (the producer project
// or the consumer project).
type Logging_LoggingDestination struct {
	// The monitored resource type. The type must be defined in
	// [Service.monitored_resources][google.api.Service.monitored_resources] section.
	MonitoredResource string `protobuf:"bytes,3,opt,name=monitored_resource,json=monitoredResource" json:"monitored_resource,omitempty"`
	// Names of the logs to be sent to this destination. Each name must
	// be defined in the [Service.logs][google.api.Service.logs] section.
	Logs []string `protobuf:"bytes,1,rep,name=logs" json:"logs,omitempty"`
}

func (m *Logging_LoggingDestination) Reset()                    { *m = Logging_LoggingDestination{} }
func (m *Logging_LoggingDestination) String() string            { return proto.CompactTextString(m) }
func (*Logging_LoggingDestination) ProtoMessage()               {}
func (*Logging_LoggingDestination) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0, 0} }

func init() {
	proto.RegisterType((*Logging)(nil), "google.api.Logging")
	proto.RegisterType((*Logging_LoggingDestination)(nil), "google.api.Logging.LoggingDestination")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/logging.proto", fileDescriptor10)
}

var fileDescriptor10 = []byte{
	// 263 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x90, 0x4f, 0x4b, 0xc3, 0x30,
	0x18, 0x87, 0x69, 0x37, 0x94, 0x45, 0x11, 0x0c, 0x0a, 0x63, 0xa7, 0xe1, 0x41, 0x77, 0x31, 0x01,
	0xfd, 0x04, 0x0e, 0x45, 0x06, 0x1e, 0x4a, 0x2f, 0x1e, 0x3c, 0x8c, 0x98, 0xc6, 0x97, 0x40, 0xfb,
	0xbe, 0x21, 0x49, 0xfd, 0x34, 0x9e, 0xfc, 0xa4, 0xb2, 0xa6, 0x75, 0x45, 0x4f, 0x7a, 0x4a, 0xc8,
	0xef, 0xc9, 0xf3, 0xfe, 0x61, 0x0f, 0x40, 0x04, 0xb5, 0x11, 0x40, 0xb5, 0x42, 0x10, 0xe4, 0x41,
	0x82, 0x41, 0xe7, 0x29, 0x92, 0x4c, 0x91, 0x72, 0x36, 0x48, 0xe5, 0xac, 0x0c, 0xc6, 0xbf, 0x5b,
	0x6d, 0x34, 0xe1, 0x9b, 0x05, 0x59, 0x13, 0x80, 0x45, 0x10, 0x1d, 0xca, 0x59, 0xaf, 0x51, 0xce,
	0x2e, 0x36, 0xff, 0x55, 0x2a, 0x44, 0x8a, 0x2a, 0x5a, 0xc2, 0x90, 0xb4, 0x17, 0x1f, 0x39, 0x3b,
	0x7c, 0x4a, 0x85, 0xf8, 0x0b, 0x3b, 0x77, 0x9e, 0xaa, 0x56, 0x1b, 0xbf, 0xad, 0x4c, 0x88, 0x16,
	0x13, 0x3a, 0xcf, 0x96, 0x93, 0xd5, 0xd1, 0xcd, 0xa5, 0xd8, 0xb7, 0x20, 0xfa, 0x3f, 0xc3, 0x79,
	0xbf, 0xc7, 0xcb, 0xb3, 0x41, 0x32, 0x7a, 0x0c, 0x3b, 0xb9, 0x26, 0x0c, 0x6d, 0xf3, 0x53, 0x9e,
	0xff, 0x4d, 0x3e, 0x48, 0xc6, 0xf2, 0xc5, 0x33, 0xe3, 0xbf, 0x59, 0x7e, 0xcd, 0x78, 0x43, 0x68,
	0x23, 0x79, 0x53, 0x6d, 0xbd, 0x09, 0xd4, 0x7a, 0x6d, 0xe6, 0x93, 0x65, 0xb6, 0x9a, 0x95, 0xa7,
	0xdf, 0x49, 0xd9, 0x07, 0x9c, 0xb3, 0x69, 0x4d, 0x90, 0xa6, 0x9d, 0x95, 0xdd, 0x7d, 0x7d, 0xc5,
	0x4e, 0x34, 0x35, 0xa3, 0xde, 0xd6, 0xc7, 0x7d, 0xa1, 0x62, 0xb7, 0xbe, 0x22, 0xfb, 0xcc, 0xa7,
	0x8f, 0x77, 0xc5, 0xe6, 0xf5, 0xa0, 0x5b, 0xe7, 0xed, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x48,
	0x22, 0x03, 0x10, 0xee, 0x01, 0x00, 0x00,
}
