// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/endpoint.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// `Endpoint` describes a network endpoint that serves a set of APIs.
// A service may expose any number of endpoints, and all endpoints share the
// same service configuration, such as quota configuration and monitoring
// configuration.
//
// Example service configuration:
//
//     name: library-example.googleapis.com
//     endpoints:
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address library-example.googleapis.com.
//       # It also allows HTTP OPTIONS calls to be passed to the backend, for
//       # it to decide whether the subsequent cross-origin request is
//       # allowed to proceed.
//     - name: library-example.googleapis.com
//       apis: google.example.library.v1.Library
//       allow_cors: true
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address
//       # google.example.library-example.v1.LibraryManager.
//     - name: library-manager.googleapis.com
//       apis: google.example.library.v1.LibraryManager
//       # BNS address for a borg job. Can specify a task by appending
//       # "/taskId" (e.g. "/0") to the job spec.
//
// Example OpenAPI extension for endpoint with allow_cors set to true:
//
//     {
//       "swagger": "2.0",
//       "info": {
//         "description": "A simple..."
//       },
//       "host": "MY_PROJECT_ID.appspot.com",
//       "x-google-endpoints": [{
//         "name": "MY_PROJECT_ID.appspot.com",
//         "allow_cors": "true"
//       }]
//     }
type Endpoint struct {
	// The canonical name of this endpoint.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// DEPRECATED: This field is no longer supported. Instead of using aliases,
	// please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
	// alias.
	//
	// Additional names that this endpoint will be hosted on.
	Aliases []string `protobuf:"bytes,2,rep,name=aliases" json:"aliases,omitempty"`
	// The list of APIs served by this endpoint.
	Apis []string `protobuf:"bytes,3,rep,name=apis" json:"apis,omitempty"`
	// The list of features enabled on this endpoint.
	Features []string `protobuf:"bytes,4,rep,name=features" json:"features,omitempty"`
	// Allowing
	// [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
	// cross-domain traffic, would allow the backends served from this endpoint to
	// receive and respond to HTTP OPTIONS requests. The response will be used by
	// the browser to determine whether the subsequent cross-origin request is
	// allowed to proceed.
	AllowCors bool `protobuf:"varint,5,opt,name=allow_cors,json=allowCors" json:"allow_cors,omitempty"`
}

func (m *Endpoint) Reset()                    { *m = Endpoint{} }
func (m *Endpoint) String() string            { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()               {}
func (*Endpoint) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func init() {
	proto.RegisterType((*Endpoint)(nil), "google.api.Endpoint")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/endpoint.proto", fileDescriptor8)
}

var fileDescriptor8 = []byte{
	// 233 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x4f, 0x41, 0x4e, 0xc3, 0x30,
	0x10, 0x94, 0xdb, 0x00, 0x89, 0x25, 0x38, 0xf8, 0x64, 0x55, 0x42, 0x8a, 0x38, 0xe5, 0x14, 0x1f,
	0x78, 0x01, 0x45, 0x80, 0x7a, 0x8b, 0xf2, 0x01, 0xb4, 0x84, 0xad, 0x65, 0xc9, 0xdd, 0xb5, 0x6c,
	0x03, 0x4f, 0xe0, 0x1f, 0xbc, 0x14, 0xc5, 0x6d, 0xe0, 0xde, 0xdb, 0xcc, 0xec, 0x68, 0x66, 0x56,
	0x3e, 0x5b, 0x66, 0xeb, 0xb1, 0xb7, 0xec, 0x81, 0x6c, 0xcf, 0xd1, 0x1a, 0x8b, 0x14, 0x22, 0x67,
	0x36, 0xc7, 0x13, 0x04, 0x97, 0x0c, 0x04, 0x67, 0x12, 0xc6, 0x4f, 0x37, 0xe1, 0xc4, 0xb4, 0x77,
	0xd6, 0x20, 0xbd, 0x07, 0x76, 0x94, 0xfb, 0xe2, 0x55, 0xf2, 0x94, 0x03, 0xc1, 0x6d, 0x76, 0xe7,
	0x66, 0x02, 0x11, 0x67, 0xc8, 0x8e, 0x29, 0x1d, 0x63, 0xef, 0xbe, 0x85, 0xac, 0x9f, 0x4e, 0x4d,
	0x4a, 0xc9, 0x8a, 0xe0, 0x80, 0x5a, 0xb4, 0xa2, 0x6b, 0xc6, 0x82, 0x95, 0x96, 0x57, 0xe0, 0x1d,
	0x24, 0x4c, 0x7a, 0xd5, 0xae, 0xbb, 0x66, 0x5c, 0xe8, 0xec, 0x9e, 0x6b, 0xf4, 0xba, 0xc8, 0x05,
	0xab, 0x8d, 0xac, 0xf7, 0x08, 0xf9, 0x23, 0x62, 0xd2, 0x55, 0xd1, 0xff, 0xb8, 0xba, 0x95, 0x12,
	0xbc, 0xe7, 0xaf, 0xd7, 0x89, 0x63, 0xd2, 0x17, 0xad, 0xe8, 0xea, 0xb1, 0x29, 0xca, 0x23, 0xc7,
	0xb4, 0xed, 0xe4, 0xcd, 0xc4, 0x87, 0xfe, 0xff, 0xcd, 0xed, 0xf5, 0x32, 0x6c, 0x98, 0xa7, 0x0e,
	0xe2, 0x67, 0x55, 0xbd, 0x3c, 0x0c, 0xbb, 0xb7, 0xcb, 0x32, 0xfd, 0xfe, 0x37, 0x00, 0x00, 0xff,
	0xff, 0x2f, 0xf3, 0xbc, 0x78, 0x5b, 0x01, 0x00, 0x00,
}
