// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/documentation.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// `Documentation` provides the information for describing a service.
//
// Example:
// <pre><code>documentation:
//   summary: >
//     The Google Calendar API gives access
//     to most calendar features.
//   pages:
//   - name: Overview
//     content: &#40;== include google/foo/overview.md ==&#41;
//   - name: Tutorial
//     content: &#40;== include google/foo/tutorial.md ==&#41;
//     subpages;
//     - name: Java
//       content: &#40;== include google/foo/tutorial_java.md ==&#41;
//   rules:
//   - selector: google.calendar.Calendar.Get
//     description: >
//       ...
//   - selector: google.calendar.Calendar.Put
//     description: >
//       ...
// </code></pre>
// Documentation is provided in markdown syntax. In addition to
// standard markdown features, definition lists, tables and fenced
// code blocks are supported. Section headers can be provided and are
// interpreted relative to the section nesting of the context where
// a documentation fragment is embedded.
//
// Documentation from the IDL is merged with documentation defined
// via the config at normalization time, where documentation provided
// by config rules overrides IDL provided.
//
// A number of constructs specific to the API platform are supported
// in documentation text.
//
// In order to reference a proto element, the following
// notation can be used:
// <pre><code>&#91;fully.qualified.proto.name]&#91;]</code></pre>
// To override the display text used for the link, this can be used:
// <pre><code>&#91;display text]&#91;fully.qualified.proto.name]</code></pre>
// Text can be excluded from doc using the following notation:
// <pre><code>&#40;-- internal comment --&#41;</code></pre>
// Comments can be made conditional using a visibility label. The below
// text will be only rendered if the `BETA` label is available:
// <pre><code>&#40;--BETA: comment for BETA users --&#41;</code></pre>
// A few directives are available in documentation. Note that
// directives must appear on a single line to be properly
// identified. The `include` directive includes a markdown file from
// an external source:
// <pre><code>&#40;== include path/to/file ==&#41;</code></pre>
// The `resource_for` directive marks a message to be the resource of
// a collection in REST view. If it is not specified, tools attempt
// to infer the resource from the operations in a collection:
// <pre><code>&#40;== resource_for v1.shelves.books ==&#41;</code></pre>
// The directive `suppress_warning` does not directly affect documentation
// and is documented together with service config validation.
type Documentation struct {
	// A short summary of what the service does. Can only be provided by
	// plain text.
	Summary string `protobuf:"bytes,1,opt,name=summary" json:"summary,omitempty"`
	// The top level pages for the documentation set.
	Pages []*Page `protobuf:"bytes,5,rep,name=pages" json:"pages,omitempty"`
	// A list of documentation rules that apply to individual API elements.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules []*DocumentationRule `protobuf:"bytes,3,rep,name=rules" json:"rules,omitempty"`
	// The URL to the root of documentation.
	DocumentationRootUrl string `protobuf:"bytes,4,opt,name=documentation_root_url,json=documentationRootUrl" json:"documentation_root_url,omitempty"`
	// Declares a single overview page. For example:
	// <pre><code>documentation:
	//   summary: ...
	//   overview: &#40;== include overview.md ==&#41;
	// </code></pre>
	// This is a shortcut for the following declaration (using pages style):
	// <pre><code>documentation:
	//   summary: ...
	//   pages:
	//   - name: Overview
	//     content: &#40;== include overview.md ==&#41;
	// </code></pre>
	// Note: you cannot specify both `overview` field and `pages` field.
	Overview string `protobuf:"bytes,2,opt,name=overview" json:"overview,omitempty"`
}

func (m *Documentation) Reset()                    { *m = Documentation{} }
func (m *Documentation) String() string            { return proto.CompactTextString(m) }
func (*Documentation) ProtoMessage()               {}
func (*Documentation) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *Documentation) GetPages() []*Page {
	if m != nil {
		return m.Pages
	}
	return nil
}

func (m *Documentation) GetRules() []*DocumentationRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A documentation rule provides information about individual API elements.
type DocumentationRule struct {
	// The selector is a comma-separated list of patterns. Each pattern is a
	// qualified name of the element which may end in "*", indicating a wildcard.
	// Wildcards are only allowed at the end and for a whole component of the
	// qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". To
	// specify a default for all applicable elements, the whole pattern "*"
	// is used.
	Selector string `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// Description of the selected API(s).
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Deprecation description of the selected element(s). It can be provided if an
	// element is marked as `deprecated`.
	DeprecationDescription string `protobuf:"bytes,3,opt,name=deprecation_description,json=deprecationDescription" json:"deprecation_description,omitempty"`
}

func (m *DocumentationRule) Reset()                    { *m = DocumentationRule{} }
func (m *DocumentationRule) String() string            { return proto.CompactTextString(m) }
func (*DocumentationRule) ProtoMessage()               {}
func (*DocumentationRule) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

// Represents a documentation page. A page can contain subpages to represent
// nested documentation set structure.
type Page struct {
	// The name of the page. It will be used as an identity of the page to
	// generate URI of the page, text of the link to this page in navigation,
	// etc. The full page name (start from the root page name to this page
	// concatenated with `.`) can be used as reference to the page in your
	// documentation. For example:
	// <pre><code>pages:
	// - name: Tutorial
	//   content: &#40;== include tutorial.md ==&#41;
	//   subpages:
	//   - name: Java
	//     content: &#40;== include tutorial_java.md ==&#41;
	// </code></pre>
	// You can reference `Java` page using Markdown reference link syntax:
	// `[Java][Tutorial.Java]`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The Markdown content of the page. You can use <code>&#40;== include {path} ==&#41;</code>
	// to include content from a Markdown file.
	Content string `protobuf:"bytes,2,opt,name=content" json:"content,omitempty"`
	// Subpages of this page. The order of subpages specified here will be
	// honored in the generated docset.
	Subpages []*Page `protobuf:"bytes,3,rep,name=subpages" json:"subpages,omitempty"`
}

func (m *Page) Reset()                    { *m = Page{} }
func (m *Page) String() string            { return proto.CompactTextString(m) }
func (*Page) ProtoMessage()               {}
func (*Page) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{2} }

func (m *Page) GetSubpages() []*Page {
	if m != nil {
		return m.Subpages
	}
	return nil
}

func init() {
	proto.RegisterType((*Documentation)(nil), "google.api.Documentation")
	proto.RegisterType((*DocumentationRule)(nil), "google.api.DocumentationRule")
	proto.RegisterType((*Page)(nil), "google.api.Page")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/documentation.proto", fileDescriptor7)
}

var fileDescriptor7 = []byte{
	// 346 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x74, 0x92, 0xd1, 0x4a, 0xeb, 0x40,
	0x10, 0x86, 0x49, 0x93, 0x9e, 0xd3, 0x33, 0xe5, 0x1c, 0x8e, 0x8b, 0xd4, 0x20, 0x08, 0xa5, 0x17,
	0xd2, 0x0b, 0x4d, 0xc0, 0x0a, 0x5e, 0x5b, 0x0a, 0x22, 0xde, 0x84, 0x80, 0xd7, 0x65, 0xbb, 0x1d,
	0x97, 0x40, 0xb2, 0x13, 0x76, 0x37, 0x15, 0x5f, 0xc1, 0xc7, 0xf0, 0xa9, 0x7c, 0x1c, 0xc9, 0x26,
	0x6d, 0x13, 0xc4, 0xbb, 0x4c, 0xfe, 0x6f, 0xe6, 0x9f, 0xf9, 0x13, 0x78, 0x92, 0x44, 0x32, 0xc7,
	0x48, 0x52, 0xce, 0x95, 0x8c, 0x48, 0xcb, 0x58, 0xa2, 0x2a, 0x35, 0x59, 0x8a, 0x1b, 0x89, 0x97,
	0x99, 0x89, 0x79, 0x99, 0xc5, 0x06, 0xf5, 0x2e, 0x13, 0x28, 0x48, 0xbd, 0x64, 0x32, 0xde, 0x92,
	0xa8, 0x0a, 0x54, 0x96, 0xdb, 0x8c, 0x54, 0xe4, 0x1a, 0x18, 0xb4, 0xc3, 0x78, 0x99, 0xcd, 0x3e,
	0x3d, 0xf8, 0xbb, 0xea, 0x32, 0x2c, 0x84, 0xdf, 0xa6, 0x2a, 0x0a, 0xae, 0xdf, 0x42, 0x6f, 0xea,
	0xcd, 0xff, 0xa4, 0xfb, 0x92, 0x5d, 0xc2, 0xb0, 0xe4, 0x12, 0x4d, 0x38, 0x9c, 0xfa, 0xf3, 0xf1,
	0xcd, 0xff, 0xe8, 0x38, 0x27, 0x4a, 0xb8, 0xc4, 0xb4, 0x91, 0xd9, 0x02, 0x86, 0xba, 0xca, 0xd1,
	0x84, 0xbe, 0xe3, 0x2e, 0xba, 0x5c, 0xcf, 0x2b, 0xad, 0x72, 0x4c, 0x1b, 0x96, 0xdd, 0xc2, 0xa4,
	0xb7, 0xeb, 0x5a, 0x13, 0xd9, 0x75, 0xa5, 0xf3, 0x30, 0x70, 0x5b, 0x9c, 0xf6, 0xd4, 0x94, 0xc8,
	0x3e, 0xeb, 0x9c, 0x9d, 0xc3, 0x88, 0x76, 0xf5, 0xc1, 0xf8, 0x1a, 0x0e, 0x1c, 0x77, 0xa8, 0x67,
	0xef, 0x1e, 0x9c, 0x7c, 0xb3, 0xab, 0x3b, 0x0c, 0xe6, 0x28, 0x2c, 0xe9, 0xf6, 0xbe, 0x43, 0xcd,
	0xa6, 0x30, 0xde, 0xa2, 0x11, 0x3a, 0x2b, 0x6b, 0xbc, 0x1d, 0xd8, 0x7d, 0xc5, 0xee, 0xe0, 0x6c,
	0x8b, 0xa5, 0x46, 0xd1, 0xec, 0xd8, 0xa5, 0x7d, 0x47, 0x4f, 0x3a, 0xf2, 0xea, 0xa8, 0xce, 0x36,
	0x10, 0xd4, 0x11, 0x31, 0x06, 0x81, 0xe2, 0x05, 0xb6, 0xd6, 0xee, 0xb9, 0x4e, 0x5c, 0x90, 0xb2,
	0xa8, 0x6c, 0x6b, 0xb9, 0x2f, 0xd9, 0x15, 0x8c, 0x4c, 0xb5, 0x69, 0x42, 0xf7, 0x7f, 0x08, 0xfd,
	0x40, 0x2c, 0xaf, 0xe1, 0x9f, 0xa0, 0xa2, 0x03, 0x2c, 0x59, 0xef, 0xfe, 0xa4, 0xfe, 0xfa, 0x89,
	0xf7, 0x31, 0x08, 0x1e, 0xee, 0x93, 0xc7, 0xcd, 0x2f, 0xf7, 0x37, 0x2c, 0xbe, 0x02, 0x00, 0x00,
	0xff, 0xff, 0x62, 0xd9, 0x85, 0x51, 0x5c, 0x02, 0x00, 0x00,
}
