{
  Gestion LinEx FacturLinEx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit Imprimir;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Spin, lr_e_pdf, LR_DBSet, LR_Class, ZConnection,
  ZDataset, LCLType, Process;

type

  { TFImpresion }

  TFImpresion = class(TForm)
    btOk1: TBitBtn;
    btSalir: TBitBtn;
    cbEsCopia: TCheckBox;
    cbDuplicado: TCheckBox;
    cbPVP: TCheckBox;
    cbprecio: TCheckBox;
    CheckBox1: TCheckBox;
    cbObservaciones: TCheckBox;
    CheckBoxAnexos: TCheckBox;

    dbCabecera: TZQuery;
    dbConect: TZConnection;
    dbDatosCliente: TZQuery;
    dbQueryAnexos: TZQuery;
    dbImprimir: TZQuery;
    dbDetalles: TZQuery;
    dbTemporal: TZQuery;
    Edit1: TEdit;

    frDBDataSet: TfrDBDataSet;
    frReport: TfrReport;
    frTNPDFExport: TfrTNPDFExport;
    Label1: TLabel;
    lbCopias: TLabel;
    pnCabecera: TPanel;
    Panel10: TPanel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    SpinEdit1: TSpinEdit;

    procedure btOk1Click(Sender: TObject);
    procedure btSalirClick(Sender: TObject);
    procedure cbDuplicadoChange(Sender: TObject);
    procedure cbEsCopiaChange(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure frReportBeginDoc;
    procedure frReportBeginPage(pgNo: Integer);
    procedure frReportEndPage(pgNo: Integer);

    procedure Imprime(dbMuestrad: TZQuery; dbMuestrac: TZQuery; dbCliente: TZQuery;
                   TipoDocumento: String; directo: boolean);
    procedure Imprime(TxtInforme: String; Informe: String; Titulo: String);
    procedure GeneraImpresion();
    procedure ImpDocumento();

    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);

    procedure CalculaIvas();

    procedure RadioGroup2Click(Sender: TObject);
    procedure VerRecargo();
    procedure frReportGetValue(const ParName: String; var ParValue: Variant);
    procedure frReportEnterRect(Memo: TStringList; View: TfrView);

    procedure ImpreTicket(dbMuestrad: TZQuery; dbMuestrac: TZQuery; dbCliente: TZQuery; TipoDocumento: String);
    procedure CabeceraTicket();
    procedure PieTicket();
    procedure EsVentas;
    procedure TipoImpreso();

    procedure BuscarAnexos();
    function GeneraKeyDelNodo():string;


  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FImpresion: TFImpresion;
  BASE1,BASE2,BASE3,IMPOIVA1,IMPOIVA2,IMPOIVA3,TOTAL1,TOTAL2,TOTAL3: Double;
  IRIVA1,IRIVA2,IRIVA3,RECARGO: Double;
  PIVA1,PIVA2,PIVA3,PRIVA1,PRIVA2,PRIVA3:Double;
  Documento: String;
  DirectorioReport: String;
  Impreso: String;
  NombrePDF: String;
  TituloInforme: String;
  PrintText: TextFile;
  Impresiondirecta: boolean;
  nPagina: integer;                      //  Contador de páginas.
  SubTotalPagina, TotalPagina: Double;    // Variables para subtotales en report
  camposKey: integer;                    // Número de campos clave de la tabla
implementation

uses
  Global, Funciones;


{ TFImpresion }

procedure TFImpresion.Imprime(dbMuestrad: TZQuery; dbMuestrac: TZQuery; dbCliente: TZQuery;
                   TipoDocumento: String; directo: boolean);
begin
  with TFImpresion.Create(Application) do
    begin
       ImpresionDirecta:= directo;
       dbDatosCliente:= dbCliente;
       dbCabecera:= dbMuestrac;
       dbDetalles:= dbMuestrad;
       Documento:=TipoDocumento;
       if copy(TipoDocumento,1,1)='V' then begin EsVentas; Exit; end;
       if DirectoryExists(RutaPdf) then
              NombrePDF:= RutaPdf+'/'+copy(Documento,1,3)+'-'+dbCabecera.Fields[2].AsString
                        +'-'+dbCabecera.Fields[3].AsString+'.pdf' else
              NombrePDF:= RutaIni+copy(Documento,1,3)+'-'+dbCabecera.Fields[2].AsString
                        +'-'+dbCabecera.Fields[3].AsString+'.pdf';
       Caption:='Imprimiendo '+Documento;
       spinEdit1.Value:= dbDatosCliente.FieldByName('C8').AsInteger;
       if spinEdit1.Value=0 then spinEdit1.Value:=1;

       if (directo=true) then
         begin
             ImpDocumento();
             TipoImpreso();
             GeneraImpresion();
             Close();
             exit;
         end;
       //Si el módulo AsistenteParaAnexos está instalado,
       //activa el CheckBox para buscar posibles anexos
       if (AsistenteAnexos='S') then
         begin
           CheckBoxAnexos.Visible:=True;
           CheckBoxAnexos.Checked:=True;
         end;
       ShowModal;
    end;
end;

procedure TFImpresion.Imprime(TxtInforme: String; Informe: String; Titulo: String);
begin
    with TFImpresion.Create(Application) do
    begin
       dbDetalles.Active:=False;
       dbDetalles.SQL.Text:= TxtInforme;
       dbDetalles.Active:=True;
       TituloInforme:= Titulo;
       Documento:=Informe;
       Impreso:=DirectorioReport+Informe+'.lrf';
       if DirectoryExists(RutaPdf) then
              NombrePDF:= RutaPdf+'/'+'Informe-'+FormatDateTime('yyyymmdd',now)+'.pdf' else
              NombrePDF:= RutaIni+'Informe-'+FormatDateTime('yyyymmdd',now)+'.pdf';
       Caption:='Imprimiendo informe';
       spinEdit1.Value:=1;
       RadioGroup1.Enabled:=False;
       CheckBox1.Enabled:=False;
       cbObservaciones.Enabled:=False;
       cbPVP.Enabled:=False;
       cbPrecio.Enabled:=False;
       ShowModal;
    end;
end;

procedure TFImpresion.btOk1Click(Sender: TObject);
begin
   if self.Caption='Imprimiendo informe' then
     begin
       frDBDataSet.DataSet:=dbDetalles;
       GeneraImpresion();
     end else
     begin
      ImpDocumento();
      TipoImpreso();
      GeneraImpresion();
     end;
      // Imprime Facturas/albaranes
end;


procedure TFImpresion.ImpDocumento();    // Imprime Documentos
var
  TxtQ: String;
  tablad:String;
begin

  tablad:='factud'; camposKey:=4;
  if Documento = 'ALBARAN' then begin tablad:= 'albad'; camposKey:=4; end;
  if Documento = 'PRESUPUESTO' then begin tablad:='presud'; camposKey:=4; end;
  if Documento = 'PROFORMA' then begin tablad:='proford'; camposKey:=4; end;
  if Documento = 'ALBARAN(H)' then begin tablad:='hisalbad'; camposKey:=4; end;


  dbImprimir.Active:=False;
  TxtQ:='DELETE FROM imptmp';                       // Borra todos los registros del temporal.
  dbImprimir.SQL.Text:=TxtQ; dbImprimir.ExecSQL;

  TxtQ:='INSERT INTO imptmp SELECT '+tablad+Tienda+'.*, MID(A17,1,300) as ANotas, A0 FROM '+tablad+Tienda+', artitien'+Tienda+' WHERE '+ dbDetalles.Fields[0].FieldName+'='+dbCabecera.Fields[0].AsString+
        ' AND '+dbDetalles.Fields[2].FieldName+'="'+dbCabecera.Fields[2].AsString+'"'+
        ' AND '+dbDetalles.Fields[3].FieldName+'='+dbCabecera.Fields[3].AsString+
        ' AND '+dbDetalles.Fields[5].FieldName+'=A0' ;
  dbImprimir.SQL.Text:=TxtQ; dbImprimir.ExecSQL;
  dbImprimir.Active:=False; dbImprimir.SQL.Text:= 'SELECT * FROM imptmp'; dbImprimir.Active:=True;

  frDBDataSet.DataSet:=dbImprimir;

  IMPOIVA1:=0; BASE1:=0; TOTAL1:=0; IRIVA1:=0; PIVA1:=0; PRIVA1:=0;
  IMPOIVA2:=0; BASE2:=0; TOTAL2:=0; IRIVA2:=0; PIVA2:=0; PRIVA2:=0;
  IMPOIVA3:=0; BASE3:=0; TOTAL3:=0; IRIVA3:=0; PIVA3:=0; PRIVA3:=0;

    //--------------- Sacar distintos ivas ------------------
  TxtQ:='SELECT DISTINCT(IMP12), (SUM(IMP13-IMP11)) As Ivas, '+
        'SUM(IMP11) As Bases, SUM(IMP13) As Totales, '+
        'SUM(IMP10) As Dtos, (((SUM(IMP11)*SUM(IMP10)) / 100)) As ImpoDtos FROM imptmp '+
        ' WHERE IMP0='+dbCabecera.Fields[0].AsString+
        ' AND IMP1="'+FormatDateTime('yyyy/mm/dd',dbCabecera.Fields[1].asDateTime)+'"'+
        ' AND IMP2="'+dbCabecera.Fields[2].AsString+'"'+
        ' AND IMP3='+dbCabecera.Fields[3].AsString+' GROUP BY IMP12 ORDER BY IMP12 ASC';
  dbTemporal.Active:=False; dbTemporal.Sql.Text:=TxtQ; dbTemporal.Active:=True;

  CalculaIvas();

  //  Impuestos incluidos
  if RadioGroup1.ItemIndex=1 then
      begin
         dbImprimir.First;
         while not dbImprimir.eof do
         begin
            dbImprimir.Edit;
            if (dbImprimir.FieldByName('IMP7').Value <> 0) then dbImprimir.FieldByName('IMP9').Value:= FormatFloat('0.000',dbImprimir.FieldByName('IMP13').Value / dbImprimir.FieldByName('IMP7').Value);
            dbImprimir.FieldByName('IMP10').Value:= 0;
            dbImprimir.FieldByName('IMP11').Value:= dbImprimir.FieldByName('IMP13').Value;
            dbImprimir.FieldByName('IMP12').Value:= 0;
            dbImprimir.FieldByName('IMP8').Value := 0;
            dbImprimir.Post;
            dbImprimir.Next;
          end;
          BASE1:=TOTAL1; PIVA1:=0; IMPOIVA1:=0; PRIVA1:=0; IRIVA1:=0;
          BASE2:=TOTAL2; PIVA2:=0; IMPOIVA2:=0; PRIVA2:=0; IRIVA2:=0;
          BASE3:=TOTAL3; PIVA3:=0; IMPOIVA3:=0; PRIVA3:=0; IRIVA3:=0;
      end;

  //  Sólo PVP
  if RadioGroup1.ItemIndex=2 then
      begin
         dbImprimir.First;
         while not dbImprimir.eof do
         begin
            dbImprimir.Edit;
            dbImprimir.FieldByName('IMP9').Value:= dbImprimir.FieldByName('IMP17').Value;
            dbImprimir.FieldByName('IMP10').Value:= 0;
            dbImprimir.FieldByName('IMP11').Value:= FormatFloat('0.000',dbImprimir.FieldByName('IMP9').Value * dbImprimir.FieldByName('IMP7').Value);
            dbImprimir.FieldByName('IMP13').Value:= dbImprimir.FieldByName('IMP11').Value;
            //------ El orden debe ser este, no tocar
            dbImprimir.FieldByName('IMP8').Value:= 0;
            dbImprimir.FieldByName('IMP12').Value:= 0;
            dbImprimir.Post;
            dbImprimir.Next;
          end;
          IMPOIVA1:=0; BASE1:=0; TOTAL1:=0; IRIVA1:=0; PIVA1:=0; PRIVA1:=0;
          IMPOIVA2:=0; BASE2:=0; TOTAL2:=0; IRIVA2:=0; PIVA2:=0; PRIVA2:=0;
          IMPOIVA3:=0; BASE3:=0; TOTAL3:=0; IRIVA3:=0; PIVA3:=0; PRIVA3:=0;

          //--------------- Sacar distintos ivas ------------------
         TxtQ:='SELECT DISTINCT(IMP12), (SUM(IMP13-IMP11)) As Ivas, '+
         'SUM(IMP11) As Bases, SUM(IMP13) As Totales, '+
         'SUM(IMP10) As Dtos, (((SUM(IMP11)*SUM(IMP10)) / 100)) As ImpoDtos FROM imptmp '+
         ' WHERE IMP0='+dbCabecera.Fields[0].AsString+
         ' AND IMP1="'+FormatDateTime('yyyy/mm/dd',dbCabecera.Fields[1].asDateTime)+'"'+
         ' AND IMP2="'+dbCabecera.Fields[2].AsString+'"'+
         ' AND IMP3='+dbCabecera.Fields[3].AsString+' GROUP BY IMP12 ORDER BY IMP12 ASC';
         dbTemporal.Active:=False; dbTemporal.Sql.Text:=TxtQ; dbTemporal.Active:=True;

         CalculaIvas();

         dbImprimir.First;
         while not dbImprimir.eof do
         begin
            dbImprimir.Edit;
            dbImprimir.FieldByName('IMP12').Value:= 0;
            dbImprimir.FieldByName('IMP8').Value:= 0;
            dbImprimir.Post;
            dbImprimir.Next;
          end;

          BASE1:=TOTAL1; PIVA1:=0; IMPOIVA1:=0; PRIVA1:=0; IRIVA1:=0;
          BASE2:=TOTAL2; PIVA2:=0; IMPOIVA2:=0; PRIVA2:=0; IRIVA2:=0;
          BASE3:=TOTAL3; PIVA3:=0; IMPOIVA3:=0; PRIVA3:=0; IRIVA3:=0;

      end;

  //  Sin valorar.
  if RadioGroup1.ItemIndex=3 then
      begin
         dbImprimir.First;
         while not dbImprimir.eof do
         begin
            dbImprimir.Edit;
            dbImprimir.FieldByName('IMP8').Value:= 0;
            dbImprimir.FieldByName('IMP9').Value:= 0;
            dbImprimir.FieldByName('IMP10').Value:= 0;
            dbImprimir.FieldByName('IMP11').Value:= 0;
            dbImprimir.FieldByName('IMP12').Value:= 0;
            dbImprimir.FieldByName('IMP13').Value:= 0;
            dbImprimir.FieldByName('IMP17').Value:= 0;
            dbImprimir.Post;
            dbImprimir.Next;
          end;
          BASE1:=0; PIVA1:=0; IMPOIVA1:=0; PRIVA1:=0; IRIVA1:=0; TOTAL1:=0;
          BASE2:=0; PIVA2:=0; IMPOIVA2:=0; PRIVA2:=0; IRIVA2:=0; TOTAL2:=0;
          BASE3:=0; PIVA3:=0; IMPOIVA3:=0; PRIVA3:=0; IRIVA3:=0; TOTAL3:=0;
      end;

  // Anulamos las columnas de PVP o precio si el checkbox está desactivado.

    if cbprecio.Checked=False then
      begin
        dbImprimir.First;
        while not dbImprimir.eof do
         begin
           dbImprimir.Edit;
           dbImprimir.FieldByName('IMP9').Value:= 0;      //---- precio sin iva
           dbImprimir.FieldByName('IMP11').Value:= 0;     //---- total sin iva
           dbImprimir.Post;
           dbImprimir.Next;
         end;
      end;

    if cbPVP.Checked=False then
      begin
        dbImprimir.First;
        while not dbImprimir.eof do
         begin
           dbImprimir.Edit;
           dbImprimir.FieldByName('IMP8').Value:= 0;      //---- precio con iva
           dbImprimir.Post;
           dbImprimir.Next;
         end;
      end;

end;

Procedure TFImpresion.cbDuplicadoChange(Sender: TObject);
begin
  if (cbDuplicado.Checked=true) then cbEsCopia.Checked:=False;
end;

procedure TFImpresion.cbEsCopiaChange(Sender: TObject);
begin
  if (cbEsCopia.Checked=true) then cbDuplicado.Checked:=False;
end;

//==================== Definimos el report a utilizar ===================
procedure TFImpresion.TipoImpreso();
var
  TImpreso: String;
  ObservacionesArticulos: string;
begin

  if Documento<>'FACTURA' then DirectorioReport:= DirectorioReport+'Documento'
                           else DirectorioReport:= DirectorioReport+'Factura';

  if (cbObservaciones.Checked=true) then ObservacionesArticulos:='2' else
                                         ObservacionesArticulos:='';
  if (CheckBox1.Checked=True) then TImpreso:='P' else TImpreso:='';

  Impreso:= DirectorioReport + ObservacionesArticulos + TImpreso + '.lrf';

end;


procedure TFImpresion.GeneraImpresion();
begin

  frReport.LoadFromFile(Impreso);

  if RadioGroup2.ItemIndex=0 then frReport.ShowReport;

  if RadioGroup2.ItemIndex=1 then
      begin
        frReport.PrepareReport;
        frReport.PrintPreparedReport('',SpinEdit1.Value);
      end;

  if RadioGroup2.ItemIndex=2 then
      begin
        frReport.PrepareReport;

        if FileExists(NombrePDF) then
           if Application.MessageBox(' Ya existe un archivo con ese nombre,' +
             #13 + ' Desea reemplazarlo ?', 'FacturLinEx',
             MB_ICONQUESTION + MB_YESNO) = idYes then DeleteFile(NombrePDF);
             ;

        frReport.ExportTo(TFrTNPDFExportFilter, NombrePDF);
  //       AProcess := TProcess.Create(nil);
  //       AProcess.CommandLine := VisorPdf+' '+RutaPdf+'\Albaran.pdf';
  //       AProcess.Execute;
  //       AProcess.Destroy;
      end;
  BuscarAnexos();
  btSalirClick(self);

end;
//================= BUSCAR DOCUMENTOS ANEXOS ===============
// Si NO está instalado el Asistente para Anexos, el checkBoxAnexos debe estar
// Visible:=False y Checked:=False. En la instalación del asistente estos
// valores guardados en el config.ini pasan a TRUE

procedure TFImpresion.BuscarAnexos();
var
  TxtQuery: string;
  Orden: string;
begin
  if CheckBoxAnexos.Checked then
    begin
      TxtQuery:='SELECT * FROM docuanexos WHERE claveNodo="'+ GeneraKeyDelNodo()+'";';
      dbQueryAnexos.Active:=False; dbQueryAnexos.SQL.Text:=TxtQuery; dbQueryAnexos.Active:=True;
      if dbQueryAnexos.RecordCount<>0 then
        begin
          while not dbQueryAnexos.EOF do
          begin
          AProcess := TProcess.Create(nil);
          Orden:= AbrirAchivo+' '+ dbQueryAnexos.FieldByName('rutaDoc').AsString;
          //showmessage(orden);
          try
            AProcess.CommandLine := Orden;
            AProcess.Execute;
          except
            showmessage('No se pudo abrir el archivo '+ dbQueryAnexos.FieldByName('rutaDoc').AsString);
            showmessage('NO EXISTE EL FICHERO O LA ORDEN PARA ABRIR ARCHIVOS NO ES CORRECTA'+ #13 +
                         '   COMPRUEBE LA ORDEN EN LA CONFIGURACIÓN DE FACTURLINEX2');
            exit;
          end;

          AProcess.Destroy;

          dbQueryAnexos.Next;
          end;
        end;
    end;
end;
//============== GENERA CLAVE DEL NODO =====================
function TFImpresion.GeneraKeyDelNodo():string;
var
  cadena: string;
  cont: integer;
begin
  cadena:='';
  cont:=0;
  while cont < camposKey-1 do
    begin
      cadena:=cadena+dbCabecera.Fields[cont].AsString+'|-|';
      cont:=cont+1;
    end;
  cadena:=cadena+dbCabecera.Fields[cont].AsString;
  //showmessage(cadena);
  Result:=cadena;
end;
//================= PASAR PARAMETROS AL REPORT ===============
procedure TFImpresion.frReportGetValue(const ParName: String;
  var ParValue: Variant);
begin
  if ParName ='EMPRESA' then ParValue := Empresa;
  if ParName='DIRECCION' then ParValue := Direccion;
  if ParName='LOCALIDAD' then ParValue := Localidad;
  if ParName='PROVINCIA' then ParValue := Provincia;
  if ParName='NIF' then ParValue := Nif;
  if ParName='TELEFONO' then ParValue := Telefono;
  if ParName='FAX' then ParValue := Fax;
  if ParName='EMAIL' then ParValue := eMail;
  if ParName='CP' then ParValue := CP;
  if ParName='REGISTRO' then ParValue := REGISTRO;

  if ParName='CCODIGO' then ParValue := dbDatosCliente.FieldByName('C0').AsString;
  if ParName='CCLIENTE' then ParValue := dbDatosCliente.FieldByName('C1').AsString;
  if ParName='CDIRECCION' then ParValue := dbDatosCliente.FieldByName('C3').AsString;
  if ParName='CLOCALIDAD' then ParValue := dbDatosCliente.FieldByName('C4').AsString;
  if ParName='CCIF' then ParValue := dbDatosCliente.FieldByName('C5').AsString;
  if ParName='CCP' then ParValue := dbDatosCliente.FieldByName('C37').AsString;
  if ParName='CPROVINCIA' then ParValue := dbDatosCliente.FieldByName('C38').AsString;

  if ParName='DOCUMENTO' then ParValue := Documento;
  if ParName='FECHA' then ParValue := dbCabecera.Fields[1].AsString;
  if ParName='SERIE' then ParValue := dbCabecera.Fields[2].AsString;
  if ParName='NUMERO' then ParValue := dbCabecera.Fields[3].AsString;

  if nPagina = frReport.EMFPages.Count then
  begin
    if ParName='BASE1' then if BASE1<>0 then ParValue:=FormatFloat('0.000',BASE1) else ParValue:='';
    if ParName='PIVA1' then if PIVA1<>0 then ParValue:=FormatFloat('0',PIVA1) else ParValue:='';
    if ParName='IMPOIVA1' then if IMPOIVA1<>0 then ParValue:=FormatFloat('0.000',IMPOIVA1) else  ParValue:='';
    if ParName='TOTAL1' then if TOTAL1<>0 then ParValue := FormatFloat('0.00',TOTAL1) else  ParValue:='';
    if ParName='PRIVA1' then if PRIVA1<>0 then ParValue := FormatFloat('0',PRIVA1) else  ParValue:='';
    if ParName='IRIVA1' then if IRIVA1<>0 then ParValue := FormatFloat('0.00',IRIVA1) else  ParValue:='';

    if ParName='BASE2' then if BASE2<>0 then ParValue:=FormatFloat('0.000',BASE2) else ParValue:='';
    if ParName='PIVA2' then if PIVA2<>0 then ParValue:=FormatFloat('0',PIVA2) else ParValue:='';
    if ParName='IMPOIVA2' then if IMPOIVA2<>0 then ParValue:=FormatFloat('0.000',IMPOIVA2) else  ParValue:='';
    if ParName='TOTAL2' then if TOTAL2<>0 then ParValue := FormatFloat('0.00',TOTAL2) else  ParValue:='';
    if ParName='PRIVA2' then if PRIVA2<>0 then ParValue := FormatFloat('0',PRIVA2) else  ParValue:='';
    if ParName='IRIVA2' then if IRIVA2<>0 then ParValue := FormatFloat('0.00',IRIVA2) else  ParValue:='';

    if ParName='BASE3' then if BASE3<>0 then ParValue:=FormatFloat('0.000',BASE3) else ParValue:='';
    if ParName='PIVA3' then if PIVA3<>0 then ParValue:=FormatFloat('0',PIVA3) else ParValue:='';
    if ParName='IMPOIVA3' then if IMPOIVA3<>0 then ParValue:=FormatFloat('0.000',IMPOIVA3) else  ParValue:='';
    if ParName='TOTAL3' then if TOTAL3<>0 then ParValue := FormatFloat('0.00',TOTAL3) else  ParValue:='';
    if ParName='PRIVA3' then if PRIVA3<>0 then ParValue := FormatFloat('0',PRIVA3) else  ParValue:='';
    if ParName='IRIVA3' then if IRIVA3<>0 then ParValue := FormatFloat('0.00',IRIVA3) else  ParValue:='';
    if ParName='TOTALGENERAL' then if TOTAL1+TOTAL2+TOTAL3<>0 then ParValue := FormatFloat('0.00',TOTAL1+TOTAL2+TOTAL3) else  ParValue:='';
    if ParName='OBSERVACIONES' then
    if Documento<>'FACTURA' then ParValue := dbCabecera.Fields[11].AsString else
                                  ParValue := dbCabecera.Fields[19].AsString;

    if ParName='FECHAV1' then ParValue:=dbCabecera.Fields[11].AsString;
    if ParName='IMPOV1' then if dbCabecera.Fields[12].AsString<>'0' then ParValue:=dbCabecera.Fields[12].AsString else ParValue:='';
    if ParName='FECHAV2' then ParValue:=dbCabecera.Fields[13].AsString;
    if ParName='IMPOV2' then if dbCabecera.Fields[14].AsString<>'0' then ParValue:=dbCabecera.Fields[14].AsString else ParValue:='';
    if ParName='FECHAV3' then ParValue:=dbCabecera.Fields[15].AsString;
    if ParName='IMPOV3' then if dbCabecera.Fields[16].AsString<>'0' then ParValue:=dbCabecera.Fields[16].AsString else ParValue:='';
    if ParName='FECHAV4' then ParValue:=dbCabecera.Fields[17].AsString;
    if ParName='IMPOV4' then if dbCabecera.Fields[18].AsString<>'0' then ParValue:=dbCabecera.Fields[18].AsString else ParValue:='';
  end else
  begin
    if ParName='BASE1' then ParValue:='';
    if ParName='PIVA1' then ParValue:='';
    if ParName='IMPOIVA1' then ParValue:='';
    if ParName='TOTAL1' then ParValue:='';
    if ParName='PRIVA1' then ParValue:='';
    if ParName='IRIVA1' then ParValue:='';

    if ParName='BASE2' then ParValue:='';
    if ParName='PIVA2' then ParValue:='';
    if ParName='IMPOIVA2' then ParValue:='';
    if ParName='TOTAL2' then ParValue:='';
    if ParName='PRIVA2' then ParValue:='';
    if ParName='IRIVA2' then ParValue:='';

    if ParName='BASE3' then ParValue:='';
    if ParName='PIVA3' then ParValue:='';
    if ParName='IMPOIVA3' then ParValue:='';
    if ParName='TOTAL3' then ParValue:='';
    if ParName='PRIVA3' then ParValue:='';
    if ParName='IRIVA3' then ParValue:='';
    if ParName='TOTALGENERAL' then ParValue:='';
    if ParName='OBSERVACIONES' then ParValue:='';

    if ParName='FECHAV1' then ParValue:='';
    if ParName='IMPOV1' then ParValue:='';
    if ParName='FECHAV2' then ParValue:='';;
    if ParName='IMPOV2' then ParValue:='';
    if ParName='FECHAV3' then ParValue:='';
    if ParName='IMPOV3' then ParValue:='';
    if ParName='FECHAV4' then ParValue:='';
    if ParName='IMPOV4' then ParValue:='';
  end;

  if ParName='TITULO' then ParValue := TituloInforme;

  if ParName = 'SUMAS' then SubTotalPagina := SubTotalPagina + dbImprimir.FieldByName('IMP13').Value;

  if ParName='SUBTOTAL' then ParValue := TotalPagina;

  if ImprimirLOPD='S' then begin
    if ParName='LOPD1' then ParValue := Lopd1;
    if ParName='LOPDEMP' then ParValue := Empresa;
    if ParName='LOPD2' then ParValue := Lopd2;
    if ParName='LOPDDIR' then ParValue := Direccion+', '+CP+' '+Localidad+' ('+Provincia+')';
  end else begin
    if ParName='LOPD1' then ParValue := '';
    if ParName='LOPDEMP' then ParValue := '';
    if ParName='LOPD2' then ParValue := '';
    if ParName='LOPDDIR' then ParValue := '';
  end;

end;


//======================= LOGOTIPO DEL FORMULARIO ========================

procedure TFImpresion.frReportEnterRect(Memo: TStringList; View: TfrView);
var
  vImage: TImage;
  RutaLogo: string;
begin

  {  if assigned( View ) and
     (View.Name = 'Picture1') and
     (View is TfrPictureView)
  then
    try
      vImage := TImage.Create( nil );
      try
         TfrPictureView(View).Picture.Clear;
         TfrPictureView(View).Picture.LoadFromFile(LogoEmpresa);
      finally
        FreeAndNil(vImage);
      end;
    except
      TfrPictureView(View).Picture.Clear;
    end;
}

  RutaLogo:='';
  if assigned( View ) and  (View is TfrPictureView) then
  begin
     if (View.Name = 'Picture1') then RutaLogo:= LogoEmpresa;
     if (View.Name = 'EsCopiaDuplicado') then
       begin
          if (cbEsCopia.Checked) then RutaLogo:=RutaIconos+'EsCopia.png';
          if (cbDuplicado.Checked) then RutaLogo:=RutaIconos+'Duplicado.png';
       end;

     try
        vImage := TImage.Create( nil );
        try
           TfrPictureView(View).Picture.Clear;
           TfrPictureView(View).Picture.LoadFromFile(RutaLogo);
        finally
          FreeAndNil(vImage);
        end;
    except
        TfrPictureView(View).Picture.Clear;
    end;
  end;

end;


//=================== CALCULAR TIPOS DE IVAS ==================
procedure TFImpresion.CalculaIvas();
begin

  // Debe cargarse previamente en dbTemporal la consulta de detalles.

  dbTemporal.First;

  //------------------------ Primer tipo de iva
  if dbTemporal.Eof=False then
   begin
    PIVA1:=dbTemporal.Fields[0].AsInteger;
    IMPOIVA1:=dbTemporal.Fields[1].AsFloat;
    BASE1:=dbTemporal.Fields[2].AsFloat;
    TOTAL1:=dbTemporal.Fields[3].AsFloat;
    //---------------- Recargo
    if dbDatosCliente.FieldByName('C19').AsString='S' then
      begin
       VerRecargo();
       PRIVA1:=RECARGO;
       IRIVA1:=dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
       TOTAL1:=dbTemporal.Fields[3].AsFloat+dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
      end;
   end;
  dbTemporal.Next;
  //------------------------ Segundo tipo de iva
  if dbTemporal.Eof=False then
   begin
    PIVA2:=dbTemporal.Fields[0].AsInteger;
    IMPOIVA2:=dbTemporal.Fields[1].AsFloat;
    BASE2:=dbTemporal.Fields[2].AsFloat;
    TOTAL2:=dbTemporal.Fields[3].AsFloat;
    //---------------- Recargo
    if dbDatosCliente.FieldByName('C19').AsString='S' then
      begin
       VerRecargo();
       PRIVA2:=RECARGO;
       IRIVA2:=dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
       TOTAL2:=dbTemporal.Fields[3].AsFloat+dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
      end;
   end;
  dbTemporal.Next;
  //------------------------ Tercer tipo de iva
  if dbTemporal.Eof=False then
   begin
    PIVA3:=dbTemporal.Fields[0].AsInteger;
    IMPOIVA3:=dbTemporal.Fields[1].AsFloat;
    BASE3:=dbTemporal.Fields[2].AsFloat;
    TOTAL3:=dbTemporal.Fields[3].AsFloat;
    //---------------- Recargo
    if dbDatosCliente.FieldByName('C19').AsString='S' then
      begin
       VerRecargo();
       PRIVA3:=RECARGO;
       IRIVA3:=dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
       TOTAL3:=dbTemporal.Fields[3].AsFloat+dbTemporal.Fields[2].AsFloat-((dbTemporal.Fields[2].AsFloat*100)/(RECARGO+100));
      end;
   end;
end;

procedure TFImpresion.RadioGroup2Click(Sender: TObject);
begin
  if (RadioGroup2.ItemIndex=2) then Edit1.Enabled:= True
                               else Edit1.Enabled:= False;
end;



//================ TIPOS DE RECARGO =====================
procedure TFImpresion.VerRecargo();
begin
   RECARGO:=RIVA1;
   if dbTemporal.Fields[0].AsFloat=IVA1 then RECARGO:=RIVA1;
   if dbTemporal.Fields[0].AsFloat=IVA2 then RECARGO:=RIVA2;
   if dbTemporal.Fields[0].AsFloat=IVA3 then RECARGO:=RIVA3;
end;

procedure TFImpresion.btSalirClick(Sender: TObject);
begin
  Close();
end;

procedure TFImpresion.Edit1Exit(Sender: TObject);
begin
  NombrePDF:= Edit1.Text;
end;

//=========================== Imprimir con Ticket ==================
procedure TFImpresion.ImpreTicket(dbMuestrad: TZQuery; dbMuestrac: TZQuery; dbCliente: TZQuery;
                                 TipoDocumento: String);
var
  Precio, SubTotal: Double;
  Texto: String;
begin
  with TFImpresion.Create(Application) do
    begin
     Documento:= TipoDocumento;
     dbDatosCliente:= dbCliente;
     dbCabecera:= dbMuestrac;
     dbDetalles:= dbMuestrad;

     AssignFile(PrintText, DevTicket); //añadido por javi para quitar opendialog
     Rewrite(PrintText);
     CabeceraTicket();
     dbMuestrad.First;
     while not dbDetalles.Eof do
       begin
         if DesgloIva='S' then
           begin
            Precio:=dbDetalles.Fields[9].AsFloat;
            SubTotal:=dbDetalles.Fields[11].AsFloat;
           end else
           begin
            Precio:=dbDetalles.Fields[8].AsFloat;
            SubTotal:=dbDetalles.Fields[13].AsFloat;
           end;
         Texto:=Copy(dbMuestrad.Fields[6].AsString+'                    ',1,18)+' ';
         Texto:=Texto + DataModule1.LFill(FormatFloat('##0.00',dbDetalles.Fields[7].AsFloat),6,' ') + ' ';
         Texto:=Texto + DataModule1.LFill(FormatFloat('##0.00',Precio),6,' ') + ' ';
         Texto:=Texto + DataModule1.LFill(FormatFloat('###0.00',SubTotal),7,' ');
         Writeln(PrintText, Texto);
         dbDetalles.Next;
       end;
     PieTicket();
     CloseFile(PrintText);
     Close();
    end;
end;

//============== CABECERA DEL TICKET ===================================
procedure TFImpresion.CabeceraTicket();
var
hora: String;
begin
  if Trim(LCTI1)<>'' then Writeln(PrintText, LCTI1);
  if Trim(LCTI2)<>'' then Writeln(PrintText, LCTI2);
  if Trim(LCTI3)<>'' then Writeln(PrintText, LCTI3);
  if Trim(LCTI4)<>'' then Writeln(PrintText, LCTI4);
  hora:='';
  if HoraEnTicket='S' then hora:='   Hora.:'+FormatDateTime('hh:mm:ss',TIME);

  Writeln(PrintText, ' ');

  Writeln(PrintText, 'N.'+Documento+':'+ dbCabecera.Fields[2].AsString+'/'+DataModule1.LFill(FormatFloat('#######',dbCabecera.Fields[3].AsFloat),7,' '));

  Writeln(PrintText, ' ');
  Writeln(PrintText, 'Fecha.: '+FormatDateTime('dd/mm/yyyy',dbCabecera.Fields[1].AsDateTime)+hora);
  Writeln(PrintText, ' ');
  Writeln(PrintText, 'ARTICULO              UND PRECIO   TOTAL');
  Writeln(PrintText, '========================================');
end;

//====================== PIE DEL TICKETC =============================
procedure TFImpresion.PieTicket();
Var
  Impuestos: Double;
  Conta: Integer;
begin
  Writeln(PrintText, ' ');
  Writeln(PrintText, '                               ---------');

  Impuestos:=dbCabecera.Fields[9].AsFloat - dbCabecera.Fields[8].AsFloat;

  if SacaIva='N' then
    begin
      Writeln(PrintText, '                    NETO      '+DataModule1.LFill( FormatFloat('######0.00',dbCabecera.Fields[8].AsFloat),7,' '));
      Writeln(PrintText, '                    IVA       '+DataModule1.LFill( FormatFloat('######0.00',Impuestos),7,' '));
    end;

  Writeln(PrintText, '                    TOTAL     '+DataModule1.LFill( FormatFloat('######0.00',dbCabecera.Fields[9].AsFloat),7,' '));
  Writeln(PrintText, ' ');
  //----------------- Sacar iva uncluido en el ticket o no --------------
  if SacaIva<>'N' then
    begin

     Writeln(PrintText, '            * IVA INCLUIDO *            ');
     Writeln(PrintText, ' ');
    end;

  Writeln(PrintText, 'Cliente: '+dbDatosCliente.FieldByName('C0').AsString);
  Writeln(PrintText, dbDatosCliente.FieldByName('C1').AsString);
  Writeln(PrintText, ' ');



  //----------------- Sacar vendedor en el ticket o no --------------
   if SacaVende<>'N' then Writeln(PrintText, 'LE ATENDIO.: '+ copy(UsuarioActivo,1,35));


  //----------------------------------------------------------------
  if Trim(LPTI1)<>'' then Writeln(PrintText, LPTI1);
  if Trim(LPTI2)<>'' then Writeln(PrintText, LPTI2);
  if Trim(LPTI3)<>'' then Writeln(PrintText, LPTI3);
  for Conta:=1 to StrToInt(LiFinTick) do Writeln(PrintText, ' ');
end;


procedure TFImpresion.EsVentas;
begin
   Delete(Documento,1,1);
   if Documento='ALBARAN'  then
     if CgPrAlbV='S' then  RadioGroup2.ItemIndex:=0           //previsualización.
                     else  RadioGroup2.ItemIndex:=1;           // Imprime.

   if Documento='FACTURA'  then
     if CgPrFraV='S' then  RadioGroup2.ItemIndex:=0           //previsualización.
                     else  RadioGroup2.ItemIndex:=1;           // Imprime.

   btOk1Click(Self);

   Close();

end;

procedure TFImpresion.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key=VK_ESCAPE) then begin key:=0; btSalirClick(self); Exit; End;
  if (key=VK_RETURN) and (btOK1.Enabled=True) then begin key:=0; btOk1Click(self) ; Exit; End;
end;

procedure TFImpresion.FormShow(Sender: TObject);
begin
  Edit1.Text:= NombrePDF;
end;

procedure TFImpresion.frReportBeginDoc;
begin
  nPagina:= 0;              // Inicializamos página.
end;

procedure TFImpresion.frReportBeginPage(pgNo: Integer);
begin
  SubTotalPagina:=0;
end;

procedure TFImpresion.frReportEndPage(pgNo: Integer);
begin
  TotalPagina:= TotalPagina + SubTotalPagina;
  if (frReport.DoublePass) and (not frReport.FinalPass) then Inc(nPagina); // Incrementamos número de página
end;

procedure TFImpresion.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
    CloseAction:=CaFree;
end;

procedure TFImpresion.FormCreate(Sender: TObject);
begin
  Conectate(dbConect);

  if DatosEmpresa='S' then CheckBox1.Checked:=False;

  Edit1.Enabled:=False;
  RadioGroup2.ItemIndex:=1;
  if ImprePrevisu='S' then RadioGroup2.ItemIndex:=0;
  if ImprePDF='S' then begin RadioGroup2.ItemIndex:=2; Edit1.Enabled:= True; end;

  DirectorioReport:=RutaReports;


end;

initialization
  {$I imprimir.lrs}

end.

