# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220903144939;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"494528", "Schönwalde\ am\ Bungsberg",
"492985", "Winterberg\-Niedersfeld",
"494139", "Hohnstorf\ Elbe",
"496340", "Wörth\-Schaidt",
"494403", "Bad\ Zwischenahn",
"494746", "Hagen\ bei\ Bremerhaven",
"495529", "Rhumspringe",
"495138", "Sehnde",
"492166", "Mönchengladbach\-Rheydt",
"498650", "Marktschellenberg",
"49951", "Bamberg",
"498054", "Breitbrunn\ am\ Chiemsee",
"4933452", "Neulewin",
"492304", "Schwerte",
"498142", "Olching",
"497465", "Emmingen\-Liptingen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"495977", "Spelle",
"496734", "Flonheim",
"492667", "Stein\-Neukirch",
"494385", "Hohenfelde\ bei\ Kiel",
"493433", "Borna\ Stadt",
"499238", "Röslau",
"496857", "Namborn",
"4934466", "Janisroda",
"492925", "Warstein\-Allagen",
"496843", "Gersheim",
"492407", "Herzogenrath\-Kohlscheid",
"497151", "Waiblingen",
"492871", "Bocholt",
"4939405", "Hötensleben",
"495373", "Hillerse\ Kreis\ Gifhorn",
"499076", "Wittislingen",
"494269", "Ahausen\-Kirchwalsede",
"4938393", "Binz\ Ostseebad",
"498459", "Manching",
"497761", "Bad\ Säckingen",
"4937607", "Ebersbrunn\ Sachsen",
"498534", "Tettenweis",
"496254", "Lautertal\ Odenwald",
"494663", "Süderlügum",
"492432", "Wassenberg",
"4936427", "Dornburg\ Saale",
"492236", "Wesseling\ Rheinland",
"497570", "Sigmaringen\-Gutenstein",
"4939723", "Krien",
"4939925", "Wredenhagen",
"495278", "Höxter\-Ovenhausen",
"495556", "Lindau\ Harz",
"499937", "Oberpöring",
"496022", "Obernburg\ am\ Main",
"494673", "Joldelund",
"497771", "Stockach",
"495363", "Wolfsburg\-Vorsfelde",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"499178", "Abenberg\ Mittelfranken",
"498341", "Kaufbeuren",
"492861", "Borken\ Westfalen",
"494793", "Hambergen",
"496082", "Niederreifenberg",
"496105", "Mörfelden\-Walldorf",
"496651", "Rasdorf",
"497352", "Ochsenhausen",
"495625", "Naumburg\ Hessen",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4939824", "Hohenzieritz",
"4938371", "Karlshagen",
"497942", "Neuenstein\ Württemberg",
"4933847", "Görzke",
"497475", "Burladingen",
"4934779", "Abberode",
"492677", "Lutzerath",
"496392", "Hauenstein\ Pfalz",
"493838", "Bergen\ auf\ Rügen",
"498282", "Krumbach\ Schwaben",
"4935725", "Wittichenau",
"498426", "Walting\ Kreis\ Eichstätt",
"499333", "Sommerhausen",
"498222", "Burgau\ Schwaben",
"495036", "Neustadt\-Schneeren",
"4936332", "Ellrich",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"4939224", "Büden",
"499549", "Lisberg",
"495685", "Knüllwald",
"4933458", "Falkenberg\ Mark",
"496055", "Freigericht",
"492684", "Puderbach\ Westerwald",
"4935937", "Prischwitz",
"494605", "Medelby",
"494151", "Schwarzenbek",
"499354", "Rieneck",
"4936963", "Dorndorf\ Rhön",
"494829", "Wewelsfleth",
"493635", "Kölleda",
"494294", "Riede\ Kreis\ Verden",
"499944", "Miltach",
"499443", "Abensberg",
"495828", "Himbergen",
"4935876", "Weissenberg\ Sachsen",
"497663", "Eichstetten",
"498735", "Gangkofen\-Kollbach",
"497269", "Sulzfeld\ Baden",
"492624", "Höhr\-Grenzhausen",
"494761", "Bremervörde",
"496173", "Kronberg\ im\ Taunus",
"4935383", "Elster\ Elbe",
"497904", "Ilshofen",
"497139", "Neuenstadt\ am\ Kocher",
"497403", "Dunningen",
"497325", "Sontheim\ an\ der\ Brenz",
"497746", "Wutöschingen",
"495652", "Bad\ Sooden\-Allendorf",
"497528", "Neukirch\ bei\ Tettnang",
"498376", "Sulzberg\ Allgäu",
"4933454", "Wölsickendorf\/Wollenberg",
"497385", "Gomadingen",
"496535", "Osann\-Monzel",
"494465", "Friedeburg\ Ostfriesland",
"498431", "Neuburg\ an\ der\ Donau",
"496338", "Hornbach\ Pfalz",
"495021", "Nienburg\ Weser",
"4939481", "Hedersleben\ bei\ Aschersleben",
"4939822", "Kratzeburg",
"499120", "Leinburg",
"494475", "Molbergen",
"493947", "Thale",
"494942", "Südbrookmerland",
"496747", "Emmelshausen",
"499292", "Konradsreuth",
"494352", "Damp",
"498366", "Oy\-Mittelberg",
"494856", "Kronprinzenkoog",
"498862", "Steingaden\ Oberbayern",
"496639", "Ottrau",
"498104", "Sauerlach",
"4936334", "Wolkramshausen",
"498553", "Spiegelau",
"496233", "Frankenthal\ Pfalz",
"492952", "Rüthen",
"497808", "Hohberg\ bei\ Offenburg",
"4937756", "Breitenbrunn\ Erzgebirge",
"495192", "Munster",
"499180", "Pyrbaum",
"4937435", "Reuth\ bei\ Plauen",
"4939222", "Möser",
"495924", "Bad\ Bentheim\-Gildehaus",
"496163", "Höchst\ im\ Odenwald",
"494771", "Hemmoor",
"494509", "Gross\ Grönau",
"497673", "Schönau\ im\ Schwarzwald",
"4936338", "Bleicherode",
"4939006", "Miesterhorst",
"495508", "Gleichen\-Rittmarshausen",
"498547", "Osterhofen\-Gergweis",
"4938326", "Grimmen",
"499848", "Simmershofen",
"496430", "Hahnstätten",
"495305", "Sickte",
"495423", "Versmold",
"498033", "Oberaudorf",
"495483", "Lienen",
"496753", "Meisenheim",
"4933366", "Chorin",
"4933677", "Glienicke\ bei\ Beeskow",
"4936925", "Marksuhl",
"4936946", "Erbenhausen\ Thüringen",
"498022", "Tegernsee",
"495236", "Blomberg\-Grossenmarpe",
"492268", "Kürten",
"495432", "Löningen",
"494474", "Garrel",
"499637", "Falkenberg\ Oberpfalz",
"494973", "Wittmund\-Burhafe",
"4935209", "Mohorn",
"498105", "Gilching",
"498651", "Bad\ Reichenhall",
"492373", "Menden\ Sauerland",
"499749", "Oberbach\ Unterfranken",
"499602", "Neustadt\ an\ der\ Waldnaab",
"4936840", "Trusetal",
"498082", "Schwindegg",
"496341", "Landau\ in\ der\ Pfalz",
"492597", "Senden\ Westfalen",
"495407", "Wallenhorst",
"4938297", "Moitin",
"495925", "Wietmarschen",
"496282", "Walldürn",
"496486", "Katzenelnbogen",
"498392", "Markt\ Rettenbach",
"497709", "Wutach",
"497571", "Sigmaringen",
"499266", "Mitwitz",
"4933206", "Fichtenwalde",
"497642", "Endingen\ Kaiserstuhl",
"499462", "Falkenstein\ Oberpfalz",
"492977", "Schmallenberg\-Bödefeld",
"4938355", "Züssow",
"493876", "Perleberg",
"495304", "Meine",
"495166", "Walsrode\-Kirchboitzen",
"493372", "Jüterbog",
"496190", "Hattersheim\ am\ Main",
"492529", "Oelde\-Stromberg",
"497150", "Korntal\-Münchingen",
"4934342", "Neukieritzsch",
"496222", "Wiesloch",
"496426", "Fronhausen",
"496650", "Hosenfeld",
"492685", "Flammersfeld",
"496054", "Birstein",
"494604", "Grossenwiehe",
"499831", "Gunzenhausen",
"498340", "Baisweil",
"495068", "Elze\ Leine",
"495176", "Edemissen",
"493362", "Erkner",
"494367", "Grossenbrode",
"493866", "Cambs",
"498857", "Benediktbeuern",
"499355", "Frammersbach",
"494295", "Emtinghausen",
"499945", "Arnbruck",
"495677", "Calden\-Westuffeln",
"4934495", "Dobitschen",
"493634", "Sömmerda",
"499276", "Bischofsgrün",
"498734", "Reisbach\ Niederbayern",
"499472", "Hohenfels\ Oberpfalz",
"496142", "Rüsselsheim",
"492625", "Ochtendung",
"497427", "Schömberg\ bei\ Balingen",
"4935607", "Jänschwalde",
"497561", "Leutkirch\ im\ Allgäu",
"49971", "Bad\ Kissingen",
"498191", "Landsberg\ am\ Lech",
"497905", "Langenburg",
"494546", "Mustin\ Lauenburg",
"497324", "Herbrechtingen",
"495861", "Dannenberg\ Elbe",
"492363", "Datteln",
"494963", "Dörpen",
"492556", "Metelen",
"497384", "Schelklingen\-Hütten",
"4939427", "Ströbeck",
"4938451", "Hoppenrade\ bei\ Güstrow",
"498254", "Altomünster",
"496534", "Mülheim\ Mosel",
"494464", "Wittmund\-Carolinensiel",
"4939329", "Möringen",
"4936623", "Berga\ Elster",
"4939956", "Neukalen",
"4936481", "Neustadt\ an\ der\ Orla",
"499826", "Weidenbach\ Mittelfranken",
"499382", "Gerolzhofen",
"494642", "Kappeln\ Schlei",
"493647", "Pössneck",
"4934443", "Teuchern",
"492652", "Mendig",
"4934606", "Teicha\ Sachsen\-Anhalt",
"498233", "Kissing",
"496553", "Schönecken",
"496104", "Heusenstamm",
"4934344", "Kohren\-Sahlis",
"498639", "Neumarkt\-Sankt\ Veit",
"495624", "Bad\ Emstal",
"496033", "Butzbach",
"497973", "Obersontheim",
"492391", "Plettenberg",
"492828", "Emmerich\-Elten",
"495141", "Celle",
"4934348", "Frohburg",
"497474", "Haigerloch",
"4935756", "Hosena",
"4935435", "Gollmitz\ bei\ Calau",
"4937467", "Klingenthal\ Sachsen",
"4937369", "Wolkenstein",
"4939861", "Gramzow\ bei\ Prenzlau",
"498753", "Elsendorf\ Niederbayern",
"4933473", "Zechin",
"4933395", "Zerpenschleuse",
"495684", "Frielendorf",
"499241", "Pegnitz",
"499092", "Wemding",
"49385", "Schwerin",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"497728", "Niedereschach",
"492984", "Hallenberg",
"494324", "Brokstedt",
"497546", "Oberteuringen",
"493841", "Wismar",
"495221", "Herford",
"4937383", "Lunzenau",
"498055", "Halfing",
"492423", "Langerwehe",
"492305", "Castrop\-Rauxel",
"495281", "Bad\ Pyrmont",
"499644", "Pressath",
"496735", "Eppelsheim",
"492508", "Drensteinfurt",
"493935", "Tangerhütte",
"497464", "Talheim\ Kreis\ Tuttlingen",
"497963", "Adelmannsfelden",
"494384", "Selent",
"4935264", "Strehla",
"492924", "Möhnesee",
"494499", "Barssel",
"492192", "Hückeswagen",
"496872", "Losheim\ am\ See",
"497367", "Aalen\-Ebnat",
"495952", "Sögel",
"4935268", "Stauchitz",
"494487", "Grossenkneten\-Huntlosen",
"494561", "Neustadt\ in\ Holstein",
"496431", "Limburg\ an\ der\ Lahn",
"495846", "Gartow\ Niedersachsen",
"498338", "Böhen",
"496255", "Lindenfels",
"498535", "Haarbach",
"4936737", "Drognitz",
"494770", "Wischhafen",
"492588", "Harsewinkel\-Greffen",
"494925", "Hinte",
"495201", "Halle\ Westfalen",
"49355", "Cottbus",
"492385", "Hamm\-Rhynern",
"494756", "Odisheim",
"4937600", "Neumark\ Sachsen",
"498762", "Wartenberg\ Oberbayern",
"497708", "Geisingen\-Leipferdingen",
"4938756", "Grabow",
"494667", "Dagebüll",
"498640", "Reit\ Im\ Winkl",
"495377", "Ehra\-Lessien",
"493334", "Eberswalde",
"494166", "Ahlerstedt",
"498152", "Herrsching\ am\ Ammersee",
"492904", "Bestwig",
"499655", "Tännesberg",
"4939452", "Ilsenburg",
"499101", "Langenzenn",
"495593", "Bovenden\-Lenglern",
"492325", "Wanne\-Eickel",
"4934722", "Preusslitz",
"492403", "Eschweiler\ Rheinland",
"492528", "Ennigerloh\-Enniger",
"496853", "Marpingen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494432", "Dötlingen\-Brettorf",
"496562", "Speicher",
"495474", "Stemwede\-Dielingen",
"494236", "Kirchlinteln",
"493437", "Grimma",
"497141", "Ludwigsburg\ Württemberg",
"4934639", "Wallendorf\ Luppe",
"492663", "Westerburg\ Westerwald",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"492269", "Kierspe\-Rönsahl",
"497624", "Grenzach\-Wyhlen",
"4934381", "Colditz",
"497684", "Glottertal",
"494871", "Hohenwestedt",
"496244", "Westhofen\ Rheinhessenen",
"494407", "Wardenburg",
"499748", "Motten",
"499526", "Riedbach",
"4937326", "Frauenstein\ Sachsen",
"49841", "Ingolstadt\ Donau",
"4933925", "Wustrau\-Altfriesack",
"497221", "Baden\-Baden",
"495546", "Scheden",
"494861", "Tönning",
"4936372", "Kleinneuhausen",
"496184", "Langenselbold",
"499337", "Gaukönigshofen",
"4939050", "Bartensleben",
"499302", "Rottendorf\ Unterfranken",
"496458", "Rosenthal\ Hessen",
"496124", "Bad\ Schwalbach",
"4936022", "Grossengottern",
"495963", "Bawinkel",
"492673", "Ellenz\-Poltersdorf",
"496572", "Manderscheid\ Eifel",
"495464", "Alfhausen",
"4939749", "Grambow\ bei\ Pasewalk",
"4938331", "Rakow\ Vorpom",
"4934296", "Groitzsch\ bei\ Pegau",
"496641", "Lauterbach\ Hessen",
"4936206", "Grossfahner",
"4939061", "Weferlingen",
"499195", "Adelsdorf\ Mittelfranken",
"495069", "Nordstemmen",
"497952", "Gerabronn",
"495604", "Grossalmerode",
"495367", "Rühen",
"494176", "Marschacht",
"4939247", "Güterglück",
"493541", "Calau",
"4934976", "Gröbzig",
"493672", "Rudolstadt",
"495295", "Lichtenau\ Westfalen",
"499933", "Wallersdorf",
"499434", "Bodenwöhr",
"498772", "Mallersdorf\-Pfaffenberg",
"494893", "Hohenaspe",
"494624", "Kropp",
"496045", "Gedern",
"4939999", "Tutow",
"492761", "Olpe\ Biggesee",
"4934223", "Dommitzsch",
"4939458", "Heudeber",
"4939777", "Borkenfriede",
"497432", "Albstadt\-Tailfingen",
"492294", "Morsbach\ Sieg",
"494141", "Stade",
"4933839", "Wusterwitz",
"497236", "Keltern",
"499344", "Gerchsheim",
"492605", "Löf",
"499954", "Simbach\ Niederbayern",
"493576", "Weisswasser",
"492151", "Krefeld",
"4933239", "Gross\ Behnitz",
"499453", "Thalmassing",
"49228", "Bonn",
"494684", "Langeness\ Hallig",
"497304", "Blaustein\ Württemberg",
"499447", "Essing",
"492465", "Inden",
"493996", "Teterow",
"497667", "Breisach\ am\ Rhein",
"494708", "Ringstedt",
"495642", "Warburg\-Scherfede",
"495571", "Uslar",
"4938209", "Sanitz\ bei\ Rostock",
"4939454", "Elbingerode\ Harz",
"498638", "Waldkraiburg",
"496676", "Hohenroda\ Hessen",
"498245", "Türkheim\ Wertach",
"4935930", "Seitschen",
"497166", "Adelberg",
"4933637", "Beerfelde",
"496834", "Bous",
"499682", "Erbendorf",
"4935451", "Dahme\ Brandenburg",
"497176", "Spraitbach",
"496666", "Freiensteinau",
"4936028", "Kammerforst\ Thüringen",
"494952", "Rhauderfehn",
"496757", "Becherbach\ bei\ Kirn",
"492856", "Hamminkeln\-Brünen",
"494342", "Preetz\ Kreis\ Plön",
"495561", "Einbeck",
"492352", "Altena\ Westfalen",
"495427", "Melle\-Buer",
"494846", "Hattstedt",
"498543", "Aidenbach",
"492942", "Geseke",
"4936378", "Ostramondra",
"499622", "Hirschau\ Oberpfalz",
"496167", "Modautal",
"49214", "Leverkusen",
"492691", "Adenau",
"495324", "Vienenburg",
"498557", "Mauth",
"497729", "Tennenbronn",
"494221", "Delmenhorst",
"495905", "Beesten",
"496237", "Maxdorf",
"4936374", "Weissensee",
"4939366", "Kehnert",
"499531", "Ebern",
"4936257", "Luisenthal\ Thüringen",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494498", "Saterland\-Ramsloh",
"496406", "Lollar",
"493943", "Wernigerode",
"496202", "Schwetzingen",
"496743", "Bacharach",
"494281", "Zeven",
"495384", "Seesen\-Gross\ Rhüden",
"4934921", "Kemberg",
"492771", "Dillenburg",
"492509", "Nottuln\-Appelhülsen",
"496835", "Beckingen",
"493592", "Kirschau",
"4938484", "Ventschow",
"49641", "Giessen",
"498641", "Grassau\ Kreis\ Traunstein",
"492973", "Eslohe\ Sauerland",
"495663", "Spangenberg",
"497391", "Ehingen\ Donau",
"498572", "Tann\ Niederbayern",
"4938302", "Sagard",
"494268", "Bötersen",
"498124", "Forstern\ Oberbayern",
"496351", "Eisenberg\ Pfalz",
"492474", "Nideggen\-Schmidt",
"498458", "Gaimersheim",
"493741", "Plauen",
"4938876", "Roggendorf",
"4939206", "Eichenbarleben",
"495528", "Gieboldehausen",
"497652", "Hinterzarten",
"495746", "Rödinghausen",
"492593", "Ascheberg\ Westfalen",
"495403", "Bad\ Iburg",
"495325", "Goslar\-Hahnenklee",
"495139", "Burgwedel",
"496692", "Neustadt\ Hessen",
"495904", "Lengerich\ Emsl",
"494529", "Süsel\-Bujendorf",
"497081", "Bad\ Wildbad",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"4936847", "Steinbach\-Hallenberg",
"492377", "Wickede\ Ruhr",
"497021", "Kirchheim\ unter\ Teck",
"4933332", "Gartz\ Oder",
"499633", "Mitterteich",
"496772", "Nastätten",
"494977", "Blomberg\ Ostfriesland",
"493445", "Naumburg\ Saale",
"4938488", "Demen",
"494625", "Jübek",
"496044", "Schotten\ Hessen",
"492295", "Ruppichteroth",
"496762", "Kastellaun",
"494967", "Rhauderfehn\-Burlage",
"493962", "Penzlin\ bei\ Waren",
"499726", "Euerbach",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"497192", "Murrhardt",
"498847", "Obersöchering",
"499345", "Külsheim\ Baden",
"492367", "Henrichenburg",
"495808", "Gerdau",
"492604", "Nassau\ Lahn",
"499955", "Mamming",
"4936452", "Berlstedt",
"499548", "Mühlhausen\ Mittelfranken",
"497220", "Forbach\-Hundsbach",
"4939039", "Bonese",
"496152", "Gross\-Gerau",
"4939343", "Jerichow",
"497305", "Erbach\ Donau",
"497423", "Oberndorf\ am\ Neckar",
"492464", "Aldenhoven\ bei\ Jülich",
"4936649", "Gefell\ bei\ Schleiz",
"495673", "Immenhausen\ Hessen",
"492963", "Brilon\-Messinghausen",
"49375", "Zwickau",
"498562", "Triftern",
"494556", "Ahrensbök\-Gnissau",
"4935600", "Döbern\ NL",
"494363", "Lensahn",
"492546", "Coesfeld\-Lette",
"499179", "Freystadt",
"496449", "Ehringshausen\-Katzenfurt",
"497483", "Horb\-Mühringen",
"496002", "Ober\-Mörlen",
"497138", "Schwaigern",
"497529", "Waldburg\ Württemberg",
"4933433", "Buckow\ Märkische\ Schweiz",
"4938308", "Göhren\ Rügen",
"498666", "Teisendorf",
"496185", "Hammersbach\ Hessen",
"492150", "Meerbusch\-Lank",
"4935475", "Straupitz",
"498167", "Zolling",
"492571", "Greven\ Westfalen",
"492642", "Remagen",
"496339", "Grosssteinhausen",
"494140", "Estorf\ Kreis\ Stade",
"4934327", "Waldheim\ Sachsen",
"4933334", "Greiffenberg",
"497977", "Oberrot\ bei\ Gaildorf",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496543", "Büchenbeuren",
"499922", "Zwiesel",
"492991", "Marsberg\-Bredelar",
"499194", "Ebermannstadt",
"4933338", "Stolpe\/Oder",
"497373", "Zwiefalten",
"498237", "Aindling",
"496557", "Hallschlag",
"495605", "Kaufungen\ Hessen",
"495151", "Hameln",
"4933989", "Sadenbeck",
"4939857", "Drense",
"4938821", "Lüdersdorf",
"4938482", "Warin",
"495829", "Wriedel",
"4938221", "Marlow",
"4938304", "Garz\ Rügen",
"49981", "Ansbach",
"495294", "Hövelhof\-Espeln",
"497268", "Bad\ Rappenau\-Obergimpern",
"493643", "Weimar\ Thüringen",
"498202", "Althegnenberg",
"498743", "Geisenhausen",
"498406", "Böhmfeld",
"4939395", "Wanzer",
"499435", "Schwarzenfeld",
"494828", "Lägerdorf",
"499251", "Münchberg",
"495761", "Stolzenau",
"494924", "Moormerland\-Oldersum",
"495509", "Rosdorf\ Kreis\ Göttingen",
"495771", "Rahden\ Westfalen",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4936458", "Bad\ Berka",
"497556", "Uhldingen\-Mühlhofen",
"492384", "Welver",
"496596", "Üdersdorf",
"494508", "Krummesse",
"4938725", "Gross\ Godems",
"498045", "Lenggries\-Fall",
"4936730", "Sitzendorf",
"494423", "Fedderwarden",
"494305", "Westensee",
"493335", "Finowfurt",
"494483", "Ovelgönne\-Grossenmeer",
"499654", "Pleystein",
"492905", "Bestwig\-Ramsbeck",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4933765", "Märkisch\ Buchholz",
"492324", "Hattingen\ Ruhr",
"495691", "Bad\ Arolsen",
"497363", "Lauchheim",
"492770", "Eschenburg",
"497967", "Jagstzell",
"495475", "Bohmte\-Hunteburg",
"495942", "Uelsen",
"49208", "Oberhausen\ Rheinland",
"497625", "Zell\ im\ Wiesental",
"498177", "Münsing\ Starnberger\ See",
"495352", "Schöningen",
"492561", "Ahaus",
"492427", "Nideggen",
"497685", "Gutach\-Bleibach",
"4936454", "Magdala",
"496245", "Biblis",
"4937297", "Thum\ Sachsen",
"49202", "Wuppertal",
"496638", "Schwalmtal\-Renzendorf",
"494192", "Bad\ Bramstedt",
"4934909", "Aken\ Elbe",
"4939606", "Glienke",
"492536", "Münster\-Albachten",
"494795", "Garlstedt",
"495365", "Wolfsburg\-Neindorf",
"4939344", "Güsen",
"496439", "Holzappel",
"496103", "Langen\ Hessen",
"499197", "Egloffstein",
"496554", "Waxweiler",
"499776", "Mellrichstadt",
"498234", "Bobingen",
"4936647", "Saalburg\ Thüringen",
"4933962", "Heiligengrabe",
"4934956", "Zörbig",
"49511", "Hannover",
"498306", "Ronsberg",
"494491", "Friesoythe",
"499335", "Aub\ Kreis\ Würzburg",
"499129", "Wendelstein",
"494288", "Horstedt\ Kreis\ Rotenburg",
"495683", "Wabern\ Hessen",
"4939037", "Pretzier",
"492778", "Siegbach",
"498754", "Volkenschwand",
"497974", "Bühlerzell",
"4934261", "Kühren\ bei\ Wurzen",
"4939348", "Klitsche",
"49921", "Bayreuth",
"495623", "Edertal",
"496034", "Wöllstadt",
"496630", "Schwalmtal\-Storndorf",
"498802", "Huglfing",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4939320", "Schinne",
"492056", "Heiligenhaus",
"499851", "Dinkelsbühl",
"497473", "Mössingen",
"49381", "Rostock",
"497463", "Mühlheim\ an\ der\ Donau",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"4933432", "Müncheberg",
"492424", "Vettweiss",
"492158", "Grefrath\ bei\ Krefeld",
"4935200", "Arnsdorf\ bei\ Dresden",
"492923", "Lippetal\-Herzfeld",
"494383", "Grebin",
"497964", "Stödtlen",
"497130", "Löwenstein\ Württemberg",
"493435", "Oschatz",
"495149", "Wienhausen",
"494323", "Bornhöved",
"494405", "Edewecht",
"498582", "Röhrnbach",
"492983", "Winterberg\-Siedlinghausen",
"492484", "Mechernich\-Eiserfey",
"4936849", "Kleinschmalkalden",
"494148", "Drochtersen\-Assel",
"494665", "Emmelsbüll\-Horsbüll",
"498631", "Mühldorf\ am\ Inn",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"493731", "Freiberg\ Sachsen",
"494927", "Krummhörn\-Loquard",
"496722", "Rüdesheim\ am\ Rhein",
"492387", "Drensteinfurt\-Walstedde",
"4938483", "Brüel",
"497071", "Tübingen",
"495452", "Mettingen\ Westfalen",
"492327", "Bochum\-Wattenscheid",
"499766", "Grosswenkheim",
"4935341", "Bad\ Liebenwerda",
"496782", "Birkenfeld\ Nahe",
"495375", "Müden\ Aller",
"497260", "Sinsheim\-Hilsbach",
"499657", "Waldthurn",
"498555", "Perlesreut",
"495907", "Geeste",
"496235", "Schifferstadt",
"496451", "Frankenberg\ Eder",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"492374", "Iserlohn\-Letmathe",
"4934907", "Jeber\-Bergfrieden",
"4938825", "Klütz",
"497046", "Zaberfeld",
"496648", "Bad\ Salzschlirf",
"494473", "Emstek",
"49631", "Kaiserslautern",
"4938225", "Trinwillershagen",
"497228", "Forbach",
"4936453", "Mellingen",
"495721", "Stadthagen",
"495932", "Haren\ Ems",
"4939391", "Lückstedt",
"494974", "Neuharlingersiel",
"4939342", "Gladau",
"496755", "Odernheim\ am\ Glan",
"495485", "Ladbergen",
"493726", "Flöha",
"497569", "Isny\-Eisenbach",
"4935471", "Birkenhainchen",
"4933964", "Fretzdorf",
"497675", "Bernau\ Baden",
"498686", "Petting",
"496165", "Breuberg",
"495425", "Borgholzhausen",
"495303", "Wendeburg",
"498035", "Raubling",
"492801", "Xanten",
"499962", "Schwarzach\ Niederbayern",
"499972", "Waldmünchen",
"496175", "Friedrichsdorf\ Taunus",
"499445", "Neustadt\ an\ der\ Donau",
"492521", "Beckum",
"497665", "March\ Breisgau",
"498733", "Mengkofen",
"492581", "Warendorf",
"498247", "Bad\ Wörishofen",
"495208", "Leopoldshöhe",
"4938303", "Sellin\ Ostseebad",
"498450", "Ingolstadt\-Zuchering",
"4933438", "Altlandsberg",
"496053", "Wächtersbach",
"494260", "Visselhövede\-Wittorf",
"494209", "Schwanewede",
"4939859", "Fürstenwerder",
"497579", "Schwenningen\ Baden",
"494603", "Havetoft",
"4933434", "Herzfelde\ bei\ Strausberg",
"497383", "Münsingen\-Buttenhausen",
"494964", "Rhede\ Ems",
"496349", "Billigheim\-Ingenheim",
"492632", "Andernach",
"4935025", "Liebstadt",
"496047", "Altenstadt\ Hessen",
"499741", "Bad\ Brückenau",
"496533", "Morbach\ Hunsrück",
"494463", "Wangerland",
"495520", "Braunlage",
"498253", "Pöttmes",
"4938721", "Ziegendorf",
"4939886", "Milmersdorf",
"4933333", "Tantow",
"497148", "Grossbottwar",
"4937360", "Olbernhau",
"492364", "Haltern\ Westfalen",
"497323", "Gerstetten",
"492607", "Kobern\-Gondorf",
"494293", "Ottersberg\-Fischerhude",
"499943", "Lam\ Oberpfalz",
"495056", "Winsen\-Meissendorf",
"493531", "Finsterwalde",
"496522", "Mettendorf",
"499353", "Karlstadt",
"492623", "Ransbach\-Baumbach",
"496174", "Königstein\ im\ Taunus",
"497307", "Senden\ Iller",
"497836", "Schiltach",
"4934385", "Mutzschen",
"497664", "Freiburg\-Tiengen",
"499444", "Siegenburg",
"492683", "Asbach\ Westerwald",
"497332", "Lauterstein",
"497271", "Wörth\ am\ Rhein",
"496582", "Freudenburg",
"494779", "Freiburg\ Elbe",
"4937341", "Ehrenfriedersdorf",
"494501", "Kastorf\ Holstein",
"499566", "Meeder",
"49211", "Düsseldorf",
"492297", "Wildbergerhütte",
"4933086", "Grieben\ Kreis\ Oberhavel",
"494965", "Surwold",
"498722", "Gangkofen",
"4935056", "Altenberg\ Sachsen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"494627", "Dörpstedt",
"496631", "Alsfeld",
"493622", "Waltershausen\ Thüringen",
"494186", "Buchholz\-Trelde",
"4939747", "Züsedom",
"497903", "Mainhardt",
"494126", "Horst\ Holstein",
"493682", "Zella\-Mehlis",
"498782", "Pfeffenhausen",
"498845", "Bad\ Kohlgrub",
"499347", "Wittighausen",
"492365", "Marl",
"497404", "Epfendorf",
"495536", "Holzminden\-Neuhaus",
"492568", "Heek",
"496234", "Mutterstadt",
"498554", "Schönberg\ Niederbayern",
"4936606", "Kraftsdorf",
"492375", "Balve",
"4934222", "Arzberg\ bei\ Torgau",
"4938856", "Pritzier\ bei\ Hagenow",
"492256", "Mechernich\-Satzvey",
"499738", "Rottershausen",
"492452", "Heinsberg\ Rheinland",
"495327", "Bad\ Grund\ Harz",
"497131", "Heilbronn\ Neckar",
"493447", "Altenburg\ Thüringen",
"494246", "Twistringen\-Heiligenloh",
"494442", "Lohne\ Oldenburg",
"4938787", "Glöwen",
"494975", "Westerholt\ Ostfriesland",
"4934637", "Frankleben",
"496754", "Martinstein",
"4933921", "Zechlinerhütte",
"499576", "Lichtenfels\-Isling",
"497261", "Sinsheim",
"493344", "Bad\ Freienwalde",
"495484", "Lienen\-Kattenvenne",
"494769", "Bremervörde\-Iselersheim",
"494821", "Itzehoe",
"496306", "Trippstadt",
"496837", "Wallerfangen",
"495768", "Petershagen\-Heimsen",
"492736", "Burbach\ Siegerl",
"497674", "Todtmoos",
"494159", "Basthorst",
"495923", "Schüttorf",
"496164", "Reichelsheim\ Odenwald",
"496802", "Völklingen\-Lauterbach",
"494881", "Friedrichstadt",
"495158", "Hemeringen",
"498034", "Brannenburg",
"498630", "Oberneukirchen",
"495424", "Bad\ Rothenfelde",
"499672", "Neunburg\ vorm\ Wald",
"496733", "Gau\-Odernheim",
"493933", "Genthin",
"497627", "Steinen\ Kreis\ Lörrach",
"4936259", "Tabarz\ Thüringer\ Wald",
"492303", "Unna",
"492425", "Nideggen\-Embken",
"4936373", "Buttstädt",
"497965", "Ellwangen\-Röhlingen",
"494404", "Elsfleth",
"4936023", "Horsmar",
"498053", "Bad\ Endorf",
"492485", "Schleiden\-Dreiborn",
"497126", "Burladingen\-Melchingen",
"496247", "Worms\-Pfeddersheim",
"494903", "Wymeer",
"492721", "Lennestadt",
"496253", "Fürth\ Odenwald",
"494664", "Neukirchen\ bei\ Niebüll",
"492932", "Neheim\-Hüsten",
"498533", "Rotthalmünster",
"493302", "Hennigsdorf",
"494836", "Hennstedt\ Dithmarschen",
"496659", "Eichenzell",
"494307", "Raisdorf",
"498349", "Stötten\ am\ Auerberg",
"494271", "Sulingen",
"496844", "Blieskastel\-Altheim",
"493337", "Biesenthal\ Brandenburg",
"4935697", "Bagenz",
"494332", "Hamdorf\ bei\ Rendsburg",
"495374", "Isenbüttel",
"495607", "Fuldatal",
"494794", "Worpswede\-Ostersode",
"4935797", "Schwepnitz",
"495364", "Velpke",
"4938207", "Stäbelow",
"497821", "Lahr\ Schwarzwald",
"494261", "Rotenburg\ Wümme",
"496358", "Kriegsfeld",
"499206", "Mistelgau\-Obernsees",
"499402", "Regenstauf",
"496555", "Bleialf",
"492520", "Wadersloh\-Diestedde",
"493586", "Neugersdorf\ Sachsen",
"4939453", "Derenburg",
"4934925", "Bad\ Schmiedeberg",
"49831", "Kempten\ Allgäu",
"495632", "Willingen\ Upland",
"494674", "Ockholm",
"497159", "Renningen",
"496187", "Schöneck",
"4934224", "Belgern\ Sachsen",
"4933237", "Paulinenaue",
"496626", "Wildeck\-Obersuhl",
"499334", "Giebelstadt",
"4935455", "Walddrehna",
"492208", "Niederkassel",
"4933976", "Wutike",
"497975", "Untergröningen",
"495467", "Voltlage",
"495521", "Herzberg\ am\ Harz",
"4939779", "Eggesin",
"496035", "Reichelsheim\ Wetterau",
"4939997", "Jarmen",
"4933870", "Zollchow\ bei\ Rathenow",
"498165", "Neufahrn\ bei\ Freising",
"497246", "Malsch\ Kreis\ Karlsruhe",
"499662", "Vilseck",
"496127", "Niedernhausen\ Taunus",
"494131", "Lüneburg",
"497442", "Baiersbronn",
"4933837", "Brielow",
"497477", "Jungingen\ bei\ Hechingen",
"495965", "Klein\ Berssen",
"492675", "Ediger\-Eller",
"499422", "Bogen\ Niederbayern",
"4933606", "Müllrose",
"496544", "Rhaunen",
"495186", "Salzhemmendorf\-Wallensen",
"497720", "Schwenningen\ am\ Neckar",
"4938351", "Mesekenhagen",
"4939327", "Klietz",
"4937382", "Geringswalde",
"495126", "Algermissen",
"499482", "Wörth\ an\ der\ Donau",
"4936624", "Teichwolframsdorf",
"4939030", "Brunau",
"499286", "Oberkotzau",
"494536", "Steinhorst\ Lauenburg",
"496466", "Dautphetal\-Friedensdorf",
"496262", "Aglasterhausen",
"493644", "Apolda",
"495293", "Paderborn\-Dahl",
"499935", "Stephansposching",
"4936921", "Wutha\-Farnroda",
"4936640", "Remptendorf",
"492228", "Remagen\-Rolandseck",
"498062", "Bruckmühl\ Mangfall",
"4935609", "Drachhausen",
"496132", "Ingelheim\ am\ Rhein",
"498744", "Gerzen",
"4936628", "Zeulenroda",
"494778", "Wingst",
"497374", "Uttenweiler",
"496107", "Kelsterbach",
"499193", "Höchstadt\ an\ der\ Aisch",
"498330", "Legau",
"499841", "Bad\ Windsheim",
"499653", "Eslarn",
"494484", "Hude\-Wüsting",
"495769", "Steyerberg\-Voigtei",
"495821", "Bad\ Bevensen",
"497364", "Oberkochen",
"492323", "Herne",
"492405", "Würselen",
"494768", "Hipstedt",
"492383", "Bönen",
"495159", "Coppenbrügge\-Bisperode",
"497632", "Badenweiler",
"494923", "Krummhörn\-Pewsum",
"494158", "Roseburg",
"498072", "Haag\ in\ Oberbayern",
"4938455", "Plaaz",
"4938736", "Goldberg",
"496476", "Mengerskirchen",
"497581", "Saulgau",
"496272", "Hirschhorn\ Neckar",
"499146", "Markt\ Berolzheim",
"496331", "Pirmasens",
"494327", "Grossenaspe",
"493886", "Gadebusch",
"495028", "Pennigsehl",
"493322", "Falkensee",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4934491", "Schmölln\ Thüringen",
"493382", "Lehnin",
"495246", "Verl",
"496855", "Freisen",
"492927", "Neuengeseke",
"4933472", "Golzow\ bei\ Seelow",
"497467", "Neuhausen\ ob\ Eck",
"4935207", "Moritzburg",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"499647", "Kirchenthumbach",
"495975", "Rheine\-Mesum",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498545", "Hofkirchen\ Bayern",
"499171", "Roth\ Mittelfranken",
"495060", "Bodenburg",
"495664", "Morschen",
"492974", "Schmallenberg\-Fredeburg",
"495836", "Wittingen\-Radenbeck",
"498348", "Bidingen",
"496441", "Wetzlar",
"495307", "Braunschweig\-Wenden",
"496096", "Wiesen\ Unterfranken",
"497056", "Gechingen",
"492473", "Simmerath",
"4936739", "Rottenbach",
"498123", "Moosinning",
"496658", "Poppenhausen\ Wasserkuppe",
"4939265", "Löderburg",
"4933657", "Steinsdorf\ Brandenburg",
"49371", "Chemnitz\ Sachsen",
"495271", "Höxter",
"495332", "Schöppenstedt",
"49861", "Traunstein",
"496326", "Deidesheim",
"496745", "Gondershausen",
"499634", "Wiesau",
"4937384", "Wechselburg",
"494477", "Lastrup\-Hemmelte",
"495404", "Westerkappeln",
"492594", "Dülmen",
"4936870", "Masserberg",
"4934206", "Rötha",
"4935263", "Gröditz\ bei\ Riesa",
"496386", "Altenkirchen\ Pfalz",
"495903", "Emsbüren",
"4936622", "Triebes",
"498296", "Villenbach",
"493831", "Stralsund",
"497327", "Dischingen",
"4937367", "Lengefeld\ Erzgebirge",
"492603", "Bad\ Ems",
"499372", "Klingenberg\ am\ Main",
"499231", "Marktredwitz",
"496502", "Schweich",
"494467", "Wittmund\-Funnix",
"494521", "Eutin",
"493462", "Bad\ Dürrenberg",
"498257", "Inchenhofen",
"496043", "Nidda",
"499876", "Rohr\ Mittelfranken",
"4933474", "Neutrebbin",
"497387", "Hohenstein\ Württemberg",
"495131", "Garbsen",
"494607", "Janneby",
"496359", "Grünstadt",
"494364", "Dahme\ Kreis\ Ostholstein",
"4934444", "Lützen",
"498649", "Schleching",
"4933478", "Gross\ Neuendorf",
"497484", "Simmersfeld",
"496057", "Flörsbachtal",
"495261", "Lemgo",
"498243", "Fuchstal",
"498702", "Wörth\ an\ der\ Isar",
"492463", "Titz",
"497424", "Spaichingen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4934343", "Regis\-Breitingen",
"496198", "Eppstein",
"494106", "Quickborn\ Kreis\ Pinneberg",
"499161", "Neustadt\ an\ der\ Aisch",
"495674", "Grebenstein",
"494632", "Steinbergkirche",
"492964", "Brilon\-Alme",
"499953", "Pilsting",
"4939823", "Rechlin",
"499343", "Lauda\-Königshofen",
"495491", "Damme\ Dümmer",
"492501", "Münster\-Hiltrup",
"492779", "Greifenstein\-Beilstein",
"494683", "Oldsum",
"499128", "Feucht",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"4939401", "Neuwegersleben",
"4939059", "Wegenstedt",
"494289", "Kirchtimke",
"499454", "Aufhausen\ Oberpfalz",
"497932", "Niederstetten\ Württemberg",
"4937207", "Hainichen\ Sachsen",
"497721", "Villingen\ im\ Schwarzwald",
"499188", "Postbauer\-Heng",
"4939728", "Medow\ bei\ Anklam",
"494623", "Böklund",
"4939740", "Nechlin",
"495228", "Vlotho\-Exter",
"4933849", "Wiesenburg\ Mark",
"492293", "Nümbrecht",
"4939223", "Theessen",
"498331", "Memmingen",
"496438", "Hünfelden",
"4939724", "Klein\ Bünzow",
"494365", "Heringsdorf\ Holstein",
"4939086", "Jävenitz",
"492687", "Horhausen\ Westerwald",
"4933747", "Marzahna",
"497485", "Empfingen",
"4935246", "Ziegenhain\ Sachsen",
"498272", "Wertingen",
"4935825", "Kodersdorf",
"492627", "Braubach",
"497303", "Illertissen",
"497425", "Trossingen",
"499357", "Gräfendorf\ Bayern",
"493496", "Köthen\ Anhalt",
"494297", "Ottersberg\-Posthausen",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495675", "Trendelburg",
"495665", "Guxhagen",
"492975", "Schmallenberg\-Oberkirchen",
"498544", "Eging\ am\ See",
"4938375", "Koserow",
"4937609", "Wolkenburg\ Mulde",
"492246", "Lohmar\ Rheinland",
"4936077", "Grossbodungen",
"494256", "Hilgermissen",
"4936962", "Vacha",
"498262", "Mittelneufnach",
"494452", "Zetel\-Neuenburg",
"498466", "Denkendorf\ Oberbayern",
"495820", "Suhlendorf",
"499396", "Urspringen\ bei\ Lohr",
"496833", "Rehlingen\-Siersburg",
"499635", "Bärnau",
"496744", "Oberwesel",
"497520", "Bodnegg",
"493944", "Blankenburg\ Harz",
"4938780", "Lanz\ Brandenburg",
"4939921", "Ankershagen",
"496062", "Erbach\ Odenwald",
"499086", "Fremdingen",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"495383", "Lutter\ am\ Barenberge",
"492159", "Meerbusch\-Osterath",
"494736", "Butjadingen\-Tossens",
"494149", "Fredenbeck",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"492595", "Olfen",
"495323", "Clausthal\-Zellerfeld",
"492821", "Kleve\ Niederrhein",
"495148", "Steinhorst\ Niedersachsen",
"4939722", "Sarnow\ bei\ Anklam",
"492903", "Meschede\-Freienohl",
"498502", "Fürstenzell",
"494485", "Elsfleth\-Huntorf",
"499551", "Burgwindheim",
"4933679", "Wendisch\ Rietz",
"497365", "Essingen\ Württemberg",
"497568", "Bad\ Wurzach\-Hauerz",
"495594", "Bovenden\-Reyershausen",
"492404", "Alsdorf\ Rheinland",
"498043", "Jachenau",
"496440", "Kölschhausen",
"494425", "Wangerland\-Hooksiel",
"494303", "Schlesen",
"4938426", "Neuburg\-Steinhausen",
"499170", "Schwanstetten",
"496257", "Seeheim\-Jugenheim",
"498537", "Bad\ Füssing\-Aigen",
"496243", "Monsheim",
"493902", "Diesdorf\ Altm",
"497683", "Simonswald",
"498057", "Aschau\-Sachrang",
"492332", "Gevelsberg",
"492271", "Bergheim\ Erft",
"49711", "Stuttgart",
"495473", "Ostercappeln",
"4936333", "Heringen\ Helme",
"4936761", "Heubisch",
"496854", "Oberthal\ Saar",
"497623", "Rheinfelden\ Baden",
"492836", "Wachtendonk",
"492307", "Kamen",
"494721", "Cuxhaven",
"496737", "Köngernheim",
"494932", "Norderney",
"492664", "Rennerod",
"493937", "Osterburg\ Altmark",
"497229", "Iffezheim",
"496123", "Eltville\ am\ Rhein",
"495964", "Lähden",
"495130", "Wedemark",
"492674", "Bad\ Bertrich",
"4936968", "Rossdorf\ Rhön",
"4933877", "Nitzahn",
"4939296", "Welsleben",
"4935384", "Steinsdorf\ bei\ Jessen",
"496348", "Offenbach\ an\ der\ Queich",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"4933830", "Ziesar",
"496545", "Blankenrath",
"492261", "Gummersbach",
"4933230", "Börnicke\ Kreis\ Havelland",
"49661", "Fulda",
"496183", "Erlensee",
"497736", "Tengen",
"495071", "Schwarmstedt",
"492131", "Neuss",
"4939485", "Gernrode\ Harz",
"4939976", "Gross\ Bützin",
"498745", "Bodenkirchen",
"498326", "Fischen\ im\ Allgäu",
"499433", "Nabburg",
"4938392", "Sassnitz",
"494208", "Grasberg",
"496296", "Ahorn\ Baden",
"498822", "Oberammergau",
"497578", "Wald\ Hohenz",
"498386", "Oberstaufen",
"4935388", "Klöden",
"4936964", "Dermbach\ Rhön",
"497375", "Obermarchtal",
"495209", "Gütersloh\-Friedrichsdorf",
"49351", "Dresden",
"4937431", "Mehltheuer\ Vogtland",
"495603", "Gudensberg",
"4935939", "Hochkirch",
"497256", "Philippsburg",
"497452", "Nagold",
"495277", "Höxter\-Fürstenau",
"4933609", "Brieskow\-Finkenheerd",
"499676", "Winklarn",
"499938", "Moos\ Niederbayern",
"497182", "Welzheim",
"492225", "Meckenheim\ Rheinland",
"4939426", "Hessen",
"4933762", "Zeuthen",
"499177", "Heideck",
"4938722", "Raduhn",
"492803", "Wesel\-Büderich",
"497122", "St\ Johann\ Württemberg",
"496447", "Langgöns\-Niederkleen",
"495301", "Lehre\-Essenrode",
"494775", "Grossenwörden",
"494204", "Thedinghausen",
"497574", "Gammertingen",
"496344", "Schwegenheim",
"498654", "Freilassing",
"492678", "Büchel\ bei\ Cochem",
"4935606", "Briesen\ bei\ Cottbus",
"496453", "Gemünden\ Wohra",
"493306", "Gransee",
"495874", "Soltendieck",
"494832", "Meldorf",
"495723", "Bad\ Nenndorf",
"494336", "Owschlag",
"492369", "Dorsten\-Wulfen",
"494471", "Cloppenburg",
"493522", "Grossenhain\ Sachsen",
"498251", "Aichach",
"494527", "Bosau",
"494461", "Jever",
"496531", "Bernkastel\-Kues",
"499202", "Waischenfeld",
"495025", "Estorf\ Weser",
"492379", "Menden\-Asbeck",
"499406", "Mintraching",
"498435", "Ehekirchen",
"49881", "Weilheim\ in\ Oberbayern",
"495137", "Seelze",
"497381", "Münsingen",
"495102", "Laatzen",
"495864", "Jameln",
"4933207", "Gross\ Kreutz",
"497321", "Heidenheim\ an\ der\ Brenz",
"495636", "Lichtenfels\-Goddelsheim",
"495978", "Hörstel\-Dreierwalde",
"4938296", "Rerik\ Ostseebad",
"4935472", "Schlepzig",
"495085", "Burgdorf\-Ehlershausen",
"498194", "Vilgertshofen",
"4939341", "Redekin",
"496858", "Ottweiler\-Fürth",
"498731", "Dingolfing",
"4939200", "Gommern",
"492523", "Wadersloh",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"494765", "Ebersdorf\ bei\ Bremervörde",
"497564", "Bad\ Wurzach",
"492408", "Aachen\-Kornelimünster",
"496622", "Bebra",
"499167", "Oberscheinfeld",
"493631", "Nordhausen\ Thüringen",
"496682", "Tann\ Rhön",
"494155", "Büchen",
"499834", "Theilenhofen",
"497703", "Bonndorf\ im\ Schwarzwald",
"499666", "Illschwang",
"497242", "Rheinstetten",
"4936947", "Jüchsen",
"4938485", "Dabel",
"497446", "Lossburg",
"496051", "Gelnhausen",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"492583", "Sassenberg",
"4938728", "Domsühl",
"497832", "Haslach\ im\ Kinzigtal",
"492429", "Hürtgenwald",
"499244", "Betzenstein",
"495681", "Homberg\ Efze",
"498179", "Eurasburg\ an\ der\ Loisach",
"494493", "Friesoythe\-Gehlenberg",
"4935342", "Mühlberg\ Elbe",
"495052", "Hermannsburg",
"4936736", "Arnsgereuth",
"4938223", "Saal\ Vorpom",
"496526", "Bollendorf",
"495144", "Wathlingen",
"497471", "Hechingen",
"496586", "Beuren\ Hochwald",
"4938823", "Selmsdorf",
"499853", "Wilburgstetten",
"499562", "Sonnefeld",
"495621", "Bad\ Wildungen",
"4933768", "Prieros",
"497807", "Neuried\ Ortenaukreis",
"492394", "Neuenrade\-Affeln",
"497336", "Lonsee",
"494182", "Tostedt",
"496655", "Neuhof\ Kreis\ Fulda",
"492680", "Mündersbach",
"496101", "Bad\ Vilbel",
"495507", "Ebergötzen",
"498548", "Vilshofen\-Sandbach",
"4933764", "Mittenwalde\ Mark",
"498726", "Schönau\ Niederbayern",
"499847", "Ergersheim",
"492865", "Raesfeld",
"498345", "Stöttwang",
"49209", "Gelsenkirchen",
"497204", "Malsch\-Völkersbach",
"497775", "Mühlingen",
"499350", "Eussenheim\-Hundsbach",
"495532", "Stadtoldendorf",
"4938724", "Siggelkow",
"494122", "Uetersen",
"492620", "Neuhäusel\ Westerwald",
"497063", "Bad\ Wimpfen",
"493686", "Eisfeld",
"497073", "Ammerbuch",
"492252", "Zülpich",
"4935478", "Goyatz",
"493733", "Annaberg\-Buchholz",
"492456", "Selfkant",
"4939394", "Hohenberg\-Krusemark",
"498633", "Tüssling",
"497765", "Rickenbach\ Hotzenwald",
"496434", "Bad\ Camberg",
"494564", "Schashagen",
"496559", "Leidenborn",
"498239", "Langenneufnach",
"4934262", "Falkenhain\ bei\ Wurzen",
"4938305", "Gingst",
"496195", "Kelkheim\ Taunus",
"494242", "Syke",
"494703", "Loxstedt\-Donnern",
"495827", "Unterlüss",
"494446", "Bakum\ Kreis\ Vechta",
"496302", "Winnweiler",
"494381", "Lütjenburg",
"492732", "Kreuztal",
"492921", "Soest",
"499572", "Burgkunstadt",
"4933335", "Pinnow\ Kreis\ Uckermark",
"499641", "Grafenwöhr",
"495284", "Schwalenberg",
"497461", "Tuttlingen",
"497527", "Wolfegg",
"4934607", "Wettin",
"493844", "Schwaan",
"495224", "Enger\ Westfalen",
"497587", "Hosskirch",
"4939398", "Gross\ Garz",
"4935474", "Schönwalde\ bei\ Lübben",
"4939957", "Gielow",
"496039", "Karben",
"492981", "Winterberg\ Westfalen",
"499184", "Deining\ Oberpfalz",
"494321", "Neumünster",
"496806", "Heusweiler",
"496337", "Grossbundenbach",
"4935023", "Bad\ Gottleuba",
"497042", "Vaihingen\ an\ der\ Enz",
"49681", "Saarbrücken",
"495300", "Salzgitter\-Üfingen",
"496435", "Wallmerod",
"497764", "Herrischried",
"4933928", "Wildberg\ Brandenburg",
"498531", "Pocking",
"4939056", "Klüden",
"496251", "Bensheim",
"495067", "Bockenem",
"492723", "Kirchhundem",
"492874", "Isselburg",
"498858", "Kochel\-Walchensee",
"4934383", "Trebsen\ Mulde",
"495936", "Twist",
"497503", "Wilhelmsdorf\ Württemberg",
"494273", "Kirchdorf\ bei\ Sulingen",
"497428", "Rosenfeld",
"4933846", "Dippmannsdorf",
"497154", "Kornwestheim",
"4936200", "Elxleben\ bei\ Arnstadt",
"498622", "Tacherting\-Peterskirchen",
"4939089", "Bismark\ Altmark",
"499339", "Ippesheim",
"492301", "Holzwickede",
"499543", "Hirschaid",
"493931", "Stendal",
"493722", "Limbach\-Oberfrohna",
"495803", "Rosche",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"496731", "Alzey",
"4935249", "Basslitz",
"495225", "Spenge",
"499966", "Wiesenfelden",
"498051", "Prien\ am\ Chiemsee",
"4933924", "Rägelin",
"499185", "Mühlhausen\ Oberpfalz",
"498682", "Laufen\ Salzach",
"495583", "Braunlage\-Hohegeiss",
"4937344", "Crottendorf\ Sachsen",
"4937606", "Lengenfeld\ Vogtland",
"499245", "Obertrubach",
"492267", "Wipperfürth",
"4938750", "Malliss",
"499976", "Rötz",
"499638", "Neualbenreuth",
"4936426", "Ottendorf\ bei\ Stadtroda",
"494409", "Westerstede\-Ocholt",
"494133", "Wittorf\ Kreis\ Lüneburg",
"495145", "Beedenbostel",
"492598", "Senden\-Ottmarsbocholt",
"492395", "Finnentrop\-Rönkhausen",
"495523", "Bad\ Sachsa",
"498250", "Hilgertshausen\-Tandern",
"4938333", "Horst\ bei\ Grimmen",
"498453", "Reichertshofen\ Oberbayern",
"496654", "Gersfeld\ Rhön",
"496050", "Biebergemünd",
"494263", "Scheessel",
"497823", "Seelbach\ Schutter",
"4934467", "Eckartsberga",
"492636", "Burgbrohl",
"492864", "Reken",
"498344", "Westendorf\ bei\ Kaufbeuren",
"492102", "Ratingen",
"492137", "Neuss\-Norf",
"4937348", "Oberwiesenthal\ Kurort",
"496849", "Kirkel",
"497774", "Eigeltingen",
"495379", "Sassenburg\-Grussendorf",
"4937320", "Mulda\ Sachsen",
"496239", "Bobenheim\-Roxheim",
"4933367", "Friedrichswalde\ Brandenburg",
"497727", "Vöhrenbach",
"498434", "Rennertshofen",
"496633", "Homberg\ Ohm",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"499772", "Bischofsheim\ an\ der\ Rhön",
"492532", "Ostbevern",
"4933676", "Friedland\ bei\ Beeskow",
"4936025", "Körner",
"495865", "Gusborn",
"4936375", "Kindelbrück",
"492507", "Havixbeck",
"495084", "Hambühren",
"4938327", "Elmenhorst\ Vorpom",
"4933922", "Karwesee",
"4938429", "Glasin",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"4939007", "Tangeln",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"494764", "Gnarrenburg\-Klenkendorf",
"492621", "Lahnstein",
"499351", "Gemünden\ am\ Main",
"4937757", "Rittersgrün",
"493533", "Elsterwerda",
"494488", "Westerstede",
"498302", "Görisried",
"499941", "Kötzting",
"498806", "Utting\ am\ Ammersee",
"499835", "Ehingen\ Mittelfranken",
"498337", "Altenstadt\ Iller",
"492052", "Velbert\-Langenberg",
"494154", "Trittau",
"494503", "Timmendorfer\ Strand",
"497273", "Hagenbach\ Pfalz",
"498039", "Rott\ am\ Inn",
"495429", "Melle\-Wellingholzhausen",
"492681", "Altenkirchen\ Westerwald",
"4934221", "Schildau\ Gneisenaustadt",
"49941", "Regensburg",
"4934923", "Cobbelsdorf",
"4934746", "Giersleben",
"494823", "Wilster",
"495707", "Petershagen\ Weser",
"497263", "Waibstadt",
"497669", "St\ Märgen",
"492224", "Bad\ Honnef",
"4939455", "Schierke",
"49331", "Potsdam",
"494883", "Süderstapel",
"497575", "Messkirch",
"494774", "Hechthausen",
"495732", "Löhne",
"495921", "Nordhorn",
"494205", "Ottersberg",
"498586", "Hauzenberg",
"494320", "Heidmühlen",
"496345", "Albersweiler",
"496726", "Lorch\ Rheingau",
"492827", "Goch\-Hassum",
"4937342", "Cranzahl",
"495875", "Emmendorf",
"4935877", "Cunewalde",
"499152", "Hartenstein\ Mittelfranken",
"495456", "Westerkappeln\-Velpe",
"495252", "Bad\ Lippspringe",
"499762", "Saal\ an\ der\ Saale",
"4935453", "Drahnsdorf",
"4935936", "Sohland\ Spree",
"496786", "Kempfeld",
"497133", "Lauffen\ am\ Neckar",
"492775", "Driedorf",
"492204", "Bensberg",
"497620", "Schopfheim\-Gersbach",
"497024", "Wendlingen\ am\ Neckar",
"499535", "Pfarrweisach",
"498506", "Bad\ Höhenstadt",
"494285", "Rhade\ bei\ Zeven",
"494803", "Pahlen",
"499338", "Röttingen\ Unterfranken",
"495901", "Fürstenau\ bei\ Bramsche",
"4938466", "Jürgenshagen",
"497084", "Schömberg\ bei\ Neuenbürg",
"496457", "Burgwald\ Eder",
"492695", "Insul",
"4934498", "Rositz",
"498121", "Markt\ Schwaben",
"492471", "Roetgen\ Eifel",
"493744", "Auerbach\ Vogtland",
"4935327", "Priessen",
"496706", "Wallhausen\ Nahe",
"4934494", "Ehrenhain",
"496443", "Ehringshausen\ Dill",
"495565", "Einbeck\-Wenzen",
"499173", "Thalmässing",
"495368", "Parsau",
"492336", "Schwelm",
"497394", "Schelklingen",
"492832", "Kevelaer",
"497429", "Egesheim",
"494936", "Grossheide",
"495273", "Beverungen",
"4936940", "Oepfershausen",
"498241", "Buchloe",
"498092", "Grafing\ bei\ München",
"4936621", "Elsterberg\ bei\ Plauen",
"492587", "Ennigerloh\-Westkirchen",
"495263", "Barntrup",
"4938453", "Mistorf",
"497707", "Bräunlingen",
"4936928", "Neuenhof\ Thüringen",
"494668", "Klanxbüll",
"499163", "Dachsbach",
"495378", "Sassenburg\-Platendorf",
"4939207", "Colbitz",
"497732", "Radolfzell\ am\ Bodensee",
"4938354", "Wusterhusen",
"4936846", "Suhl\-Dietzhausen",
"496848", "Homburg\-Einöd",
"492527", "Lippetal\-Lippborg",
"492461", "Jülich",
"499639", "Mähring",
"499233", "Arzberg\ Oberfranken",
"498322", "Oberstdorf",
"4933200", "Bergholz\-Rehbrücke",
"492601", "Nauort",
"492599", "Ascheberg\-Herbern",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"496120", "Aarbergen",
"497252", "Bretten",
"497456", "Haiterbach",
"499747", "Geroda\ Bayern",
"496041", "Glauburg",
"496292", "Seckach",
"494408", "Hude\ Oldenburg",
"498382", "Lindau\ Bodensee",
"4936924", "Mihla",
"494523", "Malente",
"4937296", "Stollberg\ Erzgebirge",
"494394", "Bokhorst",
"495764", "Steyerberg",
"499254", "Gefrees",
"494489", "Apen",
"497300", "Roggenburg",
"4939863", "Seehausen\ bei\ Prenzlau",
"496758", "Waldböckelheim",
"4934492", "Lucka",
"495042", "Bad\ Münder\ am\ Deister",
"49361", "Erfurt",
"495154", "Aerzen",
"498038", "Vogtareuth",
"499843", "Burgbernheim",
"495428", "Melle\-Neuenkirchen",
"4939263", "Unseburg",
"495503", "Nörten\-Hardenberg",
"497936", "Schrozberg\-Bartenstein",
"499191", "Forchheim\ Oberfranken",
"492994", "Marsberg\-Westheim",
"49871", "Landshut",
"497803", "Gengenbach",
"496645", "Ulrichstein",
"499734", "Burkardroth",
"498276", "Baar\ Schwaben",
"4935265", "Glaubitz",
"496238", "Dirmstein",
"49760", "Oberried\ Breisgau",
"498558", "Hohenau\ Niederbayern",
"492574", "Saerbeck",
"499857", "Schopfloch\ Mittelfranken",
"4934441", "Hohenmölsen",
"494865", "Osterhever",
"494497", "Barssel\-Harkebrügge",
"499340", "Königheim\-Brehmen",
"492182", "Grevenbroich\-Kapellen",
"497225", "Gaggenau",
"4936483", "Ziegenrück",
"49651", "Trier",
"4933394", "Blumberg\ Kreis\ Barnim",
"495320", "Torfhaus",
"496333", "Waldfischbach\-Burgalben",
"4930", "Berlin",
"492242", "Hennef\ Sieg",
"492446", "Heimbach\ Eifel",
"497583", "Bad\ Schussenried",
"494875", "Stafstedt",
"4935434", "Altdöbern",
"492564", "Vreden",
"494252", "Bruchhausen\-Vilsen",
"4936922", "Gerstungen",
"498266", "Kirchheim\ in\ Schwaben",
"494456", "Varel\-Altjührden",
"4934600", "Ostrau\ Saalkreis",
"4939856", "Beenz\ bei\ Prenzlau",
"498462", "Berching",
"497145", "Markgröningen",
"499392", "Faulbach\ Unterfranken",
"496066", "Michelstadt\-Vielbrunn",
"4934345", "Bad\ Lausick",
"497668", "Ihringen",
"495694", "Diemelstadt",
"499082", "Oettingen\ in\ Bayern",
"494707", "Langen\-Neuenwalde",
"499448", "Hausen\ Niederbayern",
"495823", "Bienenbüttel",
"499105", "Grosshabersdorf",
"499651", "Vohenstrauss",
"498136", "Markt\ Indersdorf",
"4939889", "Boitzenburg",
"4937381", "Penig",
"4938352", "Kemnitz\ bei\ Greifswald",
"498637", "Lohkirchen",
"4933398", "Werneuchen",
"494732", "Stadland\-Rodenkirchen",
"495774", "Wagenfeld\-Ströhen",
"494921", "Emden\ Stadt",
"495205", "Bielefeld\-Sennestadt",
"495883", "Lemgow",
"493737", "Rochlitz",
"492381", "Hamm\ Westfalen",
"497052", "Bad\ Liebenzell",
"4934977", "Quellendorf",
"4939246", "Lindau\ Anh",
"4937432", "Pausa\ Vogtland",
"492273", "Kerpen\-Horrem",
"4939225", "Altengrabow",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497681", "Waldkirch\ Breisgau",
"494968", "Neulehe",
"4939928", "Möllenhagen",
"495832", "Hankensbüttel",
"494874", "Todenbüttel",
"4935724", "Lohsa",
"4938391", "Altenkirchen\ Rügen",
"496092", "Heimbuchenthal",
"496241", "Worms",
"492368", "Oer\-Erkenschwick",
"495336", "Semmenstedt",
"495807", "Altenmedingen",
"494723", "Cuxhaven\-Altenwalde",
"499547", "Zapfendorf",
"492565", "Gronau\-Epe",
"497621", "Lörrach",
"4936207", "Plaue\ Thüringen",
"4939825", "Wokuhl",
"495471", "Bohmte",
"497144", "Marbach\ am\ Neckar",
"4933089", "Himmelpfort",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"494277", "Schwaförden",
"495695", "Twistetal",
"496322", "Bad\ Dürkheim",
"499553", "Ebrach\ Oberfranken",
"4935823", "Ostritz",
"4934297", "Liebertwolkwitz",
"493331", "Angermünde",
"499104", "Emskirchen",
"499366", "Geroldshausen\ Unterfranken",
"495063", "Bad\ Salzdetfurth",
"496826", "Bexbach",
"496382", "Lauterecken",
"498041", "Bad\ Tölz",
"498292", "Dinkelscherben",
"497532", "Meersburg",
"4935728", "Uhyst\ Spree",
"495775", "Diepenau",
"495204", "Steinhagen\ Westfalen",
"4939924", "Stuer",
"499431", "Schwandorf",
"496506", "Welschbillig",
"495765", "Raddestorf",
"499255", "Marktleugast",
"4938859", "Alt\ Zachun",
"4939382", "Kamern",
"4937327", "Rechenberg\-Bienenmühle",
"493544", "Luckau\ Brandenburg",
"4936762", "Steinach\ Thüringen",
"499376", "Collenberg",
"495073", "Neustadt\-Esperke",
"492409", "Stolberg\-Gressenich",
"492133", "Dormagen",
"499872", "Heilsbronn",
"495155", "Emmerthal",
"495601", "Schauenburg",
"4939404", "Ausleben",
"498457", "Vohburg\ an\ der\ Donau",
"4938373", "Katzow",
"494267", "Lauenbrück",
"493466", "Artern\ Unstrut",
"495527", "Duderstadt",
"495461", "Bramsche\ Hase",
"4939408", "Hadmersleben",
"498443", "Hohenwart\ Paar",
"498706", "Vilsheim",
"496644", "Grebenhain",
"499735", "Massbach",
"493606", "Heiligenstadt\ Heilbad",
"492575", "Greven\-Reckenfeld",
"492378", "Fröndenberg\-Langschede",
"494137", "Barendorf",
"494864", "Oldenswort",
"496181", "Hanau",
"494102", "Ahrensburg",
"494636", "Langballig",
"492263", "Engelskirchen",
"4938757", "Neustadt\-Glewe",
"4939721", "Liepen\ bei\ Anklam",
"497224", "Gernsbach",
"498549", "Vilshofen\-Pleinting",
"4936256", "Wechmar",
"495182", "Gronau\ Leine",
"499190", "Heroldsbach",
"497277", "Wörth\-Büchelberg",
"499426", "Oberschneiding",
"498333", "Babenhausen\ Schwaben",
"499222", "Presseck",
"499282", "Naila",
"495574", "Oberweser",
"496462", "Gladenbach",
"494532", "Bargteheide",
"496266", "Hassmersheim",
"4937438", "Bad\ Brambach",
"493537", "Jessen\ Elster",
"4939922", "Dambeck\ bei\ Röbel",
"4937434", "Bobenneukirchen",
"493949", "Oschersleben\ Bode",
"496136", "Nieder\-Olm",
"494681", "Wyk\ auf\ Föhr",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"4938320", "Tribsees",
"499341", "Tauberbischofsheim",
"4939000", "Beetzendorf",
"4936961", "Bad\ Liebenstein",
"492428", "Niederzier",
"492154", "Willich",
"4936335", "Grosswechsungen",
"498178", "Icking",
"499951", "Landau\ an\ der\ Isar",
"498066", "Bad\ Feilnbach",
"494144", "Himmelpforten",
"492291", "Waldbröl",
"49345", "Halle\ Saale",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"492764", "Welschen\ Ennest",
"496637", "Feldatal",
"494621", "Schleswig",
"497723", "Furtwangen\ im\ Schwarzwald",
"495381", "Seesen",
"493441", "Zeitz",
"492774", "Dietzhölztal",
"492205", "Rösrath",
"499534", "Burgpreppach",
"497025", "Neuffen",
"494284", "Selsingen",
"49671", "Bad\ Kreuznach",
"49391", "Magdeburg",
"498076", "Pfaffing",
"498168", "Attenkirchen",
"494224", "Gross\ Ippener",
"497085", "Enzklösterle",
"492823", "Goch",
"497636", "Münstertal\ Schwarzwald",
"4939388", "Goldbeck\ Altm",
"492694", "Wershofen",
"495321", "Goslar",
"496355", "Albisheim\ Pfrimm",
"496558", "Büdesheim\ Eifel",
"493745", "Falkenstein\ Vogtland",
"498238", "Gessertshausen",
"494920", "Wirdum",
"495564", "Dassel",
"496472", "Weilmünster",
"496276", "Hesseneck",
"497395", "Ehingen\-Dächingen",
"499142", "Treuchtlingen",
"4939384", "Arendsee\ Altmark",
"4933979", "Wusterhausen\ Dosse",
"4936764", "Neuhaus\-Schierschnitz",
"4939776", "Hintersee",
"4939402", "Völpke",
"49851", "Passau",
"497267", "Gemmingen",
"496831", "Saarlouis",
"495446", "Rehden",
"494827", "Wacken",
"493386", "Premnitz",
"495703", "Hille",
"495242", "Rheda\-Wiedenbrück",
"4939483", "Ballenstedt",
"494646", "Mohrkirch",
"492157", "Nettetal\-Kaldenkirchen",
"4938759", "Tewswoos",
"4938378", "Heringsdorf\ Seebad",
"496362", "Alsenz",
"495083", "Hohne\ bei\ Celle",
"499822", "Bechhofen\ an\ der\ Heide",
"499386", "Prosselsheim",
"496634", "Gemünden\ Felda",
"499745", "Wildflecken",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"499326", "Markt\ Einersheim",
"498433", "Königsmoos",
"496866", "Perl\-Nennig",
"492656", "Virneburg",
"497705", "Wolterdingen\ Schwarzw",
"497274", "Germersheim",
"494504", "Ratekau",
"4939221", "Möckern\ bei\ Magdeburg",
"494153", "Lauenburg\ Elbe",
"49991", "Deggendorf",
"494928", "Ihlow\-Riepe",
"498230", "Gablingen",
"4934636", "Schafstädt",
"49335", "Frankfurt\ \(Oder\)",
"496550", "Irrhausen",
"492585", "Warendorf\-Hoetmar",
"492388", "Hamm\-Uentrop",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"496171", "Oberursel\ Taunus",
"494763", "Gnarrenburg",
"4936607", "Niederpöllnitz",
"497661", "Kirchzarten",
"492525", "Beckum\-Neubeckum",
"499441", "Kelheim",
"499658", "Georgenberg",
"4939482", "Gatersleben",
"4937329", "Grosshartmannsdorf",
"4939821", "Carpin",
"4938374", "Lassan\ bei\ Wolgast",
"498031", "Rosenheim\ Oberbayern",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"492689", "Dierdorf",
"499198", "Heiligenstadt\ in\ Oberfranken",
"497671", "Todtnau",
"494773", "Lamstedt",
"496161", "Brensbach",
"494884", "Schwabstedt",
"497542", "Tettnang",
"499359", "Karlstadt\-Wiesenfeld",
"4935057", "Hermsdorf\ Erzgebirge",
"494824", "Krempe",
"4933087", "Bredereiche",
"4939923", "Priborn",
"496751", "Bad\ Sobernheim",
"492223", "Königswinter",
"4939746", "Krackow",
"493341", "Strausberg",
"497264", "Bad\ Rappenau",
"4934299", "Gaschwitz",
"495481", "Lengerich\ Westfalen",
"498170", "Strasslach\-Dingharting",
"495956", "Rastdorf",
"4936209", "Klettbach",
"494287", "Heeslingen\-Boitzen",
"495725", "Lindhorst\ bei\ Stadthagen",
"4939080", "Kalbe\ Milde",
"495346", "Liebenburg",
"492196", "Wermelskirchen",
"497134", "Weinsberg",
"4935723", "Bernsdorf\ OL",
"496876", "Weiskirchen\ Saar",
"492777", "Breitscheid\ Hessen",
"4935240", "Tauscha\ bei\ Grossenhain",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"492697", "Blankenheim\-Ahrhütte",
"496372", "Bruchmühlbach\-Miesau",
"496231", "Hochdorf\-Assenheim",
"498551", "Freyung",
"495842", "Schnega",
"4935828", "Reichenbach\ OL",
"496455", "Frankenau\ Hessen",
"499502", "Frensdorf",
"4939996", "Törpin",
"495371", "Gifhorn",
"499107", "Trautskirchen",
"492873", "Isselburg\-Werth",
"4939383", "Sandau\ Elbe",
"4936965", "Stadtlengsfeld",
"4933836", "Butzow\ bei\ Brandenburg",
"497153", "Plochingen",
"4936331", "Ilfeld",
"498026", "Hausham",
"495232", "Lage\ Lippe",
"494274", "Varrel\ bei\ Sulingen",
"494705", "Wremen",
"495436", "Nortrup",
"497504", "Horgenzell",
"496841", "Homburg\ Saar",
"498248", "Lamerdingen",
"495207", "Schloss\ Holte\-Stukenbrock",
"498086", "Buchbach\ Oberbayern",
"493735", "Marienberg\ Sachsen",
"494661", "Niebüll",
"492724", "Finnentrop\-Serkenrode",
"499132", "Herzogenaurach",
"4939484", "Harzgerode",
"4933977", "Gumtow",
"4938372", "Usedom",
"498635", "Pleiskirchen",
"497763", "Murg",
"499606", "Pfreimd",
"494877", "Hennstedt\ bei\ Itzehoe",
"496048", "Büdingen\-Eckartshausen",
"496286", "Walldürn\-Rippberg",
"494401", "Brake\ Unterweser",
"496482", "Runkel",
"495752", "Auetal\-Hattendorf",
"4939488", "Güntersberge",
"499262", "Wallenfels",
"497646", "Weisweil\ Breisgau",
"499466", "Stamsried",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4935796", "Panschwitz\-Kuckau",
"497147", "Sachsenheim\ Württemberg",
"496226", "Meckesheim",
"493431", "Döbeln",
"496422", "Kirchhain",
"495162", "Fallingbostel",
"4935385", "Annaburg",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"492608", "Welschneudorf",
"499544", "Baunach",
"495908", "Wietmarschen\-Lohne",
"493366", "Beeskow",
"495172", "Ilsede",
"494134", "Embsen\ Kreis\ Lüneburg",
"4937433", "Gutenfürst",
"499855", "Dentlein\ am\ Forst",
"495524", "Bad\ Lauterberg\ im\ Harz",
"496647", "Herbstein\-Stockhausen",
"4935696", "Briesnig",
"492309", "Waltrop",
"499272", "Fichtelberg",
"497227", "Lichtenau\ Baden",
"496146", "Hochheim\ am\ Main",
"495584", "Hattorf\ am\ Harz",
"494495", "Friesoythe\-Thüle",
"499331", "Ochsenfurt",
"492360", "Haltern\-Lippramsdorf",
"497773", "Bodman\-Ludwigshafen",
"494542", "Mölln\ Lauenburg",
"494671", "Bredstedt",
"4935822", "Hagenwerder",
"4933451", "Heckelberg",
"496653", "Burghaun",
"494264", "Sottrum\ Kreis\ Rotenburg",
"498454", "Karlshuld",
"494791", "Osterholz\-Scharmbeck",
"492863", "Velen",
"498343", "Aitrang",
"497824", "Schwanau",
"492552", "Steinfurt\-Borghorst",
"495361", "Wolfsburg",
"498161", "Freising",
"499854", "Wittelshofen",
"494135", "Kirchgellersen",
"494329", "Langwedel\ Holstein",
"495143", "Winsen\ Aller",
"495525", "Walkenried",
"492393", "Sundern\-Allendorf",
"497971", "Gaildorf",
"495328", "Altenau\ Harz",
"496031", "Friedberg\ Hessen",
"499737", "Wartmannsroth",
"499243", "Pottenstein",
"493448", "Meuselwitz\ Thüringen",
"4938458", "Zehna",
"495585", "Herzberg\-Sieber",
"498751", "Mainburg",
"4936923", "Treffurt",
"494494", "Bösel\ Oldenburg",
"4938454", "Kritzkow",
"4939209", "Wanzleben",
"497742", "Klettgau",
"497203", "Walzbachtal",
"495656", "Waldkappel",
"496838", "Saarwellingen",
"497660", "St\ Peter\ Schwarzwald",
"495767", "Warmsen",
"499257", "Zell\ Oberfranken",
"4938353", "Gützkow\ bei\ Greifswald",
"494265", "Fintel",
"496551", "Prüm",
"498231", "Königsbrunn\ bei\ Augsburg",
"498372", "Obergünzburg",
"495157", "Emmerthal\-Börry",
"497825", "Kippenheim",
"499492", "Parsberg",
"494946", "Grossefehn\-Bagband",
"494356", "Gross\ Wittensee",
"498362", "Füssen",
"492842", "Kamp\-Lintfort",
"497308", "Nersingen",
"4939862", "Schmölln\ bei\ Prenzlau",
"497505", "Fronreute",
"494275", "Ehrenburg",
"4934493", "Gössnitz\ Thüringen",
"494704", "Drangstedt",
"495777", "Diepenau\-Essern",
"4935329", "Dollenchen",
"495196", "Wietzendorf",
"4939262", "Güsten\ Anh",
"494852", "Brunsbüttel",
"4939036", "Binde",
"492725", "Lennestadt\-Oedingen",
"496433", "Hadamar",
"496109", "Frankfurt\-Bergen\-Enkheim",
"494563", "Scharbeutz\-Haffkrug",
"498634", "Garching\ an\ der\ Alz",
"4936646", "Tanna\ bei\ Schleiz",
"498550", "Philippsreut",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4936625", "Langenwetzendorf",
"495223", "Bünde",
"493843", "Güstrow",
"499183", "Burgthann",
"499123", "Lauf\ an\ der\ Pegnitz",
"4939607", "Kotelow",
"497961", "Ellwangen\ Jagst",
"499348", "Werbach\-Gamburg",
"495805", "Oetzen",
"495283", "Lügde\-Rischenau",
"492421", "Düren",
"492567", "Ahaus\-Alstätte",
"499545", "Buttenheim",
"498171", "Wolfratshausen",
"4936482", "Triptis",
"496059", "Jossgrund",
"495608", "Söhrewald",
"4938452", "Lalendorf",
"492804", "Xanten\-Marienbaum",
"492162", "Viersen",
"4939887", "Gerswalde",
"494609", "Eggebek",
"496357", "Standenbühl",
"497573", "Stetten\ am\ kalten\ Markt",
"494885", "Bergenhusen",
"494742", "Dorum",
"494203", "Weyhe\ bei\ Bremen",
"499438", "Fensterbach",
"494825", "Burg\ Dithmarschen",
"492752", "Bad\ Laasphe",
"4934445", "Stössen",
"4934426", "Kayna",
"498146", "Moorenweis",
"497265", "Angelbachtal",
"4933475", "Letschin",
"496188", "Kahl\ am\ Main",
"494971", "Esens",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"499072", "Lauingen\ Donau",
"495724", "Obernkirchen",
"4935433", "Vetschau",
"497135", "Brackenheim",
"497329", "Steinheim\ am\ Albuch",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"492207", "Kürten\-Dürscheid",
"492436", "Wegberg\-Rödgen",
"495468", "Bramsche\-Engter",
"492232", "Brühl\ Rheinland",
"496343", "Bad\ Bergzabern",
"497389", "Heroldstatt",
"495873", "Eimke",
"498259", "Schiltberg",
"494469", "Wangerooge",
"496454", "Lichtenfels\-Sachsenberg",
"492371", "Iserlohn",
"496128", "Taunusstein",
"495552", "Katlenburg",
"498841", "Murnau\ am\ Staffelsee",
"492361", "Recklinghausen",
"496026", "Grossostheim",
"495863", "Zernien",
"4939268", "Egeln",
"497628", "Efringen\-Kirchen",
"494479", "Molbergen\-Peheim",
"4934341", "Geithain",
"498193", "Geltendorf",
"496635", "Kirtorf",
"499744", "Zeitlofs\-Detter",
"494961", "Papenburg",
"4936484", "Knau\ bei\ Pössneck",
"499906", "Mariaposching",
"496086", "Grävenwiesbach",
"494505", "Stockelsdorf\-Curau",
"497704", "Geisingen\ Baden",
"497275", "Kandel",
"496396", "Hinterweidenthal",
"499833", "Heidenheim\ Mittelfranken",
"494308", "Schwedeneck",
"492584", "Warendorf\-Milte",
"497356", "Schemmerhofen",
"495309", "Lehre\-Wendhausen",
"497946", "Bretzfeld",
"497563", "Kisslegg",
"4939264", "Kroppenstedt",
"492524", "Ennigerloh",
"497852", "Willstätt",
"498422", "Dollnstein",
"495032", "Neustadt\ am\ Rübenberge",
"498226", "Bibertal",
"493338", "Bernau\ Brandenburg",
"4938847", "Boizenburg\ Elbe",
"4934906", "Raguhn",
"493535", "Herzberg\ Elster",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"495573", "Uslar\-Volpriehausen",
"4938334", "Grammendorf",
"4934922", "Mühlanger",
"499165", "Sugenheim",
"4938850", "Gammelin",
"494767", "Bremervörde\-Bevern",
"493762", "Crimmitschau",
"495265", "Dörentrup",
"499926", "Frauenau",
"498334", "Bad\ Grönenbach",
"492646", "Königsfeld\ Eifel",
"49931", "Würzburg",
"495135", "Burgwedel\-Fuhrberg",
"495329", "Schulenberg\ im\ Oberharz",
"4937343", "Jöhstadt",
"494143", "Drochtersen",
"4936076", "Niederorschel",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494525", "Ahrensbök",
"492763", "Drolshagen\-Bleche",
"49395", "Neubrandenburg",
"495027", "Linsburg",
"494328", "Rickling",
"498206", "Egling\ an\ der\ Paar",
"499235", "Thierstein",
"498402", "Münchsmünster",
"492928", "Soest\-Ostönnen",
"499451", "Schierling",
"492153", "Nettetal\-Lobberich",
"499648", "Neustadt\ am\ Kulm",
"495494", "Holdorf\ Niedersachsen",
"492504", "Telgte",
"4935452", "Golssen",
"496592", "Daun",
"497478", "Hirrlingen",
"494223", "Ganderkesee\-Bookholzberg",
"49341", "Leipzig",
"492693", "Antweiler",
"497552", "Pfullendorf",
"492824", "Kalkar",
"4939087", "Jerchel\ Altmark",
"492773", "Haiger",
"499349", "Werbach\-Wenkheim",
"492065", "Duisburg\-Rheinhausen",
"494283", "Tarmstedt",
"496741", "St\ Goar",
"4935247", "Zehren\ Sachsen",
"493941", "Halberstadt",
"494805", "Schafstedt",
"4933746", "Werbig\ bei\ Jüterbog",
"499533", "Untermerzbach",
"4933923", "Flecken\ Zechlin",
"495946", "Georgsdorf",
"497309", "Weissenhorn",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"494480", "Ovelgönne\-Strückhausen",
"492227", "Bornheim\-Merten",
"495356", "Helmstedt\-Barmke",
"4937206", "Frankenberg\ Sachsen",
"4934776", "Rothenschirmbach",
"495275", "Höxter\-Ottbergen",
"495704", "Petershagen\-Friedewalde",
"494777", "Cadenberge",
"493772", "Schneeberg\ Erzgebirge",
"496108", "Mühlheim\ am\ Main",
"497032", "Herrenberg",
"4934384", "Grossbothen",
"499175", "Spalt",
"498541", "Vilshofen\ Niederbayern",
"495852", "Bleckede",
"496445", "Schöffengrund",
"495563", "Kreiensen",
"497328", "Königsbronn",
"495971", "Rheine",
"492661", "Bad\ Marienberg\ Westerwald",
"494724", "Cuxhaven\-Lüdingworth",
"49621", "Mannheim",
"497525", "Aulendorf",
"497143", "Besigheim",
"493596", "Neustadt\ in\ Sachsen",
"496851", "St\ Wendel",
"492274", "Elsdorf\ Rheinland",
"498258", "Sielenbach",
"4934928", "Seegrehna",
"494468", "Friedeburg\-Reepsholt",
"492590", "Dülmen\-Buldern",
"496335", "Trulben",
"496129", "Schlangenbad",
"497585", "Ostrach",
"494873", "Aukrug",
"4935454", "Uckro",
"4939062", "Bebertal",
"4939977", "Jördenstorf",
"497388", "Pfronstetten",
"496696", "Gilserberg",
"494608", "Handewitt",
"495064", "Gross\ Düngen",
"4938332", "Gross\ Bisdorf",
"4934924", "Zahna",
"496058", "Gründau",
"495609", "Ahnatal",
"4936021", "Schlotheim",
"497656", "Schluchsee",
"495203", "Werther\ Westfalen",
"495742", "Preussisch\ Oldendorf",
"4933970", "Neustadt\ Dosse",
"495825", "Wieren",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4933876", "Buschow",
"497157", "Waldenbuch",
"4936371", "Schlossvippach",
"492401", "Baesweiler",
"499103", "Cadolzburg",
"499439", "Neunburg\-Kemnath",
"496776", "Dachsenhausen",
"499554", "Untersteinbach\ Unterfranken",
"493976", "Torgelow\ bei\ Ueckermünde",
"496766", "Kisselbach",
"495505", "Hardegsen",
"493966", "Cölpin",
"492867", "Heiden\ Kreis\ Borken",
"499845", "Oberdachstetten",
"498347", "Friesenried",
"495308", "Lehre",
"496657", "Hofbieber",
"4934382", "Nerchau",
"497420", "Deisslingen",
"495074", "Rodewald",
"499722", "Werneck",
"499931", "Plattling",
"497777", "Sauldorf",
"494552", "Leezen",
"4934721", "Nienburg\ Saale",
"494863", "Sankt\ Peter\-Ording",
"4969", "Frankfurt\ am\ Main",
"497223", "Bühl\ Baden",
"4938427", "Blowatz",
"4939451", "Wasserleben",
"4939009", "Badel",
"492264", "Marienheide",
"494478", "Cappeln\ Oldenburg",
"497629", "Tegernau\ Baden",
"496643", "Herbstein",
"498444", "Schweitenkirchen",
"4933369", "Oderberg",
"497805", "Appenweier",
"496249", "Guntersblum",
"495961", "Haselünne",
"492671", "Cochem",
"492542", "Gescher",
"495504", "Friedland\ Kreis\ Göttingen",
"497436", "Messstetten\-Oberdigisheim",
"494929", "Ihlow\ Kreis\ Aurich",
"4936949", "Obermassfeld\-Grimmenthal",
"497232", "Königsbach\-Stein",
"499844", "Obernzenn",
"495153", "Salzhemmendorf",
"492389", "Werne",
"4938796", "Viesecke",
"4935206", "Kreischa\ bei\ Dresden",
"497371", "Riedlingen\ Württemberg",
"498592", "Wegscheid\ Niederbayern",
"4934263", "Hohburg",
"492993", "Marsberg\-Canstein",
"495763", "Uchte",
"4936087", "Wüstheuterode",
"499253", "Weissenstadt",
"494393", "Boostedt",
"499659", "Leuchtenberg",
"498741", "Vilsbiburg",
"493641", "Jena",
"495646", "Willebadessen",
"4933209", "Caputh",
"4938737", "Ganzlin",
"492265", "Reichshof\-Eckenhagen",
"498445", "Gerolsbach",
"496672", "Eiterfeld",
"499733", "Münnerstadt",
"497804", "Oppenau",
"496541", "Traben\-Trarbach",
"497162", "Süssen",
"495147", "Uetze\-Hänigsen",
"492573", "Nordwalde",
"4935022", "Bad\ Schandau",
"492563", "Stadtlohn",
"494956", "Uplengen",
"4939600", "Zwiedorf",
"492852", "Hamminkeln",
"494346", "Gettorf",
"497524", "Bad\ Waldsee",
"494725", "Helgoland",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"497172", "Lorch\ Württemberg",
"4938222", "Semlow",
"499127", "Rosstal\ Mittelfranken",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492275", "Kerpen\-Buir",
"4938481", "Witzin",
"499187", "Altdorf\ bei\ Nürnberg",
"496334", "Thaleischweiler\-Fröschen",
"499626", "Hohenburg",
"497584", "Altshausen",
"494842", "Nordstrand",
"493847", "Sternberg",
"499199", "Kunreuth",
"494421", "Wilhelmshaven",
"493562", "Forst\ Lausitz",
"495065", "Sibbesse",
"492688", "Kroppach",
"495773", "Stemwede\-Wehdem",
"49365", "Gera",
"497361", "Aalen",
"4933607", "Briesen\ Mark",
"495824", "Bad\ Bodenteich",
"495693", "Volkmarsen",
"492628", "Rhens",
"499358", "Gössenheim",
"4939345", "Parchen",
"499555", "Schlüsselfeld\-Aschbach",
"496402", "Hungen",
"494481", "Hatten\-Sandkrug",
"494298", "Lilienthal",
"496206", "Lampertheim",
"499948", "Eschlkam",
"4939959", "Dargun",
"496049", "Kefenrod",
"498657", "Ramsau\ bei\ Berchtesgaden",
"497083", "Bad\ Herrenalb",
"493834", "Greifswald",
"495401", "Georgsmarienhütte",
"496347", "Hochstadt\ Pfalz",
"492591", "Lüdinghausen",
"492825", "Uedem",
"494752", "Neuhaus\ Oste",
"498766", "Gammelsdorf",
"492203", "Cologne\-Porz",
"492742", "Wissen",
"4935473", "Neu\ Lübbenau",
"4935024", "Stadt\ Wehlen",
"494804", "Nordhastedt",
"492064", "Dinslaken",
"494162", "Jork",
"4934609", "Salzmünde",
"499631", "Tirschenreuth",
"4933435", "Rehfelde",
"497023", "Weilheim\ an\ der\ Teck",
"494371", "Burg\ auf\ Fehmarn",
"4939393", "Werben\ Elbe",
"4989", "Munich",
"4936451", "Buttelstedt",
"496566", "Körperich",
"4935028", "Krippen",
"495274", "Nieheim",
"494232", "Langwedel\ Kreis\ Verden",
"495705", "Petershagen\-Windheim",
"497577", "Veringenstadt",
"494207", "Oyten",
"4937366", "Rübenau",
"499522", "Eltmann",
"496353", "Freinsheim",
"498249", "Ettringen\ Wertach",
"497393", "Munderkingen",
"492971", "Schmallenberg\-Dorlar",
"495661", "Melsungen",
"499174", "Hilpoltstein",
"496444", "Bischoffen",
"498851", "Kochel\ am\ See",
"495542", "Witzenhausen",
"4938828", "Schönberg",
"499802", "Ansbach\-Katterbach",
"492961", "Brilon",
"495671", "Hofgeismar",
"499164", "Langenfeld\ Mittelfranken",
"49821", "Augsburg",
"497567", "Leutkirch\-Friesenhofen",
"4934207", "Zwochau",
"4933965", "Herzsprung\ bei\ Wittstock",
"4933763", "Bestensee",
"4933331", "Casekow",
"4938723", "Kladrum",
"495264", "Kalletal",
"499306", "Kist",
"499837", "Haundorf",
"498335", "Fellheim",
"498538", "Pocking\-Hartkirchen",
"4938228", "Dettmannsdorf\-Kölzow",
"494361", "Oldenburg\ in\ Holstein",
"496258", "Gernsheim",
"4933656", "Bahro",
"494172", "Salzhausen",
"497346", "Illerkirchberg",
"4938224", "Gresenhorst",
"494524", "Scharbeutz\-Pönitz",
"495909", "Wettrup",
"4938301", "Putbus",
"497725", "Königsfeld\ im\ Schwarzwald",
"499234", "Neusorg",
"497842", "Kappelrodeck",
"4938824", "Mallentin",
"492308", "Unna\-Hemmerde",
"495495", "Vörden\ Kreis\ Vechta",
"492505", "Altenberge\ Westfalen",
"497935", "Schrozberg",
"493464", "Sangerhausen",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"4935954", "Grossharthau",
"494171", "Winsen\ Luhe",
"496763", "Kirchberg\ Hunsrück",
"493963", "Woldegk",
"4939853", "Holzendorf\ bei\ Prenzlau",
"493546", "Lübben\ Spreewald",
"4936742", "Uhlstädt",
"497193", "Sulzbach\ an\ der\ Murr",
"499374", "Eschau",
"494550", "Bühnsdorf",
"498628", "Kienberg\ Oberbayern",
"4938309", "Trent",
"497841", "Achern",
"496504", "Thalfang",
"492839", "Straelen\-Herongen",
"497226", "Bühl\-Sand",
"496147", "Trebur",
"497422", "Schramberg",
"495541", "Hann\.\ Münden",
"495672", "Bad\ Karlshafen",
"499720", "Üchtelhausen",
"492962", "Olsberg",
"494634", "Husby",
"498563", "Bad\ Birnbach\ Rottal",
"4933470", "Lietzen",
"4939754", "Löcknitz\ Vorpom",
"494362", "Heiligenhafen",
"4933437", "Reichenberg\ bei\ Strausberg",
"497482", "Horb\-Dettingen",
"4934424", "Reuden\ bei\ Zeitz",
"496646", "Grebenau",
"498704", "Altdorf\-Pfettrach",
"498265", "Pfaffenhausen\ Schwaben",
"494455", "Jade\-Schweiburg",
"494231", "Verden\ Aller",
"497146", "Remseck\ am\ Neckar",
"4935751", "Welzow",
"496227", "Walldorf\ Baden",
"49906", "Donauwörth",
"497739", "Hilzingen",
"493377", "Zossen\ Brandenburg",
"4937293", "Eppendorf\ Sachsen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"494372", "Westfehmarn",
"492972", "Schmallenberg",
"495662", "Felsberg\ Hessen",
"4936691", "Eisenberg\ Thüringen",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"498573", "Ering",
"4934904", "Oranienbaum",
"494876", "Reher\ Holstein",
"496287", "Limbach\ Baden",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4939266", "Förderstedt",
"499467", "Michelsneukirchen",
"492445", "Schleiden\ Eifel",
"499521", "Hassfurt",
"4936459", "Blankenhain\ Thüringen",
"495206", "Bielefeld\-Jöllenbeck",
"497653", "Lenzkirch",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"492592", "Selm",
"494751", "Otterndorf",
"497259", "Östringen\-Odenheim",
"4936878", "Oberland",
"498389", "Weissensberg",
"499364", "Zellingen",
"4934205", "Markranstädt",
"4933967", "Freyenstein",
"499607", "Luhe\-Wildenau",
"4936642", "Harra",
"496693", "Neuental",
"4934601", "Teutschenthal",
"496824", "Ottweiler",
"494161", "Buxtehude",
"496773", "Kamp\-Bornhofen",
"499632", "Waldsassen",
"493973", "Pasewalk",
"498135", "Sulzemoos",
"499106", "Markt\ Erlbach",
"4939951", "Faulenrost",
"492741", "Betzdorf",
"498027", "Dietramszell",
"495437", "Menslage",
"492696", "Nohn\ Eifel",
"497634", "Sulzburg",
"498074", "Schnaitsee",
"498670", "Reischach\ Kreis\ Altötting",
"493561", "Guben",
"492058", "Wülfrath",
"494422", "Sande\ Kreis\ Friesl",
"4938456", "Langhagen\ bei\ Güstrow",
"4938735", "Plau\ am\ See",
"495850", "Neetze",
"495957", "Lindern\ Oldenburg",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4936843", "Benshausen",
"498505", "Hutthurm",
"499536", "Kirchlauter",
"494286", "Gyhum",
"495347", "Burgdorf\ bei\ Salzgitter",
"496401", "Grünberg\ Hessen",
"494482", "Hatten",
"497362", "Bopfingen",
"492776", "Bad\ Endbach\-Hartenrod",
"4934422", "Osterfeld",
"497171", "Schwäbisch\ Gmünd",
"495444", "Wagenfeld",
"4935952", "Grossröhrsdorf\ OL",
"496661", "Schlüchtern",
"49221", "Cologne",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"495353", "Königslutter\ am\ Elm",
"494935", "Juist",
"495943", "Emlichheim",
"492851", "Rees",
"496274", "Waldbrunn\ Odenwald",
"492538", "Drensteinfurt\-Rinkerode",
"494841", "Husum\ Nordsee",
"4936085", "Reinholterode",
"4936744", "Remda",
"492335", "Wetter\ Ruhr",
"492129", "Haan\ Rheinland",
"494193", "Henstedt\-Ulzburg",
"499778", "Fladungen",
"495258", "Salzkotten",
"4939038", "Henningen",
"499097", "Marxheim",
"496003", "Rosbach\ von\ der\ Höhe",
"493991", "Waren\ Müritz",
"4936644", "Hirschberg\ Saale",
"498469", "Freystadt\-Burggriesbach",
"497751", "Waldshut",
"499484", "Brennberg",
"496264", "Neudenau",
"4933201", "Gross\ Glienicke",
"492643", "Altenahr",
"499158", "Offenhausen\ Mittelfranken",
"499424", "Strasskirchen",
"4933605", "Boossen",
"499923", "Teisnach",
"4939347", "Kade",
"497161", "Göppingen",
"496542", "Bullay",
"498825", "Krün",
"498591", "Obernzell",
"496867", "Perl",
"494146", "Stade\-Bützfleth",
"497231", "Pforzheim",
"492657", "Uersfeld",
"497455", "Dornhan",
"498064", "Au\ bei\ Bad\ Aibling",
"4939034", "Fleetmark",
"492156", "Willich\-Anrath",
"493571", "Hoyerswerda",
"4938231", "Barth",
"499089", "Bissingen\-Unterringingen",
"4936941", "Wasungen",
"496134", "Mainz\-Kastel",
"4934785", "Sandersleben",
"4936648", "Dittersdorf\ bei\ Schleiz",
"498203", "Grossaitingen",
"498742", "Velden\ Vils",
"4933733", "Stülpe",
"4933361", "Joachimsthal",
"4935775", "Pechern",
"4935973", "Stolpen",
"494551", "Bad\ Segeberg",
"4933238", "Senzke",
"496265", "Billigheim\ Baden",
"4933838", "Päwesin",
"492672", "Treis\-Karden",
"495962", "Herzlake",
"492541", "Coesfeld",
"496397", "Leimen\ Pfalz",
"499303", "Eibelstadt",
"494838", "Tellingstedt",
"4939295", "Zuchau",
"497357", "Attenweiler",
"4939998", "Loitz\ bei\ Demmin",
"4938204", "Broderstorf",
"4939001", "Apenburg",
"496573", "Gillenfeld",
"4939459", "Hasselfelde",
"495839", "Wittingen\-Ohrdorf",
"497947", "Forchtenberg",
"4938321", "Martensdorf\ bei\ Stralsund",
"4934632", "Mücheln\ Geiseltal",
"498824", "Oberau\ Loisach",
"497953", "Blaufelden",
"4933834", "Pritzerbe",
"497343", "Buch\ bei\ Illertissen",
"4938782", "Reetz\ bei\ Perleberg",
"4938208", "Kavelstorf",
"497454", "Sulz\ am\ Neckar",
"4939994", "Metschow",
"496087", "Waldems",
"499907", "Zenting",
"497128", "Sonnenbühl",
"499721", "Schweinfurt",
"499932", "Osterhofen",
"496027", "Stockstadt\ am\ Main",
"498065", "Tuntenhausen\-Schönau",
"4933234", "Wustermark",
"496135", "Bodenheim\ Rhein",
"496329", "Weidenthal\ Pfalz",
"4935893", "Mücka",
"4939773", "Altwarp",
"4939975", "Thürkow",
"498773", "Neufahrn\ in\ Niederbayern",
"499869", "Wettringen\ Mittelfranken",
"4936379", "Holzengel",
"497635", "Schliengen",
"495741", "Lübbecke",
"498075", "Amerang",
"493663", "Schleiz",
"4938425", "Kirchdorf\ Poel",
"4936253", "Georgenthal\ Thüringer\ Wald",
"497248", "Marxzell",
"498504", "Tittling",
"4939742", "Brüssow\ bei\ Pasewalk",
"497026", "Lenningen",
"498153", "Wessling",
"496628", "Oberaula",
"4935698", "Hornow",
"49203", "Duisburg",
"494230", "Verden\-Walle",
"495592", "Gleichen\-Bremke",
"492402", "Stolberg\ Rheinland",
"4936029", "Menteroda",
"492206", "Overath",
"495445", "Drebber",
"496563", "Kyllburg",
"494433", "Dötlingen",
"494109", "Tangstedt\ Bz\ Hamburg",
"4935694", "Gosda\ bei\ Klinge",
"493385", "Rathenow",
"496852", "Nohfelden",
"493588", "Niesky",
"495108", "Gehrden\ Han",
"492662", "Hachenburg",
"494934", "Marienhafe",
"493904", "Haldensleben",
"496275", "Rothenberg\ Odenwald",
"496704", "Langenlonsheim",
"492334", "Hagen\-Hohenlimburg",
"496356", "Carlsberg\ Pfalz",
"493528", "Radeberg",
"4933633", "Spreenhagen",
"499208", "Bindlach",
"4933832", "Rogäsen",
"499289", "Schwarzenbach\ am\ Wald",
"494454", "Jade",
"494128", "Kollmar",
"493691", "Eisenach\ Thüringen",
"499683", "Friedenfels",
"494539", "Westerau",
"496400", "Mücke",
"4939992", "Görmin",
"494343", "Laboe",
"495129", "Söhlde",
"495335", "Schladen",
"4938784", "Kleinow\ Kreis\ Prignitz",
"492566", "Legden",
"49911", "Nuremberg",
"494953", "Bunde",
"495851", "Dahlenburg",
"498542", "Ortenburg",
"4938376", "Zirchow",
"492943", "Erwitte",
"492353", "Halver",
"498671", "Altötting",
"49521", "Bielefeld",
"493771", "Aue\ Sachsen",
"499229", "Mainleus",
"492444", "Schleiden\-Gemünd",
"4933232", "Brieselang",
"497031", "Böblingen",
"494188", "Welle\ Nordheide",
"495776", "Preussisch\ Ströhen",
"497551", "Überlingen\ Bodensee",
"495197", "Soltau\-Frielingen",
"499365", "Rimpar",
"496591", "Gerolstein",
"498867", "Rottenbuch\ Oberbayern",
"496825", "Illingen\ Saar",
"499568", "Neustadt\ bei\ Coburg",
"492957", "Wünnenberg\-Haaren",
"4936652", "Wurzbach",
"492850", "Rees\-Haldern",
"4934638", "Zöschen",
"496742", "Boppard",
"496203", "Ladenburg",
"494947", "Aurich\-Ogenbargen",
"494357", "Sehestedt\ Eider",
"498134", "Odelzhausen",
"497838", "Nordrach",
"4938202", "Volkenshagen",
"4938788", "Gross\ Warnow",
"496660", "Steinau\-Marjoss",
"4935792", "Ossling",
"495696", "Bad\ Arolsen\-Landau",
"493475", "Lutherstadt\ Eisleben",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"4939748", "Viereck",
"497934", "Weikersheim",
"494892", "Schenefeld\ Mittelholstein",
"496670", "Ludwigsau\ Hessen",
"4935692", "Kerkwitz",
"496074", "Rödermark",
"495156", "Coppenbrügge",
"497433", "Balingen",
"4939243", "Nedlitz\ bei\ Zerbst",
"49201", "Essen",
"495657", "Meissner",
"499375", "Freudenberg\ Baden",
"496308", "Olsbrücken",
"496505", "Kordel",
"499452", "Langquaid",
"499256", "Stammbach",
"495766", "Rehburg\-Loccum",
"492738", "Netphen",
"494248", "Bassum\-Neubruchhausen",
"4935826", "Königshain\ bei\ Görlitz",
"493761", "Werdau\ Sachsen",
"498661", "Grabenstätt\ Chiemsee",
"4934461", "Nebra\ Unstrut",
"494635", "Sörup",
"495643", "Borgentreich",
"493605", "Leinefelde",
"4939085", "Zichtau",
"4939744", "Rothenklempenow",
"496479", "Waldbrunn\ Westerwald",
"499149", "Weissenburg\-Suffersheim",
"4935245", "Burkhardswalde\-Munzig",
"498274", "Buttenwiesen",
"499736", "Oberthulba",
"498705", "Altfraunhofen",
"4938792", "Lenzen\ \(Elbe\)",
"4935202", "Klingenberg\ Sachsen",
"497335", "Wiesensteig",
"4933477", "Trebnitz\ bei\ Müncheberg",
"497129", "Lichtenstein\ Württemberg",
"4937463", "Bergen\ Vogtland",
"496585", "Ralingen",
"492171", "Leverkusen\-Opladen",
"495031", "Wunstorf",
"499974", "Traitsching",
"498421", "Eichstätt\ Bayern",
"496328", "Elmstein",
"4936465", "Oberndorf\ bei\ Apolda",
"496525", "Irrel",
"499868", "Schillingsfürst",
"49721", "Karlsruhe",
"4937364", "Reitzenhain\ Erzgebirge",
"499473", "Kallmünz",
"497851", "Kehl",
"4939885", "Jakobshagen",
"496157", "Pfungstadt",
"499270", "Creussen",
"493685", "Hildburghausen",
"498785", "Rottenburg\-Oberroning",
"495551", "Northeim",
"492362", "Dorsten",
"493860", "Raben\ Steinfeld",
"4937368", "Deutschneudorf",
"494962", "Papenburg\-Aschendorf",
"492634", "Rengsdorf",
"493967", "Oertzenhof\ bei\ Strasburg",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"498725", "Wurmannsquick",
"492866", "Dorsten\-Rhade",
"498346", "Pforzen",
"495838", "Gross\ Oesingen",
"494839", "Wöhrden\ Dithmarschen",
"496656", "Ebersburg",
"498023", "Bayrischzell",
"494445", "Visbek\ Kreis\ Vechta",
"496420", "Lahntal",
"495109", "Ronnenberg",
"495433", "Badbergen",
"497156", "Ditzingen",
"4936733", "Kaulsdorf",
"4938226", "Dierhagen\ Ostseebad",
"496196", "Bad\ Soden\ am\ Taunus",
"494108", "Rosengarten\ Kreis\ Harburg",
"494972", "Langeoog",
"495934", "Haren\-Rütenbrock",
"499071", "Dillingen\ an\ der\ Donau",
"4933654", "Fünfeichen",
"499603", "Floss",
"496697", "Willingshausen",
"493529", "Heidenau\ Sachsen",
"499209", "Emtmannsberg",
"492372", "Hemer",
"4938826", "Dassow",
"499260", "Wilhelmsthal\ Oberfranken",
"4938845", "Kaarssen",
"498083", "Isen",
"497657", "Eisenbach\ Hochschwarzwald",
"492455", "Waldfeucht",
"497643", "Herbolzheim\ Breisgau",
"499463", "Wald\ Oberpfalz",
"496283", "Hardheim\ Odenwald",
"494741", "Nordholz\ bei\ Bremerhaven",
"497249", "Stutensee",
"498393", "Holzgünz",
"496805", "Kleinblittersdorf",
"492161", "Mönchengladbach",
"499964", "Stallwang",
"4939322", "Tangermünde",
"492751", "Bad\ Berleburg",
"496223", "Neckargemünd",
"496629", "Schenklengsfeld",
"494776", "Osten\-Altendorf",
"499569", "Sesslach",
"498584", "Breitenberg\ Niederbayern",
"492482", "Hellenthal",
"495840", "Schnackenburg",
"499675", "Altendorf\ am\ Nabburg",
"497839", "Schapbach",
"495947", "Laar\ Vechte",
"4935208", "Radeburg",
"492226", "Rheinbach",
"492422", "Kreuzau",
"495357", "Grasleben",
"4938293", "Kühlungsborn\ Ostseebad",
"497962", "Fichtenau",
"495128", "Hohenhameln",
"495454", "Hörstel\-Riesenbeck",
"496784", "Weierbach",
"4938794", "Cumlosen",
"492193", "Dabringhausen",
"493984", "Prenzlau",
"496873", "Nonnweiler",
"4935204", "Wilsdruff",
"499288", "Bad\ Steben",
"494335", "Hohn\ bei\ Rendsburg",
"499491", "Hemau",
"494129", "Haseldorf",
"495953", "Börger",
"496468", "Dautphetal\-Mornshausen",
"498361", "Nesselwang",
"492841", "Moers",
"492935", "Sundern\-Hachen",
"494851", "Marne",
"493423", "Eilenburg",
"499228", "Thurnau",
"494189", "Undeloh",
"4934653", "Rottleberode",
"496724", "Stromberg\ Hunsrück",
"49421", "Bremen",
"4937362", "Seiffen\ Erzgebirge",
"495248", "Langenberg\ Kreis\ Gütersloh",
"493391", "Neuruppin",
"498207", "Affing",
"495086", "Celle\-Scheuen",
"499383", "Wiesentheid",
"4939423", "Wegeleben",
"497741", "Tiengen\ Hochrhein",
"4934955", "Gossa",
"494249", "Bassum\-Nordwohlde",
"495635", "Vöhl",
"494643", "Gelting\ Angeln",
"492653", "Kaisersesch",
"4939605", "Gross\ Nemerow",
"496478", "Greifenstein\-Ulm",
"4938871", "Mühlen\ Eichsen",
"499148", "Ettenstatt",
"4939324", "Kläden\ bei\ Stendal",
"4939201", "Wolmirstedt",
"498232", "Schwabmünchen",
"495026", "Steimbke",
"499323", "Iphofen",
"499405", "Bad\ Abbach",
"496552", "Olzheim",
"4939328", "Rochau",
"497972", "Gschwend\ bei\ Gaildorf",
"4935603", "Burg\ Spreewald",
"499927", "Kirchberg\ Wald",
"496032", "Bad\ Nauheim",
"494156", "Talkau",
"4933652", "Neuzelle",
"492647", "Kesseling",
"499665", "Königstein\ Oberpfalz",
"497445", "Pfalzgrafenweiler",
"492739", "Wilnsdorf",
"499701", "Sandberg\ Unterfranken",
"499093", "Polsingen",
"496007", "Rosbach\-Rodheim",
"499820", "Lehrberg",
"498752", "Au\ in\ der\ Hallertau",
"494766", "Basdahl",
"4936781", "Grossbreitenbach",
"4939361", "Lüderitz",
"498196", "Pürgen",
"494541", "Ratzeburg",
"4934743", "Ermsleben",
"492838", "Sonsbeck",
"4934926", "Pretzsch\ Elbe",
"493677", "Ilmenau\ Thüringen",
"494672", "Langenhorn",
"495634", "Waldeck\-Sachsenhausen",
"496023", "Alzenau\ in\ Unterfranken",
"499903", "Schöllnach",
"496083", "Weilrod",
"494792", "Worpswede",
"495362", "Wolfsburg\-Fallersleben",
"492551", "Steinfurt\-Burgsteinfurt",
"4933874", "Stechow\ Brandenburg",
"497347", "Dietenheim",
"4935387", "Seyda",
"4934672", "Rossleben",
"499404", "Nittendorf",
"497957", "Kressberg",
"497943", "Schöntal\ Jagst",
"497353", "Schwendi",
"496393", "Fischbach\ bei\ Dahn",
"499836", "Gunzenhausen\-Cronheim",
"498805", "Hohenpeissenberg",
"499307", "Altertheim",
"498283", "Neuburg\ an\ der\ Kammel",
"497444", "Alpirsbach",
"4933878", "Nennhausen",
"4936967", "Geisa",
"4936072", "Weissenborn\-Lüderode",
"495171", "Peine",
"499664", "Hahnbach",
"4934244", "Mockrehna",
"498629", "Palling",
"493861", "Plate",
"499332", "Marktbreit",
"4935933", "Neschwitz",
"4935456", "Terpt",
"498223", "Ichenhausen",
"499271", "Thurnau\-Alladorf",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"497566", "Argenbühl",
"498388", "Hergensweiler",
"494402", "Rastede",
"4933673", "Weichensdorf",
"497576", "Krauchenwies",
"494206", "Stuhr\-Heiligenrode",
"496298", "Möckmühl",
"498585", "Grainet",
"4936043", "Kirchheilingen",
"495751", "Rinteln",
"499261", "Kronach",
"497258", "Oberderdingen\-Flehingen",
"493871", "Parchim",
"495161", "Walsrode",
"499070", "Tapfheim",
"499674", "Schönsee",
"4933742", "Oehna\ Brandenburg",
"498143", "Inning\ am\ Ammersee",
"496421", "Marburg",
"498328", "Balderschwang",
"496567", "Oberkail",
"4934772", "Helbra",
"495455", "Tecklenburg\-Brochterbeck",
"496842", "Blieskastel",
"496785", "Herrstein",
"492750", "Diedenshausen",
"495231", "Detmold",
"494334", "Bredenbek\ bei\ Rendsburg",
"495372", "Meinersen",
"498157", "Feldafing",
"4937202", "Claussnitz\ bei\ Chemnitz",
"497738", "Steisslingen",
"492934", "Sundern\-Altenhellefeld",
"494662", "Leck",
"498656", "Anger",
"499131", "Erlangen",
"4935364", "Lebusa",
"493304", "Velten",
"496346", "Annweiler\ am\ Trifels",
"493925", "Stassfurt",
"496725", "Gau\-Algesheim",
"494740", "Loxstedt\-Dedesdorf",
"492433", "Hückelhoven",
"494444", "Goldenstedt",
"4936423", "Orlamünde",
"4939832", "Wesenberg",
"494353", "Ascheffel",
"4936074", "Worbis",
"495935", "Twist\-Schöninghsdorf",
"499293", "Berg\ Oberfranken",
"494943", "Grossefehn",
"496207", "Wald\-Michelbach",
"4937603", "Wildenfels",
"496436", "Dornburg\ Hessen",
"495841", "Lüchow\ Wendland",
"498552", "Grafenau\ Niederbayern",
"492953", "Wünnenberg",
"496232", "Speyer",
"4936605", "Bad\ Köstritz",
"4934242", "Hohenpriessnitz",
"499779", "Nordheim\ von\ der\ Rhön",
"4936201", "Walschleben",
"4938855", "Lübtheen",
"495193", "Schneverdingen",
"496371", "Landstuhl",
"492454", "Gangelt",
"499186", "Lauterhofen\ Oberpfalz",
"497672", "St\ Blasien",
"496804", "Mandelbachtal",
"497541", "Friedrichshafen",
"499627", "Freudenberg\ Oberpfalz",
"496162", "Reinheim\ Odenwald",
"4934291", "Borsdorf",
"495422", "Melle",
"492357", "Herscheid\ Westfalen",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495226", "Bruchmühlen\ Westfalen",
"492947", "Anröchte",
"499965", "Sankt\ Englmar",
"494957", "Detern",
"496752", "Kirn\ Nahe",
"494347", "Flintbek",
"495482", "Tecklenburg",
"493342", "Neuenhagen\ bei\ Berlin",
"495286", "Ottenstein\ Niedersachsen",
"4933872", "Hohennauen",
"499126", "Eckental",
"4934774", "Röblingen\ am\ See",
"497334", "Deggingen",
"4933748", "Treuenbrietzen",
"4939053", "Süplingen",
"4939829", "Blankenförde",
"4937321", "Frankenstein\ Sachsen",
"496584", "Wellen\ Mosel",
"4937204", "Lichtenstein\ Sachsen",
"495146", "Wietze",
"498370", "Wiggensbach",
"4935362", "Schönewalde\ bei\ Herzberg",
"499975", "Waldmünchen\-Geigant",
"495647", "Lichtenau\-Kleinenberg",
"496524", "Rodershausen",
"4933843", "Niemegk",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499442", "Riedenburg",
"499088", "Mönchsdeggingen",
"499246", "Pegnitz\-Trockau",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"498468", "Altmannstein\-Pondorf",
"496361", "Rockenhausen",
"494258", "Schwarme",
"499398", "Birkenfeld\ bei\ Würzburg",
"495259", "Bad\ Driburg\-Neuenheerse",
"498784", "Hohenthann",
"497402", "Fluorn\-Winzeln",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"495653", "Sontra",
"4933744", "Hohenseefeld",
"4933085", "Seilershof",
"492635", "Rheinbrohl",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"498724", "Massing",
"493624", "Ohrdruf",
"4938751", "Picher",
"4939727", "Spantekow",
"492248", "Hennef\-Uckerath",
"4937208", "Auerswalde",
"4936370", "Grossenehrich",
"498378", "Buchenberg\ bei\ Kempten",
"492354", "Meinerzhagen",
"497586", "Herbertingen",
"496471", "Weilburg",
"499141", "Weissenburg\ in\ Bayern",
"4939052", "Erxleben\ bei\ Haldensleben",
"492944", "Rietberg\-Mastholte",
"4936337", "Schiedungen",
"492443", "Mechernich",
"499624", "Ensdorf\ Oberpfalz",
"493881", "Grevesmühlen",
"496336", "Dellfeld",
"493821", "Ribnitz\-Damgarten",
"499080", "Harburg\ Schwaben",
"495241", "Gütersloh",
"498669", "Traunreut",
"496832", "Beckingen\-Reimsbach",
"4935363", "Fermerswalde",
"4933678", "Storkow\ Mark",
"498263", "Breitenbrunn\ Schwaben",
"494453", "Zetel",
"4933971", "Kyritz\ Brandenburg",
"494954", "Moormerland",
"497748", "Grafenhausen\ Hochschwarzwald",
"4936020", "Ebeleben",
"494344", "Schönberg\ Holstein",
"498133", "Haimhausen\ Oberbayern",
"4939365", "Bellingen\ bei\ Stendal",
"4936785", "Gräfinau\-Angstedt",
"4939931", "Röbel\ Müritz",
"496775", "Strüth\ Taunus",
"496204", "Viernheim",
"4933674", "Trebatsch",
"499708", "Bad\ Bocklet",
"495826", "Suderburg",
"494447", "Vechta\-Langförden",
"495382", "Bad\ Gandersheim",
"496063", "Bad\ König",
"498460", "Berching\-Holnstein",
"497655", "Feldberg\-Altglashütten",
"495322", "Bad\ Harzburg",
"496695", "Jesberg",
"497195", "Winnenden",
"499342", "Wertheim",
"4936422", "Reinstädt\ Thüringen",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"499952", "Eichendorf",
"494682", "Amrum",
"496155", "Griesheim\ Hessen",
"4937602", "Kirchberg\ Sachsen",
"496599", "Weidenbach\ bei\ Gerolstein",
"496073", "Babenhausen\ Hessen",
"494622", "Taarstedt",
"4935934", "Grossdubrau",
"497933", "Creglingen",
"4934243", "Bad\ Düben",
"496765", "Gemünden\ Hunsrück",
"492292", "Windeck\ Sieg",
"492041", "Bottrop",
"4936969", "Merkers",
"497434", "Winterlingen",
"493965", "Burow\ bei\ Altentreptow",
"495506", "Adelebsen",
"498727", "Falkenberg\ Niederbayern",
"499846", "Ipsheim",
"493501", "Pirna",
"496587", "Zerf",
"494858", "Sankt\ Margarethen\ Holstein",
"499221", "Kulmbach",
"4935938", "Grosspostwitz\ OL",
"498273", "Nordendorf",
"4935389", "Holzdorf\ Elster",
"495859", "Thomasburg",
"495181", "Alfeld\ Leine",
"498679", "Burgkirchen\ an\ der\ Alz",
"4933457", "Altreetz",
"497337", "Nellingen\ Alb",
"497806", "Bad\ Peterstal\-Griesbach",
"495121", "Hildesheim",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"499281", "Hof\ Saale",
"495644", "Willebadessen\-Peckelsheim",
"499498", "Laaber",
"498565", "Dietersburg\-Baumgarten",
"498368", "Halblech",
"4933873", "Grosswudicke",
"496527", "Oberweis",
"494531", "Bad\ Oldesloe",
"496461", "Biedenkopf",
"497250", "Kraichtal",
"4933672", "Pfaffendorfb\ Beeskow",
"4936042", "Tonna",
"496122", "Hofheim\-Wallau",
"492645", "Vettelschoss",
"497447", "Baiersbronn\-Schwarzenberg",
"4933848", "Raben",
"492238", "Pulheim",
"495266", "Lemgo\-Kirchheide",
"4934691", "Könnern",
"496574", "Hasborn",
"495462", "Ankum",
"4934295", "Krensitz",
"499925", "Bayerisch\ Eisenstein",
"498380", "Achberg",
"498320", "Missen\-Wilhams",
"4933926", "Herzberg\ Mark",
"4939058", "Uthmöden",
"4933743", "Blönsdorf",
"496182", "Seligenstadt",
"494101", "Pinneberg",
"499166", "Münchsteinach",
"499078", "Mertingen",
"49251", "Münster",
"4939054", "Flechtingen",
"4934773", "Schwittersdorf",
"4934975", "Görzig\ Kreis\ Köthen",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"499236", "Nagel",
"492758", "Bad\ Berleburg\-Girkhausen",
"498205", "Dasing",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4936205", "Gräfenroda",
"4933844", "Brück\ Brandenburg",
"494526", "Ascheberg\ Holstein",
"497344", "Blaubeuren",
"494748", "Stubben\ bei\ Bremerhaven",
"497954", "Kirchberg\ an\ der\ Jagst",
"4936601", "Hermsdorf\ Thüringen",
"499407", "Wenzenbach",
"498823", "Mittenwald",
"495602", "Hessisch\ Lichtenau",
"497453", "Altensteig\ Württemberg",
"499871", "Windsbach",
"4938851", "Zarrentin",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495136", "Burgdorf\ Kreis\ Hannover",
"4937421", "Oelsnitz\ Vogtland",
"492066", "Duisburg\-Homberg",
"493332", "Schwedt\/Oder",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"496898", "Völklingen",
"494806", "Sarzbüttel",
"494337", "Jevenstedt",
"492902", "Warstein",
"498503", "Neuhaus\ am\ Inn",
"499861", "Rothenburg\ ob\ der\ Tauber",
"499729", "Grettstadt",
"4936701", "Lichte",
"4934742", "Sylda",
"49571", "Minden\ Westfalen",
"497531", "Konstanz",
"498764", "Mauern\ Kreis\ Freising",
"4936428", "Stadtroda",
"492937", "Arnsberg\-Oeventrop",
"4938755", "Eldena",
"493307", "Zehdenick",
"4937608", "Waldenburg\ Sachsen",
"493836", "Wolgast",
"498291", "Zusmarshausen",
"498042", "Lenggries",
"494302", "Kirchbarkau",
"4934673", "Heldrungen",
"496381", "Kusel",
"4936424", "Kahla\ Thüringen",
"499176", "Allersberg",
"497682", "Elzach",
"492333", "Ennepetal",
"496703", "Wöllstein\ Rheinhessen",
"496242", "Osthofen",
"495831", "Wittingen",
"496446", "Hohenahr",
"497051", "Calw",
"4937604", "Mosel",
"4937325", "Niederbobritzsch",
"494195", "Hartenholm",
"4937346", "Geyer",
"494559", "Wensin",
"495276", "Marienmünster",
"4935932", "Guttau",
"496564", "Neuerburg\ Eifel",
"495472", "Bad\ Essen",
"494434", "Colnrade",
"494933", "Dornum\ Ostfriesland",
"495945", "Wilsum",
"499677", "Oberviechtach\-Pullenried",
"497622", "Schopfheim",
"495355", "Frellstedt",
"4935267", "Diesbar\-Seusslitz",
"4939881", "Ringenwalde\ bei\ Templin",
"4939422", "Badersleben",
"4933766", "Teupitz",
"499652", "Waidhaus",
"495457", "Hopsten\-Schale",
"493987", "Templin",
"496787", "Niederbrombach",
"499081", "Nördlingen",
"494731", "Nordenham",
"494922", "Borkum",
"496727", "Gensingen",
"492826", "Kranenburg\ Niederrhein",
"492382", "Ahlen\ Westfalen",
"498765", "Bruckberg\ Niederbayern",
"4936738", "Königsee",
"497633", "Staufen\ im\ Breisgau",
"4938726", "Spornitz",
"498073", "Gars\ am\ Inn",
"4936450", "Kranichfeld",
"4935602", "Drebkau",
"4936734", "Leutenberg",
"4933653", "Ziltendorf",
"494194", "Sievershütten",
"492241", "Siegburg",
"4936461", "Bad\ Sulza",
"498461", "Beilngries",
"494251", "Hoya",
"495443", "Lemförde",
"494435", "Grossenkneten",
"499828", "Rügland",
"499391", "Marktheidenfeld",
"496565", "Dudeldorf",
"495706", "Porta\ Westfalica",
"49481", "Heide\ Holstein",
"495944", "Hoogstede",
"495354", "Jerxheim",
"498336", "Erkheim",
"495848", "Trebel",
"498807", "Diessen\ am\ Ammersee",
"499423", "Geiselhöring",
"499305", "Estenfeld",
"4934347", "Oelzschau\ bei\ Borna",
"492644", "Linz\ am\ Rhein",
"496575", "Landscheid",
"494849", "Hooge",
"499924", "Bodenmais",
"492181", "Grevenbroich",
"496004", "Lich\-Eberstadt",
"492859", "Wesel\-Bislich",
"4937468", "Treuen\ Vogtland",
"496263", "Neckargerach",
"496669", "Neuhof\-Hauswurz",
"4938300", "Insel\ Hiddensee",
"4935476", "Wittmannsdorf\-Bückchen",
"493491", "Lutherstadt\ Wittenberg",
"4938292", "Kröpelin",
"498063", "Feldkirchen\-Westerham",
"493675", "Sonneberg\ Thüringen",
"492506", "Münster\-Wolbeck",
"499280", "Selbitz\ Oberfranken",
"495041", "Springe\ Deister",
"495292", "Lichtenau\-Atteln",
"4939396", "Neukirchen\ Altmark",
"498204", "Mickhausen",
"496409", "Biebertal",
"496133", "Oppenheim",
"4937464", "Schöneck\ Vogtland",
"497345", "Langenau\ Württemberg",
"499192", "Gräfenberg",
"4933479", "Küstrin\-Kietz",
"497726", "Bad\ Dürrheim",
"4934652", "Allstedt",
"497955", "Wallhausen\ Württemberg",
"499220", "Kasendorf\-Azendorf",
"4938841", "Neuhaus\ Elbe",
"4937363", "Zöblitz",
"499373", "Amorbach",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"497194", "Spiegelberg",
"495168", "Walsrode\-Stellichte",
"4935604", "Krieschow",
"4936732", "Könitz",
"492602", "Montabaur",
"494169", "Sauensiek",
"496503", "Hermeskeil",
"498321", "Sonthofen",
"496428", "Stadtallendorf",
"496154", "Ober\-Ramstadt",
"498381", "Lindenberg\ im\ Allgäu",
"496042", "Büdingen\ Hessen",
"496291", "Adelsheim",
"499268", "Teuschnitz",
"49781", "Offenburg",
"4939428", "Pabstorf",
"493964", "Bredenfelde\ bei\ Strasburg",
"497435", "Albstadt\-Laufen",
"496764", "Rheinböllen",
"492637", "Weissenthurm",
"497251", "Bruchsal",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"49551", "Göttingen",
"493603", "Bad\ Langensalza",
"499529", "Oberaurach",
"498446", "Pörnbach",
"498091", "Kirchseeon",
"498703", "Essenbach",
"4935608", "Gross\ Ossnig",
"4939323", "Schönhausen\ Elbe",
"492462", "Linnich",
"495238", "Nieheim\-Himmighausen",
"492266", "Lindlar",
"498564", "Johanniskirchen",
"494633", "Satrup",
"495645", "Borgentreich\-Borgholz",
"499977", "Arnschwang",
"494239", "Dörverden\-Westen",
"497731", "Singen\ Hohentwiel",
"492355", "Schalksmühle",
"4935203", "Tharandt",
"4938793", "Dergenthin",
"492558", "Horstmar",
"498574", "Wittibreut",
"492945", "Lippstadt\-Benninghausen",
"492472", "Monschau",
"498122", "Erding",
"4937462", "Rothenkirchen\ Vogtland",
"499625", "Kastl\ bei\ Amberg",
"4934654", "Stolberg\ Harz",
"493594", "Bischofswerda",
"492831", "Geldern",
"494955", "Westoverledingen",
"495333", "Dettum",
"493868", "Rastow",
"499556", "Geiselwind",
"4934658", "Hayn\ Harz",
"495937", "Geeste\-Gross\ Hesepe",
"496774", "Kaub",
"496205", "Hockenheim",
"499278", "Weidenberg",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"49271", "Siegen",
"4939205", "Langenweddingen",
"4939601", "Friedland",
"494179", "Winsen\-Tönnhausen",
"497654", "Löffingen",
"4938294", "Neubukow",
"496694", "Neukirchen\ Knüll",
"495902", "Freren",
"499363", "Arnstein\ Unterfranken",
"495066", "Sarstedt",
"498102", "Höhenkirchen\-Siegertsbrunn",
"4933052", "Leegebruch",
"499605", "Weiherhammer",
"492954", "Rüthen\-Oestereiden",
"4935693", "Lauschütz",
"498636", "Ampfing",
"499151", "Hersbruck",
"498085", "Sankt\ Wolfgang",
"496678", "Wildeck\-Hönebach",
"492453", "Heinsberg\-Randerath",
"4937755", "Schönheide\ Erzgebirge",
"4939242", "Prödel",
"495194", "Bispingen",
"4937436", "Weischlitz",
"495251", "Paderborn",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"494706", "Schiffdorf",
"498025", "Miesbach",
"493998", "Demmin",
"494443", "Dinklage",
"495435", "Berge\ bei\ Quakenbrück",
"499294", "Regnitzlosau",
"49581", "Uelzen",
"494944", "Wiesmoor",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499829", "Flachslanden",
"498137", "Petershausen",
"4936258", "Friemar",
"4939971", "Gnoien",
"494354", "Fleckeby",
"493375", "Königs\ Wusterhausen",
"4933931", "Rheinsberg\ Mark",
"493578", "Kamenz",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4936254", "Friedrichswerth",
"498267", "Dirlewang",
"4936027", "Lengenfeld\ Unterm\ Stein",
"49751", "Ravensburg",
"4935771", "Bad\ Muskau",
"494240", "Syke\-Heiligenfelde",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495731", "Bad\ Oeynhausen",
"496285", "Walldürn\-Altheim",
"495922", "Bad\ Bentheim",
"4939291", "Calbe\ Saale",
"498395", "Tannheim\ Württemberg",
"496803", "Mandelbachtal\-Ommersheim",
"4936377", "Rastenberg",
"497645", "Freiamt",
"499465", "Neukirchen\-Balbini",
"492447", "Dahlem\ bei\ Kall",
"4939005", "Kusey",
"4938325", "Rolofshagen",
"4936330", "Grossberndten",
"499352", "Lohr\ am\ Main",
"496523", "Holsthum",
"4933833", "Wollin\ bei\ Brandenburg",
"4936766", "Schalkau",
"4939386", "Seehausen\ Altmark",
"499942", "Viechtach",
"494292", "Ritterhude",
"494496", "Friesoythe\-Markhausen",
"496408", "Buseck",
"4939993", "Hohenmocker",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"494120", "Ellerhoop",
"496145", "Flörsheim\ am\ Main",
"492622", "Bendorf\ am\ Rhein",
"494180", "Königsmoor",
"492682", "Hamm\ Sieg",
"497333", "Laichingen",
"492051", "Velbert",
"4935894", "Hähnichen",
"4939774", "Mönkebude",
"499856", "Dürrwangen",
"496583", "Palzem",
"4933233", "Ketzin",
"498723", "Arnstorf",
"499560", "Grub\ am\ Forst",
"494848", "Rantrum",
"4933734", "Felgentreu",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"495849", "Waddeweitz",
"497937", "Dörzbach",
"4939457", "Benneckenstein\ Harz",
"4936653", "Lehesten\ Thüringer\ Wald",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"493623", "Friedrichroda",
"4935974", "Hinterhermsdorf",
"497066", "Bad\ Rappenau\-Bonfeld",
"493683", "Schmalkalden",
"496668", "Birstein\-Lichenroth",
"4935793", "Elstra",
"495654", "Herleshausen",
"4938203", "Bad\ Doberan",
"498783", "Rohr\ in\ Niederbayern",
"492858", "Hünxe",
"497240", "Pfinztal",
"49451", "Lübeck",
"499904", "Lalling",
"492655", "Weibern",
"496084", "Schmitten\ Taunus",
"497457", "Rottenburg\-Ergenzingen",
"499746", "Zeitlofs",
"4939820", "Triepkendorf",
"499403", "Donaustauf",
"499325", "Kleinlangheim",
"4936252", "Tambach\-Dietharz",
"496865", "Mettlach\-Orscholz",
"499528", "Donnersdorf",
"4939743", "Zerrenthin",
"4939926", "Grabowhöfe",
"494238", "Neddenaverbergen",
"499385", "Kolitzheim",
"495633", "Diemelsee",
"496024", "Schöllkrippen",
"496620", "Philippsthal\ Werra",
"4934361", "Dahlen\ Sachsen",
"4939248", "Dobritz",
"498224", "Offingen\ Donau",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4935726", "Gross\ Särchen",
"496429", "Schweinsberg\ Hessen",
"4933054", "Liebenwalde",
"4939244", "Steutz",
"492526", "Sendenhorst",
"497354", "Erolzheim",
"492586", "Beelen",
"497944", "Kupferzell",
"494758", "Nordleda",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"497706", "Oberbaldingen",
"497443", "Dornstetten",
"498284", "Ziemetshausen",
"4933632", "Hangelsberg",
"496394", "Bundenthal",
"499269", "Tettau\ Kreis\ Kronach",
"498144", "Grafrath",
"492302", "Witten",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"499279", "Mistelgau",
"496732", "Wörrstadt",
"4935841", "Grossschönau\ Sachsen",
"499673", "Tiefenbach\ Oberpfalz",
"493721", "Meinersdorf",
"498621", "Trostberg",
"493869", "Dümmer",
"4934465", "Bad\ Bibra",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"498681", "Waging\ am\ See",
"4935241", "Lommatzsch",
"494902", "Jemgum\-Ditzum",
"496707", "Windesheim",
"494830", "Süderhastedt",
"493907", "Gardelegen",
"498052", "Aschau\ im\ Chiemgau",
"494178", "Radbruch",
"492337", "Hagen\-Dahl",
"493425", "Wurzen",
"493303", "Birkenwerder",
"4934633", "Braunsbedra",
"492933", "Sundern\ Sauerland",
"496252", "Heppenheim\ Bergstrasse",
"496456", "Haina\ Kloster",
"498532", "Griesbach\ im\ Rottal",
"497041", "Mühlacker",
"4938783", "Dallmin",
"492434", "Wegberg",
"492195", "Radevormwald",
"496875", "Nonnweiler\-Primstal",
"495955", "Esterwegen",
"4935892", "Horka\ OL",
"4939772", "Rothemühl",
"498507", "Neuburg\ am\ Inn",
"4939406", "Harbke",
"495726", "Wiedensahl",
"495345", "Baddeckenstedt",
"494333", "Erfde",
"499571", "Lichtenfels\ Bayern",
"498145", "Mammendorf",
"497462", "Immendingen",
"497266", "Kirchardt",
"499642", "Kemnath\ Stadt",
"494826", "Hohenlockstedt",
"496301", "Otterbach\ Pfalz",
"495447", "Lembruch",
"494382", "Wangels",
"495250", "Delbrück\ Westfalen",
"492922", "Werl",
"498583", "Neureichenau",
"492982", "Medebach",
"494322", "Bordesholm",
"493327", "Werder\ Havel",
"4937298", "Oelsnitz\ Erzgebirge",
"4938462", "Baumgarten",
"4933969", "Stepenitz",
"49281", "Wesel",
"492435", "Erkelenz\-Lövenich",
"498379", "Waltenhofen\-Oberdorf",
"4937294", "Grünhainichen",
"493923", "Zerbst",
"492251", "Euskirchen",
"496723", "Oestrich\-Winkel",
"496874", "Wadern\-Nunkirchen",
"496783", "Baumholder",
"497136", "Bad\ Friedrichshall",
"494241", "Bassum",
"4934903", "Coswig\ Anhalt",
"495453", "Recke",
"49212", "Solingen",
"495954", "Lorup",
"4936873", "Themar",
"495344", "Lengede",
"49771", "Donaueschingen",
"495858", "Hitzacker\-Wietzetze",
"4939858", "Bietikow",
"496085", "Waldsolms",
"499905", "Bernried\ Niederbayern",
"492654", "Polch",
"498678", "Marktl",
"499324", "Dettelbach",
"4934605", "Gröbers",
"494859", "Windbergen",
"496636", "Romrod",
"4934324", "Ostrau\ Sachsen",
"496864", "Mettlach",
"4933337", "Altkünkendorf",
"494181", "Buchholz\ in\ der\ Nordheide",
"4933439", "Fredersdorf\-Vogelsdorf",
"496102", "Neu\-Isenburg",
"4936842", "Oberhof\ Thüringen",
"499499", "Painten",
"4939955", "Jürgenstorf",
"494121", "Elmshorn",
"4939753", "Strasburg",
"499384", "Schwanfeld",
"498369", "Rückholz",
"494644", "Karby",
"495531", "Holzminden",
"4934423", "Heuckewalde",
"498067", "Tuntenhausen",
"4935755", "Ortrand",
"4935953", "Burkau",
"4935436", "Laasow\ bei\ Calau",
"498225", "Jettingen\-Scheppach",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"495051", "Bergen\ Kreis\ Celle",
"496267", "Fahrenbach\ Baden",
"4938307", "Poseritz",
"497831", "Hausach",
"4933396", "Klosterfelde",
"495682", "Borken\ Hessen",
"499094", "Tagmersheim",
"497355", "Hochdorf\ Riss",
"495622", "Fritzlar",
"4936695", "Söllmnitz",
"497558", "Illmensee",
"497945", "Wüstenrot",
"4939854", "Kleptow",
"497472", "Rottenburg\ am\ Neckar",
"4934328", "Hartha\ bei\ Döbeln",
"494506", "Stockelsdorf\-Krumbeck",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499561", "Coburg",
"498803", "Peissenberg",
"499427", "Leiblfing",
"498285", "Burtenbach",
"492759", "Bad\ Berleburg\-Aue",
"4934496", "Nöbdenitz",
"493632", "Sondershausen",
"494637", "Sterup",
"499973", "Furth\ im\ Wald",
"496621", "Bad\ Hersfeld",
"499474", "Schmidmühlen",
"4937292", "Oederan",
"498732", "Frontenhausen",
"495586", "Wieda",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4933701", "Grossbeeren",
"4936081", "Arenshausen",
"496052", "Bad\ Orb",
"4939033", "Wallstawe",
"498707", "Adlkofen",
"496681", "Hilders",
"494602", "Freienwill",
"494749", "Schiffdorf\-Geestenseth",
"494136", "Scharnebeck",
"493364", "Eisenhüttenstadt",
"497382", "Römerstein",
"497826", "Schuttertal",
"492633", "Brohl\-Lützing",
"4939349", "Parey\ Elbe",
"498456", "Lenting",
"496532", "Zeltingen\-Rachtig",
"494462", "Wittmund",
"498252", "Schrobenhausen",
"4938731", "Lübz",
"493521", "Meissen",
"494266", "Brockel",
"499201", "Gesees",
"4936643", "Thimmendorf",
"496507", "Neumagen\-Dhron",
"493581", "Görlitz",
"4938464", "Bernitt",
"497322", "Giengen\ an\ der\ Brenz",
"495655", "Wanfried",
"495101", "Pattensen",
"499377", "Freudenberg\-Boxtal",
"499367", "Unterpleichfeld",
"4936848", "Wernshausen",
"492548", "Dülmen\-Rorup",
"496827", "Eppelborn",
"499604", "Wernberg\-Köblitz",
"492955", "Büren\-Wewelsburg",
"498084", "Taufkirchen\ Vils",
"495195", "Neuenkirchen\ bei\ Soltau",
"4936926", "Creuzburg",
"4936743", "Teichel",
"4936945", "Henneberg",
"4939852", "Schönermark\ bei\ Prenzlau",
"497506", "Wangen\-Leupolz",
"494472", "Lastrup",
"495434", "Essen\ Oldenburg",
"498024", "Holzkirchen",
"494276", "Borstel\ bei\ Sulingen",
"496887", "Schmelz\ Saar",
"494558", "Todesfelde",
"495933", "Lathen",
"499295", "Töpen",
"494945", "Grossefehn\-Timmel",
"494355", "Rieseby",
"4934781", "Greifenhagen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"495337", "Kissenbrück",
"499728", "Wülfershausen\ Unterfranken",
"497181", "Schorndorf\ Württemberg",
"499546", "Burgebrach",
"4934322", "Rosswein",
"49471", "Bremerhaven",
"496224", "Sandhausen\ Baden",
"498394", "Lautrach",
"496284", "Mudau",
"4933601", "Podelzig",
"499464", "Walderbach",
"4933205", "Michendorf",
"497644", "Kenzingen",
"4936844", "Rohr\ Thüringen",
"4938356", "Behrenhoff",
"499963", "Konzell",
"495302", "Vechelde",
"497121", "Reutlingen",
"49731", "Ulm\ Donau",
"496228", "Schönau\ Odenwald",
"4935365", "Falkenberg\ Elster",
"499724", "Stadtlauringen",
"4935931", "Königswartha",
"492132", "Meerbusch\-Büderich",
"493378", "Ludwigsfelde",
"495072", "Neustadt\-Mandelsloh",
"494630", "Barderup",
"4937439", "Jocketa",
"492606", "Winningen\ Mosel",
"497235", "Unterreichenbach\ Kreis\ Calw",
"499873", "Abenberg\-Wassermungenau",
"497451", "Horb\ am\ Neckar",
"498821", "Garmisch\-Partenkirchen",
"496046", "Ortenberg\ Hessen",
"499468", "Zell\ Oberpfalz",
"498442", "Wolnzach",
"496675", "Breitenbach\ am\ Herzberg",
"498246", "Waal",
"497165", "Göppingen\-Hohenstaufen",
"4933082", "Menz\ Kreis\ Oberhavel",
"4935052", "Kipsdorf\ Kurort",
"499608", "Kohlberg\ Oberpfalz",
"494554", "Wahlstedt",
"497755", "Weilheim\ Kreis\ Waldshut",
"496569", "Bickendorf",
"494103", "Wedel",
"4934741", "Frose",
"4936702", "Lauscha",
"496500", "Waldrach",
"4939363", "Angern",
"4936783", "Gehren\ Thüringen",
"495438", "Bakum\-Lüsche",
"498028", "Fischbachau",
"492262", "Wiehl",
"4938852", "Wittenburg",
"4933974", "Dessow",
"4939389", "Schollene",
"4939487", "Friedrichsbrunn",
"4937422", "Markneukirchen",
"492272", "Bedburg\ Erft",
"497053", "Bad\ Teinach\-Zavelstein",
"498687", "Taching\-Tengling",
"4934920", "Kropstädt",
"493901", "Salzwedel",
"494845", "Ostenfeld\ Husum",
"495833", "Brome",
"4936602", "Ronneburg\ Thüringen",
"496701", "Sprendlingen\ Rheinhessen",
"496093", "Laufach",
"492331", "Hagen\ Westfalen",
"499360", "Thüngen",
"493727", "Mittweida",
"492855", "Voerde\ Niederrhein",
"494722", "Cuxhaven\-Altenbruch",
"494931", "Norden",
"497175", "Leinzell",
"496665", "Sinntal\-Altengronau",
"4933875", "Rhinow",
"493679", "Neuhaus\ am\ Rennweg",
"498501", "Thyrnau",
"499552", "Burghaslach",
"496323", "Edenkoben",
"496405", "Laubach\ Hessen",
"496383", "Glan\-Münchweiler",
"498293", "Welden\ bei\ Augsburg",
"495906", "Lünne",
"497959", "Frankenhardt",
"4933978", "Segeletz",
"4934692", "Alsleben\ Saale",
"495062", "Holle\ bei\ Hildesheim",
"4936041", "Bad\ Tennstedt",
"4939934", "Gross\ Plasten",
"497533", "Allensbach",
"495744", "Hüllhorst",
"4933671", "Lieberose",
"492745", "Brachbach\ Sieg",
"496061", "Michelstadt",
"495257", "Hövelhof",
"4935054", "Lauenstein\ Sachsen",
"494165", "Hollenstedt\ Nordheide",
"4933745", "Petkus",
"4933084", "Gutengermendorf",
"498131", "Dachau",
"499656", "Moosbach\ bei\ Vohenstrauss",
"4939929", "Jabel\ bei\ Waren",
"496594", "Birresborn",
"4936704", "Steinheid",
"4935827", "Nieder\-Seifersdorf",
"4934293", "Naunhof\ bei\ Grimma",
"499157", "Alfeld\ Mittelfranken",
"494926", "Krummhörn\-Greetsiel",
"492822", "Emmerich",
"497554", "Heiligenberg\ Baden",
"494755", "Ihlienworth",
"493774", "Schwarzenberg",
"493883", "Hagenow",
"496868", "Mettlach\-Tünsdorf",
"499525", "Königsberg\ in\ Bayern",
"492441", "Kall",
"497034", "Ehningen",
"495854", "Bleckede\-Barskamp",
"4936203", "Vieselbach",
"499143", "Pappenheim\ Mittelfranken",
"496473", "Leun",
"49431", "Kiel",
"4937601", "Mülsen\ Skt\ Jacob",
"49291", "Meschede",
"4933088", "Falkenthal",
"4936421", "Camburg",
"4934775", "Wippra",
"494451", "Varel\ Jadebusen",
"4934973", "Osternienburg",
"498261", "Mindelheim",
"4935058", "Pretzschendorf",
"495702", "Petershagen\-Lahde",
"494235", "Langwedel\-Etelsen",
"4938753", "Wöbbelin",
"492359", "Kierspe",
"495183", "Lamspringe",
"498271", "Meitingen",
"498332", "Ottobeuren",
"49561", "Kassel",
"499223", "Rugendorf",
"494533", "Reinfeld\ Holstein",
"4938858", "Lassahn",
"495545", "Hedemünden",
"498664", "Chieming",
"499805", "Burgoberbach",
"499283", "Rehau",
"494959", "Dollart",
"4936608", "Seelingstädt\ bei\ Gera",
"493764", "Meerane",
"495123", "Schellerten",
"4939932", "Malchow\ bei\ Waren",
"496130", "Schwabenheim\ an\ der\ Selz",
"494349", "Dänischenhagen",
"498404", "Oberdolling",
"496209", "Mörlenbach",
"4938854", "Redefin",
"4933972", "Breddin",
"4938377", "Zinnowitz",
"4933841", "Belzig",
"495492", "Steinfeld\ Oldenburg",
"499480", "Sünching",
"492502", "Nottuln",
"4936604", "Münchenbernsdorf",
"499420", "Feldkirchen\ Niederbayern",
"492043", "Gladbeck",
"4936075", "Dingelstädt\ Eichsfeld",
"4937323", "Lichtenberg\ Erzgebirge",
"494175", "Egestorf\ Nordheide",
"4939409", "Eilsleben",
"4939051", "Calvörde",
"499196", "Wiesenttal",
"497931", "Bad\ Mergentheim",
"497722", "Triberg\ im\ Schwarzwald",
"499777", "Ostheim\ von\ der\ Rhön",
"496071", "Dieburg",
"495262", "Extertal",
"495466", "Merzen",
"498093", "Glonn\ Kreis\ Ebersberg",
"4938220", "Wustrow\ Ostseebad",
"4939602", "Kleeth",
"493601", "Mühlhausen\ Thüringen",
"497247", "Linkenheim\-Hochstetten",
"496126", "Idstein",
"497733", "Engen\ Hegau",
"496186", "Grosskrotzenburg",
"498665", "Inzell",
"4938848", "Vellahn",
"495544", "Reinhardshagen",
"499162", "Scheinfeld",
"496627", "Nentershausen\ Hessen",
"494631", "Glücksburg\ Ostsee",
"499804", "Aurach",
"4933966", "Dranse",
"493765", "Reichenbach\ Vogtland",
"499232", "Wunsiedel",
"499436", "Nittenau",
"498405", "Stammham\ bei\ Ingolstadt",
"498323", "Immenstadt\ im\ Allgäu",
"4938844", "Gülze",
"496501", "Konz",
"497844", "Rheinau",
"4939267", "Schneidlingen",
"499371", "Miltenberg",
"497253", "Bad\ Schönborn",
"495606", "Zierenberg",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"494174", "Stelle\ Kreis\ Harburg",
"495132", "Lehrte",
"493461", "Merseburg\ Saale",
"494522", "Plön",
"496293", "Schefflenz",
"499207", "Königsfeld\ Oberfranken",
"498383", "Grünenbach\ Allgäu",
"492744", "Herdorf",
"493471", "Bernburg\ Saale",
"494164", "Harsefeld",
"494802", "Wrohm",
"496881", "Lebach",
"4933436", "Prötzel",
"496159", "Messel",
"492330", "Herdecke",
"496595", "Dockweiler",
"498046", "Bad\ Heilbrunn",
"496821", "Neunkirchen\ Saar",
"496398", "Vorderweidenthal",
"494837", "Neuenkirchen\ Dithmarschen",
"493969", "Siedenbollentin",
"497358", "Eberhardzell\-Füramoos",
"497948", "Öhringen\-Ohrnberg",
"4939884", "Hassleben\ bei\ Prenzlau",
"494754", "Bülkau",
"497555", "Deggenhausertal",
"4935439", "Zinnitz",
"4937365", "Sayda",
"499524", "Zeil\ am\ Main",
"499172", "Georgensgmünd",
"4939888", "Lychen",
"4936464", "Wormstedt",
"495855", "Nahrendorf",
"499908", "Schöfweg",
"496246", "Eich\ Rheinhessen",
"497127", "Neckartenzlingen",
"496442", "Braunfels",
"496028", "Sulzbach\ am\ Main",
"495331", "Wolfenbüttel",
"497626", "Kandern",
"4935020", "Struppen",
"492833", "Kerken",
"4936731", "Unterloquitz",
"494234", "Dörverden",
"495272", "Brakel\ Westfalen",
"493695", "Bad\ Salzungen",
"495476", "Ostercappeln\-Venne",
"492243", "Eitorf",
"4938842", "Lüttenmark",
"493321", "Nauen\ Brandenburg",
"496332", "Zweibrücken",
"4934651", "Rossla",
"496271", "Eberbach\ Baden",
"494844", "Pellworm",
"497582", "Bad\ Buchau",
"49591", "Lingen\ \(Ems\)",
"499929", "Ruhmannsfelden",
"495658", "Wehretal",
"497522", "Wangen\ im\ Allgäu",
"493381", "Brandenburg\ an\ der\ Havel",
"497174", "Mögglingen",
"4939608", "Staven",
"499393", "Rothenfels\ Unterfranken",
"496836", "Überherrn",
"496307", "Schopp",
"4935323", "Sonnewalde",
"495441", "Diepholz",
"496664", "Sinntal\-Sterbfritz",
"494253", "Asendorf\ Kreis\ Diepholz",
"492737", "Netphen\-Deuz",
"498463", "Greding",
"494247", "Affinghausen",
"499083", "Möttingen",
"495822", "Ebstorf",
"4939325", "Vinzelberg",
"4939346", "Tucheim",
"4939604", "Wildberg\ bei\ Altentreptow",
"496404", "Lich\ Hessen",
"493564", "Schwarze\ Pumpe",
"498071", "Wasserburg\ am\ Inn",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"497631", "Müllheim\ Baden",
"492440", "Nettersheim\-Tondorf",
"495745", "Stemwede\-Levern",
"494733", "Butjadingen\-Burhave",
"492257", "Reckerscheid",
"495326", "Langelsheim",
"495882", "Gorleben",
"494127", "Westerhorn",
"496131", "Mainz",
"495043", "Lauenau",
"499725", "Poppenhausen\ Unterfranken",
"499346", "Grünsfeld",
"4936462", "Ossmannstedt",
"493574", "Lauchhammer",
"499956", "Eichendorf\-Aufhausen",
"498061", "Bad\ Aibling",
"497234", "Tiefenbronn",
"492296", "Reichshof\-Brüchermühle",
"4936929", "Ruhla",
"495502", "Dransfeld",
"499842", "Uffenheim",
"494626", "Treia",
"4935205", "Ottendorf\-Okrilla",
"4935601", "Peitz",
"494187", "Holm\-Seppensen",
"496674", "Friedewald\ Hessen",
"497164", "Boll\ Kreis\ Göppingen",
"497930", "Boxberg\ Baden",
"495198", "Schneverdingen\-Wintermoor",
"497802", "Oberkirch\ Baden",
"4939203", "Barleben",
"4938873", "Carlow",
"498868", "Schwabsoien",
"492958", "Büren\-Harth",
"499421", "Straubing",
"492545", "Rosendahl\-Darfeld",
"499567", "Sesslach\-Gemünda",
"497754", "Görwihl",
"494948", "Wiesmoor\-Marcardsmoor",
"493493", "Bitterfeld",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"499481", "Pfatter",
"496261", "Mosbach\ Baden",
"494358", "Loose\ bei\ Eckernförde",
"49261", "Koblenz\ am\ Rhein",
"4939882", "Gollin",
"4938457", "Krakow\ am\ See",
"497837", "Oberharmersbach",
"4939421", "Osterwieck",
"497306", "Vöhringen\ Iller",
"492183", "Rommerskirchen",
"493994", "Malchin",
"499274", "Hollfeld",
"49791", "Schwäbisch\ Hall",
"495582", "Sankt\ Andreasberg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4935891", "Rothenburg\ OL",
"4939771", "Ueckermünde",
"494107", "Siek\ Kreis\ Stormarn",
"493636", "Greussen",
"494606", "Wanderup",
"496698", "Schrecksbach",
"497441", "Freudenstadt",
"499661", "Sulzbach\-Rosenberg",
"494132", "Amelinghausen",
"492630", "Mülheim\-Kärlich",
"495174", "Lahstedt",
"495522", "Osterode\ am\ Harz",
"496056", "Bad\ Soden\-Salmünster",
"4935695", "Simmersdorf",
"498452", "Geisenfeld",
"4938323", "Prohn",
"494466", "Wittmund\-Ardorf",
"496536", "Kleinich",
"494262", "Visselhövede",
"4939003", "Jübar",
"4935242", "Nossen",
"499401", "Neutraubling",
"498375", "Weitnau",
"492103", "Hilden",
"497386", "Hayingen",
"492554", "Laer\ Kreis\ Steinfurt",
"497822", "Ettenheim",
"4939082", "Mieste",
"494544", "Berkenthin",
"497326", "Neresheim",
"4938424", "Bobitz",
"497745", "Jestetten",
"4935971", "Sebnitz",
"495631", "Korbach",
"4935842", "Oderwitz",
"493395", "Pritzwalk",
"4933363", "Altenhof\ Kreis\ Barnim",
"4933731", "Trebbin",
"4933631", "Bad\ Saarow\-Pieskow",
"4933235", "Friesack",
"497043", "Maulbronn",
"494855", "Eddelak",
"492722", "Attendorn",
"499134", "Neunkirchen\ am\ Brand",
"492931", "Arnsberg",
"496387", "Sankt\ Julian",
"493301", "Oranienburg",
"494331", "Rendsburg",
"499495", "Breitenbrunn\ Oberpfalz",
"4939995", "Nossendorf",
"496327", "Neustadt\-Lachen",
"4935873", "Herrnhut",
"498365", "Wertach",
"499867", "Geslau",
"492845", "Neukirchen\-Vluyn",
"496029", "Mömbris",
"4933835", "Golzow\ bei\ Brandenburg",
"4936966", "Kaltennordheim",
"4939298", "Barby\ Elbe",
"497502", "Wolpertswende",
"494272", "Siedenburg",
"495234", "Horn\-Bad\ Meinberg",
"4938205", "Tessin\ bei\ Rostock",
"4934362", "Mügeln\ bei\ Oschatz",
"4935795", "Königsbrück",
"496424", "Ebsdorfergrund",
"498623", "Kirchweidach",
"496158", "Riedstadt",
"493723", "Hohenstein\-Ernstthal",
"495802", "Wrestedt",
"4939294", "Gross\ Rosenburg",
"499671", "Oberviechtach",
"4935386", "Prettin",
"495164", "Hodenhagen",
"499542", "Schesslitz",
"493968", "Schönbeck",
"49811", "Hallbergmoos",
"4939978", "Gross\ Roge",
"495306", "Cremlingen",
"497949", "Pfedelbach\-Untersteinbach",
"495837", "Sprakensehl",
"4935774", "Boxberg\ Sachsen",
"493874", "Ludwigslust",
"496484", "Beselich",
"498683", "Tittmoning",
"4934927", "Globig\-Bleddin",
"499264", "Küps",
"495754", "Extertal\-Bremke",
"494822", "Kellinghusen",
"4935244", "Krögis",
"495247", "Harsewinkel",
"492755", "Bad\ Berleburg\-Schwarzenau",
"498208", "Eurasburg\ bei\ Augsburg",
"4939726", "Ducherow",
"4939084", "Lindstedt",
"4939745", "Hetzdorf\ bei\ Strasburg",
"497466", "Beuron",
"497262", "Eppingen",
"499646", "Freihung",
"496477", "Greifenstein\-Nenderoth",
"4938422", "Neukloster",
"499147", "Nennslingen",
"4933929", "Gühlen\-Glienicke",
"492165", "Jüchen",
"497544", "Markdorf",
"494326", "Wankendorf",
"494882", "Lunden",
"4935844", "Oybin\ Kurort",
"494745", "Bad\ Bederkesa",
"495733", "Vlotho",
"4935820", "Zodel",
"492235", "Erftstadt",
"492451", "Geilenkirchen",
"496374", "Weilerbach",
"499928", "Kirchdorf\ im\ Wald",
"495844", "Clenze",
"49491", "Leer\ Ostfriesland",
"499153", "Schnaittach",
"499504", "Stadelhofen",
"49231", "Dortmund",
"4935248", "Schönfeld\ bei\ Grossenhain",
"499075", "Glött",
"494441", "Vechta",
"495659", "Ringgau",
"497132", "Neckarsulm",
"496008", "Echzell",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4939088", "Letzlingen",
"495253", "Bad\ Driburg",
"493621", "Gotha\ Thüringen",
"499773", "Unsleben",
"498869", "Kinsau",
"4934364", "Wermsdorf",
"496106", "Rodgau",
"492533", "Münster\-Nienberge",
"495199", "Schneverdingen\-Heber",
"4939292", "Biederitz",
"498721", "Eggenfelden",
"4938370", "Kröslin",
"495555", "Moringen\-Fredelsloh",
"4935772", "Rietschen",
"495948", "Itterbeck",
"498781", "Rottenburg\ an\ der\ Laaber",
"4934463", "Bad\ Kösen",
"495358", "Bahrdorf\-Mackendorf",
"496364", "Nussbach\ Pfalz",
"4933932", "Fehrbellin",
"499824", "Dietenhofen",
"493681", "Suhl",
"495127", "Harsum",
"4939972", "Walkendorf",
"495686", "Schwarzenborn\ Knüll",
"498303", "Waltenhofen",
"499287", "Selb",
"495035", "Gross\ Munzel",
"492175", "Leichlingen\ Rheinland",
"496467", "Hatzfeld\ Eder",
"494537", "Sülfeld\ Holstein",
"4937349", "Scheibenberg",
"497476", "Bisingen",
"496581", "Saarburg",
"4939241", "Leitzkau",
"4938785", "Berge\ bei\ Perleberg",
"494502", "Lübeck\-Travemünde",
"497272", "Rülzheim",
"499227", "Neuenmarkt",
"492053", "Velbert\-Neviges",
"4934635", "Bad\ Lauchstädt",
"495626", "Bad\ Zwesten",
"497331", "Geislingen\ an\ der\ Steige",
"495187", "Delligsen",
"4933051", "Nassenheide",
"496297", "Ravenstein\ Baden",
"499742", "Kalbach\ Rhön",
"499203", "Neudrossenfeld",
"498387", "Weiler\-Simmerberg",
"493523", "Coswig\ bei\ Dresden",
"4933769", "Töpchin",
"492631", "Neuwied",
"497440", "Bad\ Rippoldsau",
"497257", "Bruchsal\-Untergrombach",
"4933602", "Alt\ Zeschdorf",
"495554", "Moringen",
"495439", "Bersenbrück",
"495103", "Wennigsen\ Deister",
"4934321", "Leisnig",
"498029", "Kreuth\ bei\ Tegernsee",
"4934204", "Schkeuditz",
"493583", "Zittau",
"4938729", "Marnitz",
"498327", "Rettenberg",
"499825", "Herrieden",
"496568", "Wolsfeld",
"4936875", "Straufhain\-Streufdorf",
"4934782", "Mansfeld\ Südharz",
"493379", "Mahlow",
"4934208", "Löbnitz\ bei\ Delitzsch",
"497854", "Kehl\-Goldscheuer",
"492522", "Oelde",
"496623", "Rotenburg\ an\ der\ Fulda",
"499971", "Cham",
"498158", "Tutzing",
"492174", "Burscheid\ Rheinland",
"495034", "Neustadt\-Hagen",
"496894", "St\ Ingbert",
"498424", "Nassenfels",
"496229", "Neckarsteinach",
"4934905", "Wörlitz",
"4939851", "Göritz\ bei\ Prenzlau",
"4938827", "Kalkhorst",
"497702", "Blumberg\ Baden",
"497243", "Ettlingen",
"4938227", "Lüdershagen\ bei\ Barth",
"499469", "Roding\-Neubäu",
"496683", "Ehrenberg\ Rhön",
"492582", "Everswinkel",
"49611", "Wiesbaden",
"492754", "Bad\ Laasphe\-Feudingen",
"4935027", "Weesenstein",
"4934446", "Grosskorbetha",
"49761", "Freiburg\ im\ Breisgau",
"4934425", "Droyssig",
"4939953", "Schwinkendorf",
"492306", "Lünen",
"492837", "Weeze",
"497183", "Rudersberg\ Württemberg",
"496736", "Bechenheim",
"494330", "Emkendorf",
"497123", "Metzingen\ Württemberg",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"498056", "Eggstätt",
"499961", "Mitterfels",
"492164", "Jüchen\-Otzenrath",
"4938732", "Gallin\ bei\ Lübz",
"492802", "Alpen",
"497348", "Beimerstetten",
"494744", "Loxstedt",
"497958", "Rot\ Am\ See\-Brettheim",
"497545", "Immenstaad\ am\ Bodensee",
"492234", "Frechen",
"496578", "Salmtal",
"496375", "Wallhalben",
"4939399", "Kleinau",
"495845", "Bergen\ Dumme",
"494833", "Wesselburen",
"496256", "Lampertheim\-Hüttenfeld",
"4936082", "Ershausen",
"496452", "Battenberg\ Eder",
"499505", "Litzendorf",
"4936693", "Crossen\ an\ der\ Elster",
"498536", "Kösslarn",
"4933476", "Neuhardenberg",
"4933702", "Wünsdorf",
"495722", "Bückeburg",
"499074", "Höchstädt\ an\ der\ Donau",
"4937291", "Augustusburg",
"495931", "Meppen",
"4935753", "Grossräschen",
"4935955", "Pulsnitz",
"496721", "Bingen\ am\ Rhein",
"492253", "Bad\ Münstereifel",
"494737", "Stadland\-Schwei",
"493921", "Burg\ bei\ Magdeburg",
"497072", "Gomaringen",
"4939035", "Kuhfelde",
"499135", "Hessdorf\ Mittelfranken",
"498106", "Vaterstetten",
"494854", "Friedrichskoog",
"49531", "Braunschweig",
"496869", "Merzig\-Silwingen",
"495648", "Brakel\-Gehrden",
"498364", "Seeg",
"492844", "Rheinberg\-Orsoy",
"495451", "Ibbenbüren",
"499087", "Marktoffingen",
"494702", "Sandstedt",
"494243", "Twistringen",
"496781", "Idar\-Oberstein",
"495235", "Blomberg\ Lippe",
"4933608", "Jacobsdorf\ Mark",
"493981", "Neustrelitz",
"492733", "Hilchenbach",
"494257", "Schweringen",
"498467", "Kinding",
"4933094", "Löwenberg",
"499397", "Wertheim\-Dertingen",
"496425", "Rauschenberg\ Hessen",
"496303", "Enkenbach\-Alsenborn",
"495165", "Rethem\ Aller",
"4933604", "Lebus",
"499573", "Staffelstein\ Oberfranken",
"499099", "Kaisheim",
"4936841", "Schleusingen",
"4934202", "Delitzsch",
"4936645", "Mühltroff",
"4936626", "Auma",
"495926", "Engden",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"496485", "Nentershausen\ Westerwald",
"492247", "Neunkirchen\-Seelscheid",
"499265", "Pressig",
"495755", "Kalletal\-Varenholz",
"498581", "Waldkirchen\ Niederbayern",
"4940", "Hamburg",
"499275", "Speichersdorf",
"499704", "Euerdorf",
"492626", "Selters\ Westferwald",
"497833", "Hornberg\ Schwarzwaldbahn",
"4938738", "Karow\ bei\ Lübz",
"4936084", "Heuthen",
"4936943", "Bettenhausen\ Thüringen",
"493865", "Holthusen",
"495053", "Fassberg\-Müden",
"499356", "Burgsinn",
"4938233", "Prerow\ Ostseebad",
"499946", "Hohenwarth\ bei\ Kötzing",
"494296", "Schwanewede\-Aschwarden",
"494492", "Saterland",
"4938450", "Tarnow\ bei\ Bützow",
"498801", "Seeshaupt",
"499563", "Rödental",
"495175", "Lehrte\-Arpke",
"499852", "Feuchtwangen",
"4933704", "Baruth\ Mark",
"492686", "Weyerbusch",
"494183", "Jesteburg",
"4938461", "Bützow",
"4933708", "Rangsdorf",
"499628", "Ursensollen",
"498374", "Dietmannsried",
"492358", "Meinerzhagen\-Valbert",
"49461", "Flensburg",
"492948", "Lippstadt\-Rebbeke",
"496580", "Zemmer",
"4933203", "Kleinmachnow",
"492555", "Schöppingen",
"494958", "Jemgum",
"497744", "Stühlingen",
"495533", "Bodenwerder",
"494545", "Seedorf\ Lauenburg",
"494348", "Schönkirchen",
"497062", "Beilstein\ Württemberg",
"493394", "Wittstock\ Dosse",
"497906", "Braunsbach",
"494123", "Barmstedt",
"492853", "Schermbeck",
"495941", "Neuenhaus\ Dinkel",
"492562", "Gronau\ Westfalen",
"495351", "Helmstedt",
"4936871", "Bad\ Colberg\-Heldburg",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4936694", "Schkölen\ Thüringen",
"4938232", "Zingst\ Ostseebad",
"496663", "Steinau\ an\ der\ Strasse",
"4934901", "Rosslau\ Elbe",
"494254", "Eystrup",
"4939855", "Parmen\-Weggun",
"499394", "Esselbach",
"496269", "Gundelsheim\ Württemberg",
"497173", "Heubach",
"493628", "Arnstadt",
"49541", "Osnabrück",
"497055", "Neuweiler\ Kreis\ Calw",
"499429", "Rain\ Niederbayern",
"492244", "Königswinter\-Oberpleis",
"494191", "Kaltenkirchen\ Holstein",
"498546", "Windorf\-Otterskirchen",
"494843", "Viöl",
"495835", "Wahrenholz",
"4939397", "Geestgottberg",
"4935754", "Klettwitz",
"496095", "Bessenbach",
"498728", "Geratskirchen",
"496588", "Pluwig",
"494857", "Barlt",
"496385", "Reichenbach\-Steegen",
"493563", "Spremberg",
"498295", "Altenmünster\ Schwaben",
"4935477", "Rietzneuendorf\-Friedrichshof",
"495772", "Espelkamp",
"494734", "Stadland\-Seefeld",
"4933202", "Töplitz",
"4939954", "Stavenhagen\ Reuterstadt",
"4934325", "Mochau\-Lüttewitz",
"4934346", "Narsdorf",
"4934604", "Niemberg",
"499084", "Bissingen\ Schwaben",
"495692", "Wolfhagen",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"496403", "Linden\ Hessen",
"496139", "Budenheim",
"496325", "Lambrecht\ Pfalz",
"493946", "Quedlinburg",
"494340", "Achterwehr",
"496746", "Pfalzfeld",
"498367", "Rosshaupten\ Forggensee",
"499865", "Adelshofen\ Mittelfranken",
"494950", "Holtland",
"498377", "Unterthingau",
"499875", "Wolframs\-Eschenbach",
"495152", "Hessisch\ Oldendorf",
"497233", "Niefern\-Öschelbronn",
"4938229", "Bad\ Sülze",
"498593", "Untergriesbach",
"492992", "Marsberg",
"4937295", "Lugau\ Erzgebirge",
"494392", "Nortorf\ bei\ Neumünster",
"499252", "Helmbrechts",
"4933981", "Putlitz",
"493573", "Senftenberg",
"497747", "Berau",
"495044", "Springe\-Eldagsen",
"4935951", "Neukirch\ Lausitz",
"494105", "Seevetal",
"497753", "Albbruck",
"493494", "Wolfen",
"4938727", "Mestlin",
"4939751", "Penkun",
"4934203", "Zwenkau",
"4933767", "Friedersdorf\ bei\ Berlin",
"497163", "Ebersbach\ an\ der\ Fils",
"4935266", "Heyda\ bei\ Riesa",
"499732", "Hammelburg",
"496673", "Haunetal",
"499921", "Regen",
"492572", "Emsdetten",
"4935032", "Langenhennersdorf",
"493329", "Stahnsdorf",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"496897", "Sulzbach\ Saar",
"498561", "Pfarrkirchen\ Niederbayern",
"499803", "Colmberg",
"498427", "Wellheim",
"494338", "Alt\ Duvenstedt",
"499285", "Kirchenlamitz",
"495037", "Bad\ Rehburg",
"496465", "Breidenbach\ bei\ Biedenkopf",
"494535", "Nahe",
"495543", "Staufenberg\ Niedersachsen",
"497734", "Gailingen",
"4933204", "Beelitz\ Mark",
"495339", "Gielde",
"4939952", "Grammentin",
"4936845", "Gehlberg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"498094", "Steinhöring",
"497950", "Schnelldorf",
"4936920", "Grossenlupnitz",
"497340", "Neenstetten",
"4938733", "Karbow\-Vietlübbe",
"495185", "Duingen",
"495966", "Meppen\-Apeldorn",
"492676", "Ulmen",
"4936948", "Römhild",
"492938", "Ense",
"499225", "Stadtsteinach",
"493961", "Altentreptow",
"492045", "Bottrop\-Kirchhellen",
"494173", "Wulfsen",
"496761", "Simmern\ Hunsrück",
"497254", "Waghäusel",
"498384", "Röthenbach\ Allgäu",
"496294", "Krautheim\ Jagst",
"499369", "Uettingen",
"4939031", "Dähre",
"4936692", "Bürgel",
"4938234", "Born\ Darss",
"4936083", "Uder",
"4936944", "Rentwertshausen",
"4933703", "Sperenberg",
"497843", "Renchen",
"498324", "Hindelang",
"496151", "Darmstadt",
"4935752", "Ruhland",
"499936", "Wallerfing",
"497191", "Backnang",
"4933208", "Fahrland",
"4933093", "Fürstenberg\ Havel",
"496691", "Schwalmstadt",
"497448", "Seewald",
"497082", "Neuenbürg\ Württemberg",
"494753", "Balje",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933603", "Falkenhagen\ bei\ Seelow",
"497651", "Titisee\-Neustadt",
"492406", "Herzogenrath",
"492202", "Bergisch\ Gladbach",
"492743", "Daaden",
"497022", "Nürtingen",
"493971", "Anklam",
"499077", "Bachhagel",
"496771", "St\ Goarshausen",
"496509", "Büdlich",
"494163", "Horneburg\ Niederelbe",
"4934783", "Gerbstedt",
"492834", "Straelen",
"492666", "Freilingen\ Westerwald",
"495976", "Salzbergen",
"495245", "Herzebrock\-Clarholz",
"494233", "Blender",
"496856", "St\ Wendel\-Niederkirchen",
"4936741", "Bad\ Blankenburg",
"494639", "Schafflund",
"493591", "Bautzen",
"496352", "Kirchheimbolanden",
"499523", "Hofheim\ in\ Unterfranken",
"499408", "Altenthann",
"494747", "Beverstedt",
"496475", "Weilmünster\-Wolfenhausen",
"498642", "Übersee",
"498709", "Eching\ Niederbayern",
"498571", "Simbach\ am\ Inn",
"497392", "Laupheim",
"499145", "Solnhofen",
"494222", "Ganderkesee",
"494426", "Wangerland\-Horumersiel",
"497939", "Schrozberg\-Spielbach",
"498808", "Pähl",
"496593", "Hillesheim\ Eifel",
"492692", "Kelberg",
"4934929", "Straach",
"497553", "Salem\ Baden",
"4939293", "Dreileben",
"497366", "Abtsgmünd",
"4935975", "Hohnstein",
"4935773", "Schleife",
"492772", "Herborn\ Hessen",
"4934462", "Laucha\ Unstrut",
"4933456", "Wriezen",
"4933933", "Lindow\ Mark",
"499532", "Maroldsweisach",
"496201", "Weinheim\ Bergstr",
"494282", "Sittensen",
"494486", "Edewecht\-Friedrichsfehn",
"4935895", "Klitten",
"4939775", "Ahlbeck\ bei\ Torgelow",
"4939973", "Altkalen",
"494951", "Weener",
"492835", "Issum",
"499681", "Windischeschenbach",
"495244", "Rietberg",
"493693", "Meiningen",
"49241", "Aachen",
"497033", "Weil\ Der\ Stadt",
"499621", "Amberg\ Oberpfalz",
"493773", "Johanngeorgenstadt",
"4935874", "Bernstadt\ an\ der\ Eigen",
"496474", "Villmar\-Aumenau",
"4935691", "Bärenklau\ NL",
"495562", "Dassel\-Markoldendorf",
"492351", "Lüdenscheid",
"492941", "Lippstadt",
"499144", "Pleinfeld",
"495853", "Neu\ Darchau",
"499284", "Schwarzenbach\ an\ der\ Saale",
"495641", "Warburg",
"498269", "Unteregg\ bei\ Mindelheim",
"497735", "Öhningen",
"4938201", "Gelbensande",
"498663", "Ruhpolding",
"4939004", "Köckte\ bei\ Gardelegen",
"496464", "Angelburg",
"494534", "Steinburg\ Kreis\ Storman",
"495572", "Bodenfelde",
"4938324", "Velgast",
"493763", "Glauchau",
"495458", "Hopsten",
"496788", "Sien",
"49234", "Bochum",
"4937430", "Eichigt",
"498095", "Aying",
"496728", "Ober\-Hilbersheim",
"493928", "Schönebeck\ Elbe",
"4936651", "Lobenstein",
"4936255", "Goldbach\ bei\ Gotha",
"495184", "Freden\ Leine",
"4938423", "Bad\ Kleinen",
"493504", "Dippoldiswalde",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"492449", "Blankenheim\ Ahr",
"494142", "Steinkirchen\ Kreis\ Stade",
"4933231", "Pausin",
"497431", "Albstadt\-Ebingen",
"497255", "Graben\-Neudorf",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"496295", "Rosenberg\ Baden",
"492762", "Wenden\ Südsauerland",
"499920", "Bischofsmais",
"498385", "Hergatz",
"497376", "Langenenslingen",
"4933368", "Hohensaaten",
"4939008", "Kunrau",
"4937754", "Zwönitz",
"4938328", "Miltzow",
"4939991", "Daberkow",
"498403", "Pförring",
"499827", "Lichtenau\ Mittelfranken",
"498139", "Röhrmoos",
"498325", "Oberstaufen\-Thalkirchdorf",
"4933831", "Weseram",
"492152", "Kempen",
"4936336", "Klettenberg",
"499874", "Neuendettelsau",
"492557", "Wettringen\ Kreis\ Steinfurt",
"497951", "Crailsheim",
"498771", "Ergoldsbach",
"498509", "Ruderting",
"4935872", "Neusalza\-Spremberg",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"493542", "Lübbenau\ Spreewald",
"494547", "Gudow\ Lauenburg",
"495045", "Springe\-Bennigsen",
"499723", "Röthlein",
"493671", "Saalfeld\ Saale",
"494104", "Aumühle\ bei\ Hamburg",
"493867", "Lübstorf",
"498856", "Penzberg",
"4934363", "Cavertitz",
"494862", "Garding",
"495676", "Liebenau\ Hessen",
"494553", "Geschendorf",
"499277", "Warmensteinach",
"496150", "Weiterstadt",
"497222", "Rastatt",
"4939741", "Jatznick",
"497426", "Gosheim",
"494939", "Baltrum",
"493909", "Klötze\ Altmark",
"497486", "Horb\-Altheim",
"496571", "Wittlich",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"4934464", "Freyburg\ Unstrut",
"496642", "Schlitz",
"492339", "Sprockhövel\-Hasslinghausen",
"4939400", "Wefensleben",
"492543", "Billerbeck\ Westfalen",
"495177", "Edemissen\-Abbensen",
"494366", "Grömitz\-Cismar",
"495167", "Walsrode\-Westenholz",
"494255", "Martfeld",
"498465", "Kipfenberg",
"4939826", "Blankensee\ bei\ Neustrelitz",
"497142", "Bietigheim\-Bissingen",
"499395", "Triefenstein",
"494431", "Wildeshausen",
"496561", "Bitburg",
"496427", "Cölbe\-Schönstadt",
"497054", "Wildberg\ Württemberg",
"492245", "Much",
"499267", "Nordhalben",
"4937752", "Eibenstock",
"4938781", "Mellen",
"4939245", "Loburg",
"4939226", "Hohenziatz",
"492638", "Waldbreitbach",
"4933055", "Kremmen",
"496094", "Weibersbrunn",
"493877", "Wittenberge",
"495834", "Wittingen\-Knesebeck",
"494872", "Hanerau\-Hademarschen",
"4939002", "Oebisfelde",
"4938322", "Richtenberg",
"4933927", "Linum",
"493661", "Greiz",
"498294", "Horgau",
"4935243", "Weinböhla",
"496384", "Konken",
"495743", "Espelkamp\-Gestringen",
"495202", "Oerlinghausen",
"494735", "Butjadingen\-Stollhamm",
"492596", "Nordkirchen",
"495406", "Belm",
"497534", "Reichenau\ Baden",
"4939083", "Messdorf",
"498761", "Moosburg\ an\ der\ Isar",
"497459", "Nagold\-Hochdorf",
"499085", "Alerheim",
"495237", "Augustdorf",
"499636", "Plössberg",
"499978", "Schönthal\ Oberpfalz",
"498151", "Starnberg",
"496324", "Hassloch",
"4935843", "Hirschfelde\ bei\ Zittau",
"499102", "Wilhermsdorf",
"4933362", "Liepe\ Kreis\ Barnim",
"498363", "Pfronten",
"492843", "Rheinberg",
"495951", "Werlte",
"499493", "Beratzhausen",
"495341", "Salzgitter",
"496407", "Rabenau\ Hessen",
"496871", "Wadern",
"492191", "Remscheid",
"494244", "Harpstedt",
"4936463", "Gebstedt",
"4937465", "Tannenbergsthal\ Vogtland",
"497045", "Oberderdingen",
"49465", "Sylt",
"492254", "Weilerswist",
"496432", "Diez",
"494562", "Grömitz",
"498556", "Haidmühle",
"496236", "Neuhofen\ Pfalz",
"4933397", "Wandlitz",
"493421", "Torgau",
"494853", "Sankt\ Michaelisdonn",
"4938306", "Samtens",
"495426", "Glandorf",
"494847", "Oster\-Ohrstedt",
"498036", "Stephanskirchen\ Simssee",
"495222", "Bad\ Salzuflen",
"498860", "Bernbeuren",
"4938872", "Rehna",
"4939390", "Iden",
"495190", "Soltau\-Emmingen",
"499182", "Velburg",
"498809", "Wessobrunn",
"497676", "Feldberg\ Schwarzwald",
"497938", "Mulfingen\ Jagst",
"4939202", "Gross\ Ammensleben",
"496166", "Fischbachtal",
"496078", "Gross\-Umstadt",
"498685", "Kirchanschöring",
"496304", "Wolfstein\ Pfalz",
"492734", "Freudenberg\ Westfalen",
"499122", "Schwabach",
"496667", "Steinau\-Ulmbach",
"499574", "Marktzeuln",
"496756", "Winterbach\ Soonwald",
"4933336", "Passow\ Kreis\ Uckermark",
"4939883", "Gross\ Dölln",
"493725", "Zschopau",
"492857", "Rees\-Mehr",
"493346", "Seelow",
"495282", "Schieder\-Schwalenberg",
"4938843", "Bennin",
"4937361", "Neuhausen\ Erzgebirge",
"495142", "Eschede",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"499564", "Bad\ Rodach",
"496677", "Neuenstein\ Hessen",
"492392", "Werdohl",
"497834", "Wolfach",
"496068", "Beerfelden",
"499446", "Altmannstein",
"497666", "Denzlingen",
"499242", "Gössweinstein",
"499091", "Monheim\ Schwaben",
"4938720", "Grebbin",
"4935322", "Doberlug\-Kirchhain",
"498138", "Schwabhausen\ bei\ Dachau",
"495054", "Bergen\-Sülze",
"495650", "Cornberg",
"4936735", "Probstzella",
"494641", "Süderbrarup",
"495459", "Hörstel",
"495534", "Eschershausen\ an\ der\ Lenne",
"496789", "Heimbach\ Nahe",
"497202", "Karlsbad",
"497743", "Ühlingen\-Birkendorf",
"494458", "Wiefelstede\-Spohle",
"494124", "Glückstadt",
"498268", "Tussenhausen",
"499381", "Volkach",
"499321", "Kitzingen",
"492448", "Hellenthal\-Rescheid",
"496861", "Merzig",
"494184", "Hanstedt\ Nordheide",
"497237", "Neulingen\ Enzkreis",
"498373", "Altusried",
"492651", "Mayen",
"495862", "Hitzacker\ Elbe",
"495553", "Kalefeld",
"494938", "Hagermarsch",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4938874", "Lützow",
"4939321", "Arneburg",
"495939", "Sustrum",
"4938459", "Laage",
"498192", "Schondorf\ am\ Ammersee",
"4939204", "Niederndodeleben",
"497940", "Künzelsau",
"499775", "Schönau\ an\ der\ Brend",
"499204", "Plankenfels",
"492535", "Sendenhorst\-Albersloh",
"494796", "Teufelsmoor",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"495366", "Jembke",
"492338", "Breckerfeld",
"494177", "Drage\ Elbe",
"499832", "Wassertrüdingen",
"496684", "Hofbieber\-Schwarzbach",
"493361", "Fürstenwalde\ Spree",
"4936927", "Unterellen",
"497244", "Weingarten\ Baden",
"4938486", "Gustävel",
"497853", "Kehl\-Bodersweier",
"499471", "Burglengenfeld",
"497562", "Isny\ im\ Allgäu",
"4939208", "Loitsche",
"499336", "Bütthard",
"496893", "Saarbrücken\-Ensheim",
"498423", "Titting",
"496020", "Heigenbrücken",
"496624", "Heringen\ Werra",
"495033", "Wunstorf\-Grossenheidorn",
"492173", "Langenfeld\ Rheinland",
"492163", "Schwalmtal\ Niederrhein",
"497458", "Ebhausen",
"497124", "Trochtelfingen\ Hohenz",
"494406", "Berne",
"497572", "Mengen\ Württemberg",
"494202", "Achim\ bei\ Bremen",
"4939603", "Burg\ Stargard",
"494743", "Langen\ bei\ Bremerhaven",
"496281", "Buchen\ Odenwald",
"499527", "Knetzgau",
"499461", "Roding",
"497641", "Emmendingen",
"4934953", "Gräfenhainichen",
"496221", "Heidelberg",
"492753", "Erndtebrück",
"494237", "Bendingbostel",
"493371", "Luckenwalde",
"497184", "Kaisersbach",
"4939425", "Dingelstedt\ am\ Huy",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"499073", "Gundelfingen\ an\ der\ Donau",
"494167", "Apensen",
"492747", "Molzhain",
"499765", "Trappstadt",
"495255", "Altenbeken",
"495431", "Quakenbrück",
"498021", "Waakirchen",
"492639", "Anhausen\ Kreis\ Neuwied",
"496342", "Schweigen\-Rechtenbach",
"498081", "Dorfen\ Stadt",
"4934497", "Langenleuba\-Niederhain",
"494757", "Wanna",
"492233", "Hürth\ Rheinland",
"4935605", "Komptendorf",
"494666", "Ladelund",
"498652", "Berchtesgaden",
"495872", "Stoetze",
"494834", "Büsum",
"4935324", "Crinitz",
"4938791", "Bad\ Wilsnack",
"499155", "Simmelsdorf",
"4935201", "Langebrück",
"4938752", "Zierzow\ bei\ Ludwigslust",
"495857", "Bleckede\-Brackede",
"492486", "Nettersheim",
"497125", "Bad\ Urach",
"498677", "Burghausen\ Salzach",
"496589", "Kell\ am\ See",
"495734", "Bergkirchen\ Westfalen",
"494772", "Oberndorf\ Oste",
"497543", "Kressbronn\ am\ Bodensee",
"496138", "Mommenheim",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497966", "Unterschneidheim",
"492222", "Bornheim\ Rheinland",
"498176", "Egling\ bei\ Wolfratshausen",
"4939933", "Vollrathsruhe",
"492426", "Nörvenich",
"4939456", "Altenbrak",
"494941", "Aurich",
"496268", "Hüffenhardt",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"494351", "Eckernförde",
"499764", "Höchheim",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4935361", "Schlieben",
"4935935", "Kleinwelka",
"49441", "Oldenburg",
"496373", "Schönenberg\-Kübelberg",
"4939387", "Havelberg",
"495191", "Soltau",
"4937322", "Brand\-Erbisdorf",
"497557", "Herdwangen\-Schönach",
"4939489", "Strassberg\ Harz",
"493629", "Stadtilm",
"499503", "Oberhaid\ Oberfranken",
"496597", "Jünkerath",
"498861", "Schongau",
"499154", "Pommelsbrunn",
"492951", "Büren",
"495843", "Wustrow\ Wendland",
"494835", "Albersdorf\ Holstein",
"499428", "Kirchroth",
"495105", "Barsinghausen",
"495651", "Eschwege",
"4936376", "Straussfurt",
"495082", "Langlingen",
"499090", "Rain\ Lech",
"495448", "Barver",
"498407", "Grossmehring",
"499823", "Leutershausen",
"493585", "Löbau",
"496363", "Niederkirchen",
"493525", "Riesa",
"499774", "Oberelsbach",
"498236", "Fischach",
"4934292", "Brandis\ bei\ Wurzen",
"495022", "Wietzen",
"493328", "Teltow",
"499205", "Vorbach",
"498432", "Burgheim",
"496556", "Pronsfeld",
"492534", "Münster\-Roxel",
"4933675", "Tauche",
"4936784", "Stützerbach",
"4939364", "Dolle",
"4936026", "Struth\ bei\ Mühlhausen",
"498166", "Allershausen\ Oberbayern",
"492054", "Essen\-Kettwig",
"494152", "Geesthacht",
"496809", "Grossrosseln",
"497245", "Durmersheim",
"497976", "Sulzbach\-Laufen",
"4936202", "Neudietendorf",
"4934241", "Jesewitz",
"496036", "Wölfersheim",
"498756", "Nandlstadt",
"494762", "Kutenholz",
"4937437", "Bad\ Elster",
"498667", "Seeon\-Seebruck",
"4939831", "Feldberg",
"496625", "Niederaula",
"498304", "Wildpoldsried",
"4937423", "Adorf\ Vogtland",
"495173", "Uetze",
"4938853", "Drönnewitz\ bei\ Hagenow",
"498281", "Thannhausen\ Schwaben",
"496391", "Dahn",
"499565", "Untersiemau",
"492547", "Rosendahl\-Osterwick",
"4936603", "Weida",
"497351", "Biberach\ an\ der\ Riss",
"4939407", "Seehausen\ Börde",
"497941", "Öhringen",
"4937324", "Reinsberg\ Sachsen",
"4938379", "Benz\ Usedom",
"497835", "Zell\ am\ Harmersbach",
"4938758", "Dömitz",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"4937605", "Hartenstein\ Sachsen",
"498221", "Günzburg",
"496888", "Lebach\-Steinbach",
"494557", "Blunk",
"4936425", "Isserstedt",
"4934771", "Querfurt",
"49741", "Rottweil",
"495055", "Fassberg",
"493863", "Crivitz",
"496021", "Aschaffenburg",
"499727", "Schonungen\-Marktsteinach",
"492366", "Herten\ Westfalen",
"498846", "Uffing\ am\ Staffelsee",
"4937328", "Grossschirma",
"4938754", "Leussow\ bei\ Ludwigslust",
"495535", "Polle",
"494543", "Nusse",
"49340", "Dessau\ Anh",
"494125", "Seestermühe",
"494339", "Christiansholm",
"4933741", "Niedergörsdorf",
"494185", "Marxen\ Auetal",
"496652", "Hünfeld",
"494966", "Neubörger",
"492553", "Ochtrup",
"492104", "Mettmann",
"496081", "Usingen",
"499901", "Hengersberg\ Bayern",
"498342", "Marktoberdorf",
"492862", "Südlohn",
"496192", "Hofheim\ am\ Taunus",
"492872", "Rhede\ Westfalen",
"494976", "Spiekeroog",
"494638", "Tarp",
"4934298", "Taucha\ bei\ Leipzig",
"494245", "Neuenkirchen\ bei\ Bassum",
"496220", "Wilhelmsfeld",
"495233", "Steinheim\ Westfalen",
"497152", "Leonberg\ Württemberg",
"4936204", "Stotternheim",
"4933845", "Borkheide",
"497044", "Mönsheim",
"492431", "Erkelenz",
"4936071", "Teistungen",
"498708", "Weihmichl\-Unterneuhausen",
"492255", "Euskirchen\-Flamersheim",
"4935727", "Burghammer",
"4933920", "Walsleben\ bei\ Neuruppin",
"497762", "Wehr\ Baden",
"499133", "Baiersdorf\ Mittelfranken",
"499409", "Pielenhofen",
"4939055", "Hörsingen",
"4935829", "Gersdorf\ bei\ Görlitz",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"4939927", "Nossentiner\ Hütte",
"499263", "Ludwigsstadt",
"495753", "Auetal\-Bernsen",
"4934978", "Radegast\ Kreis\ Köthen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"497449", "Baiersbronn\-Obertal",
"498684", "Fridolfing",
"4935053", "Glashütte\ Sachsen",
"496483", "Selters\ Taunus",
"498020", "Weyarn",
"498624", "Obing",
"4934294", "Rackwitz",
"496423", "Wetter\ Hessen",
"496305", "Hochspeyer",
"4936703", "Gräfenthal",
"492735", "Neunkirchen\ Siegerl",
"496508", "Hetzerath\ Mosel",
"4936208", "Ermstedt",
"498141", "Fürstenfeldbruck",
"4939362", "Grieben\ bei\ Tangerhütte",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"499575", "Weismain",
"495163", "Fallingbostel\-Dorfmark",
"499378", "Eichenbühl\-Riedern",
"493724", "Burgstädt",};
$areanames{de} = {"494497", "Barßel\-Harkebrügge",
"498633", "Tüßling",
"495827", "Unterlüß",
"495064", "Groß\ Düngen",
"4936949", "Obermaßfeld\-Grimmenthal",
"497162", "Süßen",
"492203", "Köln\-Porz",
"4989", "München",
"4935240", "Tauscha\ bei\ Großenhain",
"498170", "Straßlach\-Dingharting",
"4934493", "Gößnitz\ Thüringen",
"4934445", "Stößen",
"4936484", "Knau\ bei\ Pößneck",
"494684", "Langeneß\ Hallig",
"495384", "Seesen\-Groß\ Rhüden",
"494483", "Ovelgönne\-Großenmeer",
"494509", "Groß\ Grönau",
"493647", "Pößneck",
"4939976", "Groß\ Bützin",
"4935248", "Schönfeld\ bei\ Großenhain",
"496364", "Nußbach\ Pfalz",
"498536", "Kößlarn",
"4935753", "Großräschen",
"495053", "Faßberg\-Müden",
"4939934", "Groß\ Plasten",
"499656", "Moosbach\ bei\ Vohenstrauß",
"499567", "Seßlach\-Gemünda",
"4939883", "Groß\ Dölln",
"499242", "Gößweinstein",
"497351", "Biberach\ an\ der\ Riß",
"496663", "Steinau\ an\ der\ Straße",
"4934901", "Roßlau\ Elbe",
"498367", "Roßhaupten\ Forggensee",
"4938234", "Born\ Darß",
"492339", "Sprockhövel\-Haßlinghausen",
"499636", "Plößberg",
"4936072", "Weißenborn\-Lüderode",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"49221", "Köln",
"4935952", "Großröhrsdorf\ OL",
"49911", "Nürnberg",
"4935726", "Groß\ Särchen",
"4935841", "Großschönau\ Sachsen",
"496252", "Heppenheim\ Bergstraße",
"497355", "Hochdorf\ Riß",
"499141", "Weißenburg\ in\ Bayern",
"4935938", "Großpostwitz\ OL",
"496321", "Neustadt\ an\ der\ Weinstraße",
"498807", "Dießen\ am\ Ammersee",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;