#!perl
use strict;
use warnings;
use ExtUtils::MakeMaker;
WriteMakefile(
    NAME         => 'CPAN::Mini::Webserver',
    VERSION_FROM => 'lib/CPAN/Mini/Webserver.pm',
    ABSTRACT     => 'Search and browse Mini CPAN',
    AUTHOR       => 'Leon Brocard <acme@astray.com>',
    LICENSE      => 'perl',
    PREREQ_PM    => {
        'App::Cache'               => '0',
        'Archive::Peek'            => '0.33',
        'Capture::Tiny'            => '0',
        'CGI'                      => '3.16',
        'Compress::Zlib'           => '0',
        'CPAN::Mini'               => '0.565',
        'Cwd'                      => '0',
        'File::Path'               => '0',
        'File::Slurp'              => '0',
        'File::Type'               => '0',
        'HTTP::Server::Simple'     => '0.34',
        'List::MoreUtils'          => '0',
        'MIME::Base64'             => '0',
        'Module::InstalledVersion' => '0',
        'Moose'                    => '0',
        'Parse::CPAN::Authors'     => '0',
        'Parse::CPAN::Whois'       => '0.02',
        'Parse::CPAN::Meta'        => '0',
        'Parse::CPAN::Packages'    => '2.35',
        'Path::Class'              => '0',
        'Pod::Simple::HTML'        => '0',
        'PPI'                      => '0',
        'PPI::HTML'                => '0',
        'Search::QueryParser'      => '0',
        'Search::Tokenizer'        => '0',
        'String::CamelCase'        => '0',
        'Template::Declare'        => '0.29',
        'Test::InDistDir'          => '0',
        'Test::More'               => '0',
        'Text::Unidecode'          => '0',
    },
    'EXE_FILES' => ['bin/minicpan_webserver'],
);
