use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

###########################################################
##         if built from a parent directory,              #
##     at install, the parent Makefile must execute       #
##                                                        #
##           as first step in install                     #
## @cd DBTarpit && $(MAKE) install_libdbtarpit $(PASTHRU) #
## @cd DBTarpit && $(MAKE) install_daemon $(PASTHRU)      #
##                                                        #
##        as step immediately after 'all'                 #
## @cd DBTarpit && $(MAKE) clean_CTest $(PASTHRU)         #
## @cd DBTarpit && $(MAKE) relink_subdirs $(PASTHRU)      #
##                                                        #
###########################################################

use vars qw($CONFIG);
use Config;
use Cwd qw(abs_path);
require 'lib/IPTables/IPv4/DBTarpit/Inst.pm';
import IPTables::IPv4::DBTarpit::Inst qw(:all);

if ((caller)[1]) {
  hard_fail("Do not MAKE __PACKAGE__ as a sibling process
it contains directory sensitive components.");
}

my $CC = $Config{ccname};
my $OS = $Config{osname};

unless ($OS =~ /linux/) {
  print STDERR "Only works on Linux with IPTABLES\n";
  exit 0;
}
# checkfor installed libnet 1.0 or greater
my $libnetstatus = system("./local_config $CC");
if ($libnetstatus) {
  print STDERR "YOUR MUST INSTALL libnet VERSION 1.0.0 or greater\n";
  exit 0;
}

my $pmname = 'DBTarpit.pm';
open(V,$pmname)
	or hard_fail("could not open $pmname to get version number");
my $c_version;
while (<V>) {
  next unless $_ =~ /\$VERSION.+(char[^;]+;)/;
  $c_version = $1;
  last;
}
close V;
hard_fail("could not find version number in $pmname")
	unless $c_version;
hard_fail("could not open 'c_version.h' for local write")
	unless open(H,'>./c_version.h');
print H qq|
/*	c_version.h
 *
 *	Do not edit this file. It was automatically created by
 *	Makefile.PL and contains the most recent version number
 */
$c_version
|;
close H;

open(V,'bdbtarpit.h') 
	or hard_fail("could not open bdbtarpit.h to get version number");
my ($major,$minor,$patch);
while(<V>) {
  if ($_ =~ /MAJOR\s+(\d+)/) {
    $major = $1;
  } elsif($_ =~ /MINOR\s+(\d+)/) {
    $minor = $1;
  } elsif($_ =~ /PATCH\s+(\d+)/) {
    $patch = $1;
    last;
  }
}
close V;

hard_fail("could not extract version information from bdbtarpit.h, bad format??")
	unless	defined $major && defined $minor && defined $patch;

my $bdbtarpit_version	= "${major}:${minor}:${patch}";

# create visible binary directory
symlink '.libs', 'bin';

my $supported_os = './supported_os.h';
hard_fail("could not open $supported_os for local write")
	unless open(H,'>'.$supported_os);

$supported_os = osname();
print H qq
|#define DBTARPIT_SUPPORTED_OS_$supported_os 1	/* 
#
# supported_os.h, |, scalar localtime(), qq|
#
# Do not edit this file. It was automatically created by 
# Makefile.Pl and is OS specific for this installation.
#
'${supported_os}';	# perl return
#			*/
|;
close H;

my $conf = 'config.db';
my $localconf = abs_path('./').'/'.$conf;
my $configtxt;

if ((caller)[0]) {
  my $master = abs_path('../').'/'.$conf;
  hard_fail("failed to access $_")
	if ($_ = cpfromto($master,$localconf));

  $CONFIG = do $localconf;
  $configtxt = make_text($CONFIG);
}
else {
  $configtxt = do 'inst/dialog.pl';
}

my $objects	= 'libipq_wrapper.o main.o tarpit.o util_pid.o fifo.o';
my $depend	= {'CTest.o'   => $lib_a,};
my $library	= 'libdbtarpit';
my $lib_a	= './.libs/'. $library .'.a';
my $lib_la	= $library .'.la';
my $libobjs	= $objects .' '. $lib_la;
my $libtest	= $objects .' '. $lib_a;


my $daemon	= 'dbtarpit_test_object';
my $daemon_real	= 'dbtarpit';

WriteMakefile(
    'NAME'		=> 'IPTables::IPv4::DBTarpit::CTest',
    'DISTNAME'		=> 'IPTables-IPv4-DBTarpit',
    'VERSION_FROM'	=> $pmname, # finds $VERSION
    'PM'		=> {'DBTarpit.pm' => '$(INST_LIB)/IPTables/IPv4/DBTarpit.pm',
			    'lib/IPTables/IPv4/DBTarpit/Inst.pm' =>
				'$(INST_LIB)/IPTables/IPv4/DBTarpit/Inst.pm',
			    'SiteConfig.pm' => '$(INST_LIB)/IPTables/IPv4/DBTarpit/SiteConfig.pm',
			},
    'MAN1PODS'		=> {$library .'.pod' => '$(INST_MAN1DIR)/'. $library . '.$(MAN1EXT)',
			    $daemon_real .'.pod' => '$(INST_MAN1DIR)/'. $daemon_real .'.$(MAN1EXT)',
			},
    'MAN3PODS'		=> {'DBTarpit.pm' => '$(INST_MAN3DIR)/IPTables::IPv4::DBTarpit.$(MAN3EXT)',
			    'lib/IPTables/IPv4/DBTarpit/Inst.pm' =>
				'$(INST_MAN3DIR)/IPTables::IPv4::DBTarpit::Inst.$(MAN3EXT)',
			    'SiteConfig.pm' => '$(INST_MAN3DIR)/IPTables::IPv4::DBTarpit::SiteConfig.$(MAN3EXT)',
			},
    'LIBS'		=> ['-ldb -lipq -lnet -lm'], # e.g., '-lm'
    'DEFINE'		=> '', # e.g., '-DHAVE_SOMETHING'
	# Insert -I. if you add *.h files later:
    'INC'		=> "", # e.g., '-I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    'OBJECT'		=> "$libtest CTest.o", # link all the C files too
    'clean'		=> {FILES	=> "$daemon *.bs *.o *.lo *.la *~ .libs tmp* bin libipq.h libnet_version.h"},
    'depend'		=> {$depend,},
);

sub MY::post_constants {
  my $pod2text = $Config{scriptdirexp} .'/pod2text';
  my $post_constants;
  if (-e $pod2text) {
    $post_constants = q| 
MY_POD2TEXT = |. $pod2text .q|
LDTool = ./libtool --mode=link $(LD) -g -s
|. $configtxt .q|
|;
  } else {
        $post_constants = q| 
MY_POD2TEXT = echo "perl distro missing 'pod2text' to convert "
LDTool = ./libtool --mode=link $(LD) -g -s
|. $configtxt .q|
|;
  }
}

sub MY::postamble {
  package MY;
  my $postamble = q|
README  : DBTarpit.pm
	@$(MY_POD2TEXT) DBTarpit.pm > README

.PHONY: clean_CTest relink_subdirs $(DBTP_DAEMON_DIR)/|. $daemon_real .q|

install_|. $library .q| : |. $library .q|.la
	./libtool --mode=install ./install-sh -c -s |. $library .q|.la $(DBTP_LIBRARY_DIR)/|. $library .q|.la
	@$(MKPATH) $(DBTP_INCLUDE_DIR)
	$(CP) bdbtarpit.h $(DBTP_INCLUDE_DIR)

install_daemon : |. $daemon .q| $(DBTP_DAEMON_DIR)/|. $daemon_real .q|
	@$(NOOP)

# make the BDB environment/home directory while we're at it
$(DBTP_DAEMON_DIR)/|. $daemon_real .q|	:
	@$(MKPATH) $(DBTP_ENVHOME_DIR)
	@$(MKPATH) $(DBTP_DAEMON_DIR)
	$(CP) bin/|. $daemon_real .q| $(DBTP_DAEMON_DIR)/|. $daemon_real .q|

# Since these are only used for testing and are large, remove them
# from the install image as they will be rebuilt as needed.

clean_CTest     :
	@$(RM_RF) $(INST_AUTODIR)
	@$(RM_RF) $(INST_ARCHAUTODIR)

relink_subdirs    :
	@cd Tools && $(MAKE) relink4_$(LINKTYPE)_install $(PASTHRU)

SiteConfig.pm	: config.db
	$(PERL) inst/make_Config.pl

|;
}

sub MY::top_targets {
  package MY;   # add dependencies for .pm and xs files
  my $inherited = shift->SUPER::top_targets(@_);
  $inherited =~ s/(\npure_all\s+::.+)/$1 $daemon README/;
  $inherited =~ s|(\npure_all\s+::.+)config(.+)|$1 libtool SiteConfig.pm config$2|;
  $inherited .= q|

# Added for for '|. $daemon .q|'

libipq.h :
	./local_config $(CC)

libnet_version.h :
	./local_config $(CC)

libtool		:
	$(SHELL) ltconfig ./ltmain.sh

|. $daemon .q|	: |. $libobjs .q|
	$(LDTool) $(LDFLAGS) |. $libobjs .q| -o |. $daemon .q| $(LDLOADLIBS)
	$(CP) ./bin/|. $daemon .' ./bin/'. $daemon_real .q|

bdbtarpit.o	: bdbtarpit.c bdbtarpit.h
	./libtool --mode=compile $(CC) -g $(INC) $(CCFLAGS) $(OPTIMIZE) -c bdbtarpit.c

fifo.o		: fifo.c
	$(CC) -c $(INC) $(CCFLAGS) $(OPTIMIZE) fifo.c

main.o		: libipq.h main.c data.c godaemon.c misc.c check.c tarpit.h \
		  supported_os.h defines.h bdbtarpit.h util_pid_func.h fifo.c fifo_func.h \
		  c_version.h
	$(CC) -c $(INC) $(CCFLAGS) $(OPTIMIZE) main.c

libipq_wrapper.o : libipq.h libipq_wrapper.c
	$(CC) -c $(INC) $(CCFLAGS) $(OPTIMIZE) libipq_wrapper.c

tarpit.o	: libnet_version.h endian.h defines.h misc_func.h libipq_wrapper.h tarpit.c
	$(CC) -c $(INC) $(CCFLAGS) $(OPTIMIZE) tarpit.c

util_pid.o	: util_pid.c
	$(CC) -c $(INC) $(CCFLAGS) $(OPTIMIZE) util_pid.c

| .qq|
$lib_a	: bdbtarpit.o
| .q|	$(LDTool) -version-info |. $bdbtarpit_version .q| \
		$(LDFLAGS) -o |. $lib_la .q| \
		bdbtarpit.lo -rpath $(DBTP_LIBRARY_DIR) -lm
| .qq|
$lib_la	: bdbtarpit.o
| .q|	$(LDTool) -version-info |. $bdbtarpit_version .q| \
		$(LDFLAGS) -o |. $lib_la .q| \
		bdbtarpit.lo -rpath $(DBTP_LIBRARY_DIR) -lm 

|. $daemon_real .q|.pod	: DBTarpit.pm
	$(CP) DBTarpit.pm |. $daemon_real .q|.pod
|;
}

sub MY::makefile {
  package MY;
  my $inherited = shift->SUPER::makefile(@_);
  $inherited =~ s/(Makefile\s+:.+)/$1 config.db/;
  $inherited .= q|
config.db :
	@$(NOOP);

|;
}

sub MY::install {
  package MY;
  my $inherited = shift->SUPER::install(@_);
  $inherited =~ s/(\ninstall\s+::)/$1 libtool install_${library} install_daemon/;
  $inherited =~ s/(\ninstall_perl\s+::)/$1 libtool install_${library} install_daemon/;
  $inherited =~ s/(\ninstall_site\s+::)/$1 libtool install_${library} install_daemon/;
  $inherited =~ s/(\s+)all(\s+)/${1}all clean_CTest relink_subdirs${2}/g;
  $inherited;
}

sub MY::realclean {
  package MY;
  my $inherited = shift->SUPER::realclean(@_) . q|
	rm -f config.db
	rm -f config.log
	rm -f SiteConfig.pm
	rm -f dbtarpit.pod
	rm -f libtool
	rm -f supported_os.h
|;
}

sub MY::dynamic_lib {
  package MY;
  my $inherited = shift->SUPER::dynamic_lib(@_);
  $inherited =~ s/(LD_RUN_PATH=([^\s]+))/$1 LD_LIBRARY_PATH=$2/;
  $inherited;
}

sub MY::const_config {
  package MY;
  $inherited = shift->SUPER::const_config(@_);
  return q|LANG=en_US
SUPPORTED=en_US:en
|. $inherited;
}
