/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends ClassLoader {
    private static String jarPath;

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            c = this.findClass(name);
        }
        if (c == null) {
            c = ClassLoader.getSystemClassLoader().loadClass(name);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJarPath() {
        if (jarPath != null) {
            return jarPath;
        }
        String classname = JarClassLoader.class.getName().replace('.', '/') + ".class";
        String classpath = System.getProperty("java.class.path");
        String[] classpaths = classpath.split(System.getProperty("path.separator"));
        for (int i = 0; i < classpaths.length; ++i) {
            String path = classpaths[i];
            JarFile jarFile = null;
            JarEntry jarEntry = null;
            try {
                jarFile = new JarFile(path);
                jarEntry = JarClassLoader.findJarEntry(jarFile, classname);
            }
            catch (IOException ioe) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (jarEntry == null) continue;
            jarPath = path;
            break;
        }
        return jarPath;
    }

    private static JarEntry findJarEntry(JarFile jarFile, String entryName) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().equals(entryName)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) {
        Class c = null;
        String jarPath = JarClassLoader.getJarPath();
        if (jarPath != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarPath);
                c = this.loadClassData(jarFile, name);
            }
            catch (IOException ioe) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return c;
    }

    private Class loadClassData(JarFile jarFile, String className) {
        String packageName;
        String entryName = className.replace('.', '/') + ".class";
        JarEntry jarEntry = JarClassLoader.findJarEntry(jarFile, entryName);
        if (jarEntry == null) {
            return null;
        }
        int index = className.lastIndexOf(46);
        if (index >= 0 && this.getPackage(packageName = className.substring(0, index)) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        Class<?> c = null;
        try {
            InputStream is = jarFile.getInputStream(jarEntry);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.copy(is, os);
            byte[] bytes = os.toByteArray();
            c = this.defineClass(className, bytes, 0, bytes.length);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return c;
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }
}

