# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170049;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"432847", "Groß\-Siegharts",
"4314", "Wien",
"437667", "Sankt\ Georgen\ im\ Attergau",
"434264", "Klein\ Sankt\ Paul",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"437954", "Sankt\ Georgen\ am\ Walde",
"4319", "Wien",
"433585", "Sankt\ Lambrecht",
"436414", "Großarl",
"4313", "Wien",
"432815", "Großschönau",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"437218", "Großtraberg",
"437751", "Sankt\ Martin\ im\ Innkreis",
"432955", "Großweikersdorf",
"432686", "Draßburg",
"436565", "Neukirchen\ am\ Großvenediger",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"434785", "Außerfragant",
"436227", "Sankt\ Gilgen",
"435678", "Weißenbach\ am\ Lech",
"432647", "Krumbach\,\ Niederösterreich",
"436276", "Nußdorf\ am\ Haunsberg",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"434226", "Sankt\ Margareten\ im\ Rosental",
"434825", "Großkirchheim",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"432756", "Sankt\ Leonhard\ am\ Forst",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"4312", "Wien",
"434876", "Kals\ am\ Großglockner",
"437254", "Großraming",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"432249", "Groß\-Enzersdorf",
"433158", "Sankt\ Anna\ am\ Aigen",
"432618", "Markt\ Sankt\ Martin",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"432617", "Draßmarkt",
"434286", "Weißbriach",
"435446", "Sankt\ Anton\ am\ Arlberg",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"433119", "Sankt\ Marein\ bei\ Graz",
"432268", "Großmugl",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"437566", "Rosenau\ am\ Hengstpaß",
"437956", "Unterweißenbach",
"435449", "Fließ",
"434783", "Reißeck",
"437224", "Sankt\ Florian",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432263", "Großrußbach",
"437435", "Sankt\ Valentin",
"432822", "Zwettl\-Niederösterreich",
"435557", "Sankt\ Gallenkirch",
"436412", "Sankt\ Johann\ im\ Pongau",
"434879", "Sankt\ Veit\ in\ Defereggen",
"432629", "Warth\,\ Niederösterreich",
"433684", "Sankt\ Martin\ am\ Grimming",
"4315", "Wien",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434266", "Straßburg",
"432242", "Sankt\ Andrä\-Wördern",
"433864", "Sankt\ Marein\ im\ Mürztal",
"434253", "Sankt\ Jakob\ im\ Rosental",
"437219", "Vorderweißenbach",
"432642", "Aspangberg\-Sankt\ Peter",
"433632", "Sankt\ Gallen",
"432719", "Droß",
"433362", "Großpetersdorf",
"436277", "Sankt\ Pantaleon",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"4318", "Wien",
"432674", "Weißenbach\ an\ der\ Triesting",
"435352", "Sankt\ Johann\ in\ Tirol",
"433868", "Tragöß",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"432556", "Großkrut",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"433469", "Sankt\ Oswald\ im\ Freiland",
"433386", "Großsteinbach",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"4316", "Wien",
"434843", "Außervillgraten",
"437565", "Sankt\ Pankraz",
"437717", "Sankt\ Aegidi",
"435245", "Hinterriß",
"432812", "Groß\ Gerungs",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"436477", "Sankt\ Michael\ im\ Lungau",
"432233", "Preßbaum",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"436241", "Sankt\ Koloman",
"433834", "Wald\ am\ Schoberpaß",
"432742", "Sankt\ Pölten",
"433575", "Sankt\ Johann\ am\ Tauern",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"434358", "Sankt\ Andrä",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"434877", "Prägraten\ am\ Großvenediger",
"436247", "Großgmain",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433464", "Groß\ Sankt\ Florian",
"433537", "Sankt\ Georgen\ ob\ Murau",
"432857", "Bad\ Großpertholz",
"4317", "Wien",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"436215", "Straßwalchen",
"432823", "Großglobnitz",};
$areanames{en} = {"436241", "St\.\ Koloman",
"432725", "Frankenfels",
"432714", "Rossatz",
"432774", "Innermanzing",
"434283", "St\.\ Stefan\ im\ Gailtal",
"433616", "Selzthal",
"435556", "Schruns",
"435338", "Kundl",
"437479", "Ardagger",
"432876", "Els",
"432816", "Karlstift",
"435443", "Galtür",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432828", "Rappottenstein",
"432952", "Hollabrunn",
"433586", "Mühlen",
"433177", "Puch\ bei\ Weiz",
"437263", "Bad\ Zell",
"433326", "Stegersbach",
"433117", "Eggersdorf\ bei\ Graz",
"433857", "Neuberg\ an\ der\ Mürz",
"437239", "Lichtenberg",
"432215", "Probstdorf",
"436478", "Zederhaus",
"436418", "Kleinarl",
"432275", "Atzenbrugg",
"434852", "Lienz",
"433126", "Frohnleiten",
"437225", "Hargelsberg",
"437274", "Alkoven",
"435284", "Gerlos",
"437214", "Reichenthal",
"435337", "Brixlegg",
"433322", "Güssing",
"432956", "Ziersdorf",
"433582", "Scheifling",
"436477", "St\.\ Michael\ im\ Lungau",
"432233", "Pressbaum",
"436417", "Hüttschlag",
"432538", "Velm\-Götzendorf",
"437434", "Haag",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"433858", "Mitterdorf\ im\ Mürztal",
"434255", "Arnoldstein",
"435552", "Bludenz",
"432872", "Ottenschlag",
"432812", "Gross\ Gerungs",
"435245", "Hinterriss",
"432269", "Niederfellabrunn",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432610", "Horitschon",
"437357", "Kleinreifling",
"433118", "Sinabelkirchen",
"433612", "Liezen",
"437724", "Mauerkirchen",
"433150", "Paldau",
"432621", "Sieggraben",
"432827", "Schönbach",
"432739", "Tiefenfucha",
"435632", "Stanzach",
"432746", "Wilhelmsburg",
"437287", "Peilstein\ im\ Mühlviertel",
"434232", "Völkermarkt",
"434873", "St\.\ Jakob\ in\ Defereggen",
"432248", "Markgrafneusiedl",
"433575", "St\.\ Johann\ am\ Tauern",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"434762", "Spittal\ an\ der\ Drau",
"432623", "Pottendorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"437664", "Weyregg\ am\ Attersee",
"432286", "Obersiebenbrunn",
"432913", "Hötzelsdorf",
"432231", "Purkersdorf",
"43732", "Linz",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432844", "Karlstein\ an\ der\ Thaya",
"432164", "Rohrau",
"436547", "Kaprun",
"433477", "St\.\ Peter\ am\ Ottersbach",
"433685", "Gröbming",
"434267", "Metnitz",
"432619", "Lackendorf",
"436484", "Lessach",
"433159", "Bad\ Gleichenberg",
"437242", "Wels",
"435354", "Fieberbrunn",
"433359", "Loipersdorf\-Kitzladen",
"432173", "Gols",
"437246", "Gunskirchen",
"433145", "Edelschrott",
"433834", "Wald\ am\ Schoberpass",
"437748", "Eggelsberg",
"432554", "Stützenhofen",
"433533", "Turrach",
"432247", "Deutsch\-Wagram",
"437261", "Schönau\ im\ Mühlkreis",
"432853", "Schrems",
"432634", "Gutenstein",
"437583", "Kremsmünster",
"434240", "Bad\ Kleinkirchheim",
"437288", "Ulrichsberg",
"435573", "Hörbranz",
"435278", "Navis",
"435513", "Hittisau",
"432665", "Prein\ an\ der\ Rax",
"437230", "Altenberg\ bei\ Linz",
"433184", "Wolfsberg\ im\ Schwarzautal",
"435441", "See",
"435226", "Neustift\ im\ Stubaital",
"432282", "Gänserndorf",
"437673", "Schwanenstadt",
"437613", "Laakirchen",
"434766", "Millstatt",
"436243", "Abtenau",
"436548", "Niedernsill",
"432742", "St\.\ Pölten",
"433865", "Kindberg",
"434268", "Friesach",
"434353", "Prebl",
"434236", "Eberndorf",
"43662", "Salzburg",
"434826", "Mörtschach",
"437255", "Losenstein",
"435264", "Mieming",
"432616", "Lockenhaus",
"434357", "St\.\ Paul\ im\ Lavanttal",
"436247", "Grossgmain",
"434715", "Kötschach\-Mauthen",
"437485", "Gaming",
"435475", "Feichten",
"433352", "Oberwart",
"437617", "Traunkirchen",
"432749", "Prinzersdorf",
"435522", "Feldkirch",
"434225", "Grafenstein",
"434214", "Brückl",
"432783", "Traismauer",
"434274", "Velden\ am\ Wörther\ See",
"433464", "Gross\ St\.\ Florian",
"432177", "Podersdorf\ am\ See",
"435577", "Lustenau",
"437587", "Wartberg\ an\ der\ Krems",
"432289", "Matzen",
"435517", "Riezlern",
"4317", "Vienna",
"432857", "Bad\ Grosspertholz",
"437754", "Waldzell",
"436452", "Radstadt",
"432628", "Felixdorf",
"432243", "Klosterneuburg",
"433537", "St\.\ Georgen\ ob\ Murau",
"437444", "Opponitz",
"433171", "Gasen",
"436456", "Obertauern",
"436589", "Unken",
"434733", "Malta",
"437618", "Neukirchen\,\ Altmünster",
"432755", "Mank",
"434263", "Hüttenberg",
"434358", "St\.\ Andrä",
"436543", "Taxenbach",
"433473", "Straden",
"434769", "Möllbrücke",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"435526", "Laterns",
"435331", "Brandenberg",
"436135", "Bad\ Goisern",
"432627", "Pitten",
"433356", "Markt\ Allhau",
"434877", "Prägraten\ am\ Grossvenediger",
"437249", "Bad\ Schallerbach",
"437588", "Ried\ im\ Traunkreis",
"437283", "Sarleinsbach",
"435578", "Höchst",
"435273", "Matrei\ am\ Brenner",
"435518", "Mellau",
"435213", "Scharnitz",
"432858", "Moorbad\ Harbach",
"435550", "Thüringen",
"434822", "Winklern",
"433152", "Feldbach",
"432612", "Oberpullendorf",
"436471", "Tweng",
"432672", "Berndorf",
"432254", "Ebreichsdorf",
"437743", "Maria\ Schmolln",
"433456", "Fresing",
"434230", "Globasnitz",
"432524", "Kautendorf",
"432644", "Grimmenstein",
"432767", "Hohenberg",
"433623", "Bad\ Mitterndorf",
"436473", "Mariapfarr",
"432575", "Ladendorf",
"436413", "Wagrain",
"433329", "Jennersdorf",
"432237", "Gaaden",
"437281", "Aigen\ im\ Mühlkreis",
"432945", "Zellerndorf",
"432823", "Grossglobnitz",
"437766", "Andorf",
"433844", "Kammern\ im\ Liesingtal",
"437353", "Gaflenz",
"437236", "Pregarten",
"433135", "Kalsdorf\ bei\ Graz",
"437563", "Spital\ am\ Pyhrn",
"437268", "Grein",
"434246", "Radenthein",
"432685", "Rust",
"436566", "Bramberg\ am\ Wildkogel",
"437953", "Liebenau",
"436233", "Oberwang",
"435333", "Söll",
"435256", "Untergurgl",
"432732", "Krems\ an\ der\ Donau",
"435448", "Pettneu\ am\ Arlberg",
"432262", "Korneuburg",
"433619", "Oppenberg",
"432984", "Eggenburg",
"437416", "Wieselburg",
"436541", "Saalbach",
"435559", "Brand",
"437476", "Aschbach\-Markt",
"433885", "Greith",
"437240", "Sipbachzell",
"433173", "Ratten",
"432145", "Prellenkirchen",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"437267", "Mönchdorf",
"433364", "Hannersdorf",
"437412", "Ybbs\ an\ der\ Donau",
"434782", "Obervellach",
"437472", "Amstetten",
"435674", "Bichlbach",
"437684", "Frankenmarkt",
"432266", "Stockerau",
"432238", "Kaltenleutgeben",
"432533", "Neusiedl\ an\ der\ Zaya",
"434242", "Villach",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"433853", "Spital\ am\ Semmering",
"436562", "Mittersill",
"433634", "Hieflau",
"432736", "Paudorf",
"435252", "Oetz",
"437944", "Sandl",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"437762", "Raab",
"435447", "Flirsch",
"433335", "Pöllau",
"436224", "Hintersee",
"433452", "Leibnitz",
"432865", "Litschau",
"436215", "Strasswalchen",
"432959", "Sitzendorf\ an\ der\ Schmida",
"435375", "Kössen",
"435672", "Reutte",
"437682", "Vöcklamarkt",
"432948", "Weitersfeld",
"437735", "Gaspoltshofen",
"432719", "Dross",
"434244", "Bad\ Bleiberg",
"432147", "Zurndorf",
"436564", "Krimml",
"433632", "St\.\ Gallen",
"437265", "Pabneukirchen",
"435254", "Sölden",
"432630", "Ternitz",
"433362", "Grosspetersdorf",
"437414", "Weins\-Isperdorf",
"432986", "Irnfritz",
"432213", "Lassee",
"437474", "Euratsfeld",
"433141", "Hirschegg",
"434784", "Mallnitz",
"434848", "Kartitsch",
"432273", "Tulbing",
"433861", "Aflenz",
"432723", "Rabenstein\ an\ der\ Pielach",
"433454", "Leutschach",
"432526", "Stronsdorf",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"435582", "Klösterle",
"434285", "Tröpolach",
"433846", "Kalwang",
"437942", "Freistadt",
"432688", "Steinbrunn",
"436217", "Mattsee",
"437234", "Ottensheim",
"436277", "St\.\ Pantaleon",
"435445", "Kappl",
"433337", "Vorau",
"437764", "Riedau",
"436462", "Bischofshofen",
"435289", "Häusling",
"437279", "Haibach\ ob\ der\ Donau",
"436466", "Werfenweng",
"434847", "Obertilliach",
"432577", "Asparn\ an\ der\ Zaya",
"432235", "Maria\-Lanzendorf",
"437219", "Vorderweissenbach",
"433842", "Leoben",
"437946", "Gutau",
"435243", "Maurach",
"432765", "Kaumberg",
"434253", "St\.\ Jakob\ im\ Rosental",
"432522", "Laa\ an\ der\ Thaya",
"433571", "Möderbrugg",
"433137", "Söding",
"432642", "Aspangberg\-St\.\ Peter",
"432947", "Theras",
"436226", "Fuschl\ am\ See",
"437713", "Schardenberg",
"433366", "Kohfidisch",
"437223", "Enns",
"433338", "Lafnitz",
"432982", "Horn",
"432687", "Siegendorf",
"436278", "Ostermiething",
"432160", "Jois",
"433636", "Wildalpen",
"432734", "Langenlois",
"435676", "Jungholz",
"437729", "Neukirchen\ an\ der\ Enknach",
"432264", "Rückersdorf\,\ Harmannsdorf",
"433683", "Donnersbach",
"432757", "Pöchlarn",
"434276", "Feldkirchen\ in\ Kärnten",
"4318", "Vienna",
"433466", "Eibiswald",
"434718", "Dellach",
"435418", "Schönwies",
"437488", "Steinakirchen\ am\ Forst",
"432849", "Schwarzenau",
"436137", "Strobl",
"437221", "Hörsching",
"437258", "Bad\ Hall",
"435280", "Hochfügen",
"435238", "Zirl",
"434824", "Heiligenblut",
"435266", "Ötztal\-Bahnhof",
"432614", "Kleinwarasdorf",
"432674", "Weissenbach\ an\ der\ Triesting",
"437711", "Suben",
"432252", "Baden",
"432625", "Bad\ Sauerbrunn",
"434875", "Matrei\ in\ Osttirol",
"433573", "Fohnsdorf",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"433513", "Bischoffeld",
"435359", "Hochfilzen",
"432915", "Drosendorf\-Zissersdorf",
"434228", "Feistritz\ im\ Rosental",
"437257", "Grünburg",
"432663", "Schottwien",
"433354", "Bernstein",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"432256", "Leobersdorf",
"435417", "Roppen",
"434717", "Steinfeld",
"435477", "Tösens",
"437487", "Gresten",
"437675", "Ampflwang\ im\ Hausruckwald",
"432639", "Bad\ Fischau",
"437615", "Scharnstein",
"432758", "Pöggstall",
"433863", "Turnau",
"434355", "Gemmersdorf",
"435262", "Telfs",
"436245", "Hallein",
"432271", "Ried\ am\ Riederberg",
"432175", "Apetlon",
"433143", "Krottendorf",
"436454", "Mandling",
"437752", "Ried\ im\ Innkreis",
"437442", "Waidhofen\ an\ der\ Ybbs",
"434227", "Ferlach",
"433535", "Krakaudorf",
"435524", "Satteins",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"434212", "St\.\ Veit\ an\ der\ Glan",
"435575", "Langen\ bei\ Bregenz",
"434272", "Pörtschach\ am\ Wörther\ See",
"435515", "Au",
"433462", "Deutschlandsberg",
"432855", "Waldenstein",
"434223", "Maria\ Saal",
"432166", "Parndorf",
"433147", "Salla",
"432632", "Pernitz",
"435356", "Kitzbühel",
"433832", "Kraubath\ an\ der\ Mur",
"432245", "Wolkersdorf\ im\ Weinviertel",
"433578", "Obdach",
"432552", "Poysdorf",
"433469", "St\.\ Oswald\ im\ Freiland",
"433386", "Grosssteinbach",
"434279", "Sirnitz",
"432667", "Schwarzau\ im\ Gebirge",
"432744", "Kasten\ bei\ Böheimkirchen",
"437253", "Wolfern",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"433182", "Wildon",
"433688", "Tauplitz",
"433867", "Pernegg\ an\ der\ Mur",
"437759", "Antiesenhofen",
"432846", "Raabs\ an\ der\ Thaya",
"437666", "Attersee",
"434713", "Techendorf",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437483", "Oberndorf\ an\ der\ Melk",
"435473", "Nauders",
"432284", "Oberweiden",
"435224", "Wattens",
"433577", "Zeltweg",
"437662", "Seewalchen\ am\ Attersee",
"437285", "Hofkirchen\ im\ Mühlkreis",
"435275", "Trins",
"432842", "Waidhofen\ an\ der\ Thaya",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"433148", "Kainach\ bei\ Voitsberg",
"434234", "Ruden",
"437745", "Lochen",
"433382", "Fürstenfeld",
"432556", "Grosskrut",
"434735", "Kremsbrücke",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"433475", "Hürth",
"437244", "Sattledt",
"432753", "Gansbach",
"433868", "Tragöss",
"435352", "St\.\ Johann\ in\ Tirol",
"433687", "Schladming",
"434265", "Weitensfeld\ im\ Gurktal",
"432162", "Bruck\ an\ der\ Leitha",
"432636", "Puchberg\ am\ Schneeberg",
"432259", "Münchendorf",
"436133", "Ebensee",
"437955", "Königswiesen",
"436235", "Thalgau",
"436131", "Obertraun",
"435335", "Hopfgarten\ im\ Brixental",
"433324", "Strem",
"432683", "Purbach\ am\ Neusiedler\ See",
"432649", "Mönichkirchen",
"437227", "Neuhofen\ an\ der\ Krems",
"433584", "Neumarkt\ in\ Steiermark",
"433849", "Vordernberg",
"432728", "Wienerbruck",
"437272", "Eferding",
"435282", "Zell\ am\ Ziller",
"437212", "Zwettl\ an\ der\ Rodl",
"433883", "Terz",
"4316", "Vienna",
"434257", "Fürnitz",
"432716", "Gföhl",
"433614", "Rottenmann",
"437722", "Braunau\ am\ Inn",
"436475", "Ramingstein",
"436415", "Schwarzach\ im\ Pongau",
"432573", "Wilfersdorf",
"434843", "Ausservillgraten",
"432278", "Absdorf",
"435634", "Elbigenalp",
"432825", "Göpfritz\ an\ der\ Wild",
"437717", "St\.\ Aegidi",
"437432", "Strengberg",
"432943", "Obritz",
"437355", "Weyer",
"433133", "Nestelbach",
"432989", "Brunn\ an\ der\ Wild",
"437565", "St\.\ Pankraz",
"435554", "Sonntag",
"432874", "Martinsberg",
"432814", "Langschlag",
"437228", "Kematen\ an\ der\ Krems",
"433333", "Sebersdorf",
"437251", "Schiedlberg",
"432712", "Aggsbach",
"436213", "Oberhofen\ am\ Irrsee",
"432772", "Neulengbach",
"435373", "Ebbs",
"432863", "Eggern",
"435286", "Ginzling",
"433175", "Anger",
"432143", "Kittsee",
"437276", "Peuerbach",
"433115", "Studenzen",
"437216", "Helfenberg",
"437718", "Waldkirchen\ am\ Wesen",
"433124", "Gratkorn",
"437949", "Rainbach\ im\ Mühlkreis",
"437750", "Andrichsfurt",
"436433", "Dorfgastein",
"432954", "Göllersdorf",
"432535", "Hohenau\ an\ der\ March",
"432277", "Zwentendorf",
"433855", "Krieglach",
"433460", "Soboth",
"434258", "Gummern",
"434221", "Gallizien",
"435248", "Steinberg\ am\ Rofan",
"436229", "Hof\ bei\ Salzburg",
"437243", "Marchtrenk",
"432176", "Tadten",
"432754", "Loosdorf",
"437289", "Rohrbach\ in\ Oberösterreich",
"435279", "St\.\ Jodok\ am\ Brenner",
"436134", "Hallstatt",
"433536", "St\.\ Peter\ am\ Kammersberg",
"433358", "Litzelsdorf",
"432856", "Weitra",
"435516", "Doren",
"437586", "Pettenbach",
"435576", "Hohenems",
"433581", "Oberwölz",
"432617", "Drassmarkt",
"436583", "Leogang",
"433157", "Kapfenstein",
"436549", "Piesendorf",
"435223", "Hall\ in\ Tirol",
"432912", "Geras",
"434269", "Flattnitz",
"433611", "Johnsbach",
"437616", "Grünau\ im\ Almtal",
"436470", "Atzmannsdorf",
"434872", "Huben",
"437676", "Ottnang\ am\ Hausruck",
"436458", "Hüttau",
"432622", "Wiener\ Neustadt",
"432255", "Deutsch\ Brodersdorf",
"436246", "Grödig",
"434233", "Griffen",
"434356", "Lavamünd",
"432743", "Böheimkirchen",
"436242", "Russbach\ am\ Pass\ Gschütt",
"435265", "Nassereith",
"434352", "Wolfsberg",
"437254", "Grossraming",
"437612", "Gmunden",
"437672", "Vöcklabruck",
"434876", "Kals\ am\ Grossglockner",
"433357", "Pinkafeld",
"4312", "Vienna",
"432626", "Mattersburg",
"432916", "Riegersburg\,\ Hardegg",
"435474", "Pfunds",
"432283", "Angern\ an\ der\ March",
"437484", "Göstling\ an\ der\ Ybbs",
"435414", "Wenns",
"434714", "Dellach\ im\ Drautal",
"432249", "Gross\-Enzersdorf",
"432951", "Guntersdorf",
"432852", "Gmünd",
"433465", "Pölfing\-Brunn",
"435512", "Egg",
"434275", "Ebene\ Reichenau",
"435572", "Dornbirn",
"434215", "Liebenfels",
"437582", "Kirchdorf\ an\ der\ Krems",
"434224", "Pischeldorf",
"433532", "Murau",
"436457", "Flachau",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437755", "Mettmach",
"432172", "Frauenkirchen",
"433170", "Fischbach",
"432618", "Markt\ St\.\ Martin",
"433158", "St\.\ Anna\ am\ Aigen",
"435234", "Axams",
"434853", "Ainet",
"433365", "Deutsch\ Schützen\-Eisenberg",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"432144", "Deutsch\ Jahrndorf",
"434247", "Afritz",
"437262", "Perg",
"433635", "Radmer",
"437477", "St\.\ Peter\ in\ der\ Au",
"432953", "Nappersdorf",
"436434", "Bad\ Gastein",
"437732", "Haag\ am\ Hausruck",
"435675", "Tannheim",
"432236", "Mödling",
"433119", "St\.\ Marein\ bei\ Graz",
"432268", "Grossmugl",
"433179", "Passail",
"435442", "Landeck",
"432738", "Fels\ am\ Wagram",
"432766", "Kleinzell",
"433457", "Gleinstätten",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"434282", "Hermagor",
"436274", "Lamprechtshausen",
"435374", "Walchsee",
"436214", "Henndorf\ am\ Wallersee",
"435585", "Dalaas",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432864", "Kautzen",
"437767", "Eggerding",
"433859", "Mürzsteg",
"432741", "Flinsbach",
"436225", "Eugendorf",
"433334", "Kaindorf",
"435339", "Wildschönau",
"432574", "Gaweinstal",
"437478", "Oed\-Oehling",
"434231", "Mittertrixen",
"435633", "Hägerau",
"433613", "Admont",
"434286", "Weissbriach",
"432645", "Wiesmath",
"432525", "Gnadendorf",
"434761", "Stockenboi",
"435553", "Raggal",
"433134", "Heiligenkreuz\ am\ Waasen",
"432762", "Lilienfeld",
"432813", "Arbesbach",
"433845", "Mautern\ in\ Steiermark",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"432873", "Kottes",
"434248", "Treffen",
"432232", "Fischamend",
"432944", "Haugsdorf",
"435446", "St\.\ Anton\ am\ Arlberg",
"437736", "Pram",
"433583", "Unzmarkt",
"437266", "Bad\ Kreuzen",
"433323", "Eberau",
"437238", "Mauthausen",
"436479", "Muhr",
"432684", "Schützen\ am\ Gebirge",
"433884", "Wegscheid",
"432829", "Schweiggers",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432267", "Sierndorf",
"432985", "Gars\ am\ Kamp",
"433116", "Kirchbach\ in\ Steiermark",
"432239", "Breitenfurt\ bei\ Wien",
"433327", "St\.\ Michael\ im\ Burgenland",
"437215", "Hellmonsödt",
"435285", "Mayrhofen",
"433176", "Stubenberg",
"437224", "St\.\ Florian",
"433587", "Schönberg\-Lachtal",
"432769", "Türnitz",
"432536", "Drösing",
"432263", "Grossrussbach",
"432733", "Schönberg\ am\ Kamp",
"436232", "Mondsee",
"435332", "Wörgl",
"433856", "Veitsch",
"437952", "Weitersfelden",
"435244", "Jenbach",
"433617", "Gaishorn\ am\ See",
"437562", "Windischgarsten",
"434254", "Faak\ am\ See",
"437435", "St\.\ Valentin",
"432958", "Maissau",
"432822", "Zwettl\,\ Lower\ Austria",
"433151", "Gnas",
"432620", "Willendorf",
"434858", "Nikolsdorf",
"433622", "Bad\ Aussee",
"437714", "Esternberg",
"436412", "St\.\ Johann\ im\ Pongau",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"436472", "Mauterndorf",
"432877", "Grainbrunn",
"435557", "St\.\ Gallenkirch",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"433453", "Ehrenhausen",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"436240", "Krispl",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"437269", "Baumgartenberg",
"436416", "Lend",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433588", "Katsch\ an\ der\ Mur",
"437763", "Kopfing\ im\ Innkreis",
"432826", "Rastenfeld",
"437566", "Rosenau\ am\ Hengstpass",
"433328", "Kukmirn",
"437233", "Feldkirchen\ an\ der\ Donau",
"435510", "Damüls",
"434243", "Bodensdorf",
"432878", "Traunstein",
"435558", "Gaschurn",
"435336", "Alpbach",
"435253", "Längenfeld",
"436563", "Uttendorf",
"433852", "Mürzzuschlag",
"437956", "Unterweissenbach",
"433127", "Peggau",
"432532", "Zistersdorf",
"432274", "Sieghartskirchen",
"432957", "Hohenwarth",
"434783", "Reisseck",
"437473", "Blindenmarkt",
"432214", "Kopfstetten",
"437413", "Marbach\ an\ der\ Donau",
"435449", "Fliess",
"433112", "Gleisdorf",
"433618", "Hohentauern",
"433172", "Weiz",
"436453", "Filzmoos",
"434736", "Innerkrems",
"432555", "Herrnbaumgarten",
"434768", "Kleblach\-Lind",
"432242", "St\.\ Andrä\-Wördern",
"434238", "Eisenkappel\-Vellach",
"434266", "Strassburg",
"433144", "Köflach",
"437471", "Neustadtl\ an\ der\ Donau",
"433476", "Bad\ Radkersburg",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"436588", "Lofer",
"432782", "Herzogenburg",
"432635", "Neunkirchen",
"437260", "Waldhausen",
"437619", "Kirchham",
"434359", "Reichenfels",
"435523", "Götzis",
"433353", "Oberschützen",
"437231", "Herzogsdorf",
"437286", "Lembach\ im\ Mühlkreis",
"435276", "Gschnitz",
"433185", "Preding",
"432747", "Ober\-Grafendorf",
"432664", "Semmering",
"433864", "St\.\ Marein\ im\ Mürztal",
"437248", "Grieskirchen",
"432287", "Strasshof\ an\ der\ Nordbahn",
"435519", "Schröcken",
"435579", "Alberschwende",
"437746", "Friedburg",
"432859", "Brand\-Nagelberg",
"433514", "Seckau",
"433385", "Ilz",
"437742", "Mattighofen",
"433574", "Pusterwald",
"433153", "Riegersburg",
"434823", "Tresdorf\,\ Rangersdorf",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432613", "Deutschkreutz",
"432845", "Weikertschlag\ an\ der\ Thaya",
"434237", "Miklauzhof",
"435212", "Seefeld\ in\ Tirol",
"435272", "Steinach\ am\ Brenner",
"437282", "Neufelden",
"434767", "Rothenthurn",
"437665", "Unterach\ am\ Attersee",
"432230", "Schwadorf",
"432288", "Auersthal",
"432731", "Idolsberg",
"432786", "Oberwölbling",
"432629", "Warth\,\ Lower\ Austria",
"433684", "St\.\ Martin\ am\ Grimming",
"437247", "Kematen\ am\ Innbach",
"434879", "St\.\ Veit\ in\ Defereggen",
"432165", "Hainburg\ a\.d\.\ Donau",
"434262", "Treibach",
"435355", "Jochberg",
"433472", "Mureck",
"432748", "Kilb",
"436542", "Zell\ am\ See",
"4315", "Vienna",
"434732", "Gmünd\ in\ Kärnten",
"432246", "Gerasdorf\ bei\ Wien",
"435214", "Leutasch",
"435274", "Gries\ am\ Brenner",
"437284", "Oberkappel",
"432638", "Winzendorf\-Muthmannsdorf",
"432666", "Reichenau",
"433387", "Söchau",
"435225", "Fulpmes",
"432253", "Oberwaltersdorf",
"433512", "Knittelfeld",
"437667", "St\.\ Georgen\ im\ Attergau",
"437744", "Munderfing",
"433572", "Judenburg",
"432641", "Kirchberg\ am\ Wechsel",
"432847", "Gross\-Siegharts",
"434235", "Bleiburg",
"433866", "Breitenau\ am\ Hochlantsch",
"4314", "Vienna",
"434264", "Klein\ St\.\ Paul",
"437245", "Lambach",
"433474", "Deutsch\ Goritz",
"433146", "Modriach",
"432167", "Neusiedl\ am\ See",
"436544", "Rauris",
"434734", "Rennweg",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433682", "Stainach",
"435357", "Kirchberg\ in\ Tirol",
"434273", "Reifnitz",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"432784", "Perschling",
"433686", "Haus",
"434213", "Launsdorf",
"433463", "Stainz",
"437259", "Sierning",
"432557", "Bernhardsthal",
"433631", "Unterlaussa",
"437753", "Eberschwang",
"437443", "Ybbsitz",
"432244", "Langenzersdorf",
"437489", "Purgstall\ an\ der\ Erlauf",
"433142", "Voitsberg",
"432637", "Grünbach\ am\ Schneeberg",
"436221", "Koppl",
"435263", "Silz",
"435358", "Ellmau",
"433862", "Bruck\ an\ der\ Mur",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432745", "Pyhra",
"433516", "Kleinlobming",
"433576", "Bretstein",
"432285", "Marchegg",
"435239", "Kühtai",
"437941", "Neumarkt\ im\ Mühlkreis",
"436461", "Dienten\ am\ Hochkönig",
"432662", "Gloggnitz",
"432168", "Mannersdorf\ am\ Leithagebirge",
"437480", "Langau\,\ Gaming",
"43316", "Graz",
"434710", "Oberdrauburg",
"436463", "Annaberg\-Lungötz",
"435246", "Achenkirch",
"437943", "Windhaag\ bei\ Freistadt",
"432717", "Unter\-Meisling",
"434256", "Nötsch\ im\ Gailtal",
"437250", "Maria\ Neustift",
"437218", "Grosstraberg",
"435288", "Fügen",
"435583", "Lech",
"437278", "Neukirchen\ am\ Walde",
"432722", "Kirchberg\ an\ der\ Pielach",
"436223", "Anthering",
"437716", "Münzkirchen",
"434855", "Assling",
"433363", "Rechnitz",
"433125", "Übelbach",
"437226", "Wilhering",
"432272", "Tulln\ an\ der\ Donau",
"432212", "Orth\ an\ der\ Donau",
"437751", "St\.\ Martin\ im\ Innkreis",
"437728", "Schwand\ im\ Innkreis",
"435230", "Sellrain",
"433114", "Markt\ Hartmannsdorf",
"4346", "Klagenfurt",
"433174", "Birkfeld",
"433339", "Friedberg",
"433633", "Landl",
"433854", "Langenwang",
"43512", "Innsbruck",
"434271", "Steuerberg",
"437683", "Frankenburg\ am\ Hausruck",
"435673", "Ehrwald",
"432955", "Grossweikersdorf",
"434220", "Köttmannsdorf",
"432534", "Niedersulz",
"436219", "Obertrum\ am\ See",
"433461", "Trahütten",
"433585", "St\.\ Lambrecht",
"4319", "Vienna",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"436234", "Zell\ am\ Moos",
"435334", "Westendorf",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"437954", "St\.\ Georgen\ am\ Walde",
"437277", "Waizenkirchen",
"435287", "Tux",
"432949", "Niederfladnitz",
"432718", "Lichtenau\ im\ Waldviertel",
"432276", "Reidling",
"432983", "Sigmundsherberg",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"432689", "Hornstein",
"432726", "Puchenstuben",
"435635", "Elmen",
"433624", "Pichl\-Kainisch",
"436414", "Grossarl",
"437712", "Schärding",
"436474", "Tamsweg",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"433615", "Trieben",
"432643", "Lichtenegg",
"432815", "Grossschönau",
"435242", "Schwaz",
"437727", "Ach",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"432875", "Grafenschlag",
"437564", "Hinterstoder",
"434252", "Wernberg",
"432824", "Allentsteig",
"4313", "Vienna",
"433638", "Palfau",
"433132", "Kumberg",
"432764", "Hainfeld",
"432647", "Krumbach\,\ Lower\ Austria",
"432527", "Wulzeshofen",
"437229", "Traun",
"437433", "Wallsee",
"432234", "Gramatneusiedl",
"432942", "Retz",
"432841", "Vitis",
"435678", "Weissenbach\ am\ Lech",
"434842", "Sillian",
"432572", "Mistelbach",
"433336", "Waldbach",
"436276", "Nussdorf\ am\ Haunsberg",
"435376", "Thiersee",
"436216", "Neumarkt\ am\ Wallersee",
"433847", "Trofaiach",
"437723", "Altheim",
"433882", "Mariazell",
"437213", "Bad\ Leonfelden",
"435283", "Kaltenbach",
"432146", "Nickelsdorf",
"437273", "Aschach\ an\ der\ Donau",
"436228", "Faistenau",
"436468", "Werfen",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"432265", "Hausleiten",
"432735", "Hadersdorf\ am\ Kamp",
"437719", "Taufkirchen\ an\ der\ Pram",
"432682", "Eisenstadt",
"437948", "Hirschbach\ im\ Mühlkreis",
"433680", "Donnersbachwald",
"435255", "Umhausen",
"437264", "Windhaag\ bei\ Perg",
"436565", "Neukirchen\ am\ Grossvenediger",
"432686", "Drassburg",
"433848", "Eisenerz",
"434245", "Feistritz\ an\ der\ Drau",
"432631", "Pöttsching",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"436432", "Bad\ Hofgastein",
"434785", "Ausserfragant",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437415", "Altenmarkt\,\ Yspertal",
"435677", "Vils",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433886", "Weichselboden",
"432142", "Gattendorf",
"432648", "Hochneukirchen",
"433637", "Gams\ bei\ Hieflau",
"434284", "Kirchbach",
"436272", "Oberndorf\ bei\ Salzburg",
"435372", "Kufstein",
"432773", "Eichgraben",
"436212", "Seekirchen\ am\ Wallersee",
"432713", "Spitz",
"432862", "Heidenreichstein",
"433455", "Arnfels",
"437947", "Kefermarkt",
"432576", "Ernstbrunn",
"436467", "Mühlbach\ am\ Hochkönig",
"434846", "Abfaltersbach",
"432988", "Neupölla",
"433332", "Hartberg",
"437765", "Lambrechten",
"436227", "St\.\ Gilgen",
"432946", "Pulkau",
"435444", "Ischgl",
"432279", "Kirchberg\ am\ Wagram",
"437235", "Gallneukirchen",
"433136", "Dobl",
"433149", "Geistthal",
"433355", "Stadtschlaining",
"435472", "Prutz",
"437482", "Scheibbs",
"435412", "Imst",
"434712", "Greifenburg",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"436244", "Golling\ an\ der\ Salzach",
"434354", "Preitenegg",
"437252", "Steyr",
"437614", "Vorchdorf",
"437674", "Attnang\-Puchheim",
"432711", "Dürnstein",
"436455", "Untertauern",
"432258", "Alland",
"432174", "Wallern\ im\ Burgenland",
"433467", "Schwanberg",
"433833", "Traboch",
"434277", "Glanegg",
"432756", "St\.\ Leonhard\ am\ Forst",
"435232", "Kematen\ in\ Tirol",
"432633", "Markt\ Piesting",
"432854", "Kirchberg\ am\ Walde",
"435514", "Bezau",
"435574", "Bregenz",
"437584", "Molln",
"436136", "Gosau",
"433534", "Stadl\ an\ der\ Mur",
"435525", "Nenzing",
"437757", "Gurten",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"436132", "Bad\ Ischl",
"434226", "St\.\ Margareten\ im\ Rosental",
"436483", "Göriach",
"432163", "Petronell\-Carnuntum",
"433579", "Pöls",
"435353", "Waidring",
"435236", "Gries\ im\ Sellrain",
"432752", "Melk",
"437211", "Reichenau\ im\ Mühlkreis",
"433383", "Burgau",
"437448", "Kematen\ an\ der\ Ybbs",
"434874", "Virgen",
"432624", "Ebenfurth",
"437758", "Obernberg\ am\ Inn",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"432615", "Lutzmannsburg",
"437256", "Ternberg",
"433155", "Fehring",
"434825", "Grosskirchheim",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"434278", "Gnesau",
"432843", "Dobersberg",
"437663", "Steinbach\ am\ Attersee",
"437486", "Lunz\ am\ See",
"435476", "Serfaus",
"432914", "Japons",
"434716", "Lesachtal",
"432257", "Klausen\-Leopoldsdorf",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;