package PDK::Net::Connector::Hillstone;

#------------------------------------------------------------------------------
# 加载项目依赖模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 加载通用方法属性
#------------------------------------------------------------------------------
with 'PDK::Net::Connector::Role';

#------------------------------------------------------------------------------
# 具体实现 _prompt,设置设备脚本执行成功回显
#------------------------------------------------------------------------------
sub _prompt {
  my $self   = shift;
  my $prompt = '\<(?:[^\<\>]*)\>|\[(?:[^\[\]]*)\]';
  return $prompt;
}

#------------------------------------------------------------------------------
# _enCommand 进入特权模式命令
#------------------------------------------------------------------------------
sub _enCommand {
  my $self = shift;
  return 'su';
}

#------------------------------------------------------------------------------
# _enPrompt 设定特权模式捕捉
#------------------------------------------------------------------------------
sub _enPrompt {
  my $self = shift;
  $self->{enPrompt} = '#\s*$';
}

#------------------------------------------------------------------------------
# 具体实现 _startupCommands,设置抓取设备启动配置的脚本
#------------------------------------------------------------------------------
sub _startupCommands {
  my $self     = shift;
  my $commands = ["screen-length 0 temporary", "show configuration running", "save force"];
  return $commands;
}

#------------------------------------------------------------------------------
# 具体实现 _runningCommands,设置抓取设备运行配置的脚本
#------------------------------------------------------------------------------
sub _runningCommands {
  my $self     = shift;
  my $commands = ["screen-length 0 temporary", "show configuration running", "save force"];
  return $commands;
}

#------------------------------------------------------------------------------
# 具体实现 _healthCheckCommands,设置抓取设备健康检查配置的脚本
#------------------------------------------------------------------------------
sub _healthCheckCommands {
  my $self     = shift;
  my $commands = ["screen-length 0 temporary", "show version", "show cpu"];
  return $commands;
}

#------------------------------------------------------------------------------
# 具体实现 truncateCommand，修正脚本下发后回显乱码
#------------------------------------------------------------------------------
sub truncateCommand {
  my ($self, $buff) = @_;

  # 字符串修正处理
  $buff =~ s/\cM+[ ]+\cM//;
  $buff =~ s/\cM//g;

  return $buff;
}

#------------------------------------------------------------------------------
# 具体实现 _errorCodes,设置命令下发错误码 -> 用于拦截配置下发
#------------------------------------------------------------------------------
sub _errorCodes {
  my $self  = shift;
  my $codes = [
    'syntax error, expecting',
    'missing argument',
    'unknown command',
    '^\s+\^-----', 'error: cli version does not match Managment Daemon', '^Error:',
  ];
  return $codes;
}

#------------------------------------------------------------------------------
# 具体实现 _buildWaitforMap,设置交互式执行脚本 -> 用于交互式下发配置
#------------------------------------------------------------------------------
sub _bufferCodes {
  my $self    = shift;
  my %mapping = (
    more     => '^ --More-- ',
    interact => {
      '^Backup (all )?start configur' => 'Y',
      '^Save configuration'           => 'Y',
      'press the enter key\)'         => ' ',
      'overwrite\?\s*\[Y\/N\]'        => 'Y',
      'are you sure\?'                => 'Y',
    }
  );

  # 返回数据字典
  return \%mapping;
}

#------------------------------------------------------------------------------
# 具体实现 runCommands，编写进入特权模式、退出保存配置的逻辑
#------------------------------------------------------------------------------
sub runCommands {
  my ($self, @commands) = @_;

  # 配置下发前 | 切入配置模式
  unshift(@commands, "system-view");

  # 完成配置后 | 报错具体配置
  push(@commands, "return", "save force");

  # 执行调度，配置批量下发
  $self->execCommands(@commands);
}

__PACKAGE__->meta->make_immutable;
1;
